#ifndef PLATNOTHREAD_H
#define PLATNOTHREAD_H

// Copyright (c) 2000, 2001, 2002, 2003 by David Scherer and others.
// See the file license.txt for complete license terms.
// See the file authors.txt for a complete list of contributors.

#ifdef _MSC_VER
#include <windows.h>
#endif

class noCritSec {
  // This is a "fake" mutex that does access counting
  //   but nothing else.  In a single-threaded program,
  //   that's all a mutex has to do.

  int count;

  public:
    struct lock { lock(noCritSec&) {} };

    noCritSec(int spincount=0, int _count=1) : count(_count) {}
    ~noCritSec() {}

    inline void sync_lock() {}
    inline void count_lock() { count++; }
    inline void sync_unlock() {}
    inline int sync_count() { return count; }

    void clear() { count = 0; }
};

void _threaded_timer(double seconds, bool (*callback)(void*), void* data);

template <class T>
void threaded_timer(double seconds, bool (*callback)(T*), T* data) {
  _threaded_timer(seconds, (bool(*)(void*))callback, (void*)data);
}
  
#endif
