# $Progeny: setup.py,v 1.2 2002/03/18 23:51:32 epg Exp $

from distutils.core import setup, Extension

longdesc = """GNU Parted is a library for manipulating disk
partitions.  This module contains Python bindings for the library.
"""

pyparted = Extension("_partedmodule",
                     ["pyparted.c"],
                     libraries=["uuid", "parted"])

setup(name="python-parted", version="0.10",
      author="Progeny Linux Systems, Inc.", author_email="bugs@progeny.com",
      url="http://hackers.progeny.com/python-parted/",
      licence="GPL",
      description="Python bindings for GNU Parted",
      long_description=longdesc,
      keywords=["partitioning", "parted", "linux"],
      platforms="all",
      py_modules=["parted"],
      ext_modules=[pyparted,])
