from att_obj import *
from oglpm import *
from whrandom import *

class Pcircle(Att_Obj):
    def __init__(self,n,r,location):
        Att_Obj.__init__(self,location)
        self.gl = Points(n*3)
	da = 2*pi/n
	for i in range(n):
	    a=i*da
	    x=r*sin(a)
	    y=r*cos(a)
	    self.gl.addpoint(x,y,0)
	    self.gl.addpoint(x,0,y)
	    self.gl.addpoint(0,x,y)
    
    def draw(self):
        glDisable(GL_LIGHTING)
        glPointSize(5.0)
        self.gl.draw()

class Cflectr:
    def __init__(self,location,size = 1,r = 1,g = 1,b = 1):
        Att_Obj.__init__(self,location)
        self.size = size
        self.r = r
        self.g = g
        self.b = b
        self.gl = Quads(3)
        self.gl.addquad(-size,-size,0,size,-size,0,size,size,0,-size,size,0)
        self.gl.addquad(-size,0,-size,size,0,-size,size,0,size,-size,0,size)
        self.gl.addquad(0,-size,-size,0,size,-size,0,size,size,0,-size,size)
	
    def draw(self):
        glEnable(GL_LIGHTING)
        glMaterialfv(GL_FRONT, GL_DIFFUSE, [1., 1., 0., 0.])
        #glColor3f(self.r,self.g,self.b)
        self.gl.draw()
	
class Psphere(Att_Obj):
    def __init__(self,n,r,location):
        Att_Obj.__init__(self,location)
        self.gl = Points(n)
        self.flowers = Points(n/10)
        for i in range(n):
            x = random()*6.2832
            z = random()
            self.gl.addpoint(sin(x)*(1-z)*r,cos(x)*(1-z)*r,z*r)
        for i in range(n/10):
            x = random()*6.2832
            z = random()
            self.flowers.addpoint(sin(x)*(1-z)*r,cos(x)*(1-z)*r,z*r)
	    
    def draw(self):
        glDisable(GL_LIGHTING)
        glColor3f(1,1,1)
        glPointSize(4.0)
        self.flowers.draw()
        glColor3f(0,.6,0)
        glPointSize(8.0)
        self.flowers.draw()
        #glColor3f(1,0,0)
        #glPointSize(4.0)
        #self.gl.draw()
        glColor3f(0,.6,0)
        glPointSize(8.0)
        self.gl.draw()
        glPointSize(10.0)
        glColor3f(0,0,0)
        self.gl.draw()
    
class Qcircle(Att_Obj):
    def __init__(self,n,r,w,location=(0,0,0),color = '(1.0,0.0,1.0)'):
        Att_Obj.__init__(self,location)
        self.color = color
        self.gl = Quads(n)
        da = 2*pi/n
        a = 0
        for i in range(n):
            a = i*da
            aa= a+da
            x=r*sin(a)
            y=r*cos(a)
            xx=r*sin(aa)
            yy=r*cos(aa)
            self.gl.addquad(((x,y,0),(x,y,w),(xx,yy,w),(xx,yy,0)))

    def draw(self):
        self.gl.draw(self.color)
        self.gl.drawlines()
	
class Qcyl(Att_Obj):
    def __init__(self,n,r,w,location=(0,0,0),color = '(1.0,1.0,1.0)'):
        Att_Obj.__init__(self,location)
        self.scalex = self.scaley = self.scalez = .5
        self.color = color
        self.quads = Quads(n)
        da = 2*pi/n
        for i in range(n):
            a=i*da
            aa = a + da
            x=r*sin(a)
            y=r*cos(a)
            xx=r*sin(aa)
            yy=r*cos(aa)
            self.quads.addquad(((x,y,-w),(xx,yy,-w),(xx,yy,w),(x,y,w)))

    def draw(self):
        self.quads.draw(self.color)
        self.quads.drawlines()

class Tube:
    def __init__(self,sym,length):
        self.sym = sym
        self.length=length
        self.radius = length/10.0
        angle = 2*pi/sym
        self.points = []
        for i in range(sym+1):
            a = angle*i
            self.points.append((sin(a)*self.radius,cos(a)*self.radius))
        self.dlist = Dlist()
        self.dlist.begininit()
        glBegin(GL_QUAD_STRIP)
        p = self.points[0]
        glColor3f(0.0,0.0,0.0)
        glVertex3f(p[0],p[1],0.0)
        glColor3f(1.0,1.0,1.0)
        glVertex3f(p[0]*.3,p[1]*.3,self.length)	
        for i in range(1,self.sym+1):
            p = self.points[i]
            glColor3f(0.0,0.0,0.0)
            glVertex3f(p[0],p[1],0.0)
            glColor3f(1.0,1.0,1.0)	    
            glVertex3f(p[0]*.3,p[1]*.3,self.length)
        glEnd()	    
        glBegin(GL_LINES)
        glColor3f(0.0,0.3,0.2)
        for i in range(self.sym):
            p = self.points[i]
            glVertex3f(p[0],p[1],0.0)
            glVertex3f(p[0]*.3,p[1]*.3,self.length)
        glEnd()
        self.dlist.endinit()

    def draw(self):
        self.dlist.draw()	    

class Leaves(Att_Obj):
    def __init__(self,n,r,z):
        Att_Obj.__init__(self,(0,0,z))
        self.z = z
        self.gl = Points(n)
        for i in range(n):
            self.gl.addpoint((random()-.5)*r,(random()-.5)*r,(random()-.5)*r)
            
    def draw(self):
        glColor3f(1,1,1)
        glPointSize(2.0)
        self.gl.draw()
        glColor3f(0,.7,0)
        glPointSize(8.0)
        self.gl.draw()
        glColor3f(0,0,0)
        glPointSize(10.0)
        self.gl.draw()

class Tree(Att_Obj):
    def __init__(self,n,length,angle,location=(0,0,0),rotation=(0,0,0,1),scale=(1,1,1)):
        Att_Obj.__init__(self,location,rotation,scale,self)
        self.twopi = 2*pi
        self.n = n
        self.length=length
        self.angle = angle
        self.trunk = Tube(n+4,self.length)
        if n > 0:
            for i in range(2):
                self.addchild(Tree(n-1,self.length,self.angle,(0,0,self.length),(self.angle,sin(i*self.twopi/n),cos(i*self.twopi/n),1),(.7,.7,.7)))
        if n == 0:
            self.addchild(Leaves(10,10,self.length))
        self.moving = 0

    def draw(self):
        if self.moving:
            self.x = self.x + self.xv
            self.y = self.y + self.yv
            self.z = self.z + self.zv
            self.moving = self.moving - 1           
        self.trunk.draw()
        
    def cut(self):
        for child in self.children:
            child.cut()
        self.parent.removechild(self)
        while self.parent:
            p = self.parent
            self.parent = self.parent.parent
        self.parent = p
        p.addchild(self)
        self.x = self.worldposition[0]
        self.y = self.worldposition[1]
        self.z = self.worldposition[2]
        self.xv = random()/10.0 - .05
        self.yv = random()/10.0 - .05
        self.zv = random()/10.0 - .05
        self.moving = 100
    
class Nutria(Att_Obj):
    def __init__(self,r,n,location):
        from whrandom import *
        Att_Obj.__init__(self,location)
        self.n = n
        self.r = r
        self.points = Points(n)
        for i in range(n):
            a = random()
            self.points.addpoint(self.r*sin(a*2*pi),self.r*cos(a*2*pi),self.r*i/n)
	  
    def draw(self):
        glPointSize(8.0)
        glColor3f(1.0,1.0,1.0)
        self.points.draw()
        glPointSize(10.0)
        glColor3f(0.4,0.4,0.0)
        self.points.draw()
	
class CoNutria(Att_Obj):
    def __init__(self,n,r,location):
        from whrandom import *
        Att_Obj.__init__(self,location)
        self.n = n
        self.r = r
        self.points = Points(n)
        for i in range(n):
            a = random()
            self.points.addpoint(self.r*sin(a*2*pi),self.r*cos(a*2*pi)*i/n,self.r*i/n)
	  
    def draw(self):
        glColor3f(1.0,1.0,1.0)
        self.points.draw()
        glPointSize(10.0)
        glColor3f(0.4,0.4,0.0)
        self.points.draw()
	
class Snutria(Att_Obj):
    def __init__(self,n,r,location):
        from whrandom import *
        Att_Obj.__init__(self,location)
        self.n = n
        self.r = r
        self.frame = 1
        self.animlist = []
        r = range(10)
        l = range(10)
        l.reverse()
        l = l + r
        for j in l:
            self.animlist.append(Points(n))
            for i in range(n):
                a = j*i*10.0/(n-1)
                a2 = j*i*9.9/(n-1)
                x = sin(a*2*pi)
                y = cos(a*2*pi)
                z = (i+j)/90.0
                self.animlist[-1].addpoint(self.r*x,self.r*y,z)
                self.animlist[-1].addpoint(self.r*sin(a2*2*pi),self.r*cos(a2*2*pi),z)
	  
    def draw(self,distance):
        ps = (1000-distance)/100
        ps2 = ps + 2
        ps3 = ps + 4
        if ps < 1:
            ps = 1
            ps2 = 2
        glPointSize(1.0)
        glColor3f(0.0,0.0,0.0)
        self.animlist[self.frame].draw()
        glPointSize(ps)
        glColor3f(1.0,1.0,1.0)
        self.animlist[self.frame].draw()
        glPointSize(ps2)
        glColor3f(1.0,0.0,0.0)
        self.animlist[self.frame].draw()
        glPointSize(ps3)
        glColor3f(0.0,1.0,0.0)
        self.animlist[self.frame].draw()
        #self.advanceframe()
        
    def advanceframe(self):
        self.frame = (self.frame+1)%20

class Qsnutria(Att_Obj):
    def __init__(self,n,iradius,oradius,location):
        from whrandom import *
        Att_Obj.__init__(self,location)
        self.x = x
        self.y = y
        self.z = z
        self.n = n
        self.iradius = iradius
        self.oradius = oradius
        self.frame = 1
        self.animlist = []
        r = range(10)
        l = range(10)
        l.reverse()
        l = l + r
        for j in l:
            self.animlist.append(Quadstrip(n))
            for i in range(n):
                a = j*i*1.0/(n-1)
                x = sin(a*2*pi)
                y = cos(a*2*pi)
                z = i+j
                if i == 0:
                    self.animlist[-1].firstquad(0,0,0,0,0,0,self.iradius*x,self.iradius*y,0,self.oradius*x,self.oradius*y,0)   
                    self.animlist[-1].addquad(self.iradius*x,self.iradius*y,z,self.oradius*x,self.oradius*y,z)
	  
    def draw(self):
        glColor3f(1.0,1.0,1.0)
        self.animlist[self.frame].draw()
        glRotate(120,0,0,1)
        glColor3f(1.0,0.0,0.0)
        self.animlist[self.frame].draw()
        glRotate(120,0,0,1)
        glColor3f(0.0,1.0,0.0)
        self.animlist[self.frame].draw()
        #self.frame = (self.frame+1)%20

class Ground(Att_Obj):
    def __init__(self,size,location):
        Att_Obj.__init__(self,location)
        self.size = size
	
    def draw(self):
        glColor3f(1,.6,0)
        glBegin(GL_QUADS)
        glVertex3f(-self.size,0,-self.size)
        glVertex3f(self.size,0,-self.size)
        glVertex3f(self.size,0,self.size)
        glVertex3f(-self.size,0,self.size)
        glEnd()

class Mesh(Att_Obj):
    def __init__(self,array,location):
        Att_Obj.__init__(self,location)
        self.gl = Quadmesh(array)
	
    def draw(self):
        glColor3f(1,.4,0)
        self.gl.draw()

class Urchin(Att_Obj):
    def __init__(self,n,location):
        Att_Obj.__init__(self,location)
        self.scalex = self.scaley = self.scalez = .5
        self.rotation_vector_x = 1   
        self.rotation_vector_y = 1   
        self.rotation_vector_z = 1   
        self.rotation_delta = 5
        self.n = n
        self.gl = Linestrip(n)
        self.p = Points(n)
        for i in range(n):
            a = random()*6.2832
            r = .1*n     
            self.p.addpoint(sin(a)*r,cos(a)*r,0)
            self.gl.addline((sin(a)*r,cos(a)*r,0))        
	
    def draw(self):
        glDisable(GL_LIGHTING)
        glColor3f(0.0,0.0,0.0)
        self.gl.draw()
        glPointSize(2.0)
        glColor3f(1.0,1.0,1.0)
        self.p.draw()
        glPointSize(7.0)
        glColor3f(0.0,0.6,0.0)
        self.p.draw()
        

      
        
    
