/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2007-2011 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#include <boost/version.hpp>
#include "ShapePy.h"

using namespace boost::python;

void exportShape ()
{
  // Check that Boost 1.34.0 or higher is being used.
  // If so, disable auto-generation of C++ signatures for Epydoc
  // (which stumbles over indentation in the auto-generated strings).
  #if ((BOOST_VERSION / 100000 >= 1) \
      && (BOOST_VERSION / 100 % 1000 >= 34)) \
      || (BOOST_VERSION / 100000 >= 2)
    boost::python::docstring_options no_autogen(true,false);
  #endif

      class_<Shape>(
        "Shape",
        "A shape designed for insertion into a L{ShapeList}.\n",
        //init<>()
	no_init
      )
      .def(
        "makeOrientationRandom",
        &Shape::makeOrientationRandom,
        ( arg("v") ),
        "Sets the shape to be randomly orientated every time\n"
        "it is inserted.\n"
        "@type v: integer\n"
        "@kwarg v: 1 for use a random orientation, 0 for constant orientation\n"
      );
      ;
}
