# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class AdlsError(Model):
    """Data Lake Store filesystem error containing a specific WebHDFS exception.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar remote_exception: the object representing the actual WebHDFS
     exception being returned.
    :vartype remote_exception: :class:`AdlsRemoteException
     <azure.mgmt.datalake.store.filesystem.models.AdlsRemoteException>`
    """ 

    _validation = {
        'remote_exception': {'readonly': True},
    }

    _attribute_map = {
        'remote_exception': {'key': 'RemoteException', 'type': 'AdlsRemoteException'},
    }

    def __init__(self):
        self.remote_exception = None


class AdlsErrorException(HttpOperationError):
    """Server responsed with exception of type: 'AdlsError'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(AdlsErrorException, self).__init__(deserialize, response, 'AdlsError', *args)
