# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class CertificateDetails(Resource):
    """Certificate Details.

    :param id: Resource Id
    :type id: str
    :param name: Resource Name
    :type name: str
    :param kind: Kind of resource
    :type kind: str
    :param location: Resource Location
    :type location: str
    :param type: Resource type
    :type type: str
    :param tags: Resource tags
    :type tags: dict
    :param version: Version
    :type version: int
    :param serial_number: Serial Number
    :type serial_number: str
    :param thumbprint: Thumbprint
    :type thumbprint: str
    :param subject: Subject
    :type subject: str
    :param not_before: Valid from
    :type not_before: datetime
    :param not_after: Valid to
    :type not_after: datetime
    :param signature_algorithm: Signature Algorithm
    :type signature_algorithm: str
    :param issuer: Issuer
    :type issuer: str
    :param raw_data: Raw certificate data
    :type raw_data: str
    """ 

    _validation = {
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'version': {'key': 'properties.version', 'type': 'int'},
        'serial_number': {'key': 'properties.serialNumber', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
        'subject': {'key': 'properties.subject', 'type': 'str'},
        'not_before': {'key': 'properties.notBefore', 'type': 'iso-8601'},
        'not_after': {'key': 'properties.notAfter', 'type': 'iso-8601'},
        'signature_algorithm': {'key': 'properties.signatureAlgorithm', 'type': 'str'},
        'issuer': {'key': 'properties.issuer', 'type': 'str'},
        'raw_data': {'key': 'properties.rawData', 'type': 'str'},
    }

    def __init__(self, location, id=None, name=None, kind=None, type=None, tags=None, version=None, serial_number=None, thumbprint=None, subject=None, not_before=None, not_after=None, signature_algorithm=None, issuer=None, raw_data=None):
        super(CertificateDetails, self).__init__(id=id, name=name, kind=kind, location=location, type=type, tags=tags)
        self.version = version
        self.serial_number = serial_number
        self.thumbprint = thumbprint
        self.subject = subject
        self.not_before = not_before
        self.not_after = not_after
        self.signature_algorithm = signature_algorithm
        self.issuer = issuer
        self.raw_data = raw_data
