# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class NetworkInterfaceDnsSettings(Model):
    """Dns settings of a network interface.

    :param dns_servers: Gets or sets list of DNS servers IP addresses
    :type dns_servers: list of str
    :param applied_dns_servers: Gets or sets list of Applied DNS servers IP
     addresses
    :type applied_dns_servers: list of str
    :param internal_dns_name_label: Gets or sets the internal DNS name
    :type internal_dns_name_label: str
    :param internal_fqdn: Gets or sets the internal fqdn.
    :type internal_fqdn: str
    :param internal_domain_name_suffix: Gets or sets internal domain name
     suffix of the NIC.
    :type internal_domain_name_suffix: str
    """ 

    _attribute_map = {
        'dns_servers': {'key': 'dnsServers', 'type': '[str]'},
        'applied_dns_servers': {'key': 'appliedDnsServers', 'type': '[str]'},
        'internal_dns_name_label': {'key': 'internalDnsNameLabel', 'type': 'str'},
        'internal_fqdn': {'key': 'internalFqdn', 'type': 'str'},
        'internal_domain_name_suffix': {'key': 'internalDomainNameSuffix', 'type': 'str'},
    }

    def __init__(self, dns_servers=None, applied_dns_servers=None, internal_dns_name_label=None, internal_fqdn=None, internal_domain_name_suffix=None):
        self.dns_servers = dns_servers
        self.applied_dns_servers = applied_dns_servers
        self.internal_dns_name_label = internal_dns_name_label
        self.internal_fqdn = internal_fqdn
        self.internal_domain_name_suffix = internal_domain_name_suffix
