
import os
DBNAME=os.environ.get("ODS_TEST_DB","ods:test")

from Ft.Ods import Database
from Ft.Ods.MetaData import TypeDefinition
from Ft.Ods.MetaData import Interface
from Ft.Ods.StorageManager import Adapters
from Ft.Ods.StorageManager.Adapters import Constants
import test_type
import test_metadata_util

def Test(tester):

    manager = Adapters.GetManager()
    adapter = Adapters.GetAdapter()
    if manager.exists(DBNAME):
        manager.reinitRepo(DBNAME,adapter)
    else:
        manager.new(DBNAME,adapter)
    
    db = Database.Database()
    db.open(DBNAME)
    try:
    
        test_type.Test(tester,db,TypeDefinition.TypeDefinition)
        tester.startGroup("TypeDefinition Interface %s Driver" % tester.test_data['driver'])
        test_metadata_util.test_form_drop(tester,db,TypeDefinition.TypeDefinition,'alias',Interface.Interface)
        tester.groupDone()

    finally:
        db.close()



