
from Ft.Ods import Database
from Ft.Ods.MetaData import Collection
from Ft.Ods.MetaData import CollectionKind
from Ft.Ods.MetaData import PrimitiveType
from Ft.Ods.MetaData import Literal
from Ft.Ods.StorageManager.Adapters import Constants
from Ft.Ods.StorageManager import Adapters
import test_type,test_metadata_util
import os
DBNAME=os.environ.get("ODS_TEST_DB","ods:test")

class TestWrapper(Collection.Collection):
    def __init__(self,db,data):
        if data is None:
            ck = CollectionKind.ck_list
        else:
            ck = None
        Collection.Collection.__init__(self,db,data,collection_kind = ck)

def Test(tester,useKlass = Collection.Collection,is_ordered=1,collectionKind=CollectionKind.ck_list):

    if useKlass == Collection.Collection:
        manager = Adapters.GetManager()
        adapter = Adapters.GetAdapter()
        if manager.exists(DBNAME):
            manager.reinitRepo(DBNAME,adapter)
        else:
            manager.new(DBNAME,adapter)

        useKlass = TestWrapper

    db = Database.Database()
    db.open(DBNAME)

    try:
        test_type.Test(tester,db,useKlass)

        tester.startGroup("Metadata Collection %s Driver" % tester.test_data['driver'])

        tester.startTest("Is Ordered")
        tx = db.new()
        tx.begin()
        i = useKlass(db,None)
        tester.compare(is_ordered, i.is_ordered(), "is_ordered")
        tester.testDone()
        tester.startTest("collectionKind")
        tester.compare(collectionKind, i.collection_kind, "collection_kind")
        tester.testDone()
        tx.abort()

        
        def GetInterface(db,values):
            from Ft.Ods.MetaData import Interface
            i = Interface.Interface(db,None)
            i.name='c2'
            return i
        test_metadata_util.test_form_drop(tester,db,useKlass,'subtype',GetInterface)
        test_metadata_util.test_form_drop(tester,db,useKlass,'max_size',Literal.Literal)

        tester.startTest("bound")

        tx = db.new()
        tx.begin()
        i = useKlass(db,None)

        tester.compare(-1,i.bound())

        l = Literal.Literal(db,None)
        l.literal_value = 3
        i.form_max_size(l)
        
        tester.compare(3,i.bound())


        tester.testDone()
        tx.abort()



        tester.groupDone()
    finally:
        db.close()

