
import sys, os, cStringIO
p = os.path.join("..","..")
sys.path.append(p)
import profile_util

from Ft.Server.Common import ResourceTypes
from Ft.Server.Server.Http import Basic
from Ft.Server.Server import ConfigParser
from Ft.Server.Server.Lib import LogUtil

class FakeFile:

    def __init__(self):
        self.data = ""

    def write(self,data):
        self.data += data
        
    def close(self):
        pass

    def flush(self):
        pass

def do_fetch():

    #Pretend it is a vhost connect, easiest to fake out
    aCon = cStringIO.StringIO()
    rFile = cStringIO.StringIO()
    wFile = FakeFile()
    connection = (aCon,rFile,wFile)

    aRequest = "HTTP/1.0 GET /profile/doc1.xml"  #Doesn't need to be correct, just there
    method = "GET"
    unparsed_uri = "/profile/doc1.xml"
    protocol = "HTTP/1.0"
    request = (aRequest,method,unparsed_uri,protocol)

    headers_in = {}
    conn = (connection,request,headers_in)

    client_address = ('local',123)  #Just needs to be sciptable

    server = ConfigParser.ServerConfig()
    server.documentRoot = '/'
    server.errorLog = LogUtil.NullLogger()
    server.properties = profile_util.GetProperties()
    
    h = Basic.RequestHandler(conn,client_address,server)

    h.handle()
   

NUM_CHILDREN = 2500
XML_SRC = """<docelem><one>Foo</one>%s<two>Bar</two></docelem>""" % ("<child/>"*NUM_CHILDREN)



def do_profile():

    #Init

    repo = profile_util.GetRepo()
    if repo.hasResource('/profile'):
        repo.deleteResource('/profile')
    repo.createContainer('/profile',1)
    repo.createDocument('/profile/doc1.xml',XML_SRC,forcedType=ResourceTypes.ResourceType.XML_DOCUMENT)
    repo.txCommit()

    profile_util.run("do_fetch()",globals(),locals())


if __name__ == '__main__':
    profile_util.InitRepo()
    do_profile()
