#4XPath Performance test from "Olivier Deckmyn" <odeckmyn.list@teaser.fr>, with import and filename updates
"""
Subject: [4suite] 4XPath performance ?
Date: Thu, 8 Jun 2000 16:30:21 +0200
From: "Olivier Deckmyn" <odeckmyn.list@teaser.fr>
To: "4Suite list" <4suite@dollar.fourthought.com>

I am playing and testing 4XPath....
And I am a little afraid of the results I see...
The machine is a Dell Server (2400) with a single PIII-750 and 256MB RAM,
USCSI disks (10K RPM), running FreeBSD4.

There is a lot of memory, cpu is not used for anything else than the test...

With a 100KB xml file, I have applied the attached test1.py

Here are the results :
QUERY="//author" (no match in the file)
Reading document
took 1.336457 sec
Starting query
took 307.572385 sec
Indexing DOM
took 0.125362 sec
Starting query
took 84.692544 sec

QUERY="//date" (few matches in the file)
Reading document
took 1.341848 sec
Starting query
took 308.466919 sec
<date> 10 October 1996</date><date>1 August 1996</date><date>17 April
1996</date><date> 17 April 1996</date><date> 17 April 1996</date><date> 12
April 1996</date><date>27 March 1996</date><date>27 March
1996</date><date>23 February 1996</date><date>9 December 1996</date><date>
29 November 1996</date><date> 31 October 1996</date>Indexing DOM
took 0.128668 sec
Starting query
took 85.145023 sec
<date> 10 October 1996</date><date>1 August 1996</date><date>17 April
1996</date><date> 17 April 1996</date><date> 17 April 1996</date><date> 12
April 1996</date><date>27 March 1996</date><date>27 March
1996</date><date>23 February 1996</date><date>9 December 1996</date><date>
29 November 1996</date><date> 31 October 1996</date>


Result :
Indexing is worth the price ! Very quick index build, and 3.5x speed gain
...
But, it very slow anyway :(

Is this the "normal" performance ? Can I do better?
"""


from xml.xpath import Evaluate
from xml.xpath import Util
import os
import string


def dom_from_file(tester,fileName):
    tester.startTest("Reading Document")
    result=tester.test_data['reader'].fromUri(fileName)
    tester.testDone()
    return result
    

def test_query(tester,dom_object, query):
    tester.startTest("Starting query")
    result = Evaluate(query, dom_object.documentElement)
    tester.testDone()
    return result

def test1(tester,fileName, queryString,name):

    tester.startGroup(name)
    xml_dom_object=dom_from_file(tester,fileName)

    test_query(tester,xml_dom_object, queryString)
    
    tester.startTest("Index DOM")
    Util.IndexDocument(xml_dom_object)
    tester.testDone()

    test_query(tester,xml_dom_object, queryString)
    tester.test_data['reader'].releaseNode(xml_dom_object)

    tester.groupDone()


def Test(tester):

    path = os.path.abspath(__file__)[len(os.getcwd())+1:]
    base = os.path.dirname(path)
    test1(tester,os.path.join(base,"od_20000608.xml"),"//author","no match")
    test1(tester,os.path.join(base,"od_20000608.xml"),"//date","Some Matches")

