import os,sys
import test_util
from Ft.Ods import Database
from Ft.Ods.StorageManager.Adapters import Constants


odl_string = """

module Test {
enum Sex {MALE,FEMALE};
class Dog {
  attribute string name;
};

class Person (extent people)
  {
	attribute string name;
        attribute string ssn;
        attribute Sex sex;
        attribute Dog bestFriend;
        attribute list<string> names;
        relationship Person spouse inverse Person::spouse_of;
        relationship Person spouse_of inverse Person::spouse;
        relationship list<Person> children inverse Person::parent;
        relationship Person parent inverse Person::children;
  };
};
"""
#"
DBNAME=os.environ.get("ODS_TEST_DB","ods:test")

def Test(tester):
    try:
        _Test(tester)
    finally:
        if os.path.exists('Test'):
            from distutils import dir_util
            dir_util.remove_tree('Test')
        pass

def _Test(tester):


    tester.startGroup('Copy Test %s Driver' % tester.test_data['driver'])

    test_util.DbInit(DBNAME,odl_string)

    tester.startTest('Testing Generated syntax')
    try:
        import Test
        from Test import Person
        from Test import Dog
    except:
        tester.error('Error in syntax', 1)

    reload(Test)
    reload(Person)
    reload(Dog)

    tester.testDone()

    db = Database.Database()
    db.open(DBNAME)
    try:
        tx = db.new()
        tx.begin()

        tester.startTest('Create a person and copy it')

        p = Person.new(db)
        p.name = "Person 1"
        p.ssn = "123-45-6789"
        p.sex = Test.Sex.MALE
        p.bestFriend = Dog.new(db)
        p.bestFriend.name='Snoopy'
        p.names.insert_element("Name 1-1")
        p.names.insert_element("Name 1-2")
        s = Person.new(db)
        s.name = "Spouse 1"
        p.form_spouse(s)
        c1 = Person.new(db)
        c1.name = 'Child 1'
        p.add_children(c1)
        c2 = Person.new(db)
        c2.name = 'Child 2'
        p.add_children(c2)

        p2 = p.copy()
        p2.name = "Person 2"
        p2.sex = Test.Sex.FEMALE
        p2.bestFriend.name='Scoby'
        p2.names.insert_element("Name 2-1")

        p3 = p.copy(deep=1)
        p3.name = "Person 3"
        p3.spouse.name="Spouse 3"
        p3.names.insert_element("Name 3-1")
        c3 = Person.new(db)
        c3.name = 'Child 3'
        p3.add_children(c3)

        tester.testResults("Person 1",p.name,done=0)
        tester.testResults("Person 2",p2.name,done=0)
        tester.testResults("Person 3",p3.name,done=0)
        tester.testResults("123-45-6789",p2.ssn,done=0)
        tester.testResults("123-45-6789",p.ssn,done=0)
        tester.testResults(Test.Sex.MALE,p.sex,done=0)
        tester.testResults(Test.Sex.FEMALE,p2.sex,done=0)
        tester.testResults(0,p.bestFriend == p2.bestFriend,done=0)
        tester.testResults('Snoopy',p.bestFriend.name,done=0)
        tester.testResults('Scoby',p2.bestFriend.name,done=0)
        tester.testResults(0,p.spouse == p3.spouse,done=0)
        tester.testResults(1,p2.spouse == None,done=0)
        tester.testResults('Spouse 1',p.spouse.name,done=0)
        tester.testResults('Spouse 3',p3.spouse.name,done=0)
        tester.testResults(2,p.names.cardinality(),done=0)
        tester.testResults(3,p2.names.cardinality(),done=0,msg='2')
        tester.testResults(3,p3.names.cardinality(),done=0,msg='3')
        tester.testResults(2,p.children.cardinality(),done=0)
        tester.testResults(0,p2.children.cardinality(),done=0,msg='2')
        tester.testResults(3,p3.children.cardinality(),done=0,msg='3')

        if db.lookup("P1"):
            db.unbind("P1")
        db.bind(p,"P1")
        if db.lookup("P2"):
            db.unbind("P2")
        db.bind(p2,"P2")
        if db.lookup("P3"):
            db.unbind("P3")
        db.bind(p3,"P3")

        tx.commit()
        tester.testDone()

        tester.startTest("Test after the load")
        tx = db.new()
        tx.begin()

        p = db.lookup("P1")
        p2 = db.lookup("P2")

        tester.testResults(0,p==p2,done=0)
        tester.testResults("Person 1",p.name,done=0)
        tester.testResults("Person 2",p2.name,done=0)
        tester.testResults("Person 3",p3.name,done=0)
        tester.testResults("123-45-6789",p.ssn,done=0)
        tester.testResults("123-45-6789",p2.ssn,done=0)
        tester.testResults(Test.Sex.MALE,p.sex,done=0)
        tester.testResults(Test.Sex.FEMALE,p2.sex,done=0)
        tester.testResults(0,p.bestFriend == p2.bestFriend,done=0)
        tester.testResults('Snoopy',p.bestFriend.name,done=0)
        tester.testResults('Scoby',p2.bestFriend.name,done=0)
        tester.testResults(0,p.spouse == p3.spouse,done=0)
        tester.testResults(1,p2.spouse == None,done=0)
        tester.testResults('Spouse 1',p.spouse.name,done=0)
        tester.testResults('Spouse 3',p3.spouse.name,done=0)
        tester.testResults(2,p.names.cardinality(),done=0)
        tester.testResults(3,p2.names.cardinality(),done=0)
        tester.testResults(3,p2.names.cardinality(),done=0)
        tester.testResults(2,p.children.cardinality(),done=0)
        tester.testResults(0,p2.children.cardinality(),done=0,msg='2')
        tester.testResults(3,p3.children.cardinality(),done=0,msg='3')

        tester.testDone()

        tx.abort()
    finally:
        db.close()
    tester.groupDone()

