


from Ft.Ods import Database
from Ft.Ods.StorageManager.Adapters import Constants
from Ft.Ods.MetaData import Module
from Ft.Ods.MetaData import Scope
from Ft.Ods.MetaData import PrimitiveKind
from Ft.Ods.MetaData import MetaKind
from Ft.Ods.MetaData import CollectionKind
from Ft.Ods.MetaData import Literal
from Ft.Ods.MetaData import Union
from Ft.Ods.MetaData import Constant
from Ft.Ods.MetaData import Structure
import test_metadata_util, test_type

def Test(tester,db,klass,fac):

    test_type.Test(tester,db,klass)


    tester.startGroup("Scoped Type Interface on %s Driver %s" % (klass.__name__,tester.test_data['driver']))

    tester.startTest("Bind")
    #We will use a module to test his because it is probaly the most stable ???
    tx=db.new()
    tx.begin()
    i = klass(db,None)
    m = fac(db,None)
    i.bind("name1",m)
    tx.commit()
    tester.testDone()

    rid1 = i._4ods_getId()
    rid2 = m._4ods_getId()
    
    tester.startTest("resolve")
    tx=db.new()
    tx.begin()
    i = db._4ods_getPersistentObjectById(Constants.Types.ROBJECT,rid1)
    m = db._4ods_getPersistentObjectById(Constants.Types.ROBJECT,rid2)
    tester.testResults(m,i.resolve("name1"),done=0,msg="Single Resolve")
    try:
        i.resolve("foo")
    except Scope.Scope.NameNotFound:
        pass
    else:
        tester.error("No NameNot Found Exception")

    tester.testDone()


    tester.startTest("Unbind")
    i.unbind("name1")
    tx.commit()

    tx=db.new()
    tx.begin()
    i = db._4ods_getPersistentObjectById(Constants.Types.ROBJECT,rid1)
    try:
        i.resolve("name1")
    except Scope.Scope.NameNotFound:
        pass
    else:
        tester.error("No NameNotFoundException")
    tx.abort()
    tester.testDone()

    tester.groupDone()

