
import os
DBNAME=os.environ.get("ODS_TEST_DB","ods:test")

def Test(tester):

    from Ft.Ods import Database
    from Ft.Ods.MetaData import Module
    from Ft.Ods.MetaData import PrimitiveKind
    from Ft.Ods.StorageManager import Adapters
    from Ft.Ods.StorageManager.Adapters import Constants

    tester.startGroup("Repo Initialization")

    tester.startTest("Init DB")
    manager = Adapters.GetManager()
    adapter = Adapters.GetAdapter()
    if manager.exists(DBNAME):
        manager.reinitRepo(DBNAME,adapter)
    else:
        manager.new(DBNAME,adapter)
    tester.testDone()
    
    db = Database.Database()
    db.open(DBNAME)
    try:
        tx = db.new()
        tx.begin()


        tester.startTest("Repository and Modules")
        try:
            db.schema()
        except:
            tester.error("No Reporitory",1)
        try:
            db.schema().resolve("ODLTypes")
        except:
            tester.error("No ODLTypes",1)
        try:
            db.schema().resolve("ODLMetaObjects")
        except:
            tester.error("No ODLMetaObjects",1)
        try:
            types = db.lookup("ftods_types")
        except:
            tester.error("No ftods_types",1)

        else:
            tester.testResults(len(PrimitiveKind.PrimitiveKind.elements),len(types),done=0,msg='Length')
            for t in types:
                #Make sure it is in elements
                tester.testResults(1,t.primitive_kind in PrimitiveKind.PrimitiveKind.elements,done=0,msg="%s not in elements" % str(t))

        tester.testDone()

        tester.groupDone()

    finally:
        db.close()

    return

