from Ft.Lib import cDomlettec
import cStringIO
import sys,time

def Test(tester):


    tester.startGroup("cDomlette Parser")
    tester.startTest("cDomlette Parser small XML")
    s = cStringIO.StringIO(XML)
    doc = cDomlettec.parse(s, '')
    cDomlettec.ReleaseNode(doc)
    tester.testDone()

    tester.startTest("cDomlette Parser nasty XML")
    s = cStringIO.StringIO(XML_2)
    doc = cDomlettec.parse(s, '')
    cDomlettec.ReleaseNode(doc)
    tester.testDone()


    tester.groupDone()


XML="""<?xml version="1.0"?>
<!DOCTYPE ADDRBOOK SYSTEM "addr_book.dtd">
<ADDRBOOK xmlns:xlink="http://www.w3.org/XML/XLink/0.9">
	<ENTRY ID="pa" xml:space='preserve'>
		<NAME>Pieter Aaron</NAME>
		<ADDRESS>404 Error Way</ADDRESS>
		<PHONENUM DESC="Work">404-555-1234</PHONENUM>
		<PHONENUM DESC="Fax">404-555-4321</PHONENUM>
		<PHONENUM DESC="Pager">404-555-5555</PHONENUM>
		<EMAIL>pieter.aaron@inter.net</EMAIL>
	</ENTRY>
	<ENTRY-LINK xlink:link="simple" xlink:href="addr_book2.xml"/>
	<ENTRY ID="en">
		<NAME>Emeka Ndubuisi</NAME>
		<ADDRESS>42 Spam Blvd</ADDRESS>
		<PHONENUM DESC="Work">767-555-7676</PHONENUM>
		<PHONENUM DESC="Fax">767-555-7642</PHONENUM>
		<PHONENUM DESC="Pager">800-SKY-PAGEx767676</PHONENUM>
		<EMAIL>endubuisi@spamtron.com</EMAIL>
	</ENTRY>
	<ENTRY ID="vz">
		<NAME>Vasia Zhugenev</NAME>
		<ADDRESS>2000 Disaster Plaza</ADDRESS>
		<PHONENUM DESC="Work">000-987-6543</PHONENUM>
		<PHONENUM DESC="Cell">000-000-0000</PHONENUM>
		<EMAIL>vxz@magog.ru</EMAIL>
	</ENTRY>
</ADDRBOOK>
"""

XML_2="""<?xml version="1.0"?>
<?xml-stylesheet type="text/xsl" href="../../style/function.use-cases.xsl"?>
<!-- <!DOCTYPE exslt:function SYSTEM 'function.dtd'> -->
<exslt:function xmlns:exslt="http://exslt.org/documentation" 
                version="1" module="math" status="new">

<exslt:name>min</exslt:name>

<rdf:Description xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
                 xmlns:dc="http://purl.org/dc/elements/1.1/"
                 ID="math:min">
   <dc:subject>EXSLT</dc:subject>
   <dc:subject>math</dc:subject>
   <dc:subject>min</dc:subject>
   <dc:subject>minimum</dc:subject>
   <dc:rights>public domain</dc:rights>
   <exslt:revision>
      <rdf:Description xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
                       xmlns:dc="http://purl.org/dc/elements/1.1/"
                       ID="math:min.1">
         <exslt:version>1</exslt:version>
         <dc:creator email="mail@jenitennison.com" 
                     url="http://www.jenitennison.com">Jeni Tennison</dc:creator>
         <dc:date>2001-03-28</dc:date>
         <dc:description>Returns the minimum value from a node-set.</dc:description>
      </rdf:Description>
   </exslt:revision>
</rdf:Description>

<exslt:doc xmlns="">
   <section>
      <para>
         The <function>math:min</function> function returns the minimum, for each node in the argument node-set, of the result of converting the string-values of the node to a number using the <ulink URL="http://www.w3.org/TR/xpath#function-number"> <function>number</function></ulink> function.  The numbers are compared as with the <literal>&lt;</literal> operator.  If the node set is empty, <returnvalue>NaN</returnvalue> is returned.      
      </para>
      <para>
         The <literal>math:min</literal> template returns a result tree fragment whose string value is the result of turning the number returned by the function into a string.      
      </para>
   </section>
</exslt:doc>

<exslt:definition>
   <exslt:return type="number" />
   <exslt:arg name="nodes" type="node-set" default="/.." />
</exslt:definition>

<exslt:implementations>
   <exslt:implementation src="math.min.function.xsl" language="exslt:exslt" 
                         version="1" />
   <exslt:implementation src="math.min.template.xsl" language="exslt:xslt" 
                         version="1" />
   <exslt:implementation src="math.min.js" language="javascript" 
                         version="1" />
</exslt:implementations>

<exslt:use-cases>
   <exslt:use-case type="example" data="math.min.data.1.xml"
                   xslt="math.min.1.xsl" result="math.min.result.1.xml" />
   <exslt:use-case type="example" template="yes" data="math.min.data.1.xml"
                   xslt="math.min.2.xsl" result="math.min.result.1.xml" />
   <exslt:use-case type="boundary" data="math.min.data.2.xml"
                   xslt="math.min.1.xsl" result="math.min.result.2.xml" />
   <exslt:use-case type="boundary" template="yes" data="math.min.data.2.xml"
                   xslt="math.min.2.xsl" result="math.min.result.2.xml" />
   <exslt:use-case type="error" data="math.min.data.1.xml"
                   xslt="math.min.3.xsl">
      <exslt:doc xmlns="">
         <para>
            This use case shows an error when the function is passed a 
            number as the value of the first argument.
         </para>
      </exslt:doc>
   </exslt:use-case>
   <exslt:use-case type="error" template="yes" data="math.min.data.1.xml"
                   xslt="math.min.4.xsl">
      <exslt:doc>
         <para>
            This use case shows an error when the function is passed a 
            number as the value of the <parameter>nodes</parameter> 
            parameter.
         </para>
      </exslt:doc>
   </exslt:use-case>
</exslt:use-cases>

</exslt:function>"""


if __name__ == '__main__':
    from Ft.Lib import TestSuite
    tester = TestSuite.TestSuite(1,1)
    import sys
    Test(tester)
