from Ft.Rdf import RdfException, ParseException
from Ft.Rdf.SchemaHandler import RdfsConstraintViolation

try:
    import os, gettext
    locale_dir = os.path.split(__file__)[0]
    gettext.install('4Suite', locale_dir)
except (ImportError, AttributeError, IOError):
    def _(msg):
        return msg

RDF_ERROR_MESSAGES = {
    RdfException.FEATURE_NOT_SUPPORTED: _('RDF 1.0 core feature not yet supported: %s'),
    RdfException.INVALID_FLAG: _('Invalid flag: "%s"'),
    RdfException.INVALID_CONTAINER_TYPE: _("Invalid Container Type: %s"),
    RdfException.INVALID_REGEX_STATEMENT: _("Invalid Regualr Expression %s: %s"),
    RdfException.ABOUT_EACH_OBJECT_NOT_CONTAINER: _("The object of a statement using aboutEach must be a container"),

    #RdfException.: _(),
    }

PARSE_ERROR_MESSAGES = {
    #ParseException.: _(),
    ParseException.FEATURE_NOT_SUPPORTED: _('RDF 1.0 XML serialization feature not yet supported: %s'),
    ParseException.INVALID_PREDICATE: _('Invalid predicate in RDF base URI: %s'),
    ParseException.MULTIPLE_VALUE_OBJECTS: _('The value of property %s must be a single object or a string literal.'),
    ParseException.INVALID_CONTAINER_PROPERTY: _("Only member Attrs or members allowed on a container object"),
    ParseException.INVALID_CONTAINER_TYPE: _("Invalid container type: %s"),
    ParseException.NONEMPTY_PROPELT_WITH_PROPATTRS: _("%s, a non-empty property element should not have property attributes."),
    }

RDFS_ERROR_MESSAGES = {
    RdfsConstraintViolation.INVALID_DOMAIN_FOR_PROPERTY: _('"%s" is an invalid subject for "%s" according to domain constraints.'),
    RdfsConstraintViolation.INVALID_RANGE_FOR_PROPERTY: _('"%s" is an invalid object for "%s" according to range constraints.'),
    RdfsConstraintViolation.PROPERTY_HAS_MULTIPLE_RANGES: _('Property "%s" has multiple ranges.'),

    #RdfsException.: _(),
    }

