############################################################################
#
# File Name: 		BidirectionalIterator.py
#
# Documentation:	http://docs.ftsuite.com/4ODS/BidirectionalIterator.py.html
#
"""
Bi-directional iterator class.
WWW: http://4suite.org/4ODS         e-mail: support@4suite.org

Copyright (c) 1999 Fourthought, Inc., USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

from Ft.Ods.Collections import Iterator

#Exception classes
class InvalidCollectionType:
    pass

class NoMoreElements:
    pass

class BidirectionalIterator(Iterator.Iterator):
    def __init__(self, collection,stable=0):
        Iterator.Iterator.__init__(self, collection,stable)

    def at_beginning(self):
        return self._index == 0

    def previous_position(self):
        if not self.at_beginning():
            self._index = self._index - 1

