#include "ds_tools.h"
#include "expat2domlette.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>


/* NsMapping */

void free_nsmapping(void *ptr)
{
  NsMapping *nsm = (NsMapping *)ptr;
  free(nsm->uri);
  free(nsm->prefix);
  free(nsm);
}


int matchUri(const void *t, const void *c){
  XML_Char *target_uri = (XML_Char *)t;
  NsMapping *candidate = (NsMapping *)c;
  return (strcmp(target_uri, candidate->uri) == 0);
}


int matchPrefix(const void *t, const void *c){
  XML_Char *target_prefix = (XML_Char *)t;
  NsMapping *candidate = (NsMapping *)c;
  return (strcmp(target_prefix, candidate->prefix) == 0);
}


int matchNsMapping(const void *a, const void *b){
  NsMapping *x = (NsMapping *)a;
  NsMapping *y = (NsMapping *)b;
  return (strcmp(x->uri, y->uri) == 0 && strcmp(x->prefix, y->prefix) == 0);
}


/* Debugging tools */

void print_pystring(void *ptr){
  PyObject *pystring = (PyObject *)ptr;
  fprintf(stderr, "\t\t\"\"\"%s\"\"\"\n", PyString_AS_STRING(pystring));
}


void print_spe_hexdump(void *ptr){
  PyObject *pystring = (PyObject *)ptr;
  fprintf(stderr, "\t\t\"\"\"%s\"\"\"\n", PyString_AS_STRING(pystring));
}


void dumpIntList(List *l, const char *desc)
{
  ListElmt *curr = NULL;
  int ci;

  fprintf(stderr, "int list: %s: ", desc);
  for (curr = list_head(l); curr; curr = list_next(curr)){
    ci = *(int *)list_data(curr);
    fprintf(stderr, ", %d", ci);
  }
  fprintf(stderr, "\n");
}

void dumpNsMappingList(List *l, const char *desc)
{
  ListElmt *curr = NULL;
  NsMapping *nsm = NULL;

  fprintf(stderr, "NsMapping list: %s: ", desc);
  for (curr = list_head(l); curr; curr = list_next(curr)){
    nsm = (NsMapping *)list_data(curr);
    fprintf(stderr, " %s{}%s", nsm->prefix, nsm->uri);
  }
  fprintf(stderr, "\n");
}

void dumpState(State *state)
{
  fprintf(stderr, "Current Text: %s\n", state->curr_text);
}

