#ifndef DOMLETTE_H
#define DOMLETTE_H
#ifdef __cplusplus
extern "C" {
#endif

#include "Python.h"
#include "ds_primitives.h"
#include "ds_tools.h"
#include "string_pool.h"

#define XMLNS_NAMESPACE "http://www.w3.org/2000/xmlns/"
#define XML_NAMESPACE "http://www.w3.org/XML/1998/namespace"

#if defined(_WIN32) || defined(__WIN32__)
#  define strcasecmp stricmp
#endif


  enum NodeType {ELEMENT_NODE=1,
         ATTRIBUTE_NODE,
         TEXT_NODE ,
         CDATA_SECTION_NODE,
         ENTITY_REFERENCE_NODE,
         ENTITY_NODE,
         PROCESSING_INSTRUCTION_NODE,
         COMMENT_NODE,
         DOCUMENT_NODE,
         DOCUMENT_TYPE_NODE,
         DOCUMENT_FRAGMENT_NODE,
         NOTATION_NODE
  };


  /*Global Instances of the NodeTypes*/
  PyObject *g_elementNodeType;
  PyObject *g_attrNodeType;
  PyObject *g_textNodeType;
  PyObject *g_cdataSectionNodeType;
  PyObject *g_entityRefNodeType;
  PyObject *g_entityNodeType;
  PyObject *g_processingInstructionNodeType;
  PyObject *g_commentNodeType;
  PyObject *g_documentNodeType;
  PyObject *g_documentTypeNodeType;
  PyObject *g_documentFragmentNodeType;
  PyObject *g_notationNodeType;

  /*Global Instances of the NodeNames*/
  PyObject *g_textNodeName;
  PyObject *g_cdataSectionNodeName;
  PyObject *g_commentNodeName;
  PyObject *g_documentNodeName;
  PyObject *g_documentFragmentNodeName;


  typedef struct NodeStruct {
    PyObject *namespaceURI;
    PyObject *prefix;
    PyObject *localName;
    PyObject *nodeName;
    PyObject *parentNode;
    PyObject *ownerDocument;
    long docIndex;
  } Node;

  typedef struct AttrStruct {
    PyObject *nodeValue;
  } Attr;

  typedef struct DocumentStruct {
    StringPool *stringPool;
    PyObject *documentElement;
    PyObject *childNodes;
    PyObject *refUri;
  } Document;

  typedef struct ElementStruct {
    PyObject *attributes;
    PyObject *childNodes;
  } Element;

  typedef struct TextStruct {
    PyObject *nodeValue;
  } Text;

  typedef struct CommentStruct {
    PyObject *nodeValue;
  } Comment;

  typedef struct ProcessingInstructionStruct {
    PyObject *target;
    PyObject *nodeValue;
  } ProcessingInstruction;

  /*Just for access*/
  typedef struct {
    PyObject_HEAD
    Node nodeData;
  } PyNodeObject;

  typedef struct {
    PyObject_HEAD
    Node nodeData;
    Document documentData;
  } PyDocumentObject;

  typedef struct {
    PyObject_HEAD
    Node nodeData;
    Element elementData;
  } PyElementObject;


  typedef struct {
    PyObject_HEAD
    Node nodeData;
    Text textData;
  } PyTextObject;

  typedef struct {
    PyObject_HEAD
    Node nodeData;
    Comment commentData;
  } PyCommentObject;

  typedef struct {
    PyObject_HEAD
    Node nodeData;
    Attr attrData;
  } PyAttrObject;

  typedef struct {
    PyObject_HEAD
    Node nodeData;
    ProcessingInstruction piData;
  } PyProcessingInstructionObject;

  typedef struct {
    PyObject_HEAD
  } PyDOMImplementationObject;


  extern DL_EXPORT(PyTypeObject) PyDomletteDocument_Type;
  extern DL_EXPORT(PyTypeObject) PyDomletteElement_Type;
  extern DL_EXPORT(PyTypeObject) PyDomletteText_Type;
  extern DL_EXPORT(PyTypeObject) PyDomletteComment_Type;
  extern DL_EXPORT(PyTypeObject) PyDomletteAttr_Type;
  extern DL_EXPORT(PyTypeObject) PyDomletteProcessingInstruction_Type;
  extern DL_EXPORT(PyTypeObject) PyDomletteDOMImplementation_Type;

#define PyDocument_Check(op) ((op)->ob_type == &PyDomletteDocument_Type)
#define PyDOMImplementation_Check(op) ((op)->ob_type == &PyDomletteDOMImplementation_Type)
#define PyElement_Check(op) ((op)->ob_type == &PyDomletteElement_Type)
#define PyText_Check(op) ((op)->ob_type == &PyDomletteText_Type)
#define PyProcessingInstruction_Check(op) ((op)->ob_type == &PyDomletteProcessingInstruction_Type)
#define PyComment_Check(op) ((op)->ob_type == &PyDomletteComment_Type)
#define PyAttr_Check(op) ((op)->ob_type == &PyDomletteAttr_Type)
#define PyNode_Check(op) (PyDocument_Check(op) || PyElement_Check(op) || PyText_Check(op) || PyProcessingInstruction_Check(op) || PyComment_Check(op) || PyAttr_Check(op))



  /* util.c functions */
  char *nodename_from_parts(const char *prefix, const char *localName);
  void cleanupTempPyStrings(PyObject **tpsbuffer);


#if (PY_MAJOR_VERSION == 1 && PY_MINOR_VERSION < 6)

#define STRING_TYPE_CHECK(OBJ) (PyString_Check(OBJ))

#else

#define STRING_TYPE_CHECK(OBJ) (PyUnicode_Check(OBJ) || PyString_Check(OBJ))

/* Mostly borrowed from PyXML's pyexpat */
/* FIXME: support UTF-16 as well from expat */

#if (0)

static PyObject * string_to_pyunicode(const XML_Char *str, int len)
{
    /* UTF-8 from Expat, Unicode desired */
    if (str == NULL) {
        Py_INCREF(Py_None);
        return Py_None;
    }
    return PyUnicode_DecodeUTF8((const char *)str, len, "strict");
}

#endif

#endif


extern PyObject *ErrorObject;
extern PyObject *g_emptyAttributes;
extern PyObject *g_emptyChildNodes;
extern PyObject *g_implementation;


  /*Node Methods */
  void Node_ReleaseNode(PyNodeObject *node);
  void Node_INIT(PyNodeObject *node, PyDocumentObject *ownerDocument);
  void node_dealloc(PyNodeObject *node);
  PyObject *node_getattr(PyNodeObject *self, char *name,struct PyMethodDef methods[]);
  PyNodeObject *Node_AppendChild(PyNodeObject * self,PyNodeObject *child);
  PyNodeObject *PyNode_AppendChild(PyNodeObject *self, PyNodeObject *child);
  PyObject *PyNode_normalize(PyObject * self, PyObject * args);
  PyObject *PyNode_hasChildNodes(PyObject * self, PyObject * args);
  PyObject *PyNode_removeChild(PyObject *self,PyObject *args);
  PyObject *PyNode_isSameNode(PyObject *self, PyObject *args);
#define NODE_METHODS {"normalize",   (PyCFunction)PyNode_normalize,  METH_VARARGS, "Combine all neighboring text child nodes"}, \
                     {"hasChildNodes",   (PyCFunction)PyNode_hasChildNodes,  METH_VARARGS, "Return True if the node has children"}, \
                     {"removeChild",   (PyCFunction)PyNode_removeChild,  METH_VARARGS, "Remove a node from a child list"}, \
                     {"isSameNode",   (PyCFunction)PyNode_isSameNode,  METH_VARARGS, "true if this node instance is the same as another"}


  /*Document Methods */
  PyDocumentObject *Document_NEW(unsigned long *docIx, const char *refUri);
  PyNodeObject *Document_AppendChild(PyDocumentObject *self,
                                     PyNodeObject *child);
  void Document_ReleaseNode(PyDocumentObject *node);
  PyElementObject *Document_CreateElementNS(PyDocumentObject *self,
					    const char *namespaceURI,
					    const char *localName,
					    const char *prefix,
					    unsigned long *docIx);
  PyProcessingInstructionObject *Document_CreateProcessingInstruction(PyDocumentObject *self,
								    const char *target,
								    const char *data,
								    unsigned long *docIx);
  PyTextObject *Document_CreateTextNode(PyDocumentObject *self,
                                        const char *data,
                                        unsigned long *docIx);
  PyCommentObject *Document_CreateComment(PyDocumentObject *self,
                                          const char *data,
                                          unsigned long *docIx);

  /*Element Methods */
  void Element_ReleaseNode(PyElementObject *node);


  PyNodeObject *Element_AppendChild(PyElementObject *self,
				    PyNodeObject *child);


  void Element_SetAttributeNS(PyElementObject *self,const char *namespaceURI,
			      const char *localName, const char *prefix,
			      const char *value, unsigned long *docIx);

  /*Attr Methods */
  void Attr_ReleaseNode(PyAttrObject *node);

  /*Character Data Methods */
  PyObject *PyCharacterData_substringData(PyObject * self, PyObject * args);
#define CHARACTERDATA_METHODS {"substringData",  (PyCFunction)PyCharacterData_substringData,  METH_VARARGS,"Return a Substring of the data"}

  /*Text Methods */
  void Text_ReleaseNode(PyTextObject *node);

  /*Comment Methods */
  void Comment_ReleaseNode(PyCommentObject *node);

  /*PI Methods */
  void ProcessingInstruction_ReleaseNode(PyProcessingInstructionObject *node);



#ifdef __cplusplus
}
#endif
#endif /* !DOMLETTEOBJECT_H */

