#include "domlette.h"
#include "expat2domlette.h"
#include <stdlib.h>
#include <stdio.h>
#include <assert.h>


PyObject *ErrorObject = NULL;
PyObject *g_emptyAttributes = NULL;
PyObject *g_emptyChildNodes = NULL;
PyObject *g_implementation = NULL;


/*
  These are the external interfaces
*/

PyObject *PyParse(PyObject *self, PyObject *args, PyObject *kwords) {
  PyObject *_argc0;
  PyObject *readmethod;
  PyDocumentObject *doc;
  PyObject *stripElements = NULL;
  PyObject *temp;
  StripSpec *strips = NULL;
  int ctr = 0;
  int numStripElements = 0;
  static char *kwlist[] = {"stream", "refUri", "stripElements", NULL};
  PyObject *tuple_item;
  PyObject *temp_pystring = NULL;
  PyObject **temp_pystrings = {NULL};
#if !(PY_MAJOR_VERSION == 1 && PY_MINOR_VERSION < 6)
  PyObject **curr_tps;
#endif
  char *buffer, *refUri;

  if(!PyArg_ParseTupleAndKeywords(args, kwords, "Os|O:parse", kwlist, &_argc0,
                                  &refUri, &stripElements))
    return NULL;

  if (stripElements) {
    if (!PyList_Check(stripElements) ) {
      /*stripElements Exception*/
      PyErr_SetString(ErrorObject, "stripElements argument must be of type list");
      return NULL;
    }
    numStripElements = PyList_GET_SIZE(stripElements);
    strips = (StripSpec *)malloc(sizeof(UniversalName)*numStripElements);
#if !(PY_MAJOR_VERSION == 1 && PY_MINOR_VERSION < 6)
    temp_pystrings = (PyObject **)calloc(numStripElements, sizeof(PyObject *));
    curr_tps = temp_pystrings;
#endif
    for (ctr=0; ctr < numStripElements; ctr++) {
      temp = PyList_GET_ITEM(stripElements,ctr);
      if (!PyTuple_Check(temp)) {
        PyErr_SetString(ErrorObject, "The individual elements of the stripElments list must be tuples of two strings and an integer 0 or 1.");
        cleanupTempPyStrings(temp_pystrings);
        return NULL;
      }
      if (PyTuple_GET_SIZE(temp) != 3) {
        PyErr_SetString(ErrorObject, "The individual elements of the stripElments list must be tuples of two strings and an integer 0 or 1.");
        cleanupTempPyStrings(temp_pystrings);
        return NULL;
      }
      tuple_item = PyTuple_GET_ITEM(temp, 0);
      if (PyString_Check(tuple_item)) {
        buffer = PyString_AS_STRING(tuple_item);
      }
#if !(PY_MAJOR_VERSION == 1 && PY_MINOR_VERSION < 6)
      else if (PyUnicode_Check(tuple_item)) {
        temp_pystring = PyUnicode_AsUTF8String(tuple_item);
        *curr_tps++ = temp_pystring;
        buffer = PyString_AS_STRING(temp_pystring);
      }
#endif
      else {
        PyErr_SetString(ErrorObject, "A first tuple item in stripElements is not a string.");
        cleanupTempPyStrings(temp_pystrings);
        return NULL;
      }
      strips[ctr].uri = buffer;
      tuple_item = PyTuple_GET_ITEM(temp, 1);
      if (PyString_Check(tuple_item)) {
        buffer = PyString_AS_STRING(tuple_item);
      }
#if !(PY_MAJOR_VERSION == 1 && PY_MINOR_VERSION < 6)
      else if (PyUnicode_Check(tuple_item)) {
        temp_pystring = PyUnicode_AsUTF8String(tuple_item);
        *curr_tps++ = temp_pystring;
        buffer = PyString_AS_STRING(temp_pystring);
      }
#endif
      else {
        PyErr_SetString(ErrorObject, "A second tuple item in stripElements is not a string.");
        cleanupTempPyStrings(temp_pystrings);
        return NULL;
      }
      strips[ctr].local = buffer;
      if (!PyInt_Check(PyTuple_GET_ITEM(temp,2))) {
        PyErr_SetString(ErrorObject, "A third tuple item in stripElements is not an integer 0 or 1.");
        cleanupTempPyStrings(temp_pystrings);
        return NULL;
      }
      strips[ctr].strip_flag = PyInt_AS_LONG(PyTuple_GET_ITEM(temp, 2));
    }
  } else {
    numStripElements = 0;
  }

  /*refUriStr = PyString_AS_STRING(refUri);*/

  /*Fixme check for attr first*/
  readmethod = PyObject_GetAttrString(_argc0, "read");

  doc = beginParse(NULL, readmethod, strips, numStripElements, refUri);

  if (numStripElements) {
      cleanupTempPyStrings(temp_pystrings);
  }
  /*Free up the strip elements*/
  free(strips);

  /*The doc is created with a count of 1, so no need to inc it*/
  /*Py_XINCREF(doc);*/
  return (PyObject *)doc;
}

static PyObject *PyReleaseNode(PyObject * self,PyObject *args)
{
  PyObject *_argc0;

  if (!PyArg_ParseTuple(args,"O:ReleaseNode",&_argc0))
    return NULL;

  if (!PyNode_Check((PyNodeObject *)_argc0)){
    PyErr_SetString(ErrorObject, "ReleaseNode must be invoked with a cDomlette node object.");
    return NULL;
  }

  Node_ReleaseNode((PyNodeObject *)_argc0);

  Py_INCREF(Py_None);
  return Py_None;
}


/*The external interface definitions */
static PyMethodDef cDomlettecMethods[] = {

     { "ReleaseNode", PyReleaseNode, 1 },
     { "parse", (PyCFunction)PyParse, METH_VARARGS|METH_KEYWORDS },
    
     { NULL, NULL }
};




void initcDomlettec () {
    PyObject *m,*d;
    register PyDOMImplementationObject *domimp;

    m = Py_InitModule("cDomlettec", cDomlettecMethods);
    d = PyModule_GetDict(m);
    /*PyDict_SetItemString(d,"ELEMENT_NODE", PyInt_FromLong((long) ELEMENT_NODE));
    PyDict_SetItemString(d,"ATTRIBUTE_NODE", PyInt_FromLong((long) ATTRIBUTE_NODE));
    PyDict_SetItemString(d,"TEXT_NODE", PyInt_FromLong((long) TEXT_NODE));
    PyDict_SetItemString(d,"CDATA_SECTION_NODE", PyInt_FromLong((long) CDATA_SECTION_NODE));
    PyDict_SetItemString(d,"ENTITY_REFERENCE_NODE", PyInt_FromLong((long) ENTITY_REFERENCE_NODE));
    PyDict_SetItemString(d,"ENTITY_NODE", PyInt_FromLong((long) ENTITY_NODE));
    PyDict_SetItemString(d,"PROCESSING_INSTRUCTION_NODE", PyInt_FromLong((long) PROCESSING_INSTRUCTION_NODE));
    PyDict_SetItemString(d,"COMMENT_NODE", PyInt_FromLong((long) COMMENT_NODE));
    PyDict_SetItemString(d,"DOCUMENT_NODE", PyInt_FromLong((long) DOCUMENT_NODE));
    PyDict_SetItemString(d,"DOCUMENT_TYPE_NODE", PyInt_FromLong((long) DOCUMENT_TYPE_NODE));
    PyDict_SetItemString(d,"DOCUMENT_FRAGMENT_NODE", PyInt_FromLong((long) DOCUMENT_FRAGMENT_NODE));
    PyDict_SetItemString(d,"NOTATION_NODE", PyInt_FromLong((long) NOTATION_NODE));*/




    ErrorObject = PyErr_NewException("cDomlettec.error", NULL, NULL);
    PyDict_SetItemString(d, "error", (PyObject *)ErrorObject);
    Py_INCREF(ErrorObject);

    PyDomletteDocument_Type.ob_type = &PyType_Type;
    PyDomletteElement_Type.ob_type = &PyType_Type;
    PyDomletteText_Type.ob_type = &PyType_Type;
    PyDomletteComment_Type.ob_type = &PyType_Type;
    PyDomletteProcessingInstruction_Type.ob_type = &PyType_Type;
    PyDomletteAttr_Type.ob_type = &PyType_Type;

    PyDict_SetItemString(d,"DocumentType", (PyObject *)&PyDomletteDocument_Type);
    PyDict_SetItemString(d,"ElementType", (PyObject *)&PyDomletteElement_Type);
    PyDict_SetItemString(d,"TextType", (PyObject *)&PyDomletteText_Type);
    PyDict_SetItemString(d,"CommentType", (PyObject *)&PyDomletteComment_Type);
    PyDict_SetItemString(d,"ProcessingInstructionType", (PyObject *)&PyDomletteProcessingInstruction_Type);
    PyDict_SetItemString(d,"AttrType", (PyObject *)&PyDomletteAttr_Type);


    g_elementNodeType =  (PyObject *)PyInt_FromLong(1);
    Py_INCREF(g_elementNodeType);
    g_attrNodeType =  (PyObject *)PyInt_FromLong(2);
    Py_INCREF(g_attrNodeType);
    g_textNodeType =  (PyObject *)PyInt_FromLong(3);
    Py_INCREF(g_textNodeType);
    g_cdataSectionNodeType =  (PyObject *)PyInt_FromLong(4);
    Py_INCREF(g_cdataSectionNodeType);
    g_entityRefNodeType =  (PyObject *)PyInt_FromLong(5);
    Py_INCREF(g_entityRefNodeType);
    g_entityNodeType =  (PyObject *)PyInt_FromLong(6);
    Py_INCREF(g_entityNodeType);
    g_processingInstructionNodeType =  (PyObject *)PyInt_FromLong(7);
    Py_INCREF(g_processingInstructionNodeType);
    g_commentNodeType =  (PyObject *)PyInt_FromLong(8);
    Py_INCREF(g_commentNodeType);
    g_documentNodeType =  (PyObject *)PyInt_FromLong(9);
    Py_INCREF(g_documentNodeType);
    g_documentTypeNodeType =  (PyObject *)PyInt_FromLong(10);
    Py_INCREF(g_documentTypeNodeType);
    g_documentFragmentNodeType =  (PyObject *)PyInt_FromLong(11);
    Py_INCREF(g_documentFragmentNodeType);
    g_notationNodeType =  (PyObject *)PyInt_FromLong(12);
    Py_INCREF(g_notationNodeType);


    g_textNodeName =  (PyObject *)PyString_FromString("#text");
    Py_INCREF(g_textNodeName);
    g_cdataSectionNodeName =  (PyObject *)PyString_FromString("#cdata-section");
    Py_INCREF(g_cdataSectionNodeName);
    g_commentNodeName =  (PyObject *)PyString_FromString("#comment");
    Py_INCREF(g_commentNodeName);
    g_documentNodeName =  (PyObject *)PyString_FromString("#document");
    Py_INCREF(g_documentNodeName);
    g_documentFragmentNodeName =  (PyObject *)PyString_FromString("#document-fragment");
    Py_INCREF(g_documentFragmentNodeName);


    g_emptyAttributes = Py_None;
    Py_INCREF(g_emptyAttributes);
    g_emptyChildNodes = PyList_New(0);
    /* No need to INCREF, it is a new object */
    /* Py_INCREF(g_emptyChildNodes); */


    /*Create our implementation*/
#if PY_MAJOR_VERSION == 1 && PY_MINOR_VERSION < 6
    domimp = PyObject_NEW(PyDOMImplementationObject, &PyDomletteDOMImplementation_Type);
#else
    /* Python versions 1.6 and later */
    domimp = PyObject_New(PyDOMImplementationObject, &PyDomletteDOMImplementation_Type);
#endif
    PyDict_SetItemString(d, "implementation", (PyObject *)domimp);
    g_implementation = (PyObject *)domimp;

}


