########################################################################
#
# File Name:            __init__.py
#
# Documentation:        http://docs.4suite.org/Lib/__init__.py.html
#
"""
WWW: http://4suite.org/Lib         e-mail: support@4suite.org

Copyright (c) 2000-2001 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

PDOMLETTE=1
CDOMLETTE=2

from xml.FtCore import FtException

class ReaderException(FtException):
    XML_PARSE_ERROR = 100
    XML_SAX_PARSE_ERROR = 101
    XMLNS_UNKNOWN_PREFIX = 200

    def __init__(self, errorCode, *args):
        FtException.__init__(self, errorCode, MessageSource.READER, args)
        return

class PdomletteException(FtException):
    PICKLE_DOCUMENT = 500    
    PICKLE_DOCUMENT_FRAGMENT = 501

    def __init__(self, errorCode, *args):
        FtException.__init__(self, errorCode, MessageSource.PDOMLETTE, args)
        return

class PgException(FtException):
    NO_PYGRES = 2500

    def __init__(self, errorCode, *args):
        FtException.__init__(self, errorCode, MessageSource.POSTGRES, args)
        return

class XIncludeException(FtException):
    XINCLUDE_MISSING_HREF = 10
    CIRCULAR_INCLUDE_ERROR = 20

    def __init__(self, errorCode, *args):
        FtException.__init__(self, errorCode, MessageSource.XINCLUDE, args)
        return


import MessageSource

