#
# Chris Lumens <clumens@redhat.com>
#
# Copyright 2007, 2008, 2009, 2010 Red Hat, Inc.
#
# This copyrighted material is made available to anyone wishing to use, modify,
# copy, or redistribute it subject to the terms and conditions of the GNU
# General Public License v.2.  This program is distributed in the hope that it
# will be useful, but WITHOUT ANY WARRANTY expressed or implied, including the
# implied warranties of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc., 51
# Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.  Any Red Hat
# trademarks that are incorporated in the source code or documentation are not
# subject to the GNU General Public License and may only be used or replicated
# with the express permission of Red Hat, Inc. 
#
from pykickstart.version import *
from pykickstart.commands import *

"""This map is keyed on kickstart syntax version as provided by
   pykickstart.version.  Within each sub-dict is a mapping from command name
   to the class that handles it.  This is an onto mapping - that is, multiple
   command names can map to the same class.  However, the Handler will ensure
   that only one instance of each class ever exists.
"""
commandMap = {
    FC3: {
        "auth": authconfig.FC3_Authconfig,
        "authconfig": authconfig.FC3_Authconfig,
        "autopart": autopart.FC3_AutoPart,
        "autostep": autostep.FC3_AutoStep,
        "bootloader": bootloader.FC3_Bootloader,
        "cdrom": method.FC3_Method,
        "clearpart": clearpart.FC3_ClearPart,
        "cmdline": displaymode.FC3_DisplayMode,
        "device": device.FC3_Device,
        "deviceprobe": deviceprobe.FC3_DeviceProbe,
        "driverdisk": driverdisk.FC3_DriverDisk,
        "firewall": firewall.FC3_Firewall,
        "firstboot": firstboot.FC3_Firstboot,
        "graphical": displaymode.FC3_DisplayMode,
        "halt": reboot.FC3_Reboot,
        "harddrive": method.FC3_Method,
        "ignoredisk": ignoredisk.FC3_IgnoreDisk,
        "install": upgrade.FC3_Upgrade,
        "interactive": interactive.FC3_Interactive,
        "keyboard": keyboard.FC3_Keyboard,
        "lang": lang.FC3_Lang,
        "langsupport": langsupport.FC3_LangSupport,
        "lilo": bootloader.FC3_Bootloader,
        "lilocheck": lilocheck.FC3_LiloCheck,
        "logvol": logvol.FC3_LogVol,
        "monitor": monitor.FC3_Monitor,
        "mouse": mouse.FC3_Mouse,
        "network": network.FC3_Network,
        "nfs": method.FC3_Method,
        "part": partition.FC3_Partition,
        "partition": partition.FC3_Partition,
        "poweroff": reboot.FC3_Reboot,
        "raid": raid.FC3_Raid,
        "reboot": reboot.FC3_Reboot,
        "rootpw": rootpw.FC3_RootPw,
        "selinux": selinux.FC3_SELinux,
        "shutdown": reboot.FC3_Reboot,
        "skipx": skipx.FC3_SkipX,
        "text": displaymode.FC3_DisplayMode,
        "timezone": timezone.FC3_Timezone,
        "upgrade": upgrade.FC3_Upgrade,
        "url": method.FC3_Method,
        "vnc": vnc.FC3_Vnc,
        "volgroup": volgroup.FC3_VolGroup,
        "xconfig": xconfig.FC3_XConfig,
        "zerombr": zerombr.FC3_ZeroMbr,
        "zfcp": zfcp.FC3_ZFCP,
    },

    # based on fc3
    FC4: {
        "auth": authconfig.FC3_Authconfig,
        "authconfig": authconfig.FC3_Authconfig,
        "autopart": autopart.FC3_AutoPart,
        "autostep": autostep.FC3_AutoStep,
        "bootloader": bootloader.FC4_Bootloader,
        "cdrom": method.FC3_Method,
        "clearpart": clearpart.FC3_ClearPart,
        "cmdline": displaymode.FC3_DisplayMode,
        "device": device.FC3_Device,
        "deviceprobe": deviceprobe.FC3_DeviceProbe,
        "driverdisk": driverdisk.FC4_DriverDisk,
        "firewall": firewall.FC3_Firewall,
        "firstboot": firstboot.FC3_Firstboot,
        "graphical": displaymode.FC3_DisplayMode,
        "halt": reboot.FC3_Reboot,
        "harddrive": method.FC3_Method,
        "ignoredisk": ignoredisk.FC3_IgnoreDisk,
        "install": upgrade.FC3_Upgrade,
        "interactive": interactive.FC3_Interactive,
        "keyboard": keyboard.FC3_Keyboard,
        "lang": lang.FC3_Lang,
        "langsupport": langsupport.FC3_LangSupport,
        "logvol": logvol.FC4_LogVol,
        "mediacheck": mediacheck.FC4_MediaCheck,
        "monitor": monitor.FC3_Monitor,
        "mouse": mouse.FC3_Mouse,
        "network": network.FC4_Network,
        "nfs": method.FC3_Method,
        "part": partition.FC4_Partition,
        "partition": partition.FC4_Partition,
        "poweroff": reboot.FC3_Reboot,
        "raid": raid.FC4_Raid,
        "reboot": reboot.FC3_Reboot,
        "rootpw": rootpw.FC3_RootPw,
        "selinux": selinux.FC3_SELinux,
        "shutdown": reboot.FC3_Reboot,
        "skipx": skipx.FC3_SkipX,
        "text": displaymode.FC3_DisplayMode,
        "timezone": timezone.FC3_Timezone,
        "upgrade": upgrade.FC3_Upgrade,
        "url": method.FC3_Method,
        "vnc": vnc.FC3_Vnc,
        "volgroup": volgroup.FC3_VolGroup,
        "xconfig": xconfig.FC3_XConfig,
        "zerombr": zerombr.FC3_ZeroMbr,
        "zfcp": zfcp.FC3_ZFCP,
    },

    # based on fc4
    FC5: {
        "auth": authconfig.FC3_Authconfig,
        "authconfig": authconfig.FC3_Authconfig,
        "autopart": autopart.FC3_AutoPart,
        "autostep": autostep.FC3_AutoStep,
        "bootloader": bootloader.FC4_Bootloader,
        "cdrom": method.FC3_Method,
        "clearpart": clearpart.FC3_ClearPart,
        "cmdline": displaymode.FC3_DisplayMode,
        "device": device.FC3_Device,
        "deviceprobe": deviceprobe.FC3_DeviceProbe,
        "driverdisk": driverdisk.FC4_DriverDisk,
        "firewall": firewall.FC3_Firewall,
        "firstboot": firstboot.FC3_Firstboot,
        "graphical": displaymode.FC3_DisplayMode,
        "halt": reboot.FC3_Reboot,
        "harddrive": method.FC3_Method,
        "ignoredisk": ignoredisk.FC3_IgnoreDisk,
        "install": upgrade.FC3_Upgrade,
        "interactive": interactive.FC3_Interactive,
        "keyboard": keyboard.FC3_Keyboard,
        "lang": lang.FC3_Lang,
        "langsupport": langsupport.FC5_LangSupport,
        "logvol": logvol.FC4_LogVol,
        "mediacheck": mediacheck.FC4_MediaCheck,
        "monitor": monitor.FC3_Monitor,
        "mouse": mouse.FC3_Mouse,
        "network": network.FC4_Network,
        "nfs": method.FC3_Method,
        "part": partition.FC4_Partition,
        "partition": partition.FC4_Partition,
        "poweroff": reboot.FC3_Reboot,
        "raid": raid.FC5_Raid,
        "reboot": reboot.FC3_Reboot,
        "rootpw": rootpw.FC3_RootPw,
        "selinux": selinux.FC3_SELinux,
        "shutdown": reboot.FC3_Reboot,
        "skipx": skipx.FC3_SkipX,
        "text": displaymode.FC3_DisplayMode,
        "timezone": timezone.FC3_Timezone,
        "upgrade": upgrade.FC3_Upgrade,
        "url": method.FC3_Method,
        "vnc": vnc.FC3_Vnc,
        "volgroup": volgroup.FC3_VolGroup,
        "xconfig": xconfig.FC3_XConfig,
        "zerombr": zerombr.FC3_ZeroMbr,
        "zfcp": zfcp.FC3_ZFCP,
    },

    # based on fc5
    FC6: {
        "auth": authconfig.FC3_Authconfig,
        "authconfig": authconfig.FC3_Authconfig,
        "autopart": autopart.FC3_AutoPart,
        "autostep": autostep.FC3_AutoStep,
        "bootloader": bootloader.FC4_Bootloader,
        "cdrom": method.FC6_Method,
        "clearpart": clearpart.FC3_ClearPart,
        "cmdline": displaymode.FC3_DisplayMode,
        "device": device.FC3_Device,
        "deviceprobe": deviceprobe.FC3_DeviceProbe,
        "dmraid": dmraid.FC6_DmRaid,
        "driverdisk": driverdisk.FC4_DriverDisk,
        "firewall": firewall.FC3_Firewall,
        "firstboot": firstboot.FC3_Firstboot,
        "graphical": displaymode.FC3_DisplayMode,
        "halt": reboot.FC6_Reboot,
        "harddrive": method.FC6_Method,
        "ignoredisk": ignoredisk.FC3_IgnoreDisk,
        "install": upgrade.FC3_Upgrade,
        "interactive": interactive.FC3_Interactive,
        "iscsi": iscsi.FC6_Iscsi,
        "iscsiname": iscsiname.FC6_IscsiName,
        "keyboard": keyboard.FC3_Keyboard,
        "lang": lang.FC3_Lang,
        "langsupport": langsupport.FC5_LangSupport,
        "logging": logging.FC6_Logging,
        "logvol": logvol.FC4_LogVol,
        "mediacheck": mediacheck.FC4_MediaCheck,
        "monitor": monitor.FC6_Monitor,
        "mouse": mouse.FC3_Mouse,
        "multipath": multipath.FC6_MultiPath,
        "network": network.FC6_Network,
        "nfs": method.FC6_Method,
        "part": partition.FC4_Partition,
        "partition": partition.FC4_Partition,
        "poweroff": reboot.FC6_Reboot,
        "raid": raid.FC5_Raid,
        "reboot": reboot.FC6_Reboot,
        "repo": repo.FC6_Repo,
        "rootpw": rootpw.FC3_RootPw,
        "selinux": selinux.FC3_SELinux,
        "services": services.FC6_Services,
        "shutdown": reboot.FC6_Reboot,
        "skipx": skipx.FC3_SkipX,
        "text": displaymode.FC3_DisplayMode,
        "timezone": timezone.FC6_Timezone,
        "upgrade": upgrade.FC3_Upgrade,
        "user": user.FC6_User,
        "url": method.FC6_Method,
        "vnc": vnc.FC6_Vnc,
        "volgroup": volgroup.FC3_VolGroup,
        "xconfig": xconfig.FC6_XConfig,
        "zerombr": zerombr.FC3_ZeroMbr,
        "zfcp": zfcp.FC3_ZFCP,
    },

    # based on fc6
    F7: {
        "auth": authconfig.FC3_Authconfig,
        "authconfig": authconfig.FC3_Authconfig,
        "autopart": autopart.FC3_AutoPart,
        "autostep": autostep.FC3_AutoStep,
        "bootloader": bootloader.FC4_Bootloader,
        "cdrom": method.FC6_Method,
        "clearpart": clearpart.FC3_ClearPart,
        "cmdline": displaymode.FC3_DisplayMode,
        "device": device.FC3_Device,
        "deviceprobe": deviceprobe.FC3_DeviceProbe,
        "dmraid": dmraid.FC6_DmRaid,
        "driverdisk": driverdisk.FC4_DriverDisk,
        "firewall": firewall.FC3_Firewall,
        "firstboot": firstboot.FC3_Firstboot,
        "graphical": displaymode.FC3_DisplayMode,
        "halt": reboot.FC6_Reboot,
        "harddrive": method.FC6_Method,
        "ignoredisk": ignoredisk.FC3_IgnoreDisk,
        "install": upgrade.FC3_Upgrade,
        "interactive": interactive.FC3_Interactive,
        "iscsi": iscsi.FC6_Iscsi,
        "iscsiname": iscsiname.FC6_IscsiName,
        "keyboard": keyboard.FC3_Keyboard,
        "lang": lang.FC3_Lang,
        "logging": logging.FC6_Logging,
        "logvol": logvol.FC4_LogVol,
        "mediacheck": mediacheck.FC4_MediaCheck,
        "monitor": monitor.FC6_Monitor,
        "multipath": multipath.FC6_MultiPath,
        "network": network.FC6_Network,
        "nfs": method.FC6_Method,
        "part": partition.FC4_Partition,
        "partition": partition.FC4_Partition,
        "poweroff": reboot.FC6_Reboot,
        "raid": raid.F7_Raid,
        "reboot": reboot.FC6_Reboot,
        "repo": repo.FC6_Repo,
        "rootpw": rootpw.FC3_RootPw,
        "selinux": selinux.FC3_SELinux,
        "services": services.FC6_Services,
        "shutdown": reboot.FC6_Reboot,
        "skipx": skipx.FC3_SkipX,
        "text": displaymode.FC3_DisplayMode,
        "timezone": timezone.FC6_Timezone,
        "updates": updates.F7_Updates,
        "upgrade": upgrade.FC3_Upgrade,
        "url": method.FC6_Method,
        "user": user.FC6_User,
        "vnc": vnc.FC6_Vnc,
        "volgroup": volgroup.FC3_VolGroup,
        "xconfig": xconfig.FC6_XConfig,
        "zerombr": zerombr.FC3_ZeroMbr,
        "zfcp": zfcp.FC3_ZFCP,
    },

    # based on f7
    F8: {
        "auth": authconfig.FC3_Authconfig,
        "authconfig": authconfig.FC3_Authconfig,
        "autopart": autopart.FC3_AutoPart,
        "autostep": autostep.FC3_AutoStep,
        "bootloader": bootloader.F8_Bootloader,
        "cdrom": method.FC6_Method,
        "clearpart": clearpart.FC3_ClearPart,
        "cmdline": displaymode.FC3_DisplayMode,
        "device": device.F8_Device,
        "deviceprobe": deviceprobe.FC3_DeviceProbe,
        "dmraid": dmraid.FC6_DmRaid,
        "driverdisk": driverdisk.FC4_DriverDisk,
        "firewall": firewall.FC3_Firewall,
        "firstboot": firstboot.FC3_Firstboot,
        "graphical": displaymode.FC3_DisplayMode,
        "halt": reboot.FC6_Reboot,
        "harddrive": method.FC6_Method,
        "ignoredisk": ignoredisk.F8_IgnoreDisk,
        "install": upgrade.FC3_Upgrade,
        "interactive": interactive.FC3_Interactive,
        "iscsi": iscsi.FC6_Iscsi,
        "iscsiname": iscsiname.FC6_IscsiName,
        "keyboard": keyboard.FC3_Keyboard,
        "lang": lang.FC3_Lang,
        "logging": logging.FC6_Logging,
        "logvol": logvol.FC4_LogVol,
        "mediacheck": mediacheck.FC4_MediaCheck,
        "monitor": monitor.FC6_Monitor,
        "multipath": multipath.FC6_MultiPath,
        "network": network.F8_Network,
        "nfs": method.FC6_Method,
        "part": partition.FC4_Partition,
        "partition": partition.FC4_Partition,
        "poweroff": reboot.FC6_Reboot,
        "raid": raid.F7_Raid,
        "reboot": reboot.FC6_Reboot,
        "repo": repo.F8_Repo,
        "rootpw": rootpw.F8_RootPw,
        "selinux": selinux.FC3_SELinux,
        "services": services.FC6_Services,
        "shutdown": reboot.FC6_Reboot,
        "skipx": skipx.FC3_SkipX,
        "text": displaymode.FC3_DisplayMode,
        "timezone": timezone.FC6_Timezone,
        "updates": updates.F7_Updates,
        "upgrade": upgrade.FC3_Upgrade,
        "url": method.FC6_Method,
        "user": user.F8_User,
        "vnc": vnc.FC6_Vnc,
        "volgroup": volgroup.FC3_VolGroup,
        "xconfig": xconfig.FC6_XConfig,
        "zerombr": zerombr.FC3_ZeroMbr,
        "zfcp": zfcp.FC3_ZFCP,
    },

    # based on f8
    F9: {
        "auth": authconfig.FC3_Authconfig,
        "authconfig": authconfig.FC3_Authconfig,
        "autopart": autopart.F9_AutoPart,
        "autostep": autostep.FC3_AutoStep,
        "bootloader": bootloader.F8_Bootloader,
        "cdrom": method.FC6_Method,
        "clearpart": clearpart.FC3_ClearPart,
        "cmdline": displaymode.FC3_DisplayMode,
        "device": device.F8_Device,
        "deviceprobe": deviceprobe.FC3_DeviceProbe,
        "dmraid": dmraid.FC6_DmRaid,
        "driverdisk": driverdisk.FC4_DriverDisk,
        "firewall": firewall.F9_Firewall,
        "firstboot": firstboot.FC3_Firstboot,
        "graphical": displaymode.FC3_DisplayMode,
        "halt": reboot.FC6_Reboot,
        "harddrive": method.FC6_Method,
        "ignoredisk": ignoredisk.F8_IgnoreDisk,
        "install": upgrade.FC3_Upgrade,
        "interactive": interactive.FC3_Interactive,
        "iscsi": iscsi.FC6_Iscsi,
        "iscsiname": iscsiname.FC6_IscsiName,
        "keyboard": keyboard.FC3_Keyboard,
        "lang": lang.FC3_Lang,
        "logging": logging.FC6_Logging,
        "logvol": logvol.F9_LogVol,
        "mediacheck": mediacheck.FC4_MediaCheck,
        "monitor": monitor.FC6_Monitor,
        "multipath": multipath.FC6_MultiPath,
        "network": network.F9_Network,
        "nfs": method.FC6_Method,
        "part": partition.F9_Partition,
        "partition": partition.F9_Partition,
        "poweroff": reboot.FC6_Reboot,
        "raid": raid.F9_Raid,
        "reboot": reboot.FC6_Reboot,
        "repo": repo.F8_Repo,
        "rootpw": rootpw.F8_RootPw,
        "selinux": selinux.FC3_SELinux,
        "services": services.FC6_Services,
        "shutdown": reboot.FC6_Reboot,
        "skipx": skipx.FC3_SkipX,
        "text": displaymode.FC3_DisplayMode,
        "timezone": timezone.FC6_Timezone,
        "updates": updates.F7_Updates,
        "upgrade": upgrade.FC3_Upgrade,
        "url": method.FC6_Method,
        "user": user.F8_User,
        "vnc": vnc.F9_Vnc,
        "volgroup": volgroup.FC3_VolGroup,
        "xconfig": xconfig.F9_XConfig,
        "zerombr": zerombr.F9_ZeroMbr,
        "zfcp": zfcp.FC3_ZFCP,
    },

    # based on f9
    F10: {
        "auth": authconfig.FC3_Authconfig,
        "authconfig": authconfig.FC3_Authconfig,
        "autopart": autopart.F9_AutoPart,
        "autostep": autostep.FC3_AutoStep,
        "bootloader": bootloader.F8_Bootloader,
        "cdrom": method.FC6_Method,
        "clearpart": clearpart.FC3_ClearPart,
        "cmdline": displaymode.FC3_DisplayMode,
        "device": device.F8_Device,
        "deviceprobe": deviceprobe.FC3_DeviceProbe,
        "dmraid": dmraid.FC6_DmRaid,
        "driverdisk": driverdisk.FC4_DriverDisk,
        "firewall": firewall.F10_Firewall,
        "firstboot": firstboot.FC3_Firstboot,
        "graphical": displaymode.FC3_DisplayMode,
        "halt": reboot.FC6_Reboot,
        "harddrive": method.FC6_Method,
        "ignoredisk": ignoredisk.F8_IgnoreDisk,
        "install": upgrade.FC3_Upgrade,
        "interactive": interactive.FC3_Interactive,
        "iscsi": iscsi.F10_Iscsi,
        "iscsiname": iscsiname.FC6_IscsiName,
        "keyboard": keyboard.FC3_Keyboard,
        "lang": lang.FC3_Lang,
        "logging": logging.FC6_Logging,
        "logvol": logvol.F9_LogVol,
        "mediacheck": mediacheck.FC4_MediaCheck,
        "monitor": monitor.F10_Monitor,
        "multipath": multipath.FC6_MultiPath,
        "network": network.F9_Network,
        "nfs": method.FC6_Method,
        "part": partition.F9_Partition,
        "partition": partition.F9_Partition,
        "poweroff": reboot.FC6_Reboot,
        "raid": raid.F9_Raid,
        "reboot": reboot.FC6_Reboot,
        "repo": repo.F8_Repo,
        "rescue": rescue.F10_Rescue,
        "rootpw": rootpw.F8_RootPw,
        "selinux": selinux.FC3_SELinux,
        "services": services.FC6_Services,
        "shutdown": reboot.FC6_Reboot,
        "skipx": skipx.FC3_SkipX,
        "text": displaymode.FC3_DisplayMode,
        "timezone": timezone.FC6_Timezone,
        "updates": updates.F7_Updates,
        "upgrade": upgrade.FC3_Upgrade,
        "url": method.FC6_Method,
        "user": user.F8_User,
        "vnc": vnc.F9_Vnc,
        "volgroup": volgroup.FC3_VolGroup,
        "xconfig": xconfig.F10_XConfig,
        "zerombr": zerombr.F9_ZeroMbr,
        "zfcp": zfcp.FC3_ZFCP,
    },

    # based on f10
    F11: {
        "auth": authconfig.FC3_Authconfig,
        "authconfig": authconfig.FC3_Authconfig,
        "autopart": autopart.F9_AutoPart,
        "autostep": autostep.FC3_AutoStep,
        "bootloader": bootloader.F8_Bootloader,
        "cdrom": method.FC6_Method,
        "clearpart": clearpart.FC3_ClearPart,
        "cmdline": displaymode.FC3_DisplayMode,
        "device": device.F8_Device,
        "deviceprobe": deviceprobe.FC3_DeviceProbe,
        "dmraid": dmraid.FC6_DmRaid,
        "driverdisk": driverdisk.FC4_DriverDisk,
        "firewall": firewall.F10_Firewall,
        "firstboot": firstboot.FC3_Firstboot,
        "graphical": displaymode.FC3_DisplayMode,
        "halt": reboot.FC6_Reboot,
        "harddrive": method.FC6_Method,
        "ignoredisk": ignoredisk.F8_IgnoreDisk,
        "install": upgrade.F11_Upgrade,
        "interactive": interactive.FC3_Interactive,
        "iscsi": iscsi.F10_Iscsi,
        "iscsiname": iscsiname.FC6_IscsiName,
        "keyboard": keyboard.FC3_Keyboard,
        "lang": lang.FC3_Lang,
        "logging": logging.FC6_Logging,
        "logvol": logvol.F9_LogVol,
        "mediacheck": mediacheck.FC4_MediaCheck,
        "monitor": monitor.F10_Monitor,
        "multipath": multipath.FC6_MultiPath,
        "network": network.F9_Network,
        "nfs": method.FC6_Method,
        "part": partition.F11_Partition,
        "partition": partition.F11_Partition,
        "poweroff": reboot.FC6_Reboot,
        "raid": raid.F9_Raid,
        "reboot": reboot.FC6_Reboot,
        "repo": repo.F11_Repo,
        "rescue": rescue.F10_Rescue,
        "rootpw": rootpw.F8_RootPw,
        "selinux": selinux.FC3_SELinux,
        "services": services.FC6_Services,
        "shutdown": reboot.FC6_Reboot,
        "skipx": skipx.FC3_SkipX,
        "text": displaymode.FC3_DisplayMode,
        "timezone": timezone.FC6_Timezone,
        "updates": updates.F7_Updates,
        "upgrade": upgrade.F11_Upgrade,
        "url": method.FC6_Method,
        "user": user.F8_User,
        "vnc": vnc.F9_Vnc,
        "volgroup": volgroup.FC3_VolGroup,
        "xconfig": xconfig.F10_XConfig,
        "zerombr": zerombr.F9_ZeroMbr,
        "zfcp": zfcp.FC3_ZFCP,
    },

    # based on f11
    F12: {
        "auth": authconfig.FC3_Authconfig,
        "authconfig": authconfig.FC3_Authconfig,
        "autopart": autopart.F12_AutoPart,
        "autostep": autostep.FC3_AutoStep,
        "bootloader": bootloader.F12_Bootloader,
        "cdrom": method.FC6_Method,
        "clearpart": clearpart.FC3_ClearPart,
        "cmdline": displaymode.FC3_DisplayMode,
        "device": device.F8_Device,
        "deviceprobe": deviceprobe.FC3_DeviceProbe,
        "dmraid": dmraid.FC6_DmRaid,
        "driverdisk": driverdisk.F12_DriverDisk,
        "fcoe": fcoe.F12_Fcoe,
        "firewall": firewall.F10_Firewall,
        "firstboot": firstboot.FC3_Firstboot,
        "graphical": displaymode.FC3_DisplayMode,
        "group": group.F12_Group,
        "halt": reboot.FC6_Reboot,
        "harddrive": method.FC6_Method,
        "ignoredisk": ignoredisk.F8_IgnoreDisk,
        "install": upgrade.F11_Upgrade,
        "interactive": interactive.FC3_Interactive,
        "iscsi": iscsi.F10_Iscsi,
        "iscsiname": iscsiname.FC6_IscsiName,
        "keyboard": keyboard.FC3_Keyboard,
        "lang": lang.FC3_Lang,
        "logging": logging.FC6_Logging,
        "logvol": logvol.F12_LogVol,
        "mediacheck": mediacheck.FC4_MediaCheck,
        "monitor": monitor.F10_Monitor,
        "multipath": multipath.FC6_MultiPath,
        "network": network.F9_Network,
        "nfs": method.FC6_Method,
        "part": partition.F12_Partition,
        "partition": partition.F12_Partition,
        "poweroff": reboot.FC6_Reboot,
        "raid": raid.F12_Raid,
        "reboot": reboot.FC6_Reboot,
        "repo": repo.F11_Repo,
        "rescue": rescue.F10_Rescue,
        "rootpw": rootpw.F8_RootPw,
        "selinux": selinux.FC3_SELinux,
        "services": services.FC6_Services,
        "shutdown": reboot.FC6_Reboot,
        "skipx": skipx.FC3_SkipX,
        "text": displaymode.FC3_DisplayMode,
        "timezone": timezone.FC6_Timezone,
        "updates": updates.F7_Updates,
        "upgrade": upgrade.F11_Upgrade,
        "url": method.FC6_Method,
        "user": user.F12_User,
        "vnc": vnc.F9_Vnc,
        "volgroup": volgroup.FC3_VolGroup,
        "xconfig": xconfig.F10_XConfig,
        "zerombr": zerombr.F9_ZeroMbr,
        "zfcp": zfcp.F12_ZFCP,
    },

    # based on f12
    F13: {
        "auth": authconfig.FC3_Authconfig,
        "authconfig": authconfig.FC3_Authconfig,
        "autopart": autopart.F12_AutoPart,
        "autostep": autostep.FC3_AutoStep,
        "bootloader": bootloader.F12_Bootloader,
        "cdrom": method.F13_Method,
        "clearpart": clearpart.FC3_ClearPart,
        "cmdline": displaymode.FC3_DisplayMode,
        "device": device.F8_Device,
        "deviceprobe": deviceprobe.FC3_DeviceProbe,
        "dmraid": dmraid.FC6_DmRaid,
        "driverdisk": driverdisk.F12_DriverDisk,
        "fcoe": fcoe.F13_Fcoe,
        "firewall": firewall.F10_Firewall,
        "firstboot": firstboot.FC3_Firstboot,
        "graphical": displaymode.FC3_DisplayMode,
        "group": group.F12_Group,
        "halt": reboot.FC6_Reboot,
        "harddrive": method.F13_Method,
        "ignoredisk": ignoredisk.F8_IgnoreDisk,
        "install": upgrade.F11_Upgrade,
        "interactive": interactive.FC3_Interactive,
        "iscsi": iscsi.F10_Iscsi,
        "iscsiname": iscsiname.FC6_IscsiName,
        "keyboard": keyboard.FC3_Keyboard,
        "lang": lang.FC3_Lang,
        "logging": logging.FC6_Logging,
        "logvol": logvol.F12_LogVol,
        "mediacheck": mediacheck.FC4_MediaCheck,
        "monitor": monitor.F10_Monitor,
        "multipath": multipath.FC6_MultiPath,
        "network": network.F9_Network,
        "nfs": method.F13_Method,
        "part": partition.F12_Partition,
        "partition": partition.F12_Partition,
        "poweroff": reboot.FC6_Reboot,
        "raid": raid.F13_Raid,
        "reboot": reboot.FC6_Reboot,
        "repo": repo.F13_Repo,
        "rescue": rescue.F10_Rescue,
        "rootpw": rootpw.F8_RootPw,
        "selinux": selinux.FC3_SELinux,
        "services": services.FC6_Services,
        "shutdown": reboot.FC6_Reboot,
        "skipx": skipx.FC3_SkipX,
        "sshpw": sshpw.F13_SshPw,
        "text": displaymode.FC3_DisplayMode,
        "timezone": timezone.FC6_Timezone,
        "updates": updates.F7_Updates,
        "upgrade": upgrade.F11_Upgrade,
        "url": method.F13_Method,
        "user": user.F12_User,
        "vnc": vnc.F9_Vnc,
        "volgroup": volgroup.FC3_VolGroup,
        "xconfig": xconfig.F10_XConfig,
        "zerombr": zerombr.F9_ZeroMbr,
        "zfcp": zfcp.F12_ZFCP,
    },

    # based on f13
    F14: {
        "auth": authconfig.FC3_Authconfig,
        "authconfig": authconfig.FC3_Authconfig,
        "autopart": autopart.F12_AutoPart,
        "autostep": autostep.FC3_AutoStep,
        "bootloader": bootloader.F14_Bootloader,
        "cdrom": method.F14_Method,
        "clearpart": clearpart.FC3_ClearPart,
        "cmdline": displaymode.FC3_DisplayMode,
        "device": device.F8_Device,
        "deviceprobe": deviceprobe.FC3_DeviceProbe,
        "dmraid": dmraid.FC6_DmRaid,
        "driverdisk": driverdisk.F14_DriverDisk,
        "fcoe": fcoe.F13_Fcoe,
        "firewall": firewall.F14_Firewall,
        "firstboot": firstboot.FC3_Firstboot,
        "graphical": displaymode.FC3_DisplayMode,
        "group": group.F12_Group,
        "halt": reboot.FC6_Reboot,
        "harddrive": method.F14_Method,
        "ignoredisk": ignoredisk.F14_IgnoreDisk,
        "install": upgrade.F11_Upgrade,
        "interactive": interactive.F14_Interactive,
        "iscsi": iscsi.F10_Iscsi,
        "iscsiname": iscsiname.FC6_IscsiName,
        "keyboard": keyboard.FC3_Keyboard,
        "lang": lang.FC3_Lang,
        "logging": logging.FC6_Logging,
        "logvol": logvol.F14_LogVol,
        "mediacheck": mediacheck.FC4_MediaCheck,
        "monitor": monitor.F10_Monitor,
        "multipath": multipath.FC6_MultiPath,
        "network": network.F9_Network,
        "nfs": method.F14_Method,
        "part": partition.F14_Partition,
        "partition": partition.F14_Partition,
        "poweroff": reboot.FC6_Reboot,
        "raid": raid.F14_Raid,
        "reboot": reboot.FC6_Reboot,
        "repo": repo.F14_Repo,
        "rescue": rescue.F10_Rescue,
        "rootpw": rootpw.F8_RootPw,
        "selinux": selinux.FC3_SELinux,
        "services": services.FC6_Services,
        "shutdown": reboot.FC6_Reboot,
        "skipx": skipx.FC3_SkipX,
        "sshpw": sshpw.F13_SshPw,
        "text": displaymode.FC3_DisplayMode,
        "timezone": timezone.FC6_Timezone,
        "updates": updates.F7_Updates,
        "upgrade": upgrade.F11_Upgrade,
        "url": method.F14_Method,
        "user": user.F12_User,
        "vnc": vnc.F9_Vnc,
        "volgroup": volgroup.FC3_VolGroup,
        "xconfig": xconfig.F14_XConfig,
        "zerombr": zerombr.F9_ZeroMbr,
        "zfcp": zfcp.F14_ZFCP,
    },

    # based on fc1
    RHEL3: {
        "auth": authconfig.FC3_Authconfig,
        "authconfig": authconfig.FC3_Authconfig,
        "autopart": autopart.FC3_AutoPart,
        "autostep": autostep.FC3_AutoStep,
        "bootloader": bootloader.FC3_Bootloader,
        "cdrom": method.FC3_Method,
        "clearpart": clearpart.FC3_ClearPart,
        "cmdline": displaymode.FC3_DisplayMode,
        "device": device.FC3_Device,
        "deviceprobe": deviceprobe.FC3_DeviceProbe,
        "driverdisk": driverdisk.FC3_DriverDisk,
        "firewall": firewall.FC3_Firewall,
        "firstboot": firstboot.FC3_Firstboot,
        "graphical": displaymode.FC3_DisplayMode,
        "halt": reboot.FC3_Reboot,
        "harddrive": method.FC3_Method,
        "ignoredisk": ignoredisk.FC3_IgnoreDisk,
        "install": upgrade.FC3_Upgrade,
        "interactive": interactive.FC3_Interactive,
        "keyboard": keyboard.FC3_Keyboard,
        "lang": lang.FC3_Lang,
        "langsupport": langsupport.FC3_LangSupport,
        "lilo": bootloader.FC3_Bootloader,
        "lilocheck": lilocheck.FC3_LiloCheck,
        "logvol": logvol.FC3_LogVol,
        "monitor": monitor.FC3_Monitor,
        "mouse": mouse.RHEL3_Mouse,
        "network": network.FC3_Network,
        "nfs": method.FC3_Method,
        "part": partition.FC3_Partition,
        "partition": partition.FC3_Partition,
        "poweroff": reboot.FC3_Reboot,
        "raid": raid.FC3_Raid,
        "reboot": reboot.FC3_Reboot,
        "rootpw": rootpw.FC3_RootPw,
        "shutdown": reboot.FC3_Reboot,
        "skipx": skipx.FC3_SkipX,
        "text": displaymode.FC3_DisplayMode,
        "timezone": timezone.FC3_Timezone,
        "upgrade": upgrade.FC3_Upgrade,
        "url": method.FC3_Method,
        "vnc": vnc.FC3_Vnc,
        "volgroup": volgroup.FC3_VolGroup,
        "xconfig": xconfig.FC3_XConfig,
        "zerombr": zerombr.FC3_ZeroMbr,
    },

    # based on fc3
    RHEL4: {
        "auth": authconfig.FC3_Authconfig,
        "authconfig": authconfig.FC3_Authconfig,
        "autopart": autopart.FC3_AutoPart,
        "autostep": autostep.FC3_AutoStep,
        "bootloader": bootloader.FC3_Bootloader,
        "cdrom": method.FC3_Method,
        "clearpart": clearpart.FC3_ClearPart,
        "cmdline": displaymode.FC3_DisplayMode,
        "device": device.FC3_Device,
        "deviceprobe": deviceprobe.FC3_DeviceProbe,
        "driverdisk": driverdisk.FC4_DriverDisk,
        "firewall": firewall.FC3_Firewall,
        "firstboot": firstboot.FC3_Firstboot,
        "graphical": displaymode.FC3_DisplayMode,
        "halt": reboot.FC3_Reboot,
        "harddrive": method.FC3_Method,
        "ignoredisk": ignoredisk.F8_IgnoreDisk,
        "install": upgrade.FC3_Upgrade,
        "interactive": interactive.FC3_Interactive,
        "keyboard": keyboard.FC3_Keyboard,
        "lang": lang.FC3_Lang,
        "langsupport": langsupport.FC3_LangSupport,
        "lilo": bootloader.FC3_Bootloader,
        "lilocheck": lilocheck.FC3_LiloCheck,
        "logvol": logvol.FC3_LogVol,
        "monitor": monitor.FC3_Monitor,
        "mouse": mouse.FC3_Mouse,
        "network": network.RHEL4_Network,
        "nfs": method.FC3_Method,
        "part": partition.FC3_Partition,
        "partition": partition.FC3_Partition,
        "poweroff": reboot.FC3_Reboot,
        "raid": raid.FC3_Raid,
        "reboot": reboot.FC3_Reboot,
        "rootpw": rootpw.FC3_RootPw,
        "selinux": selinux.FC3_SELinux,
        "shutdown": reboot.FC3_Reboot,
        "skipx": skipx.FC3_SkipX,
        "text": displaymode.FC3_DisplayMode,
        "timezone": timezone.FC3_Timezone,
        "upgrade": upgrade.FC3_Upgrade,
        "url": method.FC3_Method,
        "vnc": vnc.FC3_Vnc,
        "volgroup": volgroup.FC3_VolGroup,
        "xconfig": xconfig.FC3_XConfig,
        "zerombr": zerombr.FC3_ZeroMbr,
        "zfcp": zfcp.FC3_ZFCP,
    },

    # based on fc6
    RHEL5: {
        "auth": authconfig.FC3_Authconfig,
        "authconfig": authconfig.FC3_Authconfig,
        "autopart": autopart.F9_AutoPart,
        "autostep": autostep.FC3_AutoStep,
        "bootloader": bootloader.RHEL5_Bootloader,
        "cdrom": method.FC6_Method,
        "clearpart": clearpart.FC3_ClearPart,
        "cmdline": displaymode.FC3_DisplayMode,
        "device": device.FC3_Device,
        "deviceprobe": deviceprobe.FC3_DeviceProbe,
        "dmraid": dmraid.FC6_DmRaid,
        "driverdisk": driverdisk.F12_DriverDisk,
        "firewall": firewall.FC3_Firewall,
        "firstboot": firstboot.FC3_Firstboot,
        "graphical": displaymode.FC3_DisplayMode,
        "halt": reboot.FC6_Reboot,
        "harddrive": method.FC6_Method,
        "ignoredisk": ignoredisk.F8_IgnoreDisk,
        "install": upgrade.FC3_Upgrade,
        "interactive": interactive.FC3_Interactive,
        "iscsi": iscsi.FC6_Iscsi,
        "iscsiname": iscsiname.FC6_IscsiName,
        "key": key.RHEL5_Key,
        "keyboard": keyboard.FC3_Keyboard,
        "lang": lang.FC3_Lang,
        "langsupport": langsupport.FC5_LangSupport,
        "logging": logging.FC6_Logging,
        "logvol": logvol.RHEL5_LogVol,
        "mediacheck": mediacheck.FC4_MediaCheck,
        "monitor": monitor.FC6_Monitor,
        "mouse": mouse.FC3_Mouse,
        "multipath": multipath.FC6_MultiPath,
        "network": network.RHEL5_Network,
        "nfs": method.FC6_Method,
        "part": partition.RHEL5_Partition,
        "partition": partition.RHEL5_Partition,
        "poweroff": reboot.FC6_Reboot,
        "raid": raid.RHEL5_Raid,
        "reboot": reboot.FC6_Reboot,
        "repo": repo.FC6_Repo,
        "rootpw": rootpw.FC3_RootPw,
        "services": services.FC6_Services,
        "selinux": selinux.FC3_SELinux,
        "shutdown": reboot.FC6_Reboot,
        "skipx": skipx.FC3_SkipX,
        "text": displaymode.FC3_DisplayMode,
        "timezone": timezone.FC6_Timezone,
        "upgrade": upgrade.FC3_Upgrade,
        "user": user.FC6_User,
        "url": method.FC6_Method,
        "vnc": vnc.FC6_Vnc,
        "volgroup": volgroup.FC3_VolGroup,
        "xconfig": xconfig.FC6_XConfig,
        "zerombr": zerombr.FC3_ZeroMbr,
        "zfcp": zfcp.FC3_ZFCP,
    },

    # based on f13ish
    RHEL6: {
        "auth": authconfig.FC3_Authconfig,
        "authconfig": authconfig.FC3_Authconfig,
        "autopart": autopart.F12_AutoPart,
        "autostep": autostep.FC3_AutoStep,
        "bootloader": bootloader.F12_Bootloader,
        "cdrom": method.F13_Method,
        "clearpart": clearpart.FC3_ClearPart,
        "cmdline": displaymode.FC3_DisplayMode,
        "device": device.F8_Device,
        "deviceprobe": deviceprobe.FC3_DeviceProbe,
        "dmraid": dmraid.FC6_DmRaid,
        "driverdisk": driverdisk.F12_DriverDisk,
        "fcoe": fcoe.F13_Fcoe,
        "firewall": firewall.F10_Firewall,
        "firstboot": firstboot.FC3_Firstboot,
        "graphical": displaymode.FC3_DisplayMode,
        "group": group.F12_Group,
        "halt": reboot.FC6_Reboot,
        "harddrive": method.F13_Method,
        "ignoredisk": ignoredisk.RHEL6_IgnoreDisk,
        "install": upgrade.F11_Upgrade,
        "interactive": interactive.FC3_Interactive,
        "iscsi": iscsi.F10_Iscsi,
        "iscsiname": iscsiname.FC6_IscsiName,
        "keyboard": keyboard.FC3_Keyboard,
        "lang": lang.FC3_Lang,
        "logging": logging.FC6_Logging,
        "logvol": logvol.F12_LogVol,
        "mediacheck": mediacheck.FC4_MediaCheck,
        "monitor": monitor.F10_Monitor,
        "multipath": multipath.FC6_MultiPath,
        "network": network.F9_Network,
        "nfs": method.F13_Method,
        "part": partition.F12_Partition,
        "partition": partition.F12_Partition,
        "poweroff": reboot.FC6_Reboot,
        "raid": raid.F13_Raid,
        "reboot": reboot.FC6_Reboot,
        "repo": repo.F13_Repo,
        "rescue": rescue.F10_Rescue,
        "rootpw": rootpw.F8_RootPw,
        "selinux": selinux.FC3_SELinux,
        "services": services.FC6_Services,
        "shutdown": reboot.FC6_Reboot,
        "skipx": skipx.FC3_SkipX,
        "sshpw": sshpw.F13_SshPw,
        "text": displaymode.FC3_DisplayMode,
        "timezone": timezone.FC6_Timezone,
        "updates": updates.F7_Updates,
        "upgrade": upgrade.F11_Upgrade,
        "url": method.F13_Method,
        "user": user.F12_User,
        "vnc": vnc.F9_Vnc,
        "volgroup": volgroup.FC3_VolGroup,
        "xconfig": xconfig.F10_XConfig,
        "zerombr": zerombr.F9_ZeroMbr,
        "zfcp": zfcp.F12_ZFCP,
    }
}

"""This map is keyed on kickstart syntax version as provided by
   pykickstart.version.  Within each sub-dict is a mapping from a data object
   name to the class that provides it.  This is a bijective mapping - that is,
   each name maps to exactly one data class and all data classes have a name.
   More than one instance of each class is allowed to exist, however.
"""
dataMap = {
    FC3: {
        "DriverDiskData": driverdisk.FC3_DriverDiskData,
        "LogVolData": logvol.FC3_LogVolData,
        "NetworkData": network.FC3_NetworkData,
        "PartData": partition.FC3_PartData,
        "RaidData": raid.FC3_RaidData,
        "VolGroupData": volgroup.FC3_VolGroupData,
        "ZFCPData": zfcp.FC3_ZFCPData,
    },
    FC4: {
        "DriverDiskData": driverdisk.FC4_DriverDiskData,
        "LogVolData": logvol.FC4_LogVolData,
        "NetworkData": network.FC4_NetworkData,
        "PartData": partition.FC4_PartData,
        "RaidData": raid.FC4_RaidData,
        "VolGroupData": volgroup.FC3_VolGroupData,
        "ZFCPData": zfcp.FC3_ZFCPData,
    },
    FC5: {
        "DriverDiskData": driverdisk.FC4_DriverDiskData,
        "LogVolData": logvol.FC4_LogVolData,
        "NetworkData": network.FC4_NetworkData,
        "PartData": partition.FC4_PartData,
        "RaidData": raid.FC5_RaidData,
        "VolGroupData": volgroup.FC3_VolGroupData,
        "ZFCPData": zfcp.FC3_ZFCPData,
    },
    FC6: {
        "DriverDiskData": driverdisk.FC4_DriverDiskData,
        "DmRaidData": dmraid.FC6_DmRaidData,
        "IscsiData": iscsi.FC6_IscsiData,
        "LogVolData": logvol.FC4_LogVolData,
        "MultiPathData": multipath.FC6_MultiPathData,
        "NetworkData": network.FC6_NetworkData,
        "PartData": partition.FC4_PartData,
        "RaidData": raid.FC5_RaidData,
        "RepoData": repo.FC6_RepoData,
        "UserData": user.FC6_UserData,
        "VolGroupData": volgroup.FC3_VolGroupData,
        "ZFCPData": zfcp.FC3_ZFCPData,
    },
    F7: {
        "DriverDiskData": driverdisk.FC4_DriverDiskData,
        "DmRaidData": dmraid.FC6_DmRaidData,
        "IscsiData": iscsi.FC6_IscsiData,
        "LogVolData": logvol.FC4_LogVolData,
        "MultiPathData": multipath.FC6_MultiPathData,
        "NetworkData": network.FC6_NetworkData,
        "PartData": partition.FC4_PartData,
        "RaidData": raid.F7_RaidData,
        "RepoData": repo.FC6_RepoData,
        "UserData": user.FC6_UserData,
        "VolGroupData": volgroup.FC3_VolGroupData,
        "ZFCPData": zfcp.FC3_ZFCPData,
    },
    F8: {
        "DriverDiskData": driverdisk.FC4_DriverDiskData,
        "DeviceData": device.F8_DeviceData,
        "DmRaidData": dmraid.FC6_DmRaidData,
        "IscsiData": iscsi.FC6_IscsiData,
        "LogVolData": logvol.FC4_LogVolData,
        "MultiPathData": multipath.FC6_MultiPathData,
        "NetworkData": network.F8_NetworkData,
        "PartData": partition.FC4_PartData,
        "RaidData": raid.F7_RaidData,
        "RepoData": repo.F8_RepoData,
        "UserData": user.F8_UserData,
        "VolGroupData": volgroup.FC3_VolGroupData,
        "ZFCPData": zfcp.FC3_ZFCPData,
    },
    F9: {
        "DriverDiskData": driverdisk.FC4_DriverDiskData,
        "DeviceData": device.F8_DeviceData,
        "DmRaidData": dmraid.FC6_DmRaidData,
        "IscsiData": iscsi.FC6_IscsiData,
        "LogVolData": logvol.F9_LogVolData,
        "MultiPathData": multipath.FC6_MultiPathData,
        "NetworkData": network.F8_NetworkData,
        "PartData": partition.F9_PartData,
        "RaidData": raid.F9_RaidData,
        "RepoData": repo.F8_RepoData,
        "UserData": user.F8_UserData,
        "VolGroupData": volgroup.FC3_VolGroupData,
        "ZFCPData": zfcp.FC3_ZFCPData,
    },
    F10: {
        "DriverDiskData": driverdisk.FC4_DriverDiskData,
        "DeviceData": device.F8_DeviceData,
        "DmRaidData": dmraid.FC6_DmRaidData,
        "IscsiData": iscsi.F10_IscsiData,
        "LogVolData": logvol.F9_LogVolData,
        "MultiPathData": multipath.FC6_MultiPathData,
        "NetworkData": network.F8_NetworkData,
        "PartData": partition.F9_PartData,
        "RaidData": raid.F9_RaidData,
        "RepoData": repo.F8_RepoData,
        "UserData": user.F8_UserData,
        "VolGroupData": volgroup.FC3_VolGroupData,
        "ZFCPData": zfcp.FC3_ZFCPData,
    },
    F11: {
        "DriverDiskData": driverdisk.FC4_DriverDiskData,
        "DeviceData": device.F8_DeviceData,
        "DmRaidData": dmraid.FC6_DmRaidData,
        "IscsiData": iscsi.F10_IscsiData,
        "LogVolData": logvol.F9_LogVolData,
        "MultiPathData": multipath.FC6_MultiPathData,
        "NetworkData": network.F8_NetworkData,
        "PartData": partition.F11_PartData,
        "RaidData": raid.F9_RaidData,
        "RepoData": repo.F11_RepoData,
        "UserData": user.F8_UserData,
        "VolGroupData": volgroup.FC3_VolGroupData,
        "ZFCPData": zfcp.FC3_ZFCPData,
    },
    F12: {
        "DriverDiskData": driverdisk.F12_DriverDiskData,
        "DeviceData": device.F8_DeviceData,
        "DmRaidData": dmraid.FC6_DmRaidData,
        "FcoeData": fcoe.F12_FcoeData,
        "GroupData": group.F12_GroupData,
        "IscsiData": iscsi.F10_IscsiData,
        "LogVolData": logvol.F12_LogVolData,
        "MultiPathData": multipath.FC6_MultiPathData,
        "NetworkData": network.F8_NetworkData,
        "PartData": partition.F12_PartData,
        "RaidData": raid.F12_RaidData,
        "RepoData": repo.F11_RepoData,
        "UserData": user.F12_UserData,
        "VolGroupData": volgroup.FC3_VolGroupData,
        "ZFCPData": zfcp.F12_ZFCPData,
    },
    F13: {
        "DriverDiskData": driverdisk.F12_DriverDiskData,
        "DeviceData": device.F8_DeviceData,
        "DmRaidData": dmraid.FC6_DmRaidData,
        "FcoeData": fcoe.F13_FcoeData,
        "GroupData": group.F12_GroupData,
        "IscsiData": iscsi.F10_IscsiData,
        "LogVolData": logvol.F12_LogVolData,
        "MultiPathData": multipath.FC6_MultiPathData,
        "NetworkData": network.F8_NetworkData,
        "PartData": partition.F12_PartData,
        "RaidData": raid.F13_RaidData,
        "RepoData": repo.F13_RepoData,
        "SshPwData": sshpw.F13_SshPwData,
        "UserData": user.F12_UserData,
        "VolGroupData": volgroup.FC3_VolGroupData,
        "ZFCPData": zfcp.F12_ZFCPData,
    },
    F14: {
        "DriverDiskData": driverdisk.F14_DriverDiskData,
        "DeviceData": device.F8_DeviceData,
        "DmRaidData": dmraid.FC6_DmRaidData,
        "FcoeData": fcoe.F13_FcoeData,
        "GroupData": group.F12_GroupData,
        "IscsiData": iscsi.F10_IscsiData,
        "LogVolData": logvol.F14_LogVolData,
        "MultiPathData": multipath.FC6_MultiPathData,
        "NetworkData": network.F8_NetworkData,
        "PartData": partition.F14_PartData,
        "RaidData": raid.F14_RaidData,
        "RepoData": repo.F14_RepoData,
        "SshPwData": sshpw.F13_SshPwData,
        "UserData": user.F12_UserData,
        "VolGroupData": volgroup.FC3_VolGroupData,
        "ZFCPData": zfcp.F14_ZFCPData,
    },
    RHEL3: {
        "DriverDiskData": driverdisk.FC3_DriverDiskData,
        "LogVolData": logvol.FC3_LogVolData,
        "NetworkData": network.RHEL4_NetworkData,
        "PartData": partition.FC3_PartData,
        "RaidData": raid.FC3_RaidData,
        "VolGroupData": volgroup.FC3_VolGroupData,
        "ZFCPData": zfcp.FC3_ZFCPData,
    },
    RHEL4: {
        "DriverDiskData": driverdisk.FC4_DriverDiskData,
        "LogVolData": logvol.FC3_LogVolData,
        "NetworkData": network.RHEL4_NetworkData,
        "PartData": partition.FC3_PartData,
        "RaidData": raid.FC3_RaidData,
        "VolGroupData": volgroup.FC3_VolGroupData,
        "ZFCPData": zfcp.FC3_ZFCPData,
    },
    RHEL5: {
        "DriverDiskData": driverdisk.F12_DriverDiskData,
        "DmRaidData": dmraid.FC6_DmRaidData,
        "IscsiData": iscsi.FC6_IscsiData,
        "LogVolData": logvol.RHEL5_LogVolData,
        "MultiPathData": multipath.FC6_MultiPathData,
        "NetworkData": network.FC6_NetworkData,
        "PartData": partition.RHEL5_PartData,
        "RaidData": raid.RHEL5_RaidData,
        "RepoData": repo.FC6_RepoData,
        "UserData": user.FC6_UserData,
        "VolGroupData": volgroup.FC3_VolGroupData,
        "ZFCPData": zfcp.FC3_ZFCPData,
    },
    RHEL6: {
        "DriverDiskData": driverdisk.F12_DriverDiskData,
        "DeviceData": device.F8_DeviceData,
        "DmRaidData": dmraid.FC6_DmRaidData,
        "FcoeData": fcoe.F13_FcoeData,
        "GroupData": group.F12_GroupData,
        "IscsiData": iscsi.F10_IscsiData,
        "LogVolData": logvol.F12_LogVolData,
        "MultiPathData": multipath.FC6_MultiPathData,
        "NetworkData": network.F8_NetworkData,
        "PartData": partition.F12_PartData,
        "RaidData": raid.F13_RaidData,
        "RepoData": repo.F13_RepoData,
        "SshPwData": sshpw.F13_SshPwData,
        "UserData": user.F12_UserData,
        "VolGroupData": volgroup.FC3_VolGroupData,
        "ZFCPData": zfcp.F12_ZFCPData,
    }
}
