// Pspell implementation header file.
// Applications that just use the pspell library should not include 
// these files as they are subject to change.
// Pspell Modules MUST include some of the implementation files and
// spell checkers MAY include some of these files.
// If ANY of the implementation files are included you also link with
// libaspell-impl to protect you from changes in these files.

// Copyright 2000 by Kevin Atkinson under the terms of the LGPL

#ifndef PSPELL_STRING__HH
#define PSPELL_STRING__HH

#include "app_string.hh"

class PspellString : public PspellAppendableString
{
  char * str_;
  unsigned int size_;
  unsigned int allocated_;
public:
  PspellString();
  PspellString(const char * s);
  PspellString(const char * s, unsigned int size);
  PspellString(const PspellString & other);
  virtual ~PspellString();
  void assign(const char * s, unsigned int size);

  void clear() {
    size_ = 0;
    str_[0] = '\0';
  }

  PspellString & operator= (const PspellString & other) { 
    assign(other.str_, other.size_);
    return *this;
  }
  PspellString & operator= (const char * s) {
    assign(s, strlen(s));
    return *this;
  }
  void append(const char * s, unsigned int s_size);

  PspellString & operator += (const char * s) {
    append(s, strlen(s));
    return *this;
  }
  PspellString & operator += (const PspellString & other) {
    append(other.str_, other.size_);
    return *this;
  }
  PspellString & operator += (char c) {
    append(&c, 1);
    return *this;
  }
  const char & operator[] (unsigned int i) const {return str_[i];}
  char & operator[] (unsigned int i) {return str_[i];}
  const char * begin() const {return str_;}
  const char * end()   const {return str_ + size_;}
  char * begin() {return str_;}
  char * end()   {return str_ + size_;}
  const char * c_str() const {return str_;}
  char * mutable_data() {return str_;} 
  // WARNING: very dangerous use with extreme caution.  
  // if the string is no longer in a valid state DO NOT 
  // EVER use any other methods (except for the 
  // destructire which is always safe) until clear() is called
  unsigned int size() {return size_;}
  bool   empty() {return size_ == 0;}
};


#endif
