
#include "config.h"

void delete_pspell_config(PspellConfig * config) 
{
  delete config;
}

int pspell_config_error_number(const PspellConfig * config)
{
  return config->error_number();
}

const char * pspell_config_error_message(const PspellConfig * config) 
{
  return config->error_message();
}

const PspellErrorExtraInfo * 
pspell_config_error_extra_info(const PspellConfig * config) {
  return config->error_extra_info();
}


PspellConfig * pspell_config_clone(PspellConfig * config) 
{
  return config->clone();
}
  
int pspell_config_assign(PspellConfig * config, const PspellConfig * other) 
{
  return config->assign(other);
}
    
void pspell_config_set_extra(PspellConfig * config,
			     const PspellKeyInfo * begin, 
			     const PspellKeyInfo * end)
{
  config->set_extra(begin,end);
}

const PspellKeyInfo * pspell_config_keyinfo(PspellConfig * config, 
					    const char * key)
{
  return config->keyinfo(key);
}

PspellKeyInfoEmulation * 
pspell_config_possible_elements(PspellConfig * config, int include_extra)
{
  return config->possible_elements(include_extra);
}

const char * pspell_config_get_default(PspellConfig * config, 
				       const char * key) 
{
  return config->get_default(key);
}

PspellStringPairEmulation * pspell_config_elements(PspellConfig * config)
{
  return config->elements();
}

int pspell_config_replace(PspellConfig * config,
			  const char * key, const char * value)
{
  return config->replace(key,value);
}


int pspell_config_remove(PspellConfig * config, 
			 const char * key)
{
  return config->remove(key);
}
  
int pspell_config_have(const PspellConfig * config, const char * key)
{
  return config->have(key);
}

const char * pspell_config_retrieve (PspellConfig * config, 
				     const char * key)
{
  return config->retrieve(key);
}

int pspell_config_retrieve_list (PspellConfig * config, 
				 const char * key, 
				 PspellMutableContainer * con)
{
  return config->retrieve_list(key, *con);
}

int pspell_config_retrieve_bool(PspellConfig * config, const char * key)
{
  return config->retrieve_bool(key);
}

int pspell_config_retrieve_int(PspellConfig * config, const char * key)
{
  return config->retrieve_int(key);
}
