/*
 * WizardPanelInspector.h
 *
 * Interface declaration of the WizardPanelInspector class for the
 * WizardPalette palette
 *
 * Copyright (c) 2006, by Saso Kiselkov
 *
 * For license details please see the file COPYING included with this
 * source distribution package.
 */

#import <InterfaceBuilder/InterfaceBuilder.h>

@class NSTableView, NSTableColumn, NSNotification;

@interface WizardPanelInspector : IBInspector
{
  id center;
  id closable;
  id modal;
  id stages;
  id resizeBar;
  id titled;
  id title;
  id titleForm;
}

- init;

- (NSView*) initialFirstResponder;

- (void) addStage: (id)sender;
- (void) changeCenter: (id)sender;
- (void) changeClosable: (id)sender;
- (void) changeInitialStage: (id) sender;
- (void) changeModal: (id)sender;
- (void) changeResizeBar: (id)sender;
- (void) changeTitled: (id)sender;
- (void) removeStage: (id)sender;

- (void) titleChanged: (NSNotification *) notif;

- (int) numberOfRowsInTableView: (NSTableView *)aTableView;
- (id) tableView: (NSTableView *)aTableView 
objectValueForTableColumn: (NSTableColumn *)aTableColumn 
             row: (int)rowIndex;

- (void) setObject: anObject;

@end
