/*
 * WKWizardPanel.h
 *
 * Interface declaration of the WKWizardPanel class for the
 * WizardKit framework
 *
 * Copyright (c) 2006, by Saso Kiselkov
 *
 * For license details please see the file COPYING included with this
 * source distribution package.
 */

#ifndef _WK_WIZARD_PANEL_H_
#define _WK_WIZARD_PANEL_H_

#import <AppKit/NSPanel.h>

@class NSString,
       NSArray,
       NSMutableDictionary;
@class NSView, NSBox;

extern NSString * const WKWizardPanelDidChangeCurrentStageNotification;

@interface WKWizardPanel : NSPanel <NSCoding>
{
  // run control
  BOOL runsInModalSession;
  BOOL centersBeforeActivating;
  BOOL isActive;

  // stages
  NSArray * stages;
  NSString * initialStage;
  unsigned int currentStage;
}

- (void) setStages: (NSArray *) someStages;
- (NSArray *) stages;

- (void) setRunsInModalSession: (BOOL) flag;
- (BOOL) runsInModalSession;

- (void) setInitialStage: (NSString *) aStageName;
- (NSString *) initialStage;

- (void) setCentersBeforeActivating: (BOOL) flag;
- (BOOL) centersBeforeActivating;

- (void) setCurrentStage: (NSString *) aStageName;
- (NSArray *) currentStage;

- (void) nextStage: (id) sender;
- (void) previousStage: (id) sender;

- (int) activate: (id) sender;
- (void) deactivate: (id) sender;
- (void) deactivateWithCode: (int) aCode;

- (BOOL) isActive;

@end

@interface NSObject (WKWizardPanelDelegate)

- (NSView *) wizardPanel: (WKWizardPanel *) sender
            viewForStage: (NSString *) aStageName;

- (NSView *)       wizardPanel: (WKWizardPanel *) sender
 initialFirstResponderForStage: (NSString *) aStageName;

@end

#endif // _WK_WIZARD_PANEL_H_
