/*
    SourceEditorDocument.h

    Interface declaration of the SourceEditorDocument class for the
    ProjectManager application.

    Copyright (C) 2005, 2006  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import <AppKit/NSDocument.h>
#import <Foundation/NSRange.h>
#import <Foundation/NSString.h>

@class NSNotification,
       NSString,
       NSIndexSet;
@class NSText;

@class NSFont, NSColor;

@interface SourceEditorDocument : NSDocument
{
  id textView;
  NSString * string;
  // NSDocument does allow setting the window, but it doesn't allow
  // retrieving it, which is why we have to set up our own outlet
  // here.
  id myWindow;

  NSFont * defaultFont;
  NSColor * textColor,
          * highlightColor,
          * backgroundColor,
          * insertionPointColor;

  // YES if we are currently highlighting parentheses
  BOOL parenthesesHighlighted;
  // the positions of the highlighted parentheses
  unsigned int parenthesisA, parenthesisB;

  // This is used to protect that -textViewDidChangeSelection: invocations
  // don't do anything when the text view changing, because this causes
  // further changes to the text view and infinite recursive invocations
  // of this method.
  BOOL editorTextViewIsPressingKey;
}

- (void) customPipeOutput: sender;
- (void) pipeOutput: sender;

- (void) goToLine: sender;
- (void) goToLineNumber: (unsigned int) lineNumber;

- (void) textViewDidChangeSelection: (NSNotification *) notification;

- (void) editorTextViewWillPressKey: sender;
- (void) editorTextViewDidPressKey: sender;

- (void) findNext: sender;
- (void) findPrevious: sender;
//- (void) enterSelection: sender;
- (void) jumpToSelection: sender;

- (NSIndexSet *) highlightedCharacterIndexes;
- (NSColor *) highlightColor;
- (NSColor *) textColor;

@end
