/*
    ProjectAttributes.h

    Interface declaration of the ProjectAttributes class for the
    ProjectManager application.

    Copyright (C) 2005  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import "../../ProjectModule.h"

@class NSDictionary,
       NSBox,
       NSNotification;

@class ProjectDocument;

@protocol ProjectAttributesDelegate;

@interface ProjectAttributes : NSObject <ProjectModule>
{
  // weak references
  ProjectDocument * document;
  id <ProjectAttributesDelegate> delegate;

  id bogusWindow;

  NSBox * view;

  id generalBogusWindow;
  id generalView;
  id projectName;
  id projectType;

  // This variable holds a cached list of toolbar item identifiers
  // for toolbar items of the delegate. Each of these items is
  // prepended with @"ProjectAttributesDelegateItem: " so as to make
  // sure that it doesn't mess with the toolbar machinery.
  NSArray * delegateItemIdentifiers;
}

- (void) switchView: sender;
- (void) showGeneralAttributes: sender;
- (void) changeProjectName: sender;

- (void) projectNameChanged: (NSNotification *) notif;

@end
