/***************************************
  $Header: /home/amb/procmeter/RCS/pipedemo.c 1.1 1997/08/10 09:58:04 amb Exp $

  ProcMeter demonstration of reading from a named pipe.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1997 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>


int main(int argc,char** argv)
{
 FILE *file;
 int i;
 char *def,*dat;

 if(argc==1)
    {fprintf(stderr,"Usage: pipedemo <basename>\n");exit(1);}

 def=(char*)malloc(strlen(argv[1])+8);
 dat=(char*)malloc(strlen(argv[1])+8);

 strcpy(def,argv[1]);
 strcat(def,".def");
 strcpy(dat,argv[1]);
 strcat(dat,".dat");

 if(!(file=fopen(def,"w")))
   {fprintf(stderr,"pipedemo: Could not create definition file.\n");exit(1);}

 fprintf(file,"sine 1 5\n"
              "square 1 5\n"
              "triangle 1 5\n");

 fclose(file);

 if(mknod(dat,0644|S_IFIFO,0)==-1)
   {fprintf(stderr,"pipedemo: Could not create fifo.\n");exit(1);}

 for(i=0;;i++) 
   {
    int sine=20+(int)20*sin((double)i/5);
    int square=20*((i/20)%2);
    int triangle=i%20;

    if(!(file=fopen(dat,"w")))
       break;

    fprintf(file,"%d\n"
                 "%d\n"
                 "%d\n",sine,square,triangle);

    fclose(file);

    /* Not sure why it needs this but it does. */
    usleep(10000);
   }

 fprintf(stderr,"pipedemo: Could not open pipe to write.\n");

 return(1);
}
