#!/bin/sh
#
# ProcMeter - A performance metering/logging program for Linux - Version 2.5.
#
# A Perl script to replay logged data.
#
# Written by Andrew M. Bishop
#
# This file Copyright 1999 Andrew M. Bishop
# It may be distributed under the GNU Public License, version 2, or
# any higher version.  See section COPYING of the GNU Public license
# for conditions under which this file may be redistributed.
#

exec perl -x $0 $1 $2

exit 1

#!perl

$#ARGV==1 || die "Usage: $0 <logfile> <file-basename>\n";

$log=$ARGV[0];
$out=$ARGV[1];

#

%units=(
        "cpu"      , "%"   ,   # CPU
        "cpu-user" , "%"   ,   # CPU_USER
        "cpu-nice" , "%"   ,   # CPU_NICE
        "cpu-sys"  , "%"   ,   # CPU_SYS
        "cpu-idle" , "%"   ,   # CPU_IDLE
        "load"     , "1"   ,   # LOAD
        "proc"     , "10"  ,   # PROC
        "fork"     , "5"   ,   # FORK
        "context"  , "100" ,   # CONTEXT
        "swap"     , "50"  ,   # SWAP
        "swap-in"  , "50"  ,   # SWAP_IN
        "swap-out" , "50"  ,   # SWAP_OUT
        "page"     , "50"  ,   # PAGE
        "page-in"  , "50"  ,   # PAGE_IN
        "page-out" , "50"  ,   # PAGE_OUT
        "disk"     , "25"  ,   # DISK
        "disk-rd"  , "25"  ,   # DISK_RD
        "disk-wr"  , "25"  ,   # DISK_WR
        "intr"     , "100" ,   # INTR
        "mem-free" , "4MB" ,   # MEM_FREE
        "mem-used" , "4MB" ,   # MEM_USED
        "mem-buff" , "4MB" ,   # MEM_BUFF
        "mem-cache", "4MB" ,   # MEM_CACHE
        "mem-avail", "4MB" ,   # MEM_AVAIL
        "mem-swap" , "4MB" ,   # MEM_SWAP
        "lpkt"     , "100" ,   # LPKT
        "lbyte"    , "100 k",  # LBYTE
        "fpkt"     , "50"  ,   # FPKT
        "fbyte"    , "100 k",  # FBYTE
        "fpkt-rx"  , "50"  ,   # FPKT_RX
        "fbyte-rx" , "100 k",  # FBYTE_RX
        "fpkt-tx"  , "50"  ,   # FPKT_TX
        "fbyte-tx" , "100 k",  # FBYTE_TX
        "fpkt-coll", "50"  ,   # FPKT_COLL
        "spkt"     , "5"   ,   # SPKT
        "sbyte"    , "1 k" ,   # SBYTE
        "spkt-rx"  , "5"   ,   # SPKT_RX
        "sbyte-rx" , "1 k" ,   # SBYTE_RX
        "spkt-tx"  , "5"   ,   # SPKT_TX
        "sbyte-tx" , "1 k" ,   # SBYTE_TX
        "batt-life", "%"   ,   # BATT_LIFE
        "batt-lvl" , "HLCU"    # BATT_LVL
        );

%scale=(
        "cpu"      ,   20  ,   # CPU
        "cpu-user" ,   20  ,   # CPU_USER
        "cpu-nice" ,   20  ,   # CPU_NICE
        "cpu-sys"  ,   20  ,   # CPU_SYS
        "cpu-idle" ,   20  ,   # CPU_IDLE
        "load"     ,    1  ,   # LOAD
        "proc"     ,   10  ,   # PROC
        "fork"     ,    5  ,   # FORK
        "context"  ,  100  ,   # CONTEXT
        "swap"     ,   50  ,   # SWAP
        "swap-in"  ,   50  ,   # SWAP_IN
        "swap-out" ,   50  ,   # SWAP_OUT
        "page"     ,  100  ,   # PAGE
        "page-in"  ,  100  ,   # PAGE_IN
        "page-out" ,  100  ,   # PAGE_OUT
        "disk"     ,   25  ,   # DISK
        "disk-rd"  ,   25  ,   # DISK_RD
        "disk-wr"  ,   25  ,   # DISK_WR
        "intr"     ,  100  ,   # INTR
        "mem-free" , 4096  ,   # MEM_FREE
        "mem-used" , 4096  ,   # MEM_USED
        "mem-buff" , 4096  ,   # MEM_BUFF
        "mem-cache", 4096  ,   # MEM_CACHE
        "mem-avail", 4096  ,   # MEM_AVAIL
        "mem-swap" , 4096  ,   # MEM_SWAP
        "lpkt"     ,  100  ,   # LPKT
        "lbyte"    ,  100  ,   # LBYTE
        "fpkt"     ,   50  ,   # FPKT
        "fbyte"    ,  100  ,   # FBYTE
        "fpkt-rx"  ,   50  ,   # FPKT_RX
        "fbyte-rx" ,  100  ,   # FBYTE_RX
        "fpkt-tx"  ,   50  ,   # FPKT_TX
        "fbyte-tx" ,  100  ,   # FBYTE_TX
        "fpkt-coll",   50  ,   # FPKT_COLL
        "spkt"     ,    5  ,   # SPKT
        "sbyte"    ,    1  ,   # SBYTE
        "spkt-rx"  ,    5  ,   # SPKT_RX
        "sbyte-rx" ,    1  ,   # SBYTE_RX
        "spkt-tx"  ,    5  ,   # SPKT_TX
        "sbyte-tx" ,    1  ,   # SBYTE_TX
        "batt-life",   20  ,   # BATT_LIFE
        "batt-lvl" ,    1      # BATT_LVL
        );

#

open(LOG,"<$log");

<LOG>;
$_=<LOG>;
chop;

($hash,$time,@items)=split(' ');

open(DEF,">$out.def");

foreach $item (@items)
  {
   $units="units";
   $scale="1";
   $units=$units{$item} if($units{$item});
   $scale=$scale{$item} if($scale{$item});
   print DEF "_$item $units $scale\n";
  }

close(DEF);

system 'mkfifo',"$out.dat"; # perl has no mkfifo command.

while(<LOG>)
  {
   chop;

   ($time,@items)=split(' ');

   open(OUT,">$out.dat");

   foreach $item (@items)
       {
        print OUT "$item\n";
       }

   close(OUT);

   select(undef,undef,undef,0.25); # wait a bit
  }

while(1)
  {
   open(OUT,">$out.dat");

   foreach $item (@items)
       {
        print OUT "0\n";
       }

   close(OUT);

   select(undef,undef,undef,0.25); # wait a bit
  }

close(LOG);
