/* $Cambridge: hermes/src/prayer/session/mm.c,v 1.2 2008/05/19 15:55:58 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

/* C-client interface */

#include "prayer_session.h"

/* C-client private stuff */

BOOL critical = NIL;            /* flag saying in critical code */
BOOL debugp = NIL;              /* flag saying debugging */
BOOL verbosep = NIL;            /* flag saying verbose   */

/* ====================================================================== */

static void
 (*list_callback_fn) (MAILSTREAM * stream, int delimiter, char *name,
                      long attr);

static void
 (*login_callback_fn) (NETMBX * mb, char *user, char *pwd, long trial);

/* ====================================================================== */


/* Must call mminit before any other fn */
void mm_init()
{
#include "linkage.c"

    ml_init();
}

void
mm_register_list_callback(void (*fn) (MAILSTREAM *, int, char *, long))
{
    list_callback_fn = fn;
}

void
mm_register_login_callback(void (*fn) (NETMBX * mb, char *user,
                                       char *pwd, long trial))
{
    login_callback_fn = fn;
}

/* ====================================================================== */

/* Co-routines from MAIL library */


/* Message matches a search
 * Accepts: MAIL stream
 *	    message number
 */

void mm_searched(MAILSTREAM * stream, unsigned long msgno)
{
}


/* Message exists (i.e. there are that many messages in the mailbox)
 * Accepts: MAIL stream
 *	    message number
 */

void mm_exists(MAILSTREAM * stream, unsigned long number)
{
    ml_set_mailbox_update();
}


/* Message expunged
 * Accepts: MAIL stream
 *	    message number
 */

void mm_expunged(MAILSTREAM * stream, unsigned long number)
{
    ml_set_mailbox_update();
}


/* Message flags update seen
 * Accepts: MAIL stream
 *	    message number
 */

void mm_flags(MAILSTREAM * stream, unsigned long number)
{
    /* dummy routine */
}

/* Mailbox found
 * Accepts: MAIL stream
 *	    hierarchy delimiter
 *	    mailbox name
 *	    mailbox attributes
 */

void
mm_list(MAILSTREAM * stream, int delimiter, char *name, long attributes)
{
    if (list_callback_fn)
        (*list_callback_fn) (stream, delimiter, name, attributes);
}


/* Subscribe mailbox found
 * Accepts: MAIL stream
 *	    hierarchy delimiter
 *	    mailbox name
 *	    mailbox attributes
 */

void
mm_lsub(MAILSTREAM * stream, int delimiter, char *name, long attributes)
{
    /* dummy routine */
}


/* Mailbox status
 * Accepts: MAIL stream
 *	    mailbox name
 *	    mailbox status
 */

void mm_status(MAILSTREAM * stream, char *mailbox, MAILSTATUS * status)
{
    ml_status_callback(status);
}

/* Notification event
 * Accepts: MAIL stream
 *	    string to log
 *	    error flag
 */

void mm_notify(MAILSTREAM * stream, char *string, long errflg)
{
    mm_log(string, errflg);
}


/* Log an event for the user to see
 * Accepts: string to log
 *	    error flag
 */

void mm_log(char *string, long errflg)
{
    if (!string)
        return;

    if (!strncmp(string, "[TRYCREATE] ", strlen("[TRYCREATE] ")))
        ml_set_try_create();
    else if (!strncmp(string, "[CLOSED] ", strlen("[CLOSED] ")))
        ml_set_have_close();

    if (!ml_have_error()) {
        ml_set_errmsg(string);

        if (errflg == ERROR)
            ml_set_error();
    }
}


/* Log an event to debugging telemetry
 * Accepts: string to log
 */

void mm_dlog(char *string)
{
    log_misc("%s", string);
}

/* Get user name and password for this host
 * Accepts: parse of network mailbox name
 *	    where to return user name
 *	    where to return password
 *	    trial count
 */

void mm_login(NETMBX * mb, char *username, char *password, long trial)
{
    (*login_callback_fn) (mb, username, password, trial);
}


/* About to enter critical code
 * Accepts: stream
 */

void mm_critical(MAILSTREAM * stream)
{
    critical = T;               /* note in critical code */
}


/* About to exit critical code
 * Accepts: stream
 */

void mm_nocritical(MAILSTREAM * stream)
{
    critical = NIL;             /* note not in critical code */
}


/* Disk error found
 * Accepts: stream
 *	    system error code
 *	    flag indicating that mailbox may be clobbered
 * Returns: T if user wants to abort
 */

long mm_diskerror(MAILSTREAM * stream, long errcode, long serious)
{
    return T;
}


/* Log a fatal error event
 * Accepts: string to log
 */

void mm_fatal(char *string)
{
    log_panic("Fatal error: %s", string);
    abort();
}
