/* $Cambridge: hermes/src/prayer/cmd/cmd_manage.c,v 1.2 2008/05/19 15:55:54 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

#include "prayer_session.h"

void cmd_manage(struct session *session)
{
    struct request *request = session->request;
    struct assoc *h = NIL;
    char *s;
    struct buffer *b = request->write_buffer;
    struct template_vals *tvals = session->template_vals;

    /* Record last command for compose/cancel and friends */
    if (!session->draft->have_draft)
        session->compose_parent_cmd = "manage";

    if (request->method != POST) {
        /* Save options if anything changed */
        if (session->options->save)
            session_streams_save_options(session);

        if (session->sieved_server)
            template_vals_ulong(tvals, "using_sieve", 1);

        session_seed_template(session, tvals);
        template_expand("manage", tvals, b);
        response_html(request, 200);
        return;
    }

    request_decode_form(request);
    h = request->form;

    if ((s = assoc_lookup(h, "sub_cancel"))) {
        /* Free up working preferences and return to list screen */
        session_redirect(session, request, "list");
        return;
    }

    if (assoc_lookup(h, "sub_prefs")) {
        session_redirect(session, request, "prefs");
        return;
    }

    if (assoc_lookup(h, "sub_passwd")) {
        session_redirect(session, request, "passwd");
        return;
    }

    if (assoc_lookup(h, "sub_fullname")) {
        session_redirect(session, request, "fullname");
        return;
    }

    if (assoc_lookup(h, "sub_quota")) {
        session_redirect(session, request, "quota");
        return;
    }

    if (assoc_lookup(h, "sub_redirect")) {
        session_redirect(session, request, "redirect");
        return;
    }

    if (assoc_lookup(h, "sub_vacation")) {
        session_redirect(session, request, "vacation");
        return;
    }

    if (assoc_lookup(h, "sub_vaclog")) {
        session_redirect(session, request, "vaclog");
        return;
    }

    if (assoc_lookup(h, "sub_filter")) {
        session_redirect(session, request, "filter");
        return;
    }

    if (assoc_lookup(h, "sub_block")) {
        session_redirect(session, request, "block");
        return;
    }

    if (assoc_lookup(h, "sub_spam")) {
        session_redirect(session, request, "spam");
        return;
    }

    if (assoc_lookup(h, "sub_sieve")) {
        session_redirect(session, request, "sieve");
        return;
    }

    if (assoc_lookup(h, "sub_roles")) {
        session_redirect(session, request, "roles_list");
        return;
    }

    if (assoc_lookup(h, "sub_dictionary")) {
        session_redirect(session, request, "dictionary");
        return;
    }

    session_redirect(session, request, "list");
}
