/* $Cambridge: hermes/src/prayer/cmd/cmd_abook_export.c,v 1.2 2008/05/19 15:55:54 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

#include "prayer_session.h"

/* Export Pine format addressbook to accountd system */

void cmd_abook_export(struct session *session)
{
    struct account *account = session->account;
    struct request *request = session->request;
    struct options *options = session->options;
    struct abook *abook = options->abook;
    char *abook_text = abook_export_text(abook, request->pool);

    if (!account_abook_put(account, request->pool, abook_text)) {
        session_message(session, "Failed to export addressbook");
        session_redirect(session, request, "abook_xfer");
    } else {
        session_message(session, "Addressbook exported to Hermes");
        session_redirect(session, request, "abook_list");
    }
}
