/***************************************************************************
 *                                                                         *
 *                         Powersave Daemon                                *
 *                                                                         *
 *          Copyright (C) 2004,2005,2006 SUSE Linux Products GmbH          *
 *                                                                         *
 *               Author(s): Timo Hoenig <thoenig@suse.de>                  *
 *                                                                         *
 * This program is free software; you can redistribute it and/or modify it *
 * under the terms of the GNU General Public License as published by the   *
 * Free Software Foundation; either version 2 of the License, or (at you   *
 * option) any later version.                                              *
 *                                                                         *
 * This program is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       *
 * General Public License for more details.                                *
 *                                                                         *
 * You should have received a copy of the GNU General Public License along *
 * with this program; if not, write to the Free Software Foundation, Inc., *
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA                  *
 *                                                                         *
 ***************************************************************************/

#ifndef POWERSAVE_BRIGHTNESS_H
#define POWERSAVE_BRIGHTNESS_H

#include "config.h" 

#include <string>

class Brightness {
private:
	std::string _udi;
	std::string _interface;
	bool _supported;
	
	int PercentToLevel(int);

	int _last_percent;

public:
	Brightness();
	virtual ~ Brightness();

	int Get();
	void Set(int);
	int GetPercent();
	void SetPercent(int);

	void Min();
	void Med();
	void Max();
	void Up();
	void Down();

	int GetLevels();
};

#endif /* POWERSAVE_BRIGHTNESS_H */
