/*                              
Service_Sieve.cc
*/

#include "Service_Sieve.h"
#include "ClientTIMSIEVED.h"

extern Language *L;
extern Configuration *Conf;
extern CCLIENT *cclient;
extern Skin *skin;

bool Service_Sieve_Initialized = false;
ClientTIMSIEVED *CTS;

FilterList FLAllFilters;      
XVacation vacation;
      
class HTMLPages: public HTMLBasic
  {
  private:
    void PrintStatusLine_Sieve (const char *user, UserOptions *uo, bool displayClock, const char *mailboxname);
    void BotoneraComun_Sieve (int cmdactual, const char *lang, const char *user, const char *connid, UserOptions *uo);
  public:
    void PrintSieveFiltersShow (TProgData *pd);
    void PrintSieveFiltersEdit (int actualcmd, TProgData *pd, const char *secname);
    void PrintSieveVacationsShow (TProgData *pd);  
    };

void HTMLPages::PrintStatusLine_Sieve (const char *user, UserOptions *uo, bool displayClock, const char *mailboxname)
  {
  WRITE ("<TABLE width=\"100%%\">\n<TR>\n");
  if (FileExists (FILE_FOR_NO_ACCEPT_NEW_CONNS) == true)
    {
    TBuffer amsg;
    GetBufferFromFile (FILE_FOR_NO_ACCEPT_NEW_CONNS, amsg, CMAXBUFFER);
    WRITE ("<TD align=left><B><FONT color=\"#FF0000\"><BLINK>%s</BLINK></FONT></B></TD>\n<TD align=right><B><FONT size=2 color=\"%s\">%s: %s@%s (%s)</FONT></B></TD>\n",
              amsg, skin->getSkinAtribProp("COLOR_FONT_STATUSLINE"), 
              L->get(L_USER), user, uo->getImapServer(), 
              mailboxname);
    }
  else
    {
    if (cclient->getError () == false)
      {
      WRITE ("<TD align=left><B>%s</B></TD>\n<TD align=right><B><FONT size=%d face=\"%s\" color=\"%s\">%s: %s@%s (%s)</FONT></B></TD>\n",
             uo->getStatusLine(), skin->getSkinAtribPropI("FONT_STATUS_SIZE"), skin->getSkinAtribProp("FONT_STATUS"), skin->getSkinAtribProp("COLOR_FONT_STATUSLINE"), 
             L->get(L_USER), user, uo->getImapServer(), 
             mailboxname);
      }
    else
      {
      WRITE ("<TD align=left><B>%s</B></TD>\n<TD align=right><B><FONT size=%d face=\"%s\" color=\"%s\">%s: %s@%s (%s)</FONT></B></TD>\n",
             cclient->getErrorString(), skin->getSkinAtribPropI("FONT_STATUS_SIZE"), skin->getSkinAtribProp("FONT_STATUS"), skin->getSkinAtribProp("COLOR_FONT_STATUSLINE"), 
             L->get(L_USER), user, uo->getImapServer(), 
             mailboxname);
      }  
    }
  
  //Only is seen in IE4+/N6+
  if ((displayClock == true) && (uo->get_use_javascript() == true) && (uo->getShowClock() == true))
    {        
    WRITE ("<TD width=\"1%%\" align=right>");  
    JavaScript (DEF_JavaScriptIDClock);    
    JavaScript (DEF_JavaScriptClock);
    WRITE ("</TD>"); 
    }

  WRITE ("\n</TR></TABLE>\n");
  }

void HTMLPages::BotoneraComun_Sieve (int cmdactual, const char *lang, const char *user, const char *connid, UserOptions *uo)
  {
  long actualpos, totalmsgs;
  int validator, pageid;
  
  actualpos = uo->getCurrentPosition();
  totalmsgs = uo->getTotalMsgs();
  validator = uo->getValidator();
  pageid    = uo->getPageId ();
  
  BeginTable (0, 0, 0, 100);
    BeginTR(skin->getSkinAtribProp("COLOR_BGBOTONERA"));
    
      //BUTTON BACK  
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");        
      WRITE ("%s", uo->getLastStringCmd(cmdactual, lang, connid, true));                   
      Image (skin->getI(L_BACK), L->get(ALT_BACK), skin->getISize()); 
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_BACK));}
      WRITE ("</A>");
      EndTD();   

      //SPACE 
      EmptyCellx2();

      //BUTTON ROOT      
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      WRITE ("<A HREF=\"%s/%s/root/noop/%s/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, uo->getValidator(),
         uo->getPageId(), uo->getLastCmd(), uo->getCurrentPosition());
      Image (skin->getI(L_ROOT), L->get(ALT_ROOT), skin->getISize());
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_ROOT));}
      WRITE ("</A>");
      EndTD();   

      //SPACE 
      EmptyCellx2();
      //BUTTON HELP   
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      switch (cmdactual)
        {
        case CMD_SIEVE_FILTERS_SHOW: WRITE ("<A HREF=\"%s/%s/help/filters_show/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_SIEVE, lang, user, connid, validator, pageid, cmdactual); break; 
        case CMD_SIEVE_FILTERS_EDIT: WRITE ("<A HREF=\"%s/%s/help/filters_edit/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_SIEVE, lang, user, connid, validator, pageid, cmdactual); break;         
        case CMD_SIEVE_FILTERS_CREATE: WRITE ("<A HREF=\"%s/%s/help/filters_create/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_SIEVE, lang, user, connid, validator, pageid, cmdactual); break;         
        case CMD_SIEVE_VACATIONS_SHOW: WRITE ("<A HREF=\"%s/%s/help/vacations_show/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_SIEVE, lang, user, connid, validator, pageid, cmdactual); break; 
        }
      Image (skin->getI(L_HELP), L->get(ALT_HELP), skin->getISize());  
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_HELP));}
      WRITE ("</A>");
      EndTD();  
      
      //SPACE 
      EmptyCellx2();     
      //BUTTON LOGOUT   
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      if (uo->getConfirmLogout() == true)    
        {
        WRITE ("<A HREF=\"%s/%s/conf_act/logout/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, validator, pageid, cmdactual);
        }
      else
        {  
        WRITE ("<A HREF=\"%s/%s/logout/noop/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, validator, pageid, cmdactual);
        }
      Image (skin->getI(L_LOGOUT), L->get(ALT_LOGOUT), skin->getISize());
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_LOGOUT));}
      WRITE ("</A>");
      EndTD();
      BeginTD (100, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center"); WRITE (HTML_HSP); EndTD(); 
    EndTR();
  EndTable ();  
  PrintStatusLine_Sieve (user, uo, true, cclient->getMailboxName());
  }

//retrieve the url for the Service icon
const char *GetService_Sieve_ICO_URL (void)
  {
  return skin->getI(L_SIEVE);
  }

//Retrieve the ALT tag for the Service icon
const char *GetService_Sieve_ICO_ALT (void)
  {
  return L->get(L_SIEVE);
  }

//Retrieve the Service name
const char *GetService_Sieve_NAME (void)
  {
  return L->get(L_SIEVE);
  }

//Retrieve the Service Description
const char *GetService_Sieve_DESCRIPTION (void)
  {
  return L->get(L_SIEVE_DESCRIPTION);
  }

//Entry point to service init
bool DoService_Sieve_BEGIN (TProgData *pd)
  {
  TBuffer file2show;
  if (CheckServiceDisabled (TranslateServiceR(pd->service), file2show) == true) 
    {pd->html->dumpFile (file2show, "TEXT/HTML"); return false;}        
  
  if (Service_Sieve_Initialized == true) {return true;}
  Service_Sieve_Initialized = false;
  LOG ("Initializating Service Sieve for user=%s", pd->username);      
  
  
  CTS = new ClientTIMSIEVED (pd->uo->getSieveServer(), pd->uo->getSievePort(), pd->username, pd->password, pd->uo->getSieveFilename());
  
  Service_Sieve_Initialized = true;    
  return true;
  }

//Entry point to service end
bool DoService_Sieve_END (TProgData *pd)
  {
  if (Service_Sieve_Initialized == false) {return true;}
  
  delete CTS;  
  Service_Sieve_Initialized = false;
    
  return true;
  }

//Entry point to execute a service command
bool DoService_Sieve_CMD (TProgData *pd)
  {
  TBuffer abuf;
  HTMLPages *html;
  int cmd;

  html = (HTMLPages *)pd->html;

  TBuffer file2show;
  if (CheckServiceDisabled (TranslateServiceR(pd->service), file2show) == true) 
    {pd->html->dumpFile (file2show, "TEXT/HTML"); return false;}        

  //Some commands require some initial action
  if ((pd->cmd == CMD_SIEVE_FILTERS_DO) && (cgienv_ExistsVar (pd->envfile, "filters_create") == true)) {pd->cmd = CMD_SIEVE_FILTERS_CREATE;}                  
  else if ((pd->cmd == CMD_SIEVE_FILTERS_DO) && (cgienv_ExistsVar (pd->envfile, "filters_save") == true)) {pd->cmd = CMD_SIEVE_FILTERS_SAVE;}
  else if ((pd->cmd == CMD_SIEVE_FILTERS_DO) && (cgienv_ExistsVar (pd->envfile, "filters_edit") == true)) {pd->cmd = CMD_SIEVE_FILTERS_EDIT;}  
  else if ((pd->cmd == CMD_SIEVE_FILTERS_DO) && (cgienv_ExistsVar (pd->envfile, "filters_delete") == true)) {pd->cmd = CMD_SIEVE_FILTERS_DELETE;}
  else if ((pd->cmd == CMD_SIEVE_FILTERS_DO) && (cgienv_ExistsVar (pd->envfile, "filters_confdelete") == true)) {pd->cmd = CMD_SIEVE_FILTERS_CONFDELETE;}
  else if ((pd->cmd == CMD_SIEVE_FILTERS_DO) && (cgienv_ExistsVar (pd->envfile, "filters_cancel") == true)) {pd->cmd = CMD_SIEVE_FILTERS_CANCEL;}  
  else if ((pd->cmd == CMD_SIEVE_FILTERS_DO) && (cgienv_ExistsVar (pd->envfile, "filters_up") == true)) {pd->cmd = CMD_SIEVE_FILTERS_UP;}    
  else if ((pd->cmd == CMD_SIEVE_FILTERS_DO) && (cgienv_ExistsVar (pd->envfile, "filters_down") == true)) {pd->cmd = CMD_SIEVE_FILTERS_DOWN;}  
  else if ((pd->cmd == CMD_SIEVE_FILTERS_DO) && (cgienv_ExistsVar (pd->envfile, "filters_predefspam") == true)) {pd->cmd = CMD_SIEVE_FILTERS_PREDEFSPAM;}  
  else if ((pd->cmd == CMD_SIEVE_FILTERS_DO) && (cgienv_ExistsVar (pd->envfile, "filters_predefspam2") == true)) {pd->cmd = CMD_SIEVE_FILTERS_PREDEFSPAM2;}  
  else if ((pd->cmd == CMD_SIEVE_VACATIONS_DO) && (cgienv_ExistsVar (pd->envfile, "vacations_save") == true)) {pd->cmd = CMD_SIEVE_VACATIONS_SAVE;}
  else if ((pd->cmd == CMD_SIEVE_VACATIONS_DO) && (cgienv_ExistsVar (pd->envfile, "vacations_cancel") == true)) {pd->cmd = CMD_SIEVE_VACATIONS_CANCEL;}    
  cmd = pd->cmd;
                  
  switch (pd->cmd)
    {
    case (CMD_SIEVE_FILTERS_CANCEL):    
      {
      pd->uo->setStatusLine (L->get(MSG_CANCEL), BLUE);
      html->PrintSieveFiltersShow (pd);
      break;   
      }      
    case (CMD_SIEVE_FILTERS_SHOW):
      {
      pd->uo->InitStatusLine ();
      html->PrintSieveFiltersShow (pd);
      break;   
      }      
    case (CMD_SIEVE_FILTERS_SAVE):
      {
      TBuffer secname;
      bool b;
      cgienv_GetSimpleVarDef (pd->envfile, "filters_section", secname, "");
      b = CTS->saveFiltersToFile (pd->envfile, secname);
      if (b == false)
        {
        pd->html->ErrorPage(CTS->getErrorMsg());                
        }
      else
        {
        b = CTS->saveSieveNetwork();
        if (b == false)
          {
          pd->html->ErrorPage(CTS->getErrorMsg());
          }
        else
          {  
          pd->uo->setStatusLine (L->get(MSG_SAVEOPTIONS), BLUE);
          html->PrintSieveFiltersShow (pd);
          }
        }        
      break;   
      }      
    case (CMD_SIEVE_FILTERS_PREDEFSPAM):
    case (CMD_SIEVE_FILTERS_PREDEFSPAM2):    
      {
      bool b;      
      if (((CTS->isThereFilter(PREDEF_ANTISPAMFILTERNAME) == true) && (pd->cmd == CMD_SIEVE_FILTERS_PREDEFSPAM)) ||
          ((CTS->isThereFilter(PREDEF_ANTISPAMFILTERNAME2) == true) && (pd->cmd == CMD_SIEVE_FILTERS_PREDEFSPAM2)))
        {
        pd->html->ErrorPage(L->get(ERR_FILTERALREADYEXISTS));
        } 
      else        
        {
        TBuffer SpamMailBox, abuf;
        xstrncpy (SpamMailBox, CMAXBUFFER, cclient->expandMailboxName (SPAMMAILBOX, abuf));
        b = cclient->createMailbox (SpamMailBox);          
        if (pd->cmd == CMD_SIEVE_FILTERS_PREDEFSPAM)
          {        
          b = CTS->saveAntiSpamFilterToFile (pd->envfile, SpamMailBox);
          }
        else if (pd->cmd == CMD_SIEVE_FILTERS_PREDEFSPAM2)
          {
          b = CTS->saveAntiSpamFilterToFile2 (pd->envfile, SpamMailBox);          
          }
        if (b == false)
          {
          pd->html->ErrorPage(CTS->getErrorMsg());                
          }
        else
          {
          b = CTS->saveSieveNetwork();
          if (b == false)
            {
            pd->html->ErrorPage(CTS->getErrorMsg());
            }
          else
            {  
            pd->uo->setStatusLine (L->get(MSG_SAVEOPTIONS), BLUE);
            html->PrintSieveFiltersShow (pd);
            }
          }
        }          
      break;   
      }            
    case (CMD_SIEVE_FILTERS_CREATE):
      {
      html->PrintSieveFiltersEdit (CMD_SIEVE_FILTERS_CREATE, pd, NULL);
      break;   
      } 
    case (CMD_SIEVE_FILTERS_EDIT):
      {
      TBuffer secname;
      bool b;      

      cgienv_GetSimpleVarDef (pd->envfile, "filters_section", secname, ""); 
      b = CTS->isValidSection(secname);
      if (b == false)
        {
        pd->html->ErrorPage(CTS->getErrorMsg());                
        }
      else
        {
        html->PrintSieveFiltersEdit (CMD_SIEVE_FILTERS_EDIT, pd, secname);
        }        
      break;   
      }            
    case (CMD_SIEVE_FILTERS_UP):
      {
      TBuffer secname;
      bool b;      

      cgienv_GetSimpleVarDef (pd->envfile, "filters_section", secname, ""); 
      if (CTS->isValidSection(secname) == false) 
        {
        pd->html->ErrorPage(CTS->getErrorMsg());
        }
      else
        {
        b = CTS->upSection(secname);
        if (b == false)
          {
          pd->html->ErrorPage(CTS->getErrorMsg());                
          }
        else
          {
          b = CTS->saveSieveNetwork();
          if (b == false)
            {
            pd->html->ErrorPage(CTS->getErrorMsg());
            }
          else
            {
            pd->uo->setStatusLine (L->get(MSG_SAVEOPTIONS), BLUE);
            html->PrintSieveFiltersShow (pd);
            }
          }
        }          
      break;   
      }            
    case (CMD_SIEVE_FILTERS_DOWN):
      {
      TBuffer secname;
      bool b;      

      cgienv_GetSimpleVarDef (pd->envfile, "filters_section", secname, ""); 
      if (CTS->isValidSection(secname) == false) 
        {
        pd->html->ErrorPage(CTS->getErrorMsg());
        }
      else
        {
        b = CTS->downSection(secname);
        if (b == false)
          {
          pd->html->ErrorPage(CTS->getErrorMsg());                
          }
        else
          {
          b = CTS->saveSieveNetwork();
          if (b == false)
            {
            pd->html->ErrorPage(CTS->getErrorMsg());
            }
          else
            {
            pd->uo->setStatusLine (L->get(MSG_SAVEOPTIONS), BLUE);
            html->PrintSieveFiltersShow (pd);
            }
          }
        }        
      break;   
      }
    case (CMD_SIEVE_FILTERS_CONFDELETE):
      {
      TBuffer delete_names;
      StringList *SLMulti;
      
      pd->uo->InitStatusLine ();
      SLMulti = new StringList();
      cgienv_GetSimpleMultipleEntriesSL (pd->envfile, "filters_section", SLMulti, true);
      if (SLMulti->Count () <= 0) 
        {
        pd->html->ErrorPage(L->get(MSG_NO_ENTRIES_MARKED));
        }
      else
        {  
        initStr(delete_names);
        for (int kk=0; kk < SLMulti->Count (); ++kk) {xstrncat (delete_names, CMAXBUFFER, SLMulti->getString(kk).cstr()); xstrncat (delete_names, CMAXBUFFER, ",");}
        pd->html->PrintConfirmPage (iSERVICE_MAIN, "filters_delete", pd->stlang, delete_names, pd->username, pd->connid, 
                                    pd->uo->getValidator(), pd->uo->getPageId(), pd->uo);                                                    
        }                            
      delete SLMulti;        
      break;   
      }                                                   
    case (CMD_SIEVE_FILTERS_DELETE):
      {
      TBuffer filters_to_delete;
      bool b;
      StringList *SLMulti;
      int contdeleted;
      
      pd->uo->InitStatusLine ();      
      SLMulti = new StringList();
      cgienv_GetSimpleVarDef (pd->envfile, "filters_to_delete", filters_to_delete, ""); 
      SeparaTokensEnStringList (filters_to_delete, ',', SLMulti);
      if (SLMulti->Count () <= 0) 
        {
        pd->html->ErrorPage(L->get(MSG_NO_ENTRIES_MARKED));
        }
      else
        {  
        b = CTS->delFilters (SLMulti, &contdeleted);
        if (b == false) 
          {
          pd->html->ErrorPage(CTS->getErrorMsg());
          }
        else
          {
          b = CTS->saveSieveNetwork();
          if (b == false)
            {
            pd->html->ErrorPage(CTS->getErrorMsg());
            }
          else
            {
            pd->uo->setStatusLine (L->get(MSG_SAVEOPTIONS), BLUE);
            html->PrintSieveFiltersShow (pd);
            }
          }
        }        
      delete SLMulti;  
      break;   
      }
    case (CMD_SIEVE_VACATIONS_CANCEL):    
      {
      pd->cmd = CMD_SIEVE_VACATIONS_SAVE;
      xsnprintf (abuf, CMAXBUFFER, "%s/%s/config/noop/%s/%s/%s/%d/%d/%d/%ld/", PATH_CGI, SERVICE_CONFIG, pd->stlang, pd->username, pd->connid, pd->uo->getValidator(),
                 pd->uo->getPageId(), pd->uo->getLastCmd(), pd->uo->getCurrentPosition());                   
      pd->html->Redirect (abuf);               
      break;   
      }      
    case (CMD_SIEVE_VACATIONS_SHOW):
      {
      pd->uo->InitStatusLine ();
      html->PrintSieveVacationsShow (pd);
      break;
      }      
    case (CMD_SIEVE_VACATIONS_SAVE):
      {
      bool b;
      
      pd->uo->InitStatusLine ();      
      b = CTS->saveVacationToFile (pd->envfile, &vacation);
      if (b == false)
        {
        pd->html->ErrorPage(CTS->getErrorMsg());                
        }
      else
        {
        b = CTS->saveSieveNetwork();
        if (b == false)
          {
          pd->html->ErrorPage(CTS->getErrorMsg());
          }
        else
          {
          pd->uo->setStatusLine (L->get(MSG_SAVEOPTIONS), BLUE);
          html->PrintSieveVacationsShow (pd);
          }
        }        
      break;   
      }      
    case (CMD_SIEVE_FILTERS_DO):
    case (CMD_SIEVE_VACATIONS_DO):    
    default: 
      {    
      //pd->html->dumpFile (pd->envfile, "TEXT/PLAIN");
      LOG ("ERROR: Service_Sieve: Here we can not go!! cmd=%s, subcmd=%s", pd->stcmd, pd->stsubcmd);
      pd->html->PrintInvalidCommand (pd->stlang, pd->username, pd->connid, pd->uo);
      break;
      }         
    }
  return false;  
  }  

void HTMLPages::PrintSieveFiltersShow (TProgData *pd)
  {
  XFilter filter;

  Head ("text/html", "", "");
  HTMLBegin ();
  Title (L->get(TIT_SIEVE_DISPLAYPAGE), skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"),
         skin->getSkinAtribProp("IMG_BG"), pd->uo->get_use_javascript(), 0, NULL);  
  
  BotoneraComun_Sieve (CMD_SIEVE_FILTERS_SHOW, pd->stlang, pd->username, pd->connid, pd->uo);  
  BeginFormPost ("PrintSieveFiltersShow1", PATH_CGI);
  FormHidden ("service", SERVICE_SIEVE);
  FormHidden ("lang", pd->stlang);
  FormHidden ("user", pd->username);
  FormHidden ("connid", pd->connid);
  FormHidden ("validator", pd->uo->getValidator());
  FormHidden ("pageid", pd->uo->getPageId());
  FormHidden ("cmd", "filters_do");      
  FormHidden ("subcmd", "noop");        
  FormHidden ("lastcmd", CMD_SIEVE_FILTERS_SHOW);    
  BR();
  Label (L->get(L_FILTERS)); BR();
  Linea();
  FormButton ("filters_create",     L->get(L_CREATE));
  FormButton ("filters_edit",       L->get(L_EDIT));
  if (FLAllFilters.Count() > 0) {FormButton ("filters_confdelete", L->get(L_DELETE));}
  BR();
  Label (L->get(L_CREATEFILTER));
  WRITE ("<INPUT TYPE=SUBMIT NAME=\"%s\" VALUE=\"%s\" onClick=\"return confirm('%s')\">\n", "filters_predefspam",  L->get(L_INSERTSPAWNFILTER), L->get(MSG_INSERTSPAMFILTER));
  WRITE ("<INPUT TYPE=SUBMIT NAME=\"%s\" VALUE=\"%s\" onClick=\"return confirm('%s')\">\n", "filters_predefspam2",  L->get(L_INSERTSPAWNFILTER2), L->get(MSG_INSERTSPAMFILTER2));  
  BR();  

  WRITE ("<TABLE>\n");  
  WRITE ("<TR>\n");    
  WRITE ("<TD>\n");    
  FormBeginMultipleSelect ("PrintSieveFiltersShow1", "filters_section", NULL, pd->uo->get_use_javascript());   
  if (FLAllFilters.Count() > 0)
    {
    for (int i=0; i < FLAllFilters.Count(); ++i) 
      {
      filter = FLAllFilters.elementAt(i);
      FormAddOptionSelect (false, filter.sectionname, filter.name);
      }
    }
  else
    {
    FormAddOptionSelect (false, L->get(L_LIST_EMPTY), L->get(L_LIST_EMPTY));    
    }    
  FormEndSelect(); 
  WRITE ("</TD>\n"); 
  if (FLAllFilters.Count() > 1)
    {    
    WRITE ("<TD>\n");   
    FormButton ("filters_up", L->get(L_UP));
    BR();
    FormButton ("filters_down", L->get(L_DOWN));
    WRITE ("</TD>\n"); 
    } 
  WRITE ("</TR>\n");
  EndTable();
  EndForm ();
  HTMLEnd(skin->getSkinAtribProp("COLOR_BGTABLECOPYRIGHT"));            
  }
  
void HTMLPages::PrintSieveFiltersEdit (int actualcmd, TProgData *pd, const char *secname)
  {
  StringList SLMailboxes;
  TSBuffer abuzon;
  XFilter filter;
    
  Head ("text/html", "", "");
  HTMLBegin ();
  Title (L->get(TIT_SIEVE_DISPLAYPAGE), skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"),
         skin->getSkinAtribProp("IMG_BG"), pd->uo->get_use_javascript(), 0, NULL);  
  
  BotoneraComun_Sieve (actualcmd, pd->stlang, pd->username, pd->connid, pd->uo);  
  BeginFormPost ("PrintSieveFiltersEdit1", PATH_CGI);
  FormHidden ("service", SERVICE_SIEVE);
  FormHidden ("lang", pd->stlang);
  FormHidden ("user", pd->username);
  FormHidden ("connid", pd->connid);
  FormHidden ("validator", pd->uo->getValidator());
  FormHidden ("pageid", pd->uo->getPageId());
  FormHidden ("cmd", "filters_do");      
  FormHidden ("lastcmd", CMD_SIEVE_FILTERS_SHOW);    
  BR();

  BeginTable (5, 0, 0, 25);
  BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));
  BeginTD(); BeginCenter(); FormButton ("filters_save",   L->get(L_SAVE));   EndCenter(); EndTD();
  BeginTD(); BeginCenter(); FormButton ("filters_cancel", L->get(L_CANCEL)); EndCenter(); EndTD();
  EndTR(); 
  EndTable();  

  cclient->getMailboxes (&SLMailboxes, NULL, true, false);

  if (actualcmd == CMD_SIEVE_FILTERS_CREATE)
    {
    CTS->initFilter (&filter);
    }
  else
    {
    FormHidden ("filters_section", secname);
    CTS->getFilter (secname, &filter);
    }

  BR();
  Label (L->get(L_NAME)); Linea();
  Label (ESPACIADOR); FormEdit (100, 20, "filter_name", filter.name); 
  BR(); BR();
  
  Label (L->get(L_SIEVE_IF_IN_THE_MAIL)); Linea();
  WRITE ("<TABLE BORDER=\"0\">\n");
  BeginTR(); 
    WRITE ("<TD align=\"right\">\n");
      Text (L->get(L_SUBJECT_CONTAINS)); 
    EndTD(); 
    WRITE ("<TD align=\"left\">\n");
      FormEdit (100, 30, "filter_subject", filter.subject); 
    EndTD(); 
  EndTR();
  BeginTR(); 
    WRITE ("<TD align=\"right\">\n");
      Text (L->get(L_TO_CONTAINS)); 
    EndTD(); 
    WRITE ("<TD align=\"left\">\n");
      FormEdit (100, 30, "filter_to", filter.to);  
    EndTD(); 
  EndTR();
  BeginTR(); 
    WRITE ("<TD align=\"right\">\n");
      Text (L->get(L_FROM_CONTAINS)); 
    EndTD(); 
    WRITE ("<TD align=\"left\">\n");
      FormEdit (100, 30, "filter_from", filter.from); 
    EndTD(); 
  EndTR();   
  BeginTR(); 
    WRITE ("<TD align=\"right\">\n");
      Text (L->get(L_SIZE_IS_OVER)); 
    EndTD(); 
    WRITE ("<TD align=\"left\">\n");
      FormEdit (100, 6, "filter_size", filter.size);  
      Text (" (K)ilobytes"); 
    EndTD(); 
  EndTR();
  BeginTR(); 
    WRITE ("<TD align=\"right\">\n");
      Text (L->get(L_HEADER_CONTAINS));
      FormEdit (100, 10, "filter_header_name", filter.header_name);  
      Text (L->get(L_CONTAINS)); 
    EndTD(); 
    WRITE ("<TD align=\"left\">\n");
      FormEdit (100, 30, "filter_header_value", filter.header_value);  
    EndTD(); 
  EndTR();  
  EndTable();
  BR(); BR();
  
  Label (L->get(L_LEX_THEN)); Linea();
  WRITE ("<TABLE BORDER=\"0\">\n");
  if (strcmp(filter.action, "") == 0) 
  BeginTR();  
    WRITE ("<TD align=\"left\">\n");
      Label(ESPACIADOR);
      if (strcmp(filter.action, "move") == 0) 
        WRITE ("<INPUT CHECKED TYPE=\"radio\" NAME=\"filter_action\" VALUE=\"move\">%s \n", L->get(L_MOVEMSG));
      else
        WRITE ("<INPUT TYPE=\"radio\" NAME=\"filter_action\" VALUE=\"move\">%s \n", L->get(L_MOVEMSG));  
    EndTD(); 
    WRITE ("<TD align=\"left\">\n");  
      FormBeginSelect ("PrintSieveFiltersEdit1", "filter_folder", NULL, pd->uo->get_use_javascript()); 
      for (int i=0; i < SLMailboxes.Count(); ++i) 
        {
        xstrncpy (abuzon, CSMALLBUFFER, SLMailboxes.getString(i).cstr() + strlen(HTML_DCOMILLAS));
        abuzon [strlen(abuzon) - strlen(HTML_DCOMILLAS)] = '\0';            
        XString XS;
        int ppos;
        XS = "";
        if (NCstrstr (abuzon, NNTPFOLDERHTMLPREFIX) == 1) //Mailbox from News
          {
          XS += abuzon;
          }
        else if (strcmp (abuzon, "INBOX") != 0)
          {
          ppos = NCstrstr (abuzon, pd->uo->getMailboxPrefix());
          if (ppos > 0) {XS = XString (abuzon).substring(ppos + strlen(pd->uo->getMailboxPrefix()) - 1);}
          else {XS = "/"; XS += abuzon; xstrncpy (abuzon, CSMALLBUFFER, XS.cstr());}
          }
        else {XS = "INBOX";}
        if (strcmp (filter.folder, abuzon) == 0)
          {
          FormAddOptionSelect (true, SLMailboxes.getString(i).cstr(), XS.cstr());
          }
        else
          {
          FormAddOptionSelect (false, SLMailboxes.getString(i).cstr(), XS.cstr());
          }       
        }
      FormEndSelect();             
    EndTD(); 
  EndTR();
  BeginTR();  
    WRITE ("<TD align=\"left\" valign=\"top\">\n");
      Label(ESPACIADOR); 
      if (strcmp(filter.action, "reject") == 0) 
        WRITE ("<INPUT CHECKED TYPE=\"radio\" NAME=\"filter_action\" VALUE=\"reject\">%s\n", L->get(L_REJECT));  
      else
        WRITE ("<INPUT TYPE=\"radio\" NAME=\"filter_action\" VALUE=\"reject\">%s\n", L->get(L_REJECT));  
    EndTD();
    WRITE ("<TD align=\"left\">\n");
      FormTextArea (3, 30, "filter_rejecttext", filter.rejecttext, false); Text (L->get(L_REJECTEDTEXT));
    EndTD(); 
  EndTR();
  BeginTR(); 
    WRITE ("<TD align=\"left\">\n");   
      Label(ESPACIADOR); 
      if (strcmp(filter.action, "delete") == 0) 
        WRITE ("<INPUT CHECKED TYPE=\"radio\" NAME=\"filter_action\" VALUE=\"delete\">%s\n", L->get(L_DELETE));  
      else
        WRITE ("<INPUT TYPE=\"radio\" NAME=\"filter_action\" VALUE=\"delete\">%s\n", L->get(L_DELETE));  
    EndTD(); 
    WRITE ("<TD align=\"left\">\n");
    EndTD(); 
  EndTR();
  EndTable();
  
  BR();

  Linea();

  BeginTable (5, 0, 0, 25);
  BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));
  BeginTD(); BeginCenter(); FormButton ("filters_save",   L->get(L_SAVE));   EndCenter(); EndTD();
  BeginTD(); BeginCenter(); FormButton ("filters_cancel", L->get(L_CANCEL)); EndCenter(); EndTD();
  EndTR(); 
  EndTable();  

  EndForm ();
  HTMLEnd(skin->getSkinAtribProp("COLOR_BGTABLECOPYRIGHT"));            
  }
                                 
void HTMLPages::PrintSieveVacationsShow (TProgData *pd)
  {
  Head ("text/html", "", "");
  HTMLBegin ();
  Title (L->get(TIT_SIEVE_DISPLAYPAGE), skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"),
         skin->getSkinAtribProp("IMG_BG"), pd->uo->get_use_javascript(), 0, NULL);  
  
  BotoneraComun_Sieve (CMD_SIEVE_VACATIONS_SHOW, pd->stlang, pd->username, pd->connid, pd->uo);  

  BeginFormPost ("PrintSieveFiltersEdit1", PATH_CGI);
  FormHidden ("service", SERVICE_SIEVE);
  FormHidden ("lang", pd->stlang);
  FormHidden ("user", pd->username);
  FormHidden ("connid", pd->connid);
  FormHidden ("validator", pd->uo->getValidator());
  FormHidden ("pageid", pd->uo->getPageId());
  FormHidden ("cmd", "vacations_do");      
  FormHidden ("lastcmd", CMD_SIEVE_VACATIONS_SHOW);    
  BR();
  Linea();

  BeginTable (5, 0, 0, 25);
  BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));
  BeginTD(); BeginCenter(); FormButton ("vacations_save",   L->get(L_SAVE));   EndCenter(); EndTD();
  BeginTD(); BeginCenter(); FormButton ("vacations_cancel", L->get(L_CANCEL)); EndCenter(); EndTD();
  EndTR(); 
  EndTable();  

  CTS->getVacationFromFile ();
  if ((IsEmpty(vacation.vacations_ausenstaddresses) == true) && (!IsEmpty(pd->uo->getTrueEmail()))) 
    {xstrncpy (vacation.vacations_ausenstaddresses, CMAXBUFFER, pd->uo->getTrueEmail());}

  Linea();
  WRITE ("<TABLE BORDER=\"0\">\n");
  BeginTR(); 
    WRITE ("<TD align=\"right\">\n");
      Label (L->get(L_VACATION)); 
    EndTD(); 
    WRITE ("<TD align=\"left\">\n");
      if (strcasecmp (vacation.vacations_active, "true") == 0)
        {
        WRITE ("<INPUT TYPE=\"radio\" NAME=\"vacations_active\" VALUE=\"false\">%s\n", L->get(L_UNACTIVED));  
        WRITE ("<INPUT CHECKED TYPE=\"radio\" NAME=\"vacations_active\" VALUE=\"true\">%s\n", L->get(L_ACTIVED));          
        }
      else
        {
        WRITE ("<INPUT CHECKED TYPE=\"radio\" NAME=\"vacations_active\" VALUE=\"false\">%s\n", L->get(L_UNACTIVED));  
        WRITE ("<INPUT TYPE=\"radio\" NAME=\"vacations_active\" VALUE=\"true\">%s\n", L->get(L_ACTIVED));  
        }      
    EndTD(); 
  EndTR();   
  BeginTR(); 
    WRITE ("<TD align=\"right\" valign=\"top\">\n");
      Label (L->get(L_SUBJECT)); 
    EndTD(); 
    WRITE ("<TD align=\"left\">\n");
      FormEdit (100, 30, "vacations_msgsubject", vacation.vacations_msgsubject);
    EndTD(); 
  EndTR();     
  BeginTR(); 
    WRITE ("<TD align=\"right\" valign=\"top\">\n");
      Label (L->get(L_VACATION_TEXT)); 
    EndTD(); 
    WRITE ("<TD align=\"left\">\n");
      FormTextArea (5, 30, "vacations_msgtext", vacation.vacations_msgtext, false);
    EndTD(); 
  EndTR();   
  BeginTR(); 
    WRITE ("<TD align=\"right\">\n");
      Label (L->get(L_VACATION_DAYS2REPEAT)); 
    EndTD(); 
    WRITE ("<TD align=\"left\">\n");
      FormEdit (100, 3, "vacations_days2repeat", vacation.vacations_days2repeat);  
    EndTD(); 
  EndTR();
  BeginTR(); 
    WRITE ("<TD align=\"right\" valign=\"top\">\n");
      Label (L->get(L_VACATION_ADDRESSES)); 
    EndTD(); 
    WRITE ("<TD align=\"left\">\n");
      FormTextArea (3, 30, "vacations_ausenstaddresses", vacation.vacations_ausenstaddresses, false);
      WRITE ("<BR>%s<BR>\n", L->get(L_VACATION_ADD_EXPLICAT));
    EndTD(); 
  EndTR();
  EndTable();
  BR(); BR();
  
  Linea();
  BeginTable (5, 0, 0, 25);
  BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));
  BeginTD(); BeginCenter(); FormButton ("vacations_save",   L->get(L_SAVE));   EndCenter(); EndTD();
  BeginTD(); BeginCenter(); FormButton ("vacations_cancel", L->get(L_CANCEL)); EndCenter(); EndTD();
  EndTR(); 
  EndTable();  

  EndForm ();
  HTMLEnd(skin->getSkinAtribProp("COLOR_BGTABLECOPYRIGHT"));            
  }  
   
