/*
SendMSG.h
*/

#ifndef __SendMSG_H
#define __SendMSG_H

#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <signal.h>

#include "c-client.h"

#include "Language.h"
#include "Utils.h"
#include "Config.h"
#include "XSocket.h"
#include "XVector.h"
#include "Codecs.h"
#include "UserOptions.h"
#include "CCLIENT.h"

#include "postman_flstring.h"

#define SIZEBOUNDARY LENGTHBOUNDARY + 10

class SendMSG
  {
  private:
    bool Quoted, savemsginsentmail;
    int UseSMTPAuthenticated;
    char BOUNDARY[SIZEBOUNDARY], *firsttext;
    TBuffer user, to, newsgroups, cc, bcc, subject, from, personalname, references, trueemail;
    UserOptions *uo;
    IPNAME localhost, defaulthost, server;
    CCLIENT *cclient;
    StringList SLTO, SLCC, SLBCC;
    const char *MakeBoundary (void);
    const char *MakeMidBoundary (const char *boundary);
    const char *MakeEndBoundary (const char *boundary);
    const char *MakeContentID (const char *user, const char *maildomain);
  public:
    SendMSG (const char *aserver, const char *flname, UserOptions *auo, 
             const char *adefaulthost, CCLIENT *acclient);
    virtual ~SendMSG ();  
    bool getMustSaveMsgSentmail (void);
    void setTO  (const char *ato);
    void setNNTPGROUPS (const char *anewsgroups);
    void setFROM (const char *afrom);
    void setCC  (const char *acc);
    void setBCC (const char *abcc);
    void setSUBJECT (const char *asubject);
    void setPERSONALNAME  (const char *apersonalname);
    void setFIRSTTEXT (const char *afirsttext);
    void setREFERENCES (const char *areferences);
    void setTRUEEMAIL  (const char *atrueemail);
    char *getTO (void);
    char *getNNTPGROUPS (void);    
    char *getFROM (void);
    char *getCC (void);
    char *getBCC (void);
    char *getSUBJECT (void);
    char *getPERSONALNAME (void);
    char *getFIRSTTEXT (void);
    char *getREFERENCES (void);
    char *getTRUEEMAIL (void);
    void DelAttachs (void);
    bool sendSMTP  (TBuffer errormsg, const char *sentmail, bool *createdsentmailfolder, const char *fnmailcap);
    bool sendNNTP  (TBuffer errormsg, const char *sentmail, bool *createdsentmailfolder, const char *fnmailcap);    
  };
  
#endif

