/*                               
Service_FileBrowser.cc
*/

#include "Service_FileBrowser.h"
#include "ClientFileBrowser.h"

extern Language *L;
extern Configuration *Conf;
extern TBuffer BasePath;
extern Skin *skin;

StringList SLPapeleraCopy, SLPapeleraCut;
bool Inverse = false;
int CurrentDisk, FLSortToken = -1; //0=Filename, 1=Date, 2=Size
bool Service_FileBrowser_Initialized = false;
DiskList FLAllDisks; 
ClientFileBrowser *CFB;
TBuffer CurrentRelDir;
              
class HTMLPages: public HTMLBasic
  {
  private:
    void MyBotoneraComun (int cmdactual, const char *lang, const char *user, const char *connid, 
                          UserOptions *uo, const char *reldir);
  public:
    void PrintFileBrowserDisplayPage (const char *stlang, const char *user, const char *connid, UserOptions *uo, 
                                      ClientFileBrowser *CFB);
    void PrintFileBrowserEditFilePage (const char *stlang, const char *user, const char *connid, UserOptions *uo, 
                                       const char *shortfilename, const char *fullfilename);
    void PrintFileBrowserConfirmPage (const char *stlang, const char *user, const char *connid, UserOptions *uo, 
                                      ClientFileBrowser *CFB, StringList *SLMulti);
    void PrintFileBrowserRename (const char *stlang, const char *user, const char *connid, UserOptions *uo, 
                                 ClientFileBrowser *CFB, const char *oldfilename, const char *oldfullfilename);
  };

//retrieve the url for the Service icon
const char *GetService_FileBrowser_ICO_URL (void)
  {
  return skin->getI(L_FILEBROWSER);
  }

//Retrieve the ALT tag for the Service icon
const char *GetService_FileBrowser_ICO_ALT (void)
  {
  return L->get(L_FILEBROWSER);
  }

//Retrieve the Service name
const char *GetService_FileBrowser_NAME (void)
  {
  return L->get(L_FILEBROWSER);
  }

//Retrieve the Service Description
const char *GetService_FileBrowser_DESCRIPTION (TProgData *pd)
  {
  return L->get(L_FILEBROWSER_DESCRIPTION);
  }

//Entry point to service init
bool DoService_FileBrowser_BEGIN (TProgData *pd)
  {
  int i;
  TBuffer sectname, label, sectname_spaces, homedir, internal, ErrBuf;
  XDisk AXD;
  Configuration *TheConf;
  TBuffer file2show;

  if (Service_FileBrowser_Initialized == true) {return true;}
  Service_FileBrowser_Initialized = false;
  LOG ("Initializating Service FileBrowser for user=%s", pd->username);

  if (CheckServiceDisabled (TranslateServiceR(pd->service), file2show) == true) 
    {pd->html->dumpFile (file2show, "TEXT/HTML"); return false;}        
 
  ReturnUsersDir (BasePath, pd->username, pd->imapserver, homedir);
  TheConf = new Configuration (pd->maincfg, false);
  TheConf->Reload();
  FLAllDisks.Clear();
  i = 1;
  ReturnRestrictedDirNameFileBrowser (BasePath, pd->username, pd->imapserver, internal);
  if (CreateDir (internal, NEWDIRSMODE) == false)
    {
    LOG ("Error creating directory for BasePath: %s", internal);
    pd->html->ErrorPage("Error creating directory for BasePath");
    return false;
    }
  xsnprintf (sectname, CMAXBUFFER, "mount_%d", i);
  xsnprintf (label, CMAXBUFFER, TheConf->getString (sectname, "label", "", CMAXBUFFER));
  xsnprintf (sectname_spaces, CMAXBUFFER, " %s ", sectname);
  while (strcmp (label, "") != 0)
    {     
    if (NCstrstr (pd->uo->getMountPoints(), sectname_spaces) > 0)
      {
      xstrncpy (AXD.DiskName, CMAXBUFFER, sectname);
      xstrncpy (AXD.Label, CMAXBUFFER, label);
      xstrncpy (AXD.mount_dir, CMAXBUFFER, TheConf->getString (sectname, "mount_dir", "", CMAXBUFFER));
      ExpandString (AXD.mount_dir, CMAXBUFFER, "", pd->imapserver, pd->username, pd->password, homedir);    
      xstrncpy (AXD.mount_cmd, CMAXBUFFER, TheConf->getString (sectname, "mount_cmd", "", CMAXBUFFER));
      ExpandString (AXD.mount_cmd, CMAXBUFFER, "", pd->imapserver, pd->username, pd->password, homedir);    
      xstrncpy (AXD.umount_cmd, CMAXBUFFER, TheConf->getString (sectname, "umount_cmd", "", CMAXBUFFER));
      ExpandString (AXD.umount_cmd, CMAXBUFFER, "", pd->imapserver, pd->username, pd->password, homedir);
      xstrncpy (AXD.restricted_dir, CMAXBUFFER, TheConf->getString (sectname, "restricted_dir", "", CMAXBUFFER));
      ExpandString (AXD.restricted_dir, CMAXBUFFER, internal, pd->imapserver, pd->username, pd->password, homedir);    
      AXD.mounted = false; 
      AXD.quota = TheConf->getInt (sectname, "quota", 0);
      AXD.diskusage = getHardDiskUsage (AXD.restricted_dir, ErrBuf);
      FLAllDisks.Add (AXD);
      }
    ++i;
    xsnprintf (sectname, CMAXBUFFER, "mount_%d", i);
    xsnprintf (sectname_spaces, CMAXBUFFER, " %s ", sectname);
    xsnprintf (label, CMAXBUFFER, TheConf->getString (sectname, "label", "", CMAXBUFFER));
    }
  delete TheConf;
  if (FLAllDisks.Count() <= 0) 
    {
    LOG("DoService_FileBrowser_BEGIN: ERROR: No disks to mount."); 
    pd->html->ErrorPage("DoService_FileBrowser_BEGIN: ERROR: No disks to mount.");
    return false;
    };
  //MOUNT THE FIRST DEVICE
  if (strcmp (FLAllDisks.elementAt(0).mount_cmd, "") != 0)
    {
    CreateDir (FLAllDisks.elementAt(0).mount_dir, NEWDIRSMODE);
    //DEBUG ("--%s--", FLAllDisks.elementAt(0).mount_cmd);    
    TBuffer buf;
    xsnprintf (buf, CMAXBUFFER, "%s", FLAllDisks.elementAt(0).mount_cmd);
    int k=strlen(buf) - 1; while ((k >= 0) && (buf[k] != '=')) {buf[k] = 'X'; --k;}
    LOG (buf);
    int res = system (FLAllDisks.elementAt(0).mount_cmd);
    if (res != 0) 
      {
      //LOG("DoService_FileBrowser_BEGIN: ERROR: Code error executing '%s'", FLAllDisks.elementAt(0).mount_cmd); 
      LOG("DoService_FileBrowser_BEGIN: ERROR: Code error executing disk mount for user=%s", pd->username);
#define ERROR_NO_MOUNT "/"APPNAME"/error_no_mount.html"
      pd->html->Redirect (ERROR_NO_MOUNT);
      //pd->html->ErrorPage("DoService_FileBrowser_BEGIN: ERROR: Mounting disk.");
      return false;
      }
    }
  //DEFAULT DISK  
  FLAllDisks.elementAt(0).mounted = true;
  CFB = new ClientFileBrowser (0, 
                               FLAllDisks.elementAt(0).restricted_dir,
                               FLAllDisks.elementAt(0).diskusage, 
                               FLAllDisks.elementAt(0).quota);
  Service_FileBrowser_Initialized = true;
  return true;
  }

//Entry point to service end
bool DoService_FileBrowser_END (TProgData *pd)
  {
  if (Service_FileBrowser_Initialized == false) {return true;}
  //DEBUG ("DoService_FileBrowser_END");
  //UMOUNT ALL THE USER MOUNTS
  for (int k = 0; k < FLAllDisks.Count(); ++k)
    {
    if (FLAllDisks.elementAt(k).mounted == true)
      {
      if (strcmp (FLAllDisks.elementAt(k).umount_cmd, "") != 0)
        {
        if (system (FLAllDisks.elementAt(k).umount_cmd) == -1) 
          {
          LOG("DoService_FileBrowser_END: ERROR: Code error executing '%s'", FLAllDisks.elementAt(k).umount_cmd);
          }
        }
      }
    }
  delete CFB;
  Service_FileBrowser_Initialized = false;
  return true;
  }

//Entry point to execute a service command
bool DoService_FileBrowser_CMD (TProgData *pd)
  {
  HTMLPages *html;
  bool b;
  TBuffer anum, tmpbuff;

  html = (HTMLPages *)pd->html;
  
  TBuffer file2show;
  if (CheckServiceDisabled (TranslateServiceR(pd->service), file2show) == true) 
    {pd->html->dumpFile (file2show, "TEXT/HTML"); return false;}
  
  
  if (FLSortToken == -1) FLSortToken = 0;
  
  if (cgienv_ExistsVar (pd->envfile, "currentdisk") == true)
    {
    cgienv_GetSimpleVarDef (pd->envfile, "currentdisk", anum, "0");
    CurrentDisk = xatoidef (anum, 0);
    cgienv_GetSimpleVarDef (pd->envfile, "currentreldir", tmpbuff, "/");    
    CFB->unescape_input (tmpbuff, CurrentRelDir);
    }
  else
    {
    xstrncpy (anum, CMAXBUFFER, pd->parm1);        
    if (strcmp (anum, "") != 0)
      {  
      CurrentDisk = xatoidef (anum, 0);    
      xstrncpy (tmpbuff, CMAXBUFFER, pd->parm2);      
      }
    else
      {
      xstrncpy (tmpbuff, CMAXBUFFER, CFB->getCurrentRelDir());
      }  
    CFB->unescape_input (tmpbuff, CurrentRelDir);   
    }     
  if (strcmp (CurrentRelDir, "") == 0) xstrncpy (CurrentRelDir, CMAXBUFFER, "/");
  CFB->init (CurrentDisk,
             FLAllDisks.elementAt(CurrentDisk).restricted_dir,
             FLAllDisks.elementAt(CurrentDisk).diskusage, 
             FLAllDisks.elementAt(CurrentDisk).quota);
  b = CFB->setCurrentRelDir (CurrentRelDir);
  if (b == false) {pd->html->ErrorPage(CFB->getErrorMsg());}

  //Some commands require some initial action
  if ((pd->cmd == CMD_FILEBROWSER_EDITSHOW) && (cgienv_ExistsVar (pd->envfile, "editsave") == true))
    {
    pd->cmd = CMD_FILEBROWSER_EDITSAVE;
    }
  else if ((pd->cmd == CMD_FILEBROWSER_EDITSHOW) && (cgienv_ExistsVar (pd->envfile, "editcancel") == true))
    {
    pd->cmd = CMD_FILEBROWSER_EDITCANCEL;
    }
  else if (cgienv_ExistsVar (pd->envfile, "changedisk") == true)
    {
    pd->cmd = CMD_FILEBROWSER_CHANGEDISK;
    }                                        
  else if (cgienv_ExistsVar (pd->envfile, "createitem") == true)
    {
    pd->cmd = CMD_FILEBROWSER_CREATEITEM;
    }                                    
  else if (cgienv_ExistsVar (pd->envfile, "delete_conf") == true)
    {
    pd->cmd = CMD_FILEBROWSER_DELETEITEM_CONF;
    }                                            
  else if (cgienv_ExistsVar (pd->envfile, "delete") == true)
    {
    pd->cmd = CMD_FILEBROWSER_DELETEITEM;
    }                                        
  else if (cgienv_ExistsVar (pd->envfile, "copy") == true)
    {
    pd->cmd = CMD_FILEBROWSER_COPY;
    }                                            
  else if (cgienv_ExistsVar (pd->envfile, "cut") == true)
    {
    pd->cmd = CMD_FILEBROWSER_CUT;
    }                                            
  else if (cgienv_ExistsVar (pd->envfile, "paste") == true)
    {
    pd->cmd = CMD_FILEBROWSER_PASTE;
    }                                            
  else if (cgienv_ExistsVar (pd->envfile, "rename") == true)
    {
    pd->cmd = CMD_FILEBROWSER_RENAME;
    }                                            
  else if (cgienv_ExistsVar (pd->envfile, "rename_cancel") == true)
    {
    pd->cmd = CMD_FILEBROWSER_RENAMECANCEL;
    }                               
  else if (cgienv_ExistsVar (pd->envfile, "rename_ok") == true)
    {
    pd->cmd = CMD_FILEBROWSER_RENAMEOK;
    }                                            
  else if (cgienv_ExistsVar (pd->envfile, "loadfile") == true)
    {
    pd->cmd = CMD_FILEBROWSER_LOADFILE;
    }                                                
               
  switch (pd->cmd)
    {    
    case (CMD_FILEBROWSER_RENAMECANCEL):
    case (CMD_FILEBROWSER_EDITCANCEL):
    case (CMD_FILEBROWSER_DISPLAYPAGE):
      {
      b = CFB->obtainFileList ();
      if (b == false) 
        {
        pd->html->ErrorPage(CFB->getErrorMsg());
        }
      else
        {  
        pd->uo->InitStatusLine ();
        html->PrintFileBrowserDisplayPage (pd->stlang, pd->username, pd->connid, pd->uo, CFB);
        }
      break;   
      }
    case (CMD_FILEBROWSER_LOADFILE):
      {
      TBuffer filename, ori_fullfilename, des_fullfilename;
      int res;
      cgienv_GetSimpleVarDef (pd->envfile, "file", filename, "");
      if (strcmp (filename, "") == 0) {pd->html->ErrorPage(L->get(ERR_FILE_INVALIDNAME)); break;}
      if (LastChar (pd->uo->getAttachDir()) != '/')
        xsnprintf (ori_fullfilename, CMAXBUFFER, "%s/%s", pd->uo->getAttachDir(), filename);
      else
        xsnprintf (ori_fullfilename, CMAXBUFFER, "%s%s", pd->uo->getAttachDir(), filename);
      if (FileSize (ori_fullfilename) <= 0) {pd->html->ErrorPage(L->get(ERR_FILE_INVALIDNAME)); break;}
      b = CFB->obtainFullName (filename, des_fullfilename);
      if (b == false) 
        {
        pd->html->ErrorPage(CFB->getErrorMsg());
        }
      else
        {
        //DEBUG ("--%s--%s--", ori_fullfilename, des_fullfilename);
        res = xrename (ori_fullfilename, des_fullfilename);
        if (res != 0)
          {
          pd->html->ErrorPage("Renaming files");
          }
        else
          {  
          b = CFB->obtainFileList ();
          if (b == false) 
            {
            pd->html->ErrorPage(CFB->getErrorMsg());
            }
          else
            {
            pd->uo->InitStatusLine ();
            html->PrintFileBrowserDisplayPage (pd->stlang, pd->username, pd->connid, pd->uo, CFB);
            }
          }  
        }
      break;   
      }    
    case (CMD_FILEBROWSER_CHANGEDISK):
      {
      TBuffer abuf;
      int diskentry;

      cgienv_GetSimpleVarDef (pd->envfile, "disk_to_change", abuf, "0");
      diskentry = xatoidef (abuf, 0);
      if ((strcmp (FLAllDisks.elementAt(diskentry).mount_cmd, "") != 0) && 
          (FLAllDisks.elementAt(diskentry).mounted == false))
        {
        CreateDir (FLAllDisks.elementAt(diskentry).mount_dir, NEWDIRSMODE);
        if (system (FLAllDisks.elementAt(diskentry).mount_cmd) != 0) 
          {
          LOG("DoService_FileBrowser_BEGIN: ERROR: Code error executing '%s'", FLAllDisks.elementAt(diskentry).mount_cmd); 
          pd->html->ErrorPage("DoService_FileBrowser_BEGIN: ERROR: Mounting disk.");
          break;
          }
        }
      FLAllDisks.elementAt(diskentry).mounted = true;
      FLAllDisks.elementAt(diskentry).diskusage = getHardDiskUsage (FLAllDisks.elementAt(diskentry).restricted_dir, abuf);
      CFB->init (diskentry,
                 FLAllDisks.elementAt(diskentry).restricted_dir,
                 FLAllDisks.elementAt(diskentry).diskusage, 
                 FLAllDisks.elementAt(diskentry).quota);
      b = CFB->obtainFileList ();
      if (b == false) 
        {
        pd->html->ErrorPage(CFB->getErrorMsg());
        }
      else
        {
        xsnprintf (abuf, CMAXBUFFER, L->get(MSG_DISKCHANGED_OK));
        pd->uo->setStatusLine (abuf, BLUE);
        html->PrintFileBrowserDisplayPage (pd->stlang, pd->username, pd->connid, pd->uo, CFB);
        }
      break;         
      }                
    case (CMD_FILEBROWSER_CREATEITEM):
      {
      TBuffer itemname, whatcreate, abuf;
      cgienv_GetSimpleVarDef (pd->envfile, "to_create", itemname, "");
      cgienv_GetSimpleVarDef (pd->envfile, "whatcreate", whatcreate, "");
      if (strcasecmp (whatcreate, "dir") == 0) {b = CFB->makeDir(itemname);}
      else if (strcasecmp (whatcreate, "file") == 0) {b = CFB->makeFile(itemname);}
      else {b = false;}
      if (b == false) 
        {
        pd->html->ErrorPage(CFB->getErrorMsg());
        }
      else
        {  
        b = CFB->obtainFileList();
        if (b == false)                                                  
          {
          pd->html->ErrorPage(CFB->getErrorMsg());
          }
        else
          {
          xsnprintf (abuf, CMAXBUFFER, "%s", L->get(MSG_FILECREATED_OK));
          pd->uo->setStatusLine (abuf, BLUE);
          html->PrintFileBrowserDisplayPage (pd->stlang, pd->username, pd->connid, pd->uo, CFB);
          }
        }
      break;   
      }  
    case (CMD_FILEBROWSER_COPY):
      {
      bool b;
      TBuffer abuf;
      StringList *SLMulti;
      SLMulti = new StringList();
      SLPapeleraCopy.Clear();
      SLPapeleraCut.Clear();
      cgienv_GetSimpleMultipleEntriesSL (pd->envfile, "filename", SLMulti, true);        
      if (SLMulti->Count () <= 0) 
        {
        pd->html->ErrorPage(L->get(MSG_NO_ENTRIES_MARKED));
        }
      else
        {  
        for (int i = 0; i < SLMulti->Count (); ++i)
          {
          if (LastChar (CFB->getCurrentFullDir()) == '/')
            xsnprintf (abuf, CMAXBUFFER, "%s%s", CFB->getCurrentFullDir(), SLMulti->getString(i).cstr());          
          else
            xsnprintf (abuf, CMAXBUFFER, "%s/%s", CFB->getCurrentFullDir(), SLMulti->getString(i).cstr());          
          SLPapeleraCopy.Add (abuf);
          }
        b = CFB->obtainFileList ();
        if (b == false) 
          {
          pd->html->ErrorPage(CFB->getErrorMsg());
          }
        else
          {
          xsnprintf (abuf, CMAXBUFFER, "%s: %d", L->get(MSG_FILESCOPY), SLPapeleraCopy.Count()); 
          pd->uo->setStatusLine (abuf, BLUE);
          html->PrintFileBrowserDisplayPage (pd->stlang, pd->username, pd->connid, pd->uo, CFB);
          }
        }
      delete SLMulti;
      break;   
      }                  
    case (CMD_FILEBROWSER_CUT):
      {
      bool b;
      TBuffer abuf;
      StringList *SLMulti;
      SLMulti = new StringList();
      SLPapeleraCopy.Clear();
      SLPapeleraCut.Clear();
      cgienv_GetSimpleMultipleEntriesSL (pd->envfile, "filename", SLMulti, true);        
      if (SLMulti->Count () <= 0) 
        {
        pd->html->ErrorPage(L->get(MSG_NO_ENTRIES_MARKED));
        }
      else
        {  
        for (int i = 0; i < SLMulti->Count (); ++i)
          {
          if (LastChar (CFB->getCurrentFullDir()) == '/')
            xsnprintf (abuf, CMAXBUFFER, "%s%s", CFB->getCurrentFullDir(), SLMulti->getString(i).cstr());
          else
            xsnprintf (abuf, CMAXBUFFER, "%s/%s", CFB->getCurrentFullDir(), SLMulti->getString(i).cstr());          
          SLPapeleraCut.Add (abuf);
          }
        b = CFB->obtainFileList ();
        if (b == false) 
          {
          pd->html->ErrorPage(CFB->getErrorMsg());
          }
        else
          {
          xsnprintf (abuf, CMAXBUFFER, "%s: %d", L->get(MSG_FILESCUT), SLPapeleraCut.Count()); 
          pd->uo->setStatusLine (abuf, BLUE);
          html->PrintFileBrowserDisplayPage (pd->stlang, pd->username, pd->connid, pd->uo, CFB);
          }
        }
      delete SLMulti;
      break;   
      }      
    case (CMD_FILEBROWSER_PASTE):
      {
      bool b;
      TBuffer abuf;
      b = CFB->pasteItems (&SLPapeleraCopy, &SLPapeleraCut);
      if (b == false) 
        {
        pd->html->ErrorPage(CFB->getErrorMsg());
        }
      else
        {
        b = CFB->obtainFileList ();
        if (b == false) 
          {
          pd->html->ErrorPage(CFB->getErrorMsg());
          }
        else
          {
          if (SLPapeleraCopy.Count() > 0)
            xsnprintf (abuf, CMAXBUFFER, "%s: %d", L->get(MSG_FILESPASTED), SLPapeleraCopy.Count());
          else
            xsnprintf (abuf, CMAXBUFFER, "%s: %d", L->get(MSG_FILESPASTED), SLPapeleraCut.Count());
          pd->uo->setStatusLine (abuf, BLUE);
          html->PrintFileBrowserDisplayPage (pd->stlang, pd->username, pd->connid, pd->uo, CFB);
          }
        }
      break;   
      }        
    case (CMD_FILEBROWSER_DELETEITEM_CONF):
      {
      StringList *SLMulti;
      SLMulti = new StringList();      
      cgienv_GetSimpleMultipleEntriesSL (pd->envfile, "filename", SLMulti, true);            
      if (SLMulti->Count () <= 0) 
        {
        pd->html->ErrorPage(L->get(MSG_NO_ENTRIES_MARKED));
        }
      else
        {  
        pd->uo->InitStatusLine ();
        html->PrintFileBrowserConfirmPage (pd->stlang, pd->username, pd->connid, pd->uo, CFB, SLMulti);
        }      
      delete SLMulti;
      break;   
      }                  
    case (CMD_FILEBROWSER_DELETEITEM):
      {
      int contdeleted;
      TBuffer abuf;
      StringList *SLMulti;
      SLMulti = new StringList();
      cgienv_GetSimpleMultipleEntriesSL (pd->envfile, "filename", SLMulti, true);      
      b = CFB->deleteItems (SLMulti, &contdeleted);
      if (b == false) 
        {
        pd->html->ErrorPage(CFB->getErrorMsg());
        }
      else
        {
        b = CFB->obtainFileList ();
        if (b == false) 
          {
          pd->html->ErrorPage(CFB->getErrorMsg());
          }
        else
          {
          if (contdeleted <= 1)
            xsnprintf (abuf, CMAXBUFFER, L->get(MSG_FILESDELETED), contdeleted);              
          else
            xsnprintf (abuf, CMAXBUFFER, L->get(MSG_FILESDELETED_S), contdeleted);
          pd->uo->setStatusLine (abuf, BLUE);
          html->PrintFileBrowserDisplayPage (pd->stlang, pd->username, pd->connid, pd->uo, CFB);
          }
        }
      delete SLMulti;
      break;   
      }       
    case (CMD_FILEBROWSER_RENAMEOK):             
      {
      TBuffer abuf, oldfilename, newfilename;
      cgienv_GetSimpleVarDef (pd->envfile, "oldfilename", oldfilename, ""); 
      cgienv_GetSimpleVarDef (pd->envfile, "newfilename", newfilename, "");            
      b = CFB->renameItems (oldfilename, newfilename);
      if (b == false) 
        {
        pd->html->ErrorPage(CFB->getErrorMsg());
        }
      else
        {  
        b = CFB->obtainFileList ();
        if (b == false) 
          {
          pd->html->ErrorPage(CFB->getErrorMsg());
          }
        else
          {
          xsnprintf (abuf, CMAXBUFFER, L->get(MSG_FILERENAMED_OK));
          pd->uo->setStatusLine (abuf, BLUE);
          html->PrintFileBrowserDisplayPage (pd->stlang, pd->username, pd->connid, pd->uo, CFB);
          }
        }
      break;         
      }      
    case (CMD_FILEBROWSER_SORTNAME):
      {
      TBuffer abuf;      
      b = CFB->sortName ();
      if (b == false) 
        {
        pd->html->ErrorPage(CFB->getErrorMsg());
        }
      else
        {  
        xsnprintf (abuf, CMAXBUFFER, "%s", L->get(MSG_FILESORT_OK));
        pd->uo->setStatusLine (abuf, BLUE);
        html->PrintFileBrowserDisplayPage (pd->stlang, pd->username, pd->connid, pd->uo, CFB);
        }
      break;   
      }            
    case (CMD_FILEBROWSER_SORTDATE):
      {
      TBuffer abuf;      
      b = CFB->sortDate();
      if (b == false) 
        {
        pd->html->ErrorPage(CFB->getErrorMsg());
        }
      else
        {  
        xsnprintf (abuf, CMAXBUFFER, "%s", L->get(MSG_FILESORT_OK));
        pd->uo->setStatusLine (abuf, BLUE);
        html->PrintFileBrowserDisplayPage (pd->stlang, pd->username, pd->connid, pd->uo, CFB);
        }
      break;   
      }                  
    case (CMD_FILEBROWSER_SORTSIZE):
      {
      TBuffer abuf;      
      b = CFB->sortSize();
      if (b == false) 
        {
        pd->html->ErrorPage(CFB->getErrorMsg());
        }
      else
        {  
        xsnprintf (abuf, CMAXBUFFER, "%s", L->get(MSG_FILESORT_OK));
        pd->uo->setStatusLine (abuf, BLUE);
        html->PrintFileBrowserDisplayPage (pd->stlang, pd->username, pd->connid, pd->uo, CFB);
        }
      break;   
      }                        
    case (CMD_FILEBROWSER_CWDUP):
      {
      b = CFB->CwdUp();
      if (b == false) 
        {
        pd->html->ErrorPage(CFB->getErrorMsg());
        }
      else
        {  
        pd->uo->InitStatusLine ();
        html->PrintFileBrowserDisplayPage (pd->stlang, pd->username, pd->connid, pd->uo, CFB);
        }
      break;   
      }      
    case (CMD_FILEBROWSER_CWD):
      {
      b = CFB->Cwd(pd->parm3);
      if (b == false) 
        {
        pd->html->ErrorPage(CFB->getErrorMsg());
        }
      else
        {  
        pd->uo->InitStatusLine ();
        html->PrintFileBrowserDisplayPage (pd->stlang, pd->username, pd->connid, pd->uo, CFB);
        }
      break;   
      }                
    case (CMD_FILEBROWSER_CWDF):
      {
      b = CFB->CwdNonRelative(pd->parm3);
      if (b == false) 
        {
        pd->html->ErrorPage(CFB->getErrorMsg());
        }
      else
        {  
        pd->uo->InitStatusLine ();
        html->PrintFileBrowserDisplayPage (pd->stlang, pd->username, pd->connid, pd->uo, CFB);
        }
      break;   
      }          
    case (CMD_FILEBROWSER_DUMP):
      {
      TBuffer tmpbuff, REQUEST_URI, trueallparms, fullfilename, CT;
      cgienv_GetSimpleVarDef (pd->envfile, "REQUEST_URI", REQUEST_URI, "");
      getTrueAllParms (REQUEST_URI, tmpbuff);            
      CFB->unescape_input (tmpbuff, trueallparms);
      b = CFB->dumpFile (trueallparms, fullfilename, CT);
      if (b == false) 
        {
        pd->html->ErrorPage(CFB->getErrorMsg());
        }
      else
        {
        html->dumpFile (fullfilename, CT);  
        }
      break;   
      }                
    case (CMD_FILEBROWSER_RENAME):
      {
      StringList *SLMulti;
      TBuffer fullfilename;
      SLMulti = new StringList();      
      cgienv_GetSimpleMultipleEntriesSL (pd->envfile, "filename", SLMulti, true);            
      if (SLMulti->Count () <= 0) {pd->html->ErrorPage(L->get(MSG_NO_ENTRIES_MARKED));}       
      else if (SLMulti->Count () > 1) {pd->html->ErrorPage(L->get(ERR_SELECT_MORE_ONE));}
      else
        {  
        b = CFB->obtainFullName (SLMulti->getString(0).cstr(), fullfilename);
        if (b == false) 
          {
          pd->html->ErrorPage(CFB->getErrorMsg());
          }
        else
          {
          pd->uo->InitStatusLine ();
          html->PrintFileBrowserRename (pd->stlang, pd->username, pd->connid, pd->uo, CFB, 
                SLMulti->getString(0).cstr(), fullfilename);
          }
        }  
      break;   
      }                                  
    case (CMD_FILEBROWSER_EDITSHOW):
      {
      TBuffer fullfilename;
      b = CFB->obtainFullName (pd->parm3, fullfilename);
      if (b == false) 
        {
        pd->html->ErrorPage(CFB->getErrorMsg());
        }
      else
        {
        pd->uo->InitStatusLine ();
        html->PrintFileBrowserEditFilePage (pd->stlang, pd->username, pd->connid, pd->uo, 
                                            pd->parm3, fullfilename);
        }
      break;   
      }                            
    case (CMD_FILEBROWSER_EDITSAVE):
      {
      TBuffer shortfilename, fullfilename, abuf;
      cgienv_GetSimpleVarDef (pd->envfile, "filename", shortfilename, "");
      b = CFB->obtainFullName (shortfilename, fullfilename);
      if (b == false) 
        {
        pd->html->ErrorPage(CFB->getErrorMsg());
        }
      else
        {
        b = CFB->saveFile (fullfilename, cgienv_GetComplexVar (pd->envfile, "filetext"));
        if (b == false)
          {
          pd->html->ErrorPage(CFB->getErrorMsg());
          }
        else
          {
          xsnprintf (abuf, CMAXBUFFER, "%s", L->get(MSG_FILESAVED_OK));
          pd->uo->setStatusLine (abuf, BLUE);
          html->PrintFileBrowserEditFilePage (pd->stlang, pd->username, pd->connid, pd->uo, 
                                              shortfilename, fullfilename);
          }
        }
      break;   
      }                            
    default: 
      {    
      LOG ("ERROR: Service_FileBrowser: Here we can not go!! cmd=%s, subcmd=%s", pd->stcmd, pd->stsubcmd);
      pd->html->PrintInvalidCommand (pd->stlang, pd->username, pd->connid, pd->uo);
      break;
      }                             
    }
  return false;  
  }  

void HTMLPages::MyBotoneraComun (int cmdactual, const char *lang, const char *user, const char *connid, 
                                 UserOptions *uo, const char *reldir)
  {
  long actualpos, totalmsgs;
  int validator, pageid;
  TBuffer tmpbuf;
  
  actualpos = uo->getCurrentPosition();
  totalmsgs = uo->getTotalMsgs();
  validator = uo->getValidator();
  pageid    = uo->getPageId ();
  
  BeginTable (0, 0, 0, 100);
    BeginTR(skin->getSkinAtribProp("COLOR_BGBOTONERA"));

      //BUTTON BACK 
      if (strcmp (reldir, "/") != 0)   
        {   
        BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
        switch (cmdactual)
          {
          case CMD_FILEBROWSER_RENAME:
          case CMD_FILEBROWSER_EDITSAVE:
          case CMD_FILEBROWSER_EDITSHOW: 
            WRITE ("<A HREF=\"%s/%s/displaypage/noop/%s/%s/%s/%d/%d/%d/%d/%s\">", PATH_CGI, SERVICE_FILEBROWSER, lang, user, connid, validator, pageid, 
                   cmdactual, 
                   CFB->getCurrentDisk(), 
                   CFB->escape_input(CFB->getCurrentRelDir(), tmpbuf)); 
            break;
          default: 
            if (strcmp (reldir, "/") == 0)
              {
              WRITE ("<A HREF=\"%s/%s/root/noop/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, validator, pageid, cmdactual); 
              }
            else
              WRITE ("<A HREF=\"%s/%s/cwdup/noop/%s/%s/%s/%d/%d/%d/%d/%s\">", PATH_CGI, SERVICE_FILEBROWSER, lang, user, connid, validator, pageid, 
                     cmdactual, 
                     CFB->getCurrentDisk(), 
                     CFB->escape_input(CFB->getCurrentRelDir(), tmpbuf));
            break;
          }
        Image (skin->getI(L_BACK), L->get(ALT_BACK), skin->getISize());
        if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_BACK));}
        WRITE ("</A>");
        EndTD();  
        }
        
      //BUTTON ROOT      
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      WRITE ("<A HREF=\"%s/%s/root/noop/%s/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, uo->getValidator(),
         uo->getPageId(), uo->getLastCmd(), uo->getCurrentPosition());
      Image (skin->getI(L_ROOT), L->get(ALT_ROOT), skin->getISize());
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_ROOT));}
      WRITE ("</A>");
      EndTD();   
      
      //SPACE 
      EmptyCellx2();
      //BUTTON HELP   
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      switch (cmdactual)
        {
        case CMD_FILEBROWSER_RENAME:     WRITE ("<A HREF=\"%s/%s/help/rename/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_FILEBROWSER, lang, user, connid, validator, pageid, cmdactual); break;
        case CMD_FILEBROWSER_EDITSHOW:   WRITE ("<A HREF=\"%s/%s/help/editshow/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_FILEBROWSER, lang, user, connid, validator, pageid, cmdactual); break;
        case CMD_FILEBROWSER_DISPLAYPAGE:WRITE ("<A HREF=\"%s/%s/help/displaypage/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_FILEBROWSER, lang, user, connid, validator, pageid, cmdactual); break;  
        }
      Image (skin->getI(L_HELP), L->get(ALT_HELP), skin->getISize());
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_HELP));}
      WRITE ("</A>");
      EndTD();  
      //SPACE
      EmptyCellx2();      
      //BUTTON LOGOUT   
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      if (uo->getConfirmLogout() == true)    
        {
        WRITE ("<A HREF=\"%s/%s/conf_act/logout/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, validator, pageid, cmdactual);
        }
      else
        {  
        WRITE ("<A HREF=\"%s/%s/logout/noop/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, validator, pageid, cmdactual); 
        }
      Image (skin->getI(L_LOGOUT), L->get(ALT_LOGOUT), skin->getISize());
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_LOGOUT));}
      WRITE ("</A>");
      EndTD();
      BeginTD (100, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center"); WRITE (HTML_HSP);
    EndTR();
  EndTable ();  
  PrintStatusLine (user, uo, true);
  }

void HTMLPages::PrintFileBrowserDisplayPage (const char *stlang, const char *user, const char *connid, UserOptions *uo, 
                                             ClientFileBrowser *CFB)
              
  {
  TBuffer tmpbuf;
  StringList SL, SLInc;
  int EsDirWriteable = DIR_IS_WRITEABLE;
  
  Head ("text/html", "", "");
  HTMLBegin ();
  Title (L->get(TIT_FILEBROWSER_DISPLAYPAGE), skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"),
         skin->getSkinAtribProp("IMG_BG"), uo->get_use_javascript(), 0, NULL);  
  if (uo->get_use_javascript() == true)
    {
    JavaScript(DEF_JavaIndexCheck);
    }
                
  MyBotoneraComun (CMD_FILEBROWSER_DISPLAYPAGE, stlang, user, connid, uo, CFB->getCurrentRelDir());

  BeginTable (0, 2, 1, 100);
  //PROBANDO BeginFormPost ("PrintFileBrowserDisplayPage", PATH_CGI);
  BeginFormPostMultipartFormData ("PrintFileBrowserDisplayPage", PATH_CGI);
  FormHidden ("service", SERVICE_FILEBROWSER);
  FormHidden ("lang", stlang);
  FormHidden ("user", user);
  FormHidden ("connid", connid);
  FormHidden ("validator", uo->getValidator());
  FormHidden ("pageid", uo->getPageId());
  FormHidden ("cmd", "go");      
  FormHidden ("lastcmd", CMD_FILEBROWSER_DISPLAYPAGE);    
  FormHidden ("currentdisk", CFB->getCurrentDisk());
  FormHidden ("currentreldir",  CFB->getCurrentRelDir());

  EsDirWriteable = IsDirWriteable (CFB->getCurrentFullDir());

  BeginTR(skin->getSkinAtribProp("COLOR_BGTABLEMSGINDEX"));    
    BeginTDColSpan (1);    
    if (strcmp (CFB->obtainOldCurrentRelDir(), "") != 0)
      {
      WRITE ("<A HREF=\"%s/%s/cwdup/noop/%s/%s/%s/%d/%d/%d/%d/%s\">\n", PATH_CGI, SERVICE_FILEBROWSER, stlang, user, connid, 
             uo->getValidator(), uo->getPageId(), CMD_FILEBROWSER_DISPLAYPAGE, 
             CFB->getCurrentDisk(), 
             CFB->escape_input(CFB->getCurrentRelDir(), tmpbuf));
      Image (skin->getI(L_PARENTFOLDER), L->get(L_PARENTFOLDER), NULL);
      WRITE ("</A>\n");
      }
    else
      {
      Text ("&nbsp;");
      }
    EndTD();
    BeginTDColSpanCenter (4);        
    CFB->parseIncrementalPath (CFB->getCurrentRelDir(), &SL, &SLInc);
    if (EsDirWriteable == DIR_IS_WRITEABLE)
      {        
      WRITE ("<B>[%s]%s</B> ", 
             FLAllDisks.elementAt(CFB->getCurrentDisk()).Label,  
             CFB->getCurrentRelDir()
             );
      }
    else
      {        
      WRITE ("<FONT COLOR=\"#FF0000\">(R/O)</FONT>            <B>[%s]%s</B> ", 
             FLAllDisks.elementAt(CFB->getCurrentDisk()).Label,  
             CFB->getCurrentRelDir()
             );
      }                   
    if (FLAllDisks.elementAt(CFB->getCurrentDisk()).quota > 0)
      {      
      xsnprintf (tmpbuf, CMAXBUFFER, "%.2f MB", (float)CFB->getQuota() / (1024.0 * 1024.0)); 
      WRITE ("(%s: <B>%.2f%%</B>, %s: <B>%s</B>)", 
             L->get(L_QUOTAUSAGE),
             CFB->getPercQuotaUsage(),
             L->get(L_TOTAL_SIZE),
             tmpbuf
             );
      }                  
           
    EndTD();    
  EndTR();
  //SORT LINE HEADER TABLE
  BeginTR(skin->getSkinAtribProp("COLOR_BGTABLEMSGINDEX"));    
    //EMPTY
    BeginTD (skin->getSkinAtribProp("COLOR_BGTABLEMSGINDEX"));      
      Text ("&nbsp;");
    EndTD();
    //EMPTY
    BeginTD (skin->getSkinAtribProp("COLOR_BGTABLEMSGINDEX"));      
      Text ("&nbsp;");
    EndTD();    
    //NAME
    BeginTD (skin->getSkinAtribProp("COLOR_BGTABLEMSGINDEX"));
      if (uo->get_use_javascript() == true)
        {
        JSFormCheckbox ("jscheckall", "", "if (this.checked) {putOn()} else {putOff()}", false);
        }
      else
        {
        WRITE (HTML_HSP); 
        } 
      //I am sorting by name
      if (FLSortToken == 0) 
        {
        if (Inverse == true) Image (skin->getI(L_UPSORT), L->get(ALT_UPSORT), NULL);
        else Image (skin->getI(L_DOWNSORT), L->get(ALT_DOWNSORT), NULL);
        }  
      WRITE ("<A HREF=\"%s/%s/sortname/noop/%s/%s/%s/%d/%d/%d/%d/%s\">\n", PATH_CGI, SERVICE_FILEBROWSER, stlang, user, connid, 
             uo->getValidator(), uo->getPageId(), CMD_FILEBROWSER_DISPLAYPAGE, 
             CFB->getCurrentDisk(), 
             CFB->escape_input(CFB->getCurrentRelDir(), tmpbuf));
      Label("Nombre"); 
      WRITE ("</A>\n");  
    EndTD();
    //SIZE
    WRITE ("<TD align=\"right\" bgcolor=\"%s\">\n", skin->getSkinAtribProp("COLOR_BGTABLEMSGINDEX"));
      //I am sorting by size
      if (FLSortToken == 2) 
        {
        if (Inverse == true) Image (skin->getI(L_UPSORT), L->get(ALT_UPSORT), NULL);
        else Image (skin->getI(L_DOWNSORT), L->get(ALT_DOWNSORT), NULL);
        }  
      WRITE ("<A HREF=\"%s/%s/sortsize/noop/%s/%s/%s/%d/%d/%d/%d/%s\">\n", PATH_CGI, SERVICE_FILEBROWSER, stlang, user, connid, 
             uo->getValidator(), uo->getPageId(), CMD_FILEBROWSER_DISPLAYPAGE, 
             CFB->getCurrentDisk(), CFB->escape_input(CFB->getCurrentRelDir(), tmpbuf));
      Label("Tamao"); 
      WRITE ("</A>\n");  
    EndTD();
    //DATE TIME
    WRITE ("<TD align=\"right\" bgcolor=\"%s\">\n", skin->getSkinAtribProp("COLOR_BGTABLEMSGINDEX"));
      //I am sorting by DateTime
      if (FLSortToken == 1) 
        {
        if (Inverse == true) Image (skin->getI(L_UPSORT), L->get(ALT_UPSORT), NULL);
        else Image (skin->getI(L_DOWNSORT), L->get(ALT_DOWNSORT), NULL);
        }    
      WRITE ("<A HREF=\"%s/%s/sortdate/noop/%s/%s/%s/%d/%d/%d/%d/%s\">\n", PATH_CGI, SERVICE_FILEBROWSER, stlang, user, connid, 
             uo->getValidator(), uo->getPageId(), CMD_FILEBROWSER_DISPLAYPAGE, 
             CFB->getCurrentDisk(), CFB->escape_input(CFB->getCurrentRelDir(), tmpbuf));
      Label("Fecha"); 
      WRITE ("</A>\n");  
    EndTD();
  EndTR();

  //DIRECTORIES
  for (int i = 0; i < CFB->FLAllFiles.Count(); ++i)
    {
    if (CFB->FLAllFiles.elementAt(i).type == S_IFDIR) 
      {
      WRITE ("<TR valign=baseline bgcolor=\"%s\">", skin->getSkinAtribProp("COLOR_BGFILASMSGINDEX"));
          
        //IMG
        BeginTD (skin->getSkinAtribProp("COLOR_BGFILASMSGINDEX"));
          WRITE ("<A HREF=\"%s/%s/cwd/noop/%s/%s/%s/%d/%d/%d/%d/%s/%s/\">\n", PATH_CGI, SERVICE_FILEBROWSER, stlang, user, connid, 
                 uo->getValidator(), uo->getPageId(), CMD_FILEBROWSER_DISPLAYPAGE, 
                 CFB->getCurrentDisk(), CFB->escape_input(CFB->getCurrentRelDir(), tmpbuf),
                 CFB->FLAllFiles.elementAt(i).FileName);
          if (CFB->FLAllFiles.elementAt(i).Copiado == true) 
            {
            Image (skin->getI(L_FOLDER_COPY), L->get(L_FOLDER_COPY), NULL);
            }   
          else if (CFB->FLAllFiles.elementAt(i).Cortado == true)
            {
            Image (skin->getI(L_FOLDER_CUT), L->get(L_FOLDER_CUT), NULL);
            }
          else 
            {
            Image (skin->getI(L_FOLDER), L->get(L_FOLDER), NULL);
            }
          WRITE ("</A>\n");  
        EndTD();  
      
        //EMPTY
        BeginTD (skin->getSkinAtribProp("COLOR_BGFILASMSGINDEX"));      
          Text ("&nbsp;");
        EndTD();
      
        //DIR NAME
        BeginTD (skin->getSkinAtribProp("COLOR_BGFILASMSGINDEX"));
          FormCheckbox ("filename", CFB->FLAllFiles.elementAt(i).FileName, false); 
          WRITE ("<A HREF=\"%s/%s/cwd/noop/%s/%s/%s/%d/%d/%d/%d/%s/%s/\">\n", PATH_CGI, SERVICE_FILEBROWSER, stlang, user, connid, 
                 uo->getValidator(), uo->getPageId(), CMD_FILEBROWSER_DISPLAYPAGE, 
                 CFB->getCurrentDisk(), CFB->escape_input(CFB->getCurrentRelDir(), tmpbuf),
                 CFB->FLAllFiles.elementAt(i).FileName);
          Label(CFB->FLAllFiles.elementAt(i).FileName); 
          WRITE ("</A>\n");  
        EndTD();
                
        //EMPTY
        BeginTD (skin->getSkinAtribProp("COLOR_BGFILASMSGINDEX")); Text ("&nbsp;"); 
        EndTD();   
      
        //DATETIME
        WRITE ("<TD align=\"right\" bgcolor=\"%s\">\n", skin->getSkinAtribProp("COLOR_BGFILASMSGINDEX"));
          Text (CFB->getFileDate (&CFB->FLAllFiles.elementAt(i).st_mtime, tmpbuf));
        EndTD();      
      EndTR();  
      }
    }

  //FILES
  for (int i = 0; i < CFB->FLAllFiles.Count(); ++i)
    {
    if (CFB->FLAllFiles.elementAt(i).type == S_IFREG)
      {
      WRITE ("<TR valign=baseline bgcolor=\"%s\">", skin->getSkinAtribProp("COLOR_BGFILASMSGINDEX"));
          
        //IMG
        BeginTD (skin->getSkinAtribProp("COLOR_BGFILASMSGINDEX"));
          WRITE ("<A HREF=\"%s/%s/dump/noop/%s/%s/%s/%d/%d/%d/%d/%s/%s\">\n", PATH_CGI, SERVICE_FILEBROWSER, stlang, user, connid, 
                 uo->getValidator(), uo->getPageId(), CMD_FILEBROWSER_DISPLAYPAGE, 
                 CFB->getCurrentDisk(), CFB->escape_input(CFB->getCurrentRelDir(), tmpbuf),
                 CFB->FLAllFiles.elementAt(i).FileName);
          if (CFB->FLAllFiles.elementAt(i).Copiado == true)
            {   
            Image (skin->getI(L_FILE_COPY), L->get(L_FILE_COPY), NULL);
            } 
          else if (CFB->FLAllFiles.elementAt(i).Cortado == true)
            {   
            Image (skin->getI(L_FILE_CUT), L->get(L_FILE_CUT), NULL);
            }
          else 
            {
            Image (skin->getI(L_FILE), L->get(L_FILE), NULL);
            }
          WRITE ("</A>\n");  
        EndTD();  
      
        //EDIT FILE
        BeginTD (skin->getSkinAtribProp("COLOR_BGFILASMSGINDEX"));      
        if (EsDirWriteable == DIR_IS_WRITEABLE)  
          {
          if (CFB->isEditableFile (CFB->FLAllFiles.elementAt(i).FileName) == true)
            {
            WRITE ("<A HREF=\"%s/%s/editshow/noop/%s/%s/%s/%d/%d/%d/%d/%s/%s/\">\n", PATH_CGI, SERVICE_FILEBROWSER, stlang, user, connid, 
                   uo->getValidator(), uo->getPageId(), CMD_FILEBROWSER_DISPLAYPAGE, 
                   CFB->getCurrentDisk(), CFB->escape_input(CFB->getCurrentRelDir(), tmpbuf),
                   CFB->FLAllFiles.elementAt(i).FileName);
            Image (skin->getI(L_EDIT), L->get(L_EDIT), NULL);
            WRITE ("</A>\n");  
            }
          else 
            {
            Text ("&nbsp;");
            }    
          }      
        EndTD();
       
        //FILENAME
        BeginTD (skin->getSkinAtribProp("COLOR_BGFILASMSGINDEX"));
          FormCheckbox ("filename", CFB->FLAllFiles.elementAt(i).FileName, false); 
          WRITE ("<A HREF=\"%s/%s/dump/noop/%s/%s/%s/%d/%d/%d/%d/%s/%s\">\n", PATH_CGI, SERVICE_FILEBROWSER, stlang, user, connid, 
                 uo->getValidator(), uo->getPageId(), CMD_FILEBROWSER_DISPLAYPAGE,                  
                 CFB->getCurrentDisk(), CFB->escape_input(CFB->getCurrentRelDir(), tmpbuf),
                 CFB->FLAllFiles.elementAt(i).FileName);
          Label(CFB->FLAllFiles.elementAt(i).FileName); 
          WRITE ("</A>\n");  
        EndTD();
      
        //SIZE
        WRITE ("<TD align=\"right\" bgcolor=\"%s\">\n", skin->getSkinAtribProp("COLOR_BGFILASMSGINDEX"));
          CFB->FormatCountBytes (CFB->FLAllFiles.elementAt(i).size, tmpbuf);
          if (tmpbuf[strlen(tmpbuf) - 2] != 'K')
            {
            WRITE ("<FONT color=\"%s\">%s</FONT>", RED, tmpbuf);
            }
          else
            {
            Text (tmpbuf);
            }
        EndTD();   
      
        //FILEDATE
        WRITE ("<TD align=\"right\" bgcolor=\"%s\">\n", skin->getSkinAtribProp("COLOR_BGFILASMSGINDEX"));
          Text (CFB->getFileDate (&CFB->FLAllFiles.elementAt(i).st_mtime, tmpbuf));
        EndTD();      
      EndTR();  
      }
    }
  EndTable();              
  
  FormHidden ("service", SERVICE_FILEBROWSER);
  FormHidden ("lang", stlang);
  FormHidden ("user", user);
  FormHidden ("connid", connid);
  FormHidden ("cmd", "go");
  FormHidden ("validator", uo->getValidator());  
  FormHidden ("pageid", uo->getPageId());
  FormHidden ("lastcmd", CMD_FILEBROWSER_DISPLAYPAGE);
  if (EsDirWriteable == DIR_IS_WRITEABLE) 
    {
    FormButton ("loadfile", L->get(L_LOAD)); FormFile (255, 50, "file", "", "*"); 
    }
  FormHidden ("currentdisk", CFB->getCurrentDisk());
  FormHidden ("currentreldir",  CFB->getCurrentRelDir());

  BR();
  if ((EsDirWriteable == DIR_IS_WRITEABLE) || (EsDirWriteable == DIR_IS_OVERQUOTA)) 
                                          FormButton ("delete_conf", L->get(L_DELETE));      
  FormButton ("copy",        L->get(L_COPY));
  if (EsDirWriteable == DIR_IS_WRITEABLE) FormButton ("cut",         L->get(L_CUT));    
  if (EsDirWriteable == DIR_IS_WRITEABLE) FormButton ("paste",       L->get(L_PASTE));
  if (EsDirWriteable == DIR_IS_WRITEABLE) FormButton ("rename",      L->get(L_RENAME));
  BR();  
  if (EsDirWriteable == DIR_IS_WRITEABLE) 
    {
    FormButton ("createitem", L->get(L_CREATE));
    FormBeginSelect ("PrintFileBrowserDisplayPage1", "whatcreate", NULL, uo->get_use_javascript()); 
    FormAddOptionSelect (true,  "dir",       L->get(L_FOLDER));
    FormAddOptionSelect (false, "file",      L->get(L_FILE));  
    FormEndSelect();
    WRITE ("<INPUT TYPE=TEXT NAME=\"to_create\" SIZE=\"10\" MAXLENGTH=\"20\" VALUE=\"\">\n"); 
    }
  if (FLAllDisks.Count() > 1)
    {
    FormButton ("changedisk",  L->get(L_CHANGE_DISK));
    FormBeginSelect ("PrintFileBrowserDisplayPage2", "disk_to_change", NULL, uo->get_use_javascript()); 
    for (int k=0; k < FLAllDisks.Count(); ++k)
      {
      TNumber anum;
      if (k == 0)
        FormAddOptionSelect (true, xitoa(k, anum), FLAllDisks.elementAt(k).Label);
      else
        FormAddOptionSelect (false, xitoa(k, anum), FLAllDisks.elementAt(k).Label);
      }
    FormEndSelect();  
    }
  EndForm ();
  HTMLEnd(skin->getSkinAtribProp("COLOR_BGTABLECOPYRIGHT"));            
  }
  
void HTMLPages::PrintFileBrowserEditFilePage (const char *stlang, const char *user, const char *connid, UserOptions *uo, 
                                              const char *shortfilename, const char *fullfilename)

  {
  XString JS;
  char *pc = NULL;
    
  Head ("text/html", "", "");
  HTMLBegin ();
  Title (L->get(TIT_FILEBROWSER_EDITFILEPAGE), skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"),
         skin->getSkinAtribProp("IMG_BG"), uo->get_use_javascript(), 0, NULL);  
  
  MyBotoneraComun (CMD_FILEBROWSER_EDITSHOW, stlang, user, connid, uo, "");

  BeginCenter();
  BeginTable (0, 0, 0, 100);
  BeginTR();
    BeginTD();
      Label (shortfilename);
    EndTD();  
  EndTR();  
  BeginFormPost ("PrintFileBrowserEditFilePage", PATH_CGI);
  FormHidden ("service", SERVICE_FILEBROWSER);
  FormHidden ("lang", stlang);
  FormHidden ("user", user);
  FormHidden ("connid", connid);
  FormHidden ("validator", uo->getValidator());
  FormHidden ("pageid", uo->getPageId());
  FormHidden ("cmd", "editshow");      
  FormHidden ("lastcmd", CMD_FILEBROWSER_DISPLAYPAGE);    
  FormHidden ("filename", shortfilename);
  FormHidden ("currentdisk", CFB->getCurrentDisk());
  FormHidden ("currentreldir",  CFB->getCurrentRelDir());

  JS = getLineFile(fullfilename, 1, -1, NULL);
  BeginTR();
    BeginTD();
      FormTextArea (uo->getHeightWriteArea(), uo->getWidthWriteArea(), "filetext", Text2HTML(JS.cstr(), pc), false); BR(); free(pc);
    EndTD();  
  EndTR();  
  BeginTR();
    BeginTD();
      FormButton ("editsave", L->get(L_SAVE));
      FormButton ("editcancel", L->get(L_CANCEL));  
    EndTD();  
  EndTR();  

  EndForm ();
  EndTable();              
  EndCenter();

  HTMLEnd(skin->getSkinAtribProp("COLOR_BGTABLECOPYRIGHT"));            
  }  
   
void HTMLPages::PrintFileBrowserConfirmPage (const char *stlang, const char *user, const char *connid, UserOptions *uo, 
                                             ClientFileBrowser *CFB, StringList *SLMulti)
  {
  TBuffer abuff;
  Head ("text/html", "", "");
  HTMLBegin ();
  Title (L->get(TIT_CONFIRMACTION), skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"),
         skin->getSkinAtribProp("IMG_BG"), uo->get_use_javascript(), 0, NULL);  
  Linea ();
  BeginCenter(); 
  snprintf (abuff, CMAXBUFFER, L->get(MSG_CONF_DELETEITEMS)); 
  RedLabel (abuff);     
  EndCenter ();
  BeginCenter();
  BeginFormPost ("PrintConfirmPage1", PATH_CGI);
  FormHidden ("service", SERVICE_FILEBROWSER);
  FormHidden ("lang", stlang);
  FormHidden ("user", user);
  FormHidden ("connid", connid);
  FormHidden ("cmd", "deleteitem");
  FormHidden ("validator", uo->getValidator());
  FormHidden ("pageid", uo->getPageId());
  FormHidden ("lastcmd", CMD_MAIN_CONF_ACT);
  FormHidden ("currentdisk", CFB->getCurrentDisk());
  FormHidden ("currentreldir", CFB->getCurrentRelDir());
  FormButton ("theaction", L->get(L_CONFIRM));    
  for (int i=0; i < SLMulti->Count(); ++i)
    {
    FormHidden ("filename", SLMulti->getString(i).cstr());
    }    
  EndForm ();   
  EndCenter ();
  
  BeginCenter();
  BeginTable (0, 0, 0, 0);
  for (int i=0; i < SLMulti->Count(); ++i)
    {
    BeginTR();
    BeginTD();
    if (CFB->isDirectory (SLMulti->getString(i).cstr()) == true)
      {
      WRITE ("<B><IMG SRC=\"%s\" border=0 alt=\"%s\"> %s</B><BR>\n", 
             skin->getI(L_FOLDER), L->get(L_FOLDER), SLMulti->getString(i).cstr());  
      }
    else
      {
      WRITE ("<B><IMG SRC=\"%s\" border=0 alt=\"%s\"> %s</B><BR>\n", 
             skin->getI(L_FILE), L->get(L_FILE), SLMulti->getString(i).cstr());        
      }
    EndTD();  
    EndTR();  
    }
  EndTable ();  
  EndCenter();
    
  HTMLEnd(skin->getSkinAtribProp("COLOR_BGTABLECOPYRIGHT"));      
  }
         
void HTMLPages::PrintFileBrowserRename (const char *stlang, const char *user, const char *connid, UserOptions *uo, 
                                        ClientFileBrowser *CFB, const char *oldfilename, const char *oldfullfilename)

  {
  TBuffer abuf;  

  Head ("text/html", "", "");
  HTMLBegin ();
  Title (L->get(TIT_FILEBROWSER_EDITFILEPAGE), skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"),
         skin->getSkinAtribProp("IMG_BG"), uo->get_use_javascript(), 0, NULL);  
  
  MyBotoneraComun (CMD_FILEBROWSER_RENAME, stlang, user, connid, uo, "");

  BeginFormPost ("PrintFileBrowserRename", PATH_CGI);
  FormHidden ("service", SERVICE_FILEBROWSER);
  FormHidden ("lang", stlang);
  FormHidden ("user", user);
  FormHidden ("connid", connid);
  FormHidden ("validator", uo->getValidator());
  FormHidden ("pageid", uo->getPageId());
  FormHidden ("cmd", "go");      
  FormHidden ("lastcmd", CMD_FILEBROWSER_DISPLAYPAGE);    
  FormHidden ("currentdisk", CFB->getCurrentDisk());
  FormHidden ("currentreldir",  CFB->getCurrentRelDir());
  FormHidden ("oldfilename", oldfilename);
  xsnprintf (abuf, CMAXBUFFER, L->get(L_RENAME_TO), oldfilename);
  Label (abuf);
  WRITE ("<INPUT TYPE=TEXT NAME=\"newfilename\" SIZE=\"20\" MAXLENGTH=\"20\" VALUE=\"\">\n"); 
  BR(); 
  BR();
  FormButton ("rename_ok",     L->get(L_RENAME));
  FormButton ("rename_cancel", L->get(L_CANCEL));  

  HTMLEnd(skin->getSkinAtribProp("COLOR_BGTABLECOPYRIGHT"));            
  }  
   
   
