// ------------------------------------------------------------------------- //
// $Id: particle.h,v 1.1 2003/05/27 21:57:06 pandr Exp $
// ------------------------------------------------------------------------- //

/*
 * Copyright (c) 2002 
 *				see AUTHORS list
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

// ------------------------------------------------------------------------- //

#ifndef _PARTICLE_H_
#define _PARTICLE_H_

#if HAVE_VECTOR
# include <vector>
#endif

#include "common.h"

class Particle
{
public:
	Particle();
	void set_pos(v3 pos) { _pos = pos;  }
	v3   get_pos() const { return _pos; }
	void set_mat(m33 mat){ _mat = mat;  }
	m33  get_mat() const { return _mat; }
	void set_age(float age) { _age = age; }
	float get_age() const { return _age; }
	void set_velocity(v3 vel) { _velocity = vel;  }
	v3   get_velocity() const { return _velocity; }
	void set_color(rgba& col) { _color = col; }
	rgba get_color() const { return _color; }
//private:
	v3 _pos;
	m33 _mat;
	float _age;
	v3 _velocity;
	rgba _color;
	float _size;
	float _size_original;
	bool _dead;
};

class ParticleSystem
{
public:
	ParticleSystem();
	~ParticleSystem();
	typedef std::vector<Particle> _particles_;
	void draw();
	void update(float delta_time);
	int spawn_particles(int num);
private:
	void draw_particle(v3 &pos, float size, byte r, byte g, byte b, byte a);
	_particles_ _particles;
	v3 _pos;
	v3 _velocity;
	v3 _gravity;
	int _max_particles;
	float _spawn_frequency;
	float _particles_to_spawn;
	class Texture* _tex;
};

class Field
{
public:
	v3 _center;
	v3 _size;
	v3 _force;
};


#endif /* _PARTICLE_H_ */

// ------------------------------------------------------------------------- //

