// ------------------------------------------------------------------------- //
// $Id: nodefactory.h,v 1.39 2004/01/02 15:58:25 pandr Exp $
// ------------------------------------------------------------------------- //

/*
 * Copyright (c) 2002 
 *				see AUTHORS list
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

// ------------------------------------------------------------------------- //

#ifndef _NODEFACTORY_H_
#define _NODEFACTORY_H_

#include "node.h"
#include "group.h"
#include "image.h"
#include "primitive.h"

// ------------------------------------------------------------------------- //

class FreeTypeFont;

//! A description of a tile-element

class TileInfo
{
public:
	TileInfo(Tile::handle h, float x, float y)
		: tile(h), xoffset(x), yoffset(y) { };
	Tile::handle tile;
	float        xoffset;
	float        yoffset;
};

//! A list of tiles. Used for caching images that has been loaded
//  onto textures and cut into tiles.

class TileList : public std::vector<TileInfo>
{
public:
	TileList(uint w, uint h) : _width(w), _height(h) { };
	uint get_width()  const { return _width;  }
	uint get_height() const { return _height; }
private:
	uint _width;
	uint _height;
};

//! A factory (DP, pp. 107ff) producing Nodes.
//! This is primarily used by the Python part of pointless to get 
//  building blocks from which the nodetree may be constructed.

class NodeFactory
{
public:
	static NodeFactory* instance();
	~NodeFactory() {};
protected:
	NodeFactory() {};
public:
	Leaf*       image(const char*  filename, bool center, bool gray_alpha,
                      const rgba& color, float dropshadow);
	Leaf*		rectangle(const v2 &ll, const v2 &ur, const rgba& ll_color,
					const rgba& lr_color, const rgba& ul_color, 
					const rgba& ur_color, bool stretch, 
					const char *texturename);
	Letter*		letter(FreeTypeFont::handle font, FT_ULong c, 
					const rgba& color, float dropshadow);
	Group*		group(const char* name);
	TileList*	pic_primlist(Image *img, bool center);
private:
	static NodeFactory _instance;
	ImageLoader	_image_loader;
};

#endif /* _NODEFACTORY_H_ */

// ------------------------------------------------------------------------- //

