/*
 * JSToken.cs - Token codes for JScript constructs.
 *
 * Copyright (C) 2003 Southern Storm Software, Pty Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
namespace Microsoft.JScript
{

public enum JSToken
{
	None						=  -1,
	EndOfFile					=   0,
	If							=   1,
	For							=   2,
	Do							=   3,
	While						=   4,
	Continue					=   5,
	Break						=   6,
	Return						=   7,
	Import						=   8,
	With						=   9,
	Switch						=  10,
	Throw						=  11,
	Try							=  12,
	Package						=  13,
	Internal					=  14,
	Abstract					=  15,
	Public						=  16,
	Static						=  17,
	Private						=  18,
	Protected					=  19,
	Final						=  20,
	Event						=  21,
	Var							=  22,
	Const						=  23,
	Class						=  24,
	Function					=  25,
	LeftCurly					=  26,
	Semicolon					=  27,
	Null						=  28,
	True						=  29,
	False						=  30,
	This						=  31,
	Identifier					=  32,
	StringLiteral				=  33,
	IntegerLiteral				=  34,
	NumericLiteral				=  35,
	LeftParen					=  36,
	LeftBracket					=  37,
	AccessField					=  38,
	LogicalNot					=  39,
	BitwiseNot					=  40,
	Delete						=  41,
	Void						=  42,
	Typeof						=  43,
	Increment					=  44,
	Decrement					=  45,
	Plus						=  46,
	Minus						=  47,
	LogicalOr					=  48,
	LogicalAnd					=  49,
	BitwiseOr					=  50,
	BitwiseXor					=  51,
	BitwiseAnd					=  52,
	Equal						=  53,
	NotEqual					=  54,
	StrictEqual					=  55,
	StrictNotEqual				=  56,
	GreaterThan					=  57,
	LessThan					=  58,
	LessThanEqual				=  59,
	GreaterThanEqual			=  60,
	LeftShift					=  61,
	RightShift					=  62,
	UnsignedRightShift			=  63,
	Multiply					=  64,
	Divide						=  65,
	Modulo						=  66,
	Instanceof					=  67,
	In							=  68,
	Assign						=  69,
	PlusAssign					=  70,
	MinusAssign					=  71,
	MultiplyAssign				=  72,
	DivideAssign				=  73,
	BitwiseAndAssign			=  74,
	BitwiseOrAssign				=  75,
	BitwiseXorAssign			=  76,
	ModuloAssign				=  77,
	LeftShiftAssign				=  78,
	RightShiftAssign			=  79,
	UnsignedRightShiftAssign    =  80,
	ConditionalIf    			=  81,
	Colon    					=  82,
	Comma    					=  83,
	Case    					=  84,
	Catch    					=  85,
	Debugger    				=  86,
	Default    					=  87,
	Else    					=  88,
	Export    					=  89,
	Extends						=  90,
	Finally						=  91,
	Get							=  92,
	Implements					=  93,
	Interface					=  94,
	New							=  95,
	Set							=  96,
	Super						=  97,
	RightParen					=  98,
	RightCurly					=  99,
	RightBracket				= 100,
	PreProcessorConstant		= 101,
	Comment						= 102,
	UnterminatedComment			= 103,
	Assert						= 104,
	Boolean						= 105,
	Byte						= 106,
	Char						= 107,
	Decimal						= 108,
	Double						= 109,
	DoubleColon					= 110,
	Enum						= 111,
	Ensure						= 112,
	Float						= 113,
	Goto						= 114,
	Int							= 115,
	Invariant					= 116,
	Long						= 117,
	Namespace					= 118,
	Native						= 119,
	Require						= 120,
	Sbyte						= 121,
	Short						= 122,
	Synchronized				= 123,
	Transient					= 124,
	Throws						= 125,
	ParamArray					= 126,
	Volatile					= 127,
	Ushort						= 128,
	Uint						= 129,
	Ulong						= 130,
	Use							= 131,
	EndOfLine					= 132,
	PreProcessDirective			= 133,
	FirstOp						= LogicalNot,
	FirstBinaryOp				= Plus,
	LastPPOperator				= Modulo,
	LastAssign					= UnsignedRightShiftAssign,
	LastBinaryOp				= UnsignedRightShiftAssign,
	LastOp						= Comma

}; // enum JSToken

}; // namespace Microsoft.JScript
