/* Generated from "XMLReader.cmod" by precompile.pike
 *
 * Do NOT edit this file.
 */

#undef PRECOMPILE_API_VERSION
#define PRECOMPILE_API_VERSION 2


#line 1 "XMLReader.cmod"
/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: XMLReader.cmod,v 1.17 2005/07/22 19:56:32 hww3 Exp $
 */

/*
 * File licensing and authorship information block.
 *
 * Version: MPL 1.1/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Initial Developer of the Original Code is
 *
 * Bill Welliver <hww3@riverweb.com>
 *
 * Portions created by the Initial Developer are Copyright (C) Bill Welliver
 * All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of the LGPL, and not to allow others to use your version
 * of this file under the terms of the MPL, indicate your decision by
 * deleting the provisions above and replace them with the notice
 * and other provisions required by the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL or the LGPL.
 *
 * Significant Contributors to this file are:
 *
 *
 */

#define THIS_IS_XML2_XMLREADER 1

#include "xml2.h"

/*! @module Public
 */

/*! @module Parser
 */

/*! @module XML2
 */

/*! @class XMLReader
 *!
 *! A simplified parser for XML documents. Similar to the C# XMLReader 
 *! class.
 */
#ifdef HAVE_LIBXML_XMLREADER_H


#undef class_XMLReader_defined
#define class_XMLReader_defined
struct program *XMLReader_program=NULL;
static int XMLReader_program_fun_num=-1;

#undef var_object_data_XMLReader_defined
#define var_object_data_XMLReader_defined

#undef THIS
#define THIS ((struct XMLReader_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_XMLREADER
#define THIS_XMLREADER ((struct XMLReader_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_XMLREADER
#define OBJ2_XMLREADER(o) ((struct XMLReader_struct *)(o->storage+XMLReader_storage_offset))

#undef GET_XMLREADER_STORAGE
#define GET_XMLREADER_STORAGE ((struct XMLReader_struct *)(o->storage+XMLReader_storage_offset)
static ptrdiff_t XMLReader_storage_offset;
struct XMLReader_struct {

#ifdef var_object_data_XMLReader_defined
#line 83 "XMLReader.cmod"
XMLREADER_OBJECT_DATA   *object_data;
#endif /* var_object_data_XMLReader_defined */
};
#define f_XMLReader_cq__sprintf_defined
ptrdiff_t f_XMLReader_cq__sprintf_fun_num = 0;
void f_XMLReader_cq__sprintf(INT32 args) {
#line 85 "XMLReader.cmod"
INT_TYPE type;
#line 85 "XMLReader.cmod"
struct svalue * t;
#line 85 "XMLReader.cmod"
if(args != 2) wrong_number_of_args_error("_sprintf",args,2);
#line 85 "XMLReader.cmod"
if(Pike_sp[0-2].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("_sprintf",1,"int");
type=Pike_sp[0-2].u.integer;
#line 85 "XMLReader.cmod"
t=Pike_sp+1-2; dmalloc_touch_svalue(Pike_sp+1-2);
{
  char * desc;

  push_text("XMLReader()");
}

}
/*! @decl void set_autoencode(int a)
 *!
 *! turns autoencoding of data to UTF-8 on or off.
 *!
 */
#define f_XMLReader_set_autoencode_defined
ptrdiff_t f_XMLReader_set_autoencode_fun_num = 0;
void f_XMLReader_set_autoencode(INT32 args) {
#line 97 "XMLReader.cmod"
INT_TYPE a;
#line 97 "XMLReader.cmod"
if(args != 1) wrong_number_of_args_error("set_autoencode",args,1);
#line 97 "XMLReader.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("set_autoencode",1,"int");
a=Pike_sp[0-1].u.integer;
#line 98 "XMLReader.cmod"
{
  THIS->object_data->autoencode = a;
  pop_stack();
}

}
/*! @decl int read()
 *!
 *! reads the next node of the document and loads its data.
 *!
 *! returns 1 if a node was read, 0 if no additional nodes are available,
 *!  and throws an error if a parse error occurred.
 */
#define f_XMLReader_read_defined
ptrdiff_t f_XMLReader_read_fun_num = 0;
void f_XMLReader_read(INT32 args) {
#line 110 "XMLReader.cmod"
if(args != 0) wrong_number_of_args_error("read",args,0);
{
  int res;

  if(THIS->object_data == NULL || THIS->object_data->reader == NULL)
  {
    Pike_error("no xmlReader!\n");
  }

  res = xmlTextReaderRead(THIS->object_data->reader);
  if(res == 1) /* we got data to process! */
  {
    push_int(1);
    return;
  }
  else if (res == 0)
  {
    push_int(0);
    return;
  }
  else
  {
    Pike_error("unable to parse, result code: %d!\n", res);
  }
}

}
/*! @decl int node_type()
 *! 
 *!  returns the type of the current node. Types are described here:
 *!   http://dotgnu.org/pnetlib-doc/System/Xml/XmlNodeType.html
 */
#define f_XMLReader_node_type_defined
ptrdiff_t f_XMLReader_node_type_fun_num = 0;
void f_XMLReader_node_type(INT32 args) {
#line 141 "XMLReader.cmod"
if(args != 0) wrong_number_of_args_error("node_type",args,0);
{
  if(THIS->object_data->reader == NULL)
  {
    Pike_error("no xmlReader!\n");
  }

  do { INT_TYPE ret_=(xmlTextReaderNodeType(THIS->object_data->reader));  push_int(ret_); return; }while(0);
#line 149 "XMLReader.cmod"
}

}
/*! @decl Node expand()
 *!
 */

#define f_XMLReader_expand_defined
ptrdiff_t f_XMLReader_expand_fun_num = 0;
void f_XMLReader_expand(INT32 args) {
#line 155 "XMLReader.cmod"
if(args != 0) wrong_number_of_args_error("expand",args,0);
{
  xmlNodePtr node;
struct object * xnode;
  struct Node_struct * ns;
  NODE_OBJECT_DATA * od;

  if(THIS->object_data->reader == NULL)
  {
    Pike_error("no xmlReader!\n");
  }

  node = xmlTextReaderExpand(THIS->object_data->reader);

  if(node == NULL)
  {
    Pike_error("error expanding node!\n");
  }

  xnode = NEW_NODE();
  ns = OBJ2_NODE((xnode));
  od = (NODE_OBJECT_DATA *)(ns->object_data);
  od->transient = 1;
  od->refs = malloc(sizeof(INT32));
  (* od->refs)=1;

  od->node = node;

  push_object(xnode);  
}

}
/*! @decl int depth()
 *! 
 *!   returns the depth of the current node within the tree.
 */
#define f_XMLReader_depth_defined
ptrdiff_t f_XMLReader_depth_fun_num = 0;
void f_XMLReader_depth(INT32 args) {
#line 190 "XMLReader.cmod"
if(args != 0) wrong_number_of_args_error("depth",args,0);
{
  if(THIS->object_data->reader == NULL)
  {
    Pike_error("no xmlReader!\n");
  }

  do { INT_TYPE ret_=(xmlTextReaderDepth(THIS->object_data->reader));  push_int(ret_); return; }while(0);
#line 198 "XMLReader.cmod"
}

}
/*! @decl int has_attributes()
 *! 
 *!  Does the node have attributes?
 */
#define f_XMLReader_has_attributes_defined
ptrdiff_t f_XMLReader_has_attributes_fun_num = 0;
void f_XMLReader_has_attributes(INT32 args) {
#line 204 "XMLReader.cmod"
if(args != 0) wrong_number_of_args_error("has_attributes",args,0);
{
  if(THIS->object_data->reader == NULL)
  {
    Pike_error("no xmlReader!\n");
  }

  do { INT_TYPE ret_=(xmlTextReaderHasAttributes(THIS->object_data->reader));  push_int(ret_); return; }while(0);
#line 212 "XMLReader.cmod"
}

}
/*! @decl int attribute_count()
 *! 
 *!  returns the number of attributes associated with the current node.
 */
#define f_XMLReader_attribute_count_defined
ptrdiff_t f_XMLReader_attribute_count_fun_num = 0;
void f_XMLReader_attribute_count(INT32 args) {
#line 218 "XMLReader.cmod"
if(args != 0) wrong_number_of_args_error("attribute_count",args,0);
{
  if(THIS->object_data->reader == NULL)
  {
    Pike_error("no xmlReader!\n");
  }

  do { INT_TYPE ret_=(xmlTextReaderAttributeCount(THIS->object_data->reader));  push_int(ret_); return; }while(0);
#line 226 "XMLReader.cmod"
}

}
/*! @decl int next_sibling()
 *! 
 */
#define f_XMLReader_next_sibling_defined
ptrdiff_t f_XMLReader_next_sibling_fun_num = 0;
void f_XMLReader_next_sibling(INT32 args) {
#line 231 "XMLReader.cmod"
if(args != 0) wrong_number_of_args_error("next_sibling",args,0);
{
  if(THIS->object_data->reader == NULL)
  {
    Pike_error("no xmlReader!\n");
  }

  do { INT_TYPE ret_=(xmlTextReaderNextSibling(THIS->object_data->reader));  push_int(ret_); return; }while(0);
#line 239 "XMLReader.cmod"
}

}
/*! @decl int next()
 *! 
 */
#define f_XMLReader_next_defined
ptrdiff_t f_XMLReader_next_fun_num = 0;
void f_XMLReader_next(INT32 args) {
#line 244 "XMLReader.cmod"
if(args != 0) wrong_number_of_args_error("next",args,0);
{
  if(THIS->object_data->reader == NULL)
  {
    Pike_error("no xmlReader!\n");
  }

  do { INT_TYPE ret_=(xmlTextReaderNext(THIS->object_data->reader));  push_int(ret_); return; }while(0);
#line 252 "XMLReader.cmod"
}

}
/*! @decl int element()
 *! 
 */
#define f_XMLReader_element_defined
ptrdiff_t f_XMLReader_element_fun_num = 0;
void f_XMLReader_element(INT32 args) {
#line 257 "XMLReader.cmod"
if(args != 0) wrong_number_of_args_error("element",args,0);
{
  if(THIS->object_data->reader == NULL)
  {
    Pike_error("no xmlReader!\n");
  }

  do { INT_TYPE ret_=(xmlTextReaderMoveToElement(THIS->object_data->reader));  push_int(ret_); return; }while(0);
#line 265 "XMLReader.cmod"
}

}
/*! @decl int first_attribute()
 *! 
 */
#define f_XMLReader_first_attribute_defined
ptrdiff_t f_XMLReader_first_attribute_fun_num = 0;
void f_XMLReader_first_attribute(INT32 args) {
#line 270 "XMLReader.cmod"
if(args != 0) wrong_number_of_args_error("first_attribute",args,0);
{
  if(THIS->object_data->reader == NULL)
  {
    Pike_error("no xmlReader!\n");
  }

  do { INT_TYPE ret_=(xmlTextReaderMoveToFirstAttribute(THIS->object_data->reader));  push_int(ret_); return; }while(0);
#line 278 "XMLReader.cmod"
}

}
/*! @decl int next_attribute()
 *! 
 */
#define f_XMLReader_next_attribute_defined
ptrdiff_t f_XMLReader_next_attribute_fun_num = 0;
void f_XMLReader_next_attribute(INT32 args) {
#line 283 "XMLReader.cmod"
if(args != 0) wrong_number_of_args_error("next_attribute",args,0);
{
  if(THIS->object_data->reader == NULL)
  {
    Pike_error("no xmlReader!\n");
  }

  do { INT_TYPE ret_=(xmlTextReaderMoveToNextAttribute(THIS->object_data->reader));  push_int(ret_); return; }while(0);
#line 291 "XMLReader.cmod"
}

}
/*! @decl int attribute_no()
 *! 
 */
#define f_XMLReader_attribute_no_defined
ptrdiff_t f_XMLReader_attribute_no_fun_num = 0;
void f_XMLReader_attribute_no(INT32 args) {
#line 296 "XMLReader.cmod"
INT_TYPE no;
#line 296 "XMLReader.cmod"
if(args != 1) wrong_number_of_args_error("attribute_no",args,1);
#line 296 "XMLReader.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("attribute_no",1,"int");
no=Pike_sp[0-1].u.integer;
#line 297 "XMLReader.cmod"
{
  if(THIS->object_data->reader == NULL)
  {
    Pike_error("no xmlReader!\n");
  }

  do { INT_TYPE ret_=(xmlTextReaderMoveToAttributeNo(THIS->object_data->reader, no)); pop_stack(); push_int(ret_); return; }while(0);
#line 304 "XMLReader.cmod"
}

}
/*! @decl int attribute_ns(string localName, string namespaceURI)
 *! 
 */
#define f_XMLReader_attribute_ns_defined
ptrdiff_t f_XMLReader_attribute_ns_fun_num = 0;
void f_XMLReader_attribute_ns(INT32 args) {
#line 309 "XMLReader.cmod"
struct pike_string * localName;
#line 309 "XMLReader.cmod"
struct pike_string * namespaceURI;
#line 309 "XMLReader.cmod"
if(args != 2) wrong_number_of_args_error("attribute_ns",args,2);
#line 309 "XMLReader.cmod"
if(Pike_sp[0-2].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("attribute_ns",1,"string");
#line 309 "XMLReader.cmod"
debug_malloc_pass(localName=Pike_sp[0-2].u.string);
#line 309 "XMLReader.cmod"
if(Pike_sp[1-2].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("attribute_ns",2,"string");
#line 309 "XMLReader.cmod"
debug_malloc_pass(namespaceURI=Pike_sp[1-2].u.string);
{
  if(THIS->object_data->reader == NULL)
  {
    Pike_error("no xmlReader!\n");
  }

  f_rconvert_string_utf8(1);
  namespaceURI = Pike_sp[-1].u.string;

  stack_swap_n(2);

  localName = Pike_sp[-1].u.string;
  f_rconvert_string_utf8(1);

  do { INT_TYPE ret_=(xmlTextReaderMoveToAttributeNs(THIS->object_data->reader, 
    (const xmlChar *)localName->str, (const xmlChar *)namespaceURI->str)); pop_n_elems(2); push_int(ret_); return; }while(0);
#line 326 "XMLReader.cmod"
}

}
/*! @decl int attribute(string name)
 *! 
 */
#define f_XMLReader_attribute_defined
ptrdiff_t f_XMLReader_attribute_fun_num = 0;
void f_XMLReader_attribute(INT32 args) {
#line 331 "XMLReader.cmod"
struct pike_string * name;
#line 331 "XMLReader.cmod"
if(args != 1) wrong_number_of_args_error("attribute",args,1);
#line 331 "XMLReader.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("attribute",1,"string");
#line 331 "XMLReader.cmod"
debug_malloc_pass(name=Pike_sp[0-1].u.string);
{
  if(THIS->object_data->reader == NULL)
  {
    Pike_error("no xmlReader!\n");
  }

  f_rconvert_string_utf8(1);
  name = Pike_sp[-1].u.string;

  do { INT_TYPE ret_=(xmlTextReaderMoveToAttribute(THIS->object_data->reader, 
    (const xmlChar *)name->str)); pop_stack(); push_int(ret_); return; }while(0);
#line 343 "XMLReader.cmod"
}


}
/*! @decl int has_value()
 *! 
 */
#define f_XMLReader_has_value_defined
ptrdiff_t f_XMLReader_has_value_fun_num = 0;
void f_XMLReader_has_value(INT32 args) {
#line 349 "XMLReader.cmod"
if(args != 0) wrong_number_of_args_error("has_value",args,0);
{
  if(THIS->object_data->reader == NULL)
  {
    Pike_error("no xmlReader!\n");
  }

  do { INT_TYPE ret_=(xmlTextReaderHasValue(THIS->object_data->reader));  push_int(ret_); return; }while(0);
#line 357 "XMLReader.cmod"
}

}
/*! @decl int is_default()
 *! 
 */
#define f_XMLReader_is_default_defined
ptrdiff_t f_XMLReader_is_default_fun_num = 0;
void f_XMLReader_is_default(INT32 args) {
#line 362 "XMLReader.cmod"
if(args != 0) wrong_number_of_args_error("is_default",args,0);
{
  if(THIS->object_data->reader == NULL)
  {
    Pike_error("no xmlReader!\n");
  }

  do { INT_TYPE ret_=(xmlTextReaderIsDefault(THIS->object_data->reader));  push_int(ret_); return; }while(0);
#line 370 "XMLReader.cmod"
}

}
/*! @decl int is_namespace_decl()
 *! 
 */
#define f_XMLReader_is_namespace_decl_defined
ptrdiff_t f_XMLReader_is_namespace_decl_fun_num = 0;
void f_XMLReader_is_namespace_decl(INT32 args) {
#line 375 "XMLReader.cmod"
if(args != 0) wrong_number_of_args_error("is_namespace_decl",args,0);
{
  if(THIS->object_data->reader == NULL)
  {
    Pike_error("no xmlReader!\n");
  }

  do { INT_TYPE ret_=(xmlTextReaderIsNamespaceDecl(THIS->object_data->reader));  push_int(ret_); return; }while(0);
#line 383 "XMLReader.cmod"
}

}
/*! @decl int is_empty_element()
 *! 
 */
#define f_XMLReader_is_empty_element_defined
ptrdiff_t f_XMLReader_is_empty_element_fun_num = 0;
void f_XMLReader_is_empty_element(INT32 args) {
#line 388 "XMLReader.cmod"
if(args != 0) wrong_number_of_args_error("is_empty_element",args,0);
{
  if(THIS->object_data->reader == NULL)
  {
    Pike_error("no xmlReader!\n");
  }

  do { INT_TYPE ret_=(xmlTextReaderIsEmptyElement(THIS->object_data->reader));  push_int(ret_); return; }while(0);
#line 396 "XMLReader.cmod"
}

}
/*! @decl int is_valid()
 *! 
 */
#define f_XMLReader_is_valid_defined
ptrdiff_t f_XMLReader_is_valid_fun_num = 0;
void f_XMLReader_is_valid(INT32 args) {
#line 401 "XMLReader.cmod"
if(args != 0) wrong_number_of_args_error("is_valid",args,0);
{
  if(THIS->object_data->reader == NULL)
  {
    Pike_error("no xmlReader!\n");
  }

  do { INT_TYPE ret_=(xmlTextReaderIsValid(THIS->object_data->reader));  push_int(ret_); return; }while(0);
#line 409 "XMLReader.cmod"
}

}
/*! @decl int parser_column_number()
 *! 
 */
#define f_XMLReader_parser_column_number_defined
ptrdiff_t f_XMLReader_parser_column_number_fun_num = 0;
void f_XMLReader_parser_column_number(INT32 args) {
#line 414 "XMLReader.cmod"
if(args != 0) wrong_number_of_args_error("parser_column_number",args,0);
{
  if(THIS->object_data->reader == NULL)
  {
    Pike_error("no xmlReader!\n");
  }
#ifdef HAVE_XMLTEXTREADERGETPARSERCOLUMNNUMBER
  do { INT_TYPE ret_=(xmlTextReaderGetParserColumnNumber(THIS->object_data->reader));  push_int(ret_); return; }while(0);
#line 422 "XMLReader.cmod"
#else
  do { INT_TYPE ret_=(-1);  push_int(ret_); return; }while(0);
#line 424 "XMLReader.cmod"
#endif /* HAVE_XMLTEXTREADERGETPARSERCOLUMNNUMBER */
}

}
/*! @decl int parser_line_number()
 *! 
 */
#define f_XMLReader_parser_line_number_defined
ptrdiff_t f_XMLReader_parser_line_number_fun_num = 0;
void f_XMLReader_parser_line_number(INT32 args) {
#line 430 "XMLReader.cmod"
if(args != 0) wrong_number_of_args_error("parser_line_number",args,0);
{
  if(THIS->object_data->reader == NULL)
  {
    Pike_error("no xmlReader!\n");
  }
#ifdef HAVE_XMLTEXTREADERGETPARSERLINENUMBER
  do { INT_TYPE ret_=(xmlTextReaderGetParserLineNumber(THIS->object_data->reader));  push_int(ret_); return; }while(0);
#line 438 "XMLReader.cmod"
#else
  do { INT_TYPE ret_=(-1);  push_int(ret_); return; }while(0);
#line 440 "XMLReader.cmod"
#endif /* HAVE_XMLTEXTREADERGETPARSERLINENUMBER */
}

}
/*! @decl int get_parser_prop(int prop)
 *! 
 *! @param prop
 *!   the property to get
 */
#define f_XMLReader_get_parser_prop_defined
ptrdiff_t f_XMLReader_get_parser_prop_fun_num = 0;
void f_XMLReader_get_parser_prop(INT32 args) {
#line 448 "XMLReader.cmod"
INT_TYPE prop;
#line 448 "XMLReader.cmod"
if(args != 1) wrong_number_of_args_error("get_parser_prop",args,1);
#line 448 "XMLReader.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("get_parser_prop",1,"int");
prop=Pike_sp[0-1].u.integer;
#line 449 "XMLReader.cmod"
{
  if(THIS->object_data->reader == NULL)
  {
    Pike_error("no xmlReader!\n");
  }

  do { INT_TYPE ret_=(xmlTextReaderGetParserProp(THIS->object_data->reader, prop)); pop_stack(); push_int(ret_); return; }while(0);
#line 456 "XMLReader.cmod"
}

}
/*! @decl int set_parser_prop(int prop, int value)
 *! 
 *! @param prop
 *!   the property to set
 *!
 *! @param value
 *!   the value to set
 */
#define f_XMLReader_set_parser_prop_defined
ptrdiff_t f_XMLReader_set_parser_prop_fun_num = 0;
void f_XMLReader_set_parser_prop(INT32 args) {
#line 466 "XMLReader.cmod"
INT_TYPE prop;
#line 466 "XMLReader.cmod"
INT_TYPE value;
#line 466 "XMLReader.cmod"
if(args != 2) wrong_number_of_args_error("set_parser_prop",args,2);
#line 466 "XMLReader.cmod"
if(Pike_sp[0-2].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("set_parser_prop",1,"int");
prop=Pike_sp[0-2].u.integer;
#line 466 "XMLReader.cmod"
if(Pike_sp[1-2].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("set_parser_prop",2,"int");
value=Pike_sp[1-2].u.integer;
#line 467 "XMLReader.cmod"
{
  if(THIS->object_data->reader == NULL)
  {
    Pike_error("no xmlReader!\n");
  }

  do { INT_TYPE ret_=(xmlTextReaderSetParserProp(THIS->object_data->reader, prop, value)); pop_n_elems(2); push_int(ret_); return; }while(0);
#line 474 "XMLReader.cmod"
}

}
/*! @decl string name()
 *! 
 */
#define f_XMLReader_name_defined
ptrdiff_t f_XMLReader_name_fun_num = 0;
void f_XMLReader_name(INT32 args) {
#line 479 "XMLReader.cmod"
if(args != 0) wrong_number_of_args_error("name",args,0);
{
  xmlChar * c;

  if(THIS->object_data->reader == NULL)
  {
    Pike_error("no xmlReader!\n");
  }

  c = xmlTextReaderName(THIS->object_data->reader);
  if(c != NULL)
  {
    push_text(c);
    xmlFree(c);
  }
  else
    push_int(0);
}

}
/*! @decl string get_attribute(string name)
 *! 
 */
#define f_XMLReader_get_attribute_1_defined
ptrdiff_t f_XMLReader_get_attribute_1_fun_num = 0;
void f_XMLReader_get_attribute_1(INT32 args) {
#line 501 "XMLReader.cmod"
struct pike_string * name;
#line 501 "XMLReader.cmod"
if(args != 1) wrong_number_of_args_error("get_attribute",args,1);
#line 501 "XMLReader.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("get_attribute",1,"string");
#line 501 "XMLReader.cmod"
debug_malloc_pass(name=Pike_sp[0-1].u.string);
{
  xmlChar * c;

  if(THIS->object_data->reader == NULL)
  {
    Pike_error("no xmlReader!\n");
  }

  f_rconvert_string_utf8(1);
  name = Pike_sp[-1].u.string;

  c = xmlTextReaderGetAttribute(THIS->object_data->reader, name->str);
  if(c != NULL)
  {
    push_text(c);
    xmlFree(c);
  }
  else
    push_int(0);
}


}
/*! @decl string get_attribute_no(int no)
 *! 
 */
#define f_XMLReader_get_attribute_no_defined
ptrdiff_t f_XMLReader_get_attribute_no_fun_num = 0;
void f_XMLReader_get_attribute_no(INT32 args) {
#line 527 "XMLReader.cmod"
INT_TYPE no;
#line 527 "XMLReader.cmod"
if(args != 1) wrong_number_of_args_error("get_attribute_no",args,1);
#line 527 "XMLReader.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("get_attribute_no",1,"int");
no=Pike_sp[0-1].u.integer;
#line 528 "XMLReader.cmod"
{
  xmlChar * c;

  if(THIS->object_data->reader == NULL)
  {
    Pike_error("no xmlReader!\n");
  }

  c = xmlTextReaderGetAttributeNo(THIS->object_data->reader, no);
  if(c != NULL)
  {
    push_text(c);
    xmlFree(c);
  }
  else
    push_int(0);
}

}
/*! @decl string get_attribute_ns(string localName, string namespaceURI)
 *! 
 */
#define f_XMLReader_get_attribute_2_defined
ptrdiff_t f_XMLReader_get_attribute_2_fun_num = 0;
void f_XMLReader_get_attribute_2(INT32 args) {
#line 549 "XMLReader.cmod"
struct pike_string * localName;
#line 549 "XMLReader.cmod"
struct pike_string * namespaceURI;
#line 549 "XMLReader.cmod"
if(args != 2) wrong_number_of_args_error("get_attribute",args,2);
#line 549 "XMLReader.cmod"
if(Pike_sp[0-2].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("get_attribute",1,"string");
#line 549 "XMLReader.cmod"
debug_malloc_pass(localName=Pike_sp[0-2].u.string);
#line 549 "XMLReader.cmod"
if(Pike_sp[1-2].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("get_attribute",2,"string");
#line 549 "XMLReader.cmod"
debug_malloc_pass(namespaceURI=Pike_sp[1-2].u.string);
{
  xmlChar * c;

  if(THIS->object_data->reader == NULL)
  {
    Pike_error("no xmlReader!\n");
  }

  f_rconvert_string_utf8(1);
  namespaceURI = Pike_sp[-1].u.string;

  stack_swap_n(2);

  f_rconvert_string_utf8(1);
  localName = Pike_sp[-1].u.string;

  c = xmlTextReaderGetAttributeNs(THIS->object_data->reader, 
         localName->str, namespaceURI->str);
  if(c != NULL)
  {
    push_text(c);
    xmlFree(c);
  }
  else
    push_int(0);
}


}

#if defined(f_XMLReader_get_attribute_1_defined) || defined(f_XMLReader_get_attribute_2_defined)
#define f_XMLReader_get_attribute_defined
ptrdiff_t XMLReader_f_XMLReader_get_attribute_fun_num = 0;
void f_XMLReader_get_attribute(INT32 args) {
  switch(args) {
   case 1:

#ifdef f_XMLReader_get_attribute_1_defined
    f_XMLReader_get_attribute_1(args);
    return;

#endif /* f_XMLReader_get_attribute_1_defined */
    break;
   case 2:

#ifdef f_XMLReader_get_attribute_2_defined
    f_XMLReader_get_attribute_2(args);
    return;

#endif /* f_XMLReader_get_attribute_2_defined */
    break;
   default:
    wrong_number_of_args_error("get_attribute",args,1);
  }
}

#endif /* f_XMLReader_get_attribute_1_defined, f_XMLReader_get_attribute_2_defined */
/*! @decl string lookup_namespace(string|void prefix)
 *! 
 */
#define f_XMLReader_lookup_namespace_1_defined
ptrdiff_t f_XMLReader_lookup_namespace_1_fun_num = 0;
void f_XMLReader_lookup_namespace_1(INT32 args) {
#line 581 "XMLReader.cmod"
struct pike_string * prefix;
#line 581 "XMLReader.cmod"
if(args != 1) wrong_number_of_args_error("lookup_namespace",args,1);
#line 581 "XMLReader.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("lookup_namespace",1,"string");
#line 581 "XMLReader.cmod"
debug_malloc_pass(prefix=Pike_sp[0-1].u.string);
{
  xmlChar * c;

  if(THIS->object_data->reader == NULL)
  {
    Pike_error("no xmlReader!\n");
  }

  f_rconvert_string_utf8(1);
  prefix = Pike_sp[-1].u.string;

  c = xmlTextReaderLookupNamespace(THIS->object_data->reader, prefix->str);
  if(c != NULL)
  {
    push_text(c);
    xmlFree(c);
  }
  else
    push_int(0);
}

}
#define f_XMLReader_lookup_namespace_2_defined
ptrdiff_t f_XMLReader_lookup_namespace_2_fun_num = 0;
void f_XMLReader_lookup_namespace_2(INT32 args) {
#line 603 "XMLReader.cmod"
if(args != 0) wrong_number_of_args_error("lookup_namespace",args,0);
{
  xmlChar * c;

  if(THIS->object_data->reader == NULL)
  {
    Pike_error("no xmlReader!\n");
  }

  c = xmlTextReaderLookupNamespace(THIS->object_data->reader, NULL);
  if(c != NULL)
  {
    push_text(c);
    xmlFree(c);
  }
  else
    push_int(0);
}

}

#if defined(f_XMLReader_lookup_namespace_1_defined) || defined(f_XMLReader_lookup_namespace_2_defined)
#define f_XMLReader_lookup_namespace_defined
ptrdiff_t XMLReader_f_XMLReader_lookup_namespace_fun_num = 0;
void f_XMLReader_lookup_namespace(INT32 args) {
  switch(args) {
   case 0:

#ifdef f_XMLReader_lookup_namespace_2_defined
    f_XMLReader_lookup_namespace_2(args);
    return;

#endif /* f_XMLReader_lookup_namespace_2_defined */
    break;
   case 1:

#ifdef f_XMLReader_lookup_namespace_1_defined
    f_XMLReader_lookup_namespace_1(args);
    return;

#endif /* f_XMLReader_lookup_namespace_1_defined */
    break;
   default:
    wrong_number_of_args_error("lookup_namespace",args,0);
  }
}

#endif /* f_XMLReader_lookup_namespace_1_defined, f_XMLReader_lookup_namespace_2_defined */
/*! @decl string xml_lang()
 *! 
 */
#define f_XMLReader_xml_lang_defined
ptrdiff_t f_XMLReader_xml_lang_fun_num = 0;
void f_XMLReader_xml_lang(INT32 args) {
#line 625 "XMLReader.cmod"
if(args != 0) wrong_number_of_args_error("xml_lang",args,0);
{
  xmlChar * c;

  if(THIS->object_data->reader == NULL)
  {
    Pike_error("no xmlReader!\n");
  }

  c = xmlTextReaderXmlLang(THIS->object_data->reader);
  if(c != NULL)
  {
    push_text(c);
    xmlFree(c);
  }
  else
    push_int(0);
}


}
/*! @decl string prefix()
 *! 
 */
#define f_XMLReader_prefix_defined
ptrdiff_t f_XMLReader_prefix_fun_num = 0;
void f_XMLReader_prefix(INT32 args) {
#line 648 "XMLReader.cmod"
if(args != 0) wrong_number_of_args_error("prefix",args,0);
{
  xmlChar * c;

  if(THIS->object_data->reader == NULL)
  {
    Pike_error("no xmlReader!\n");
  }

  c = xmlTextReaderPrefix(THIS->object_data->reader);
  if(c != NULL)
  {
    push_text(c);
    xmlFree(c);
  }
  else
    push_int(0);
}

}
/*! @decl string namespaceuri()
 *! 
 */
#define f_XMLReader_namespaceuri_defined
ptrdiff_t f_XMLReader_namespaceuri_fun_num = 0;
void f_XMLReader_namespaceuri(INT32 args) {
#line 670 "XMLReader.cmod"
if(args != 0) wrong_number_of_args_error("namespaceuri",args,0);
{
  xmlChar * c;

  if(THIS->object_data->reader == NULL)
  {
    Pike_error("no xmlReader!\n");
  }

  c = xmlTextReaderNamespaceUri(THIS->object_data->reader);
  if(c != NULL)
  {
    push_text(c);
    xmlFree(c);
  }
  else
    push_int(0);
}
}
/*! @decl string baseuri()
 *! 
 */
#define f_XMLReader_baseuri_defined
ptrdiff_t f_XMLReader_baseuri_fun_num = 0;
void f_XMLReader_baseuri(INT32 args) {
#line 691 "XMLReader.cmod"
if(args != 0) wrong_number_of_args_error("baseuri",args,0);
{
  xmlChar * c;

  if(THIS->object_data->reader == NULL)
  {
    Pike_error("no xmlReader!\n");
  }

  c = xmlTextReaderBaseUri(THIS->object_data->reader);
  if(c != NULL)
  {
    push_text(c);
    xmlFree(c);
  }
  else
    push_int(0);
}

}
/*! @decl string localname()
 *! 
 */
#define f_XMLReader_localname_defined
ptrdiff_t f_XMLReader_localname_fun_num = 0;
void f_XMLReader_localname(INT32 args) {
#line 713 "XMLReader.cmod"
if(args != 0) wrong_number_of_args_error("localname",args,0);
{
  xmlChar * c;

  if(THIS->object_data->reader == NULL)
  {
    Pike_error("no xmlReader!\n");
  }

  c = xmlTextReaderLocalName(THIS->object_data->reader);
  if(c != NULL)
  {
    push_text(c);
    xmlFree(c);
  }
  else
    push_int(0);
}

}
/*! @decl string value()
 *! 
 */
#define f_XMLReader_value_defined
ptrdiff_t f_XMLReader_value_fun_num = 0;
void f_XMLReader_value(INT32 args) {
#line 735 "XMLReader.cmod"
if(args != 0) wrong_number_of_args_error("value",args,0);
{
  xmlChar * c;

  if(THIS->object_data->reader == NULL)
  {
    Pike_error("no xmlReader!\n");
  }

  c = xmlTextReaderValue(THIS->object_data->reader);
  if(c != NULL)
  {
    push_text(c);
    xmlFree(c);
  }
  else
    push_int(0);
}

}
/*! @decl string string()
 *! 
 */
#define f_XMLReader_string_defined
ptrdiff_t f_XMLReader_string_fun_num = 0;
void f_XMLReader_string(INT32 args) {
#line 757 "XMLReader.cmod"
if(args != 0) wrong_number_of_args_error("string",args,0);
{
  xmlChar * c;

  if(THIS->object_data->reader == NULL)
  {
    Pike_error("no xmlReader!\n");
  }

  c = xmlTextReaderReadString(THIS->object_data->reader);
  if(c != NULL)
  {
    push_text(c);
    xmlFree(c);
  }
  else
    push_int(0);
}

}
/*! @decl string inner_xml()
 *! 
 */
#define f_XMLReader_inner_xml_defined
ptrdiff_t f_XMLReader_inner_xml_fun_num = 0;
void f_XMLReader_inner_xml(INT32 args) {
#line 779 "XMLReader.cmod"
if(args != 0) wrong_number_of_args_error("inner_xml",args,0);
{
  xmlChar * c;

  if(THIS->object_data->reader == NULL)
  {
    Pike_error("no xmlReader!\n");
  }

  c = xmlTextReaderReadInnerXml(THIS->object_data->reader);
  if(c != NULL)
  {
    push_text(c);
    xmlFree(c);
  }
  else
    push_int(0);
}

}
/*! @decl string outer_xml()
 *! 
 */
#define f_XMLReader_outer_xml_defined
ptrdiff_t f_XMLReader_outer_xml_fun_num = 0;
void f_XMLReader_outer_xml(INT32 args) {
#line 801 "XMLReader.cmod"
if(args != 0) wrong_number_of_args_error("outer_xml",args,0);
{
  xmlChar * c;

  if(THIS->object_data->reader == NULL)
  {
    Pike_error("no xmlReader!\n");
  }

  c = xmlTextReaderReadOuterXml(THIS->object_data->reader);
  if(c != NULL)
  {
    push_text(c);
    xmlFree(c);
  }
  else
    push_int(0);
}

}
/*! @decl void create(string xml, string|void url, int|void options, string encoding)
 *!
 *!  note that xml is expected to be encoded according to the encoding directive in the
 *!  xml file, or as UTF-8. All other strings may be in Pike standard string format.
 */
#define f_XMLReader_create_1_defined
ptrdiff_t f_XMLReader_create_1_fun_num = 0;
void f_XMLReader_create_1(INT32 args) {
#line 825 "XMLReader.cmod"
struct pike_string * xml;
#line 825 "XMLReader.cmod"
struct pike_string * url;
#line 825 "XMLReader.cmod"
INT_TYPE options;
#line 825 "XMLReader.cmod"
struct pike_string * encoding;
#line 825 "XMLReader.cmod"
if(args != 4) wrong_number_of_args_error("create",args,4);
#line 825 "XMLReader.cmod"
if(Pike_sp[0-4].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("create",1,"string");
#line 825 "XMLReader.cmod"
debug_malloc_pass(xml=Pike_sp[0-4].u.string);
#line 825 "XMLReader.cmod"
if(Pike_sp[1-4].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("create",2,"string");
#line 825 "XMLReader.cmod"
debug_malloc_pass(url=Pike_sp[1-4].u.string);
#line 825 "XMLReader.cmod"
if(Pike_sp[2-4].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("create",3,"int");
options=Pike_sp[2-4].u.integer;
#line 825 "XMLReader.cmod"
if(Pike_sp[3-4].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("create",4,"string");
#line 825 "XMLReader.cmod"
debug_malloc_pass(encoding=Pike_sp[3-4].u.string);
{
  xmlTextReaderPtr reader;
/*
  xmlParserCtxtPtr ctxt;
  xmlSAXHandlerPtr sax;
 */

  stack_swap_n(2);
  f_rconvert_string_utf8(1);
  url = Pike_sp[-1].u.string;

  stack_swap_n(4);
  f_rconvert_string_utf8(1);
  encoding = Pike_sp[-1].u.string;

  reader = xmlReaderForMemory(xml->str, xml->len, url->str, 
               encoding->str, options);

  if(reader == NULL)
  {
    Pike_error("unable to get xmlReader\n");
  }
/*
  ctxt = (struct _xmlTextReader)reader->ctxt;
  sax = ctxt->sax;

//->getEntity = my_xml_getent;
*/
  THIS->object_data->reader = reader;

  pop_n_elems(args);
}

}
#define f_XMLReader_create_2_defined
ptrdiff_t f_XMLReader_create_2_fun_num = 0;
void f_XMLReader_create_2(INT32 args) {
#line 859 "XMLReader.cmod"
struct pike_string * xml;
#line 859 "XMLReader.cmod"
struct pike_string * url;
#line 859 "XMLReader.cmod"
INT_TYPE options;
#line 859 "XMLReader.cmod"
if(args != 3) wrong_number_of_args_error("create",args,3);
#line 859 "XMLReader.cmod"
if(Pike_sp[0-3].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("create",1,"string");
#line 859 "XMLReader.cmod"
debug_malloc_pass(xml=Pike_sp[0-3].u.string);
#line 859 "XMLReader.cmod"
if(Pike_sp[1-3].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("create",2,"string");
#line 859 "XMLReader.cmod"
debug_malloc_pass(url=Pike_sp[1-3].u.string);
#line 859 "XMLReader.cmod"
if(Pike_sp[2-3].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("create",3,"int");
options=Pike_sp[2-3].u.integer;
#line 860 "XMLReader.cmod"
{
  xmlTextReaderPtr reader;

  stack_swap_n(2);
  f_rconvert_string_utf8(1);
  url = Pike_sp[-1].u.string; 

  reader = xmlReaderForMemory(xml->str, xml->len, url->str, 
               NULL, options);

  if(reader == NULL)
  {
    Pike_error("unable to get xmlReader\n");
  }

  THIS->object_data->reader = reader;

  pop_n_elems(args);
}

}
#define f_XMLReader_create_3_defined
ptrdiff_t f_XMLReader_create_3_fun_num = 0;
void f_XMLReader_create_3(INT32 args) {
#line 880 "XMLReader.cmod"
struct pike_string * xml;
#line 880 "XMLReader.cmod"
if(args != 1) wrong_number_of_args_error("create",args,1);
#line 880 "XMLReader.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("create",1,"string");
#line 880 "XMLReader.cmod"
debug_malloc_pass(xml=Pike_sp[0-1].u.string);
{
  push_text("noname.xml");
  push_int(0);

  f_XMLReader_create(3);
}

}

#if defined(f_XMLReader_create_1_defined) || defined(f_XMLReader_create_2_defined) || defined(f_XMLReader_create_3_defined)
#define f_XMLReader_create_defined
ptrdiff_t XMLReader_f_XMLReader_create_fun_num = 0;
void f_XMLReader_create(INT32 args) {
  switch(args) {
   case 1:

#ifdef f_XMLReader_create_3_defined
    f_XMLReader_create_3(args);
    return;

#endif /* f_XMLReader_create_3_defined */
    break;
   case 3:

#ifdef f_XMLReader_create_2_defined
    f_XMLReader_create_2(args);
    return;

#endif /* f_XMLReader_create_2_defined */
    break;
   case 4:

#ifdef f_XMLReader_create_1_defined
    f_XMLReader_create_1(args);
    return;

#endif /* f_XMLReader_create_1_defined */
    break;
   default:
    wrong_number_of_args_error("create",args,1);
  }
}

#endif /* f_XMLReader_create_1_defined, f_XMLReader_create_2_defined, f_XMLReader_create_3_defined */

#undef internal_init_XMLReader_defined
#define internal_init_XMLReader_defined

#undef XMLReader_event_handler_defined
#define XMLReader_event_handler_defined
static void init_XMLReader_struct(void)
#line 889 "XMLReader.cmod"
{
  XMLREADER_OBJECT_DATA * dta;

  dta = 
	(XMLREADER_OBJECT_DATA*)malloc(sizeof(XMLREADER_OBJECT_DATA));
    if (!dta)
        Pike_error("init_xmlreader: Out of memory!\n");

    dta->reader = NULL;
    dta->autoencode = 1;
    THIS->object_data = dta;
}


#undef internal_exit_XMLReader_defined
#define internal_exit_XMLReader_defined

#undef XMLReader_event_handler_defined
#define XMLReader_event_handler_defined
static void exit_XMLReader_struct(void)
#line 903 "XMLReader.cmod"
{ 

  if(THIS->object_data->reader != NULL)
  {
    xmlFreeTextReader(THIS->object_data->reader);
    THIS->object_data->reader = NULL;
  }
  if(THIS->object_data)
  {
    free(THIS->object_data);
    THIS->object_data = NULL;
  }
}

#ifdef XMLReader_event_handler_defined
static void XMLReader_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_XMLReader_defined
  case PROG_EVENT_INIT: init_XMLReader_struct(); break;

#endif /* internal_init_XMLReader_defined */

#ifdef internal_exit_XMLReader_defined
  case PROG_EVENT_EXIT: exit_XMLReader_struct(); break;

#endif /* internal_exit_XMLReader_defined */
  default: break; 
  }
}

#endif /* XMLReader_event_handler_defined */
#line 918 "XMLReader.cmod"
#endif /* HAVE_LIBXML_XMLREADER_H */
/*! @endclass
 */


/*! @endmodule
 */

/*! @endmodule
 */

/*! @endmodule
 */


void pike_init_xml2_xmlreader()
{
  
#ifdef class_XMLReader_defined

#ifdef PROG_XMLREADER_ID
#line 79 "XMLReader.cmod"
  START_NEW_PROGRAM_ID(XMLREADER);
#else
#line 79 "XMLReader.cmod"
  start_new_program();

#endif /* PROG_XMLREADER_ID */

#ifndef tObjImpl_XMLREADER

#undef tObjImpl_XMLREADER
#define tObjImpl_XMLREADER tObj

#endif /* tObjImpl_XMLREADER */

#ifdef THIS_XMLREADER
  XMLReader_storage_offset = ADD_STORAGE(struct XMLReader_struct);
#endif /* THIS_XMLREADER */

#ifdef XMLReader_event_handler_defined
  pike_set_prog_event_callback(XMLReader_event_handler);

#endif /* XMLReader_event_handler_defined */

#ifdef f_XMLReader_cq__sprintf_defined
  f_XMLReader_cq__sprintf_fun_num =
#line 85 "XMLReader.cmod"
    ADD_FUNCTION2("_sprintf", f_XMLReader_cq__sprintf, tFunc("\10\200\0\0\0\177\377\377\377" tMix,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_XMLReader_cq__sprintf_defined */

#ifdef f_XMLReader_set_autoencode_defined
  f_XMLReader_set_autoencode_fun_num =
#line 97 "XMLReader.cmod"
    ADD_FUNCTION2("set_autoencode", f_XMLReader_set_autoencode, tFunc("\10\200\0\0\0\177\377\377\377",tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_XMLReader_set_autoencode_defined */

#ifdef f_XMLReader_read_defined
  f_XMLReader_read_fun_num =
#line 110 "XMLReader.cmod"
    ADD_FUNCTION2("read", f_XMLReader_read, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_XMLReader_read_defined */

#ifdef f_XMLReader_node_type_defined
  f_XMLReader_node_type_fun_num =
#line 141 "XMLReader.cmod"
    ADD_FUNCTION2("node_type", f_XMLReader_node_type, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_XMLReader_node_type_defined */

#ifdef f_XMLReader_expand_defined
  f_XMLReader_expand_fun_num =
#line 155 "XMLReader.cmod"
    ADD_FUNCTION2("expand", f_XMLReader_expand, tFunc(tNone,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_XMLReader_expand_defined */

#ifdef f_XMLReader_depth_defined
  f_XMLReader_depth_fun_num =
#line 190 "XMLReader.cmod"
    ADD_FUNCTION2("depth", f_XMLReader_depth, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_XMLReader_depth_defined */

#ifdef f_XMLReader_has_attributes_defined
  f_XMLReader_has_attributes_fun_num =
#line 204 "XMLReader.cmod"
    ADD_FUNCTION2("has_attributes", f_XMLReader_has_attributes, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_XMLReader_has_attributes_defined */

#ifdef f_XMLReader_attribute_count_defined
  f_XMLReader_attribute_count_fun_num =
#line 218 "XMLReader.cmod"
    ADD_FUNCTION2("attribute_count", f_XMLReader_attribute_count, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_XMLReader_attribute_count_defined */

#ifdef f_XMLReader_next_sibling_defined
  f_XMLReader_next_sibling_fun_num =
#line 231 "XMLReader.cmod"
    ADD_FUNCTION2("next_sibling", f_XMLReader_next_sibling, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_XMLReader_next_sibling_defined */

#ifdef f_XMLReader_next_defined
  f_XMLReader_next_fun_num =
#line 244 "XMLReader.cmod"
    ADD_FUNCTION2("next", f_XMLReader_next, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_XMLReader_next_defined */

#ifdef f_XMLReader_element_defined
  f_XMLReader_element_fun_num =
#line 257 "XMLReader.cmod"
    ADD_FUNCTION2("element", f_XMLReader_element, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_XMLReader_element_defined */

#ifdef f_XMLReader_first_attribute_defined
  f_XMLReader_first_attribute_fun_num =
#line 270 "XMLReader.cmod"
    ADD_FUNCTION2("first_attribute", f_XMLReader_first_attribute, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_XMLReader_first_attribute_defined */

#ifdef f_XMLReader_next_attribute_defined
  f_XMLReader_next_attribute_fun_num =
#line 283 "XMLReader.cmod"
    ADD_FUNCTION2("next_attribute", f_XMLReader_next_attribute, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_XMLReader_next_attribute_defined */

#ifdef f_XMLReader_attribute_no_defined
  f_XMLReader_attribute_no_fun_num =
#line 296 "XMLReader.cmod"
    ADD_FUNCTION2("attribute_no", f_XMLReader_attribute_no, tFunc("\10\200\0\0\0\177\377\377\377","\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_XMLReader_attribute_no_defined */

#ifdef f_XMLReader_attribute_ns_defined
  f_XMLReader_attribute_ns_fun_num =
#line 309 "XMLReader.cmod"
    ADD_FUNCTION2("attribute_ns", f_XMLReader_attribute_ns, tFunc(tString tString,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_XMLReader_attribute_ns_defined */

#ifdef f_XMLReader_attribute_defined
  f_XMLReader_attribute_fun_num =
#line 331 "XMLReader.cmod"
    ADD_FUNCTION2("attribute", f_XMLReader_attribute, tFunc(tString,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_XMLReader_attribute_defined */

#ifdef f_XMLReader_has_value_defined
  f_XMLReader_has_value_fun_num =
#line 349 "XMLReader.cmod"
    ADD_FUNCTION2("has_value", f_XMLReader_has_value, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_XMLReader_has_value_defined */

#ifdef f_XMLReader_is_default_defined
  f_XMLReader_is_default_fun_num =
#line 362 "XMLReader.cmod"
    ADD_FUNCTION2("is_default", f_XMLReader_is_default, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_XMLReader_is_default_defined */

#ifdef f_XMLReader_is_namespace_decl_defined
  f_XMLReader_is_namespace_decl_fun_num =
#line 375 "XMLReader.cmod"
    ADD_FUNCTION2("is_namespace_decl", f_XMLReader_is_namespace_decl, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_XMLReader_is_namespace_decl_defined */

#ifdef f_XMLReader_is_empty_element_defined
  f_XMLReader_is_empty_element_fun_num =
#line 388 "XMLReader.cmod"
    ADD_FUNCTION2("is_empty_element", f_XMLReader_is_empty_element, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_XMLReader_is_empty_element_defined */

#ifdef f_XMLReader_is_valid_defined
  f_XMLReader_is_valid_fun_num =
#line 401 "XMLReader.cmod"
    ADD_FUNCTION2("is_valid", f_XMLReader_is_valid, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_XMLReader_is_valid_defined */

#ifdef f_XMLReader_parser_column_number_defined
  f_XMLReader_parser_column_number_fun_num =
#line 414 "XMLReader.cmod"
    ADD_FUNCTION2("parser_column_number", f_XMLReader_parser_column_number, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_XMLReader_parser_column_number_defined */

#ifdef f_XMLReader_parser_line_number_defined
  f_XMLReader_parser_line_number_fun_num =
#line 430 "XMLReader.cmod"
    ADD_FUNCTION2("parser_line_number", f_XMLReader_parser_line_number, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_XMLReader_parser_line_number_defined */

#ifdef f_XMLReader_get_parser_prop_defined
  f_XMLReader_get_parser_prop_fun_num =
#line 448 "XMLReader.cmod"
    ADD_FUNCTION2("get_parser_prop", f_XMLReader_get_parser_prop, tFunc("\10\200\0\0\0\177\377\377\377","\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_XMLReader_get_parser_prop_defined */

#ifdef f_XMLReader_set_parser_prop_defined
  f_XMLReader_set_parser_prop_fun_num =
#line 466 "XMLReader.cmod"
    ADD_FUNCTION2("set_parser_prop", f_XMLReader_set_parser_prop, tFunc("\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377","\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_XMLReader_set_parser_prop_defined */

#ifdef f_XMLReader_name_defined
  f_XMLReader_name_fun_num =
#line 479 "XMLReader.cmod"
    ADD_FUNCTION2("name", f_XMLReader_name, tFunc(tNone,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_XMLReader_name_defined */

#ifdef f_XMLReader_get_attribute_no_defined
  f_XMLReader_get_attribute_no_fun_num =
#line 527 "XMLReader.cmod"
    ADD_FUNCTION2("get_attribute_no", f_XMLReader_get_attribute_no, tFunc("\10\200\0\0\0\177\377\377\377",tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_XMLReader_get_attribute_no_defined */

#ifdef f_XMLReader_get_attribute_defined
  XMLReader_f_XMLReader_get_attribute_fun_num =
#line 549 "XMLReader.cmod"
    ADD_FUNCTION2("get_attribute", f_XMLReader_get_attribute, tOr(tFunc(tString,tString),tFunc(tString tString,tString)), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_XMLReader_get_attribute_defined */

#ifdef f_XMLReader_lookup_namespace_defined
  XMLReader_f_XMLReader_lookup_namespace_fun_num =
#line 603 "XMLReader.cmod"
    ADD_FUNCTION2("lookup_namespace", f_XMLReader_lookup_namespace, tOr(tFunc(tString,tString),tFunc(tNone,tString)), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_XMLReader_lookup_namespace_defined */

#ifdef f_XMLReader_xml_lang_defined
  f_XMLReader_xml_lang_fun_num =
#line 625 "XMLReader.cmod"
    ADD_FUNCTION2("xml_lang", f_XMLReader_xml_lang, tFunc(tNone,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_XMLReader_xml_lang_defined */

#ifdef f_XMLReader_prefix_defined
  f_XMLReader_prefix_fun_num =
#line 648 "XMLReader.cmod"
    ADD_FUNCTION2("prefix", f_XMLReader_prefix, tFunc(tNone,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_XMLReader_prefix_defined */

#ifdef f_XMLReader_namespaceuri_defined
  f_XMLReader_namespaceuri_fun_num =
#line 670 "XMLReader.cmod"
    ADD_FUNCTION2("namespaceuri", f_XMLReader_namespaceuri, tFunc(tNone,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_XMLReader_namespaceuri_defined */

#ifdef f_XMLReader_baseuri_defined
  f_XMLReader_baseuri_fun_num =
#line 691 "XMLReader.cmod"
    ADD_FUNCTION2("baseuri", f_XMLReader_baseuri, tFunc(tNone,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_XMLReader_baseuri_defined */

#ifdef f_XMLReader_localname_defined
  f_XMLReader_localname_fun_num =
#line 713 "XMLReader.cmod"
    ADD_FUNCTION2("localname", f_XMLReader_localname, tFunc(tNone,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_XMLReader_localname_defined */

#ifdef f_XMLReader_value_defined
  f_XMLReader_value_fun_num =
#line 735 "XMLReader.cmod"
    ADD_FUNCTION2("value", f_XMLReader_value, tFunc(tNone,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_XMLReader_value_defined */

#ifdef f_XMLReader_string_defined
  f_XMLReader_string_fun_num =
#line 757 "XMLReader.cmod"
    ADD_FUNCTION2("string", f_XMLReader_string, tFunc(tNone,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_XMLReader_string_defined */

#ifdef f_XMLReader_inner_xml_defined
  f_XMLReader_inner_xml_fun_num =
#line 779 "XMLReader.cmod"
    ADD_FUNCTION2("inner_xml", f_XMLReader_inner_xml, tFunc(tNone,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_XMLReader_inner_xml_defined */

#ifdef f_XMLReader_outer_xml_defined
  f_XMLReader_outer_xml_fun_num =
#line 801 "XMLReader.cmod"
    ADD_FUNCTION2("outer_xml", f_XMLReader_outer_xml, tFunc(tNone,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_XMLReader_outer_xml_defined */

#ifdef f_XMLReader_create_defined
  XMLReader_f_XMLReader_create_fun_num =
#line 880 "XMLReader.cmod"
    ADD_FUNCTION2("create", f_XMLReader_create, tOr3(tFunc(tString tString "\10\200\0\0\0\177\377\377\377" tString,tVoid),tFunc(tString tString "\10\200\0\0\0\177\377\377\377",tVoid),tFunc(tString,tVoid)), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_XMLReader_create_defined */
#line 80 "XMLReader.cmod"
  Pike_compiler->new_program->flags |= PROGRAM_USES_PARENT;
#line 79 "XMLReader.cmod"
  XMLReader_program=end_program();
#line 79 "XMLReader.cmod"
  XMLReader_program_fun_num=add_program_constant("XMLReader",XMLReader_program,0);

#endif /* class_XMLReader_defined */
#line 936 "XMLReader.cmod"
}

void pike_exit_xml2_xmlreader()
{
  
#ifdef class_XMLReader_defined
  if(XMLReader_program) {
#line 79 "XMLReader.cmod"
    free_program(XMLReader_program);
    XMLReader_program=0;
  }

#endif /* class_XMLReader_defined */
#line 941 "XMLReader.cmod"
}

