/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta.plugin;

import de.mud.jta.FilterPlugin;
import de.mud.jta.Plugin;
import de.mud.jta.PluginBus;
import de.mud.jta.PluginConfig;
import de.mud.jta.event.ConfigurationListener;
import de.mud.jta.event.OnlineStatus;
import de.mud.jta.event.SocketListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Socket
extends Plugin
implements FilterPlugin,
SocketListener {
    private static final int debug = 0;
    protected java.net.Socket socket;
    protected InputStream in;
    protected OutputStream out;
    protected String relay = null;
    protected int relayPort = 31415;
    private String error = null;

    public Socket(PluginBus bus, final String id) {
        super(bus, id);
        bus.registerPluginListener(this);
        bus.registerPluginListener(new ConfigurationListener(){

            public void setConfiguration(PluginConfig config) {
                block2: {
                    Socket.this.relay = config.getProperty("Socket", id, "relay");
                    if (Socket.this.relay == null || config.getProperty("Socket", id, "relayPort") == null) break block2;
                    try {
                        Socket.this.relayPort = Integer.parseInt(config.getProperty("Socket", id, "relayPort"));
                    }
                    catch (NumberFormatException e) {
                        Socket.this.error("relayPort is not a number");
                    }
                }
            }
        });
    }

    public void connect(String host, int port) throws IOException {
        if (host == null) {
            return;
        }
        try {
            this.socket = this.relay == null ? new java.net.Socket(host, port) : new java.net.Socket(this.relay, this.relayPort);
            this.in = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
            if (this.relay != null) {
                this.write(("relay " + host + " " + port + "\n").getBytes());
            }
        }
        catch (Exception e) {
            this.error = "Sorry, Could not connect to: " + host + " " + port + "\r\n" + "Reason: " + e + "\r\n\r\n";
            this.error("can't connect: " + e);
        }
        this.bus.broadcast(new OnlineStatus(true));
    }

    public void disconnect() throws IOException {
        this.bus.broadcast(new OnlineStatus(false));
        if (this.socket != null) {
            this.socket.close();
            this.in = null;
            this.out = null;
        }
    }

    public void setFilterSource(FilterPlugin plugin) {
    }

    public FilterPlugin getFilterSource() {
        return null;
    }

    public int read(byte[] b) throws IOException {
        if (this.error != null && this.error.length() > 0) {
            int n = this.error.length() < b.length ? this.error.length() : b.length;
            System.arraycopy(this.error.getBytes(), 0, b, 0, n);
            this.error = this.error.substring(n);
            return n;
        }
        if (this.in == null) {
            this.disconnect();
            return -1;
        }
        int n = this.in.read(b);
        if (n < 0) {
            this.disconnect();
        }
        return n;
    }

    public void write(byte[] b) throws IOException {
        if (this.out == null) {
            return;
        }
        try {
            this.out.write(b);
        }
        catch (IOException e) {
            this.disconnect();
        }
    }
}

