<?php

if (!isset($phpgw_info['flags']['currentapp'])) {
	$phpgw_info['flags']['currentapp']='wcm';
	$phpgw_info['flags']['noheader']=True;
	include("../header.inc.php");
}


##########################################################################
#  File:        comments.php                                             #
#  Description: This file controls the creation, previewing, and editing #
#               of comments posted to an article.                        #
##########################################################################

##########################################################################
#  Function: modone()                                                    #
#  Author:   phpNuke developers                                          #
#  Purpose:  This function is used in conjunction with modtwo/modthree   #
#            to allow for the moderation of comments (ie: scoring, etc). #
##########################################################################


function modone()
{
	include("config.php");
	global $admintest;

	if((($admintest == 1) && ($moderate == 1)) || ($moderate == 2))
	echo "<form action=\"comments.php\" method=\"post\">";
}

##########################################################################
#  Function: modtwo()                                                    #
#  Author:   phpNuke developers                                          #
#  Purpose:  This function is used in conjunction with modone/modthree   #
#            to allow for the moderation of comments (ie: scoring, etc). #
##########################################################################
function modtwo($tid, $score, $reason)
{
	include("config.php");
	global $admintest, $user;
	global $phpgw_info;

	if(((($admintest==1) && ($moderate == 1)) || ($moderate == 2)) && (($user) || ($phpgw_info['user']['account_id'])))
	{
		echo " | <select name=\"dkn$tid\">";

		for($i=0; $i<sizeof($reasons); $i++)
		echo "<option value=\"$score:$i\">$reasons[$i]</option>\n";

		echo "</select>";
	}
}

##########################################################################
#  Function: modthree()                                                  #
#  Author:   phpNuke developers                                          #
#  Purpose:  This function is used in conjunction with modone/modtwo     #
#            to allow for the moderation of comments (ie: scoring, etc). #
##########################################################################
function modthree($sid, $mode, $order, $thold=0)
{
	include("config.php");
	global $admintest, $user;
	global $phpgw_info;

	if(((($admintest==1) && ($moderate == 1)) || ($moderate ==2 )) && (($user) || ($phpgw_info['user']['account_id'])))
	echo "<div align=\"center\"><input type=\"hidden\" name=\"sid\" value=\"$sid\">
	<input type=\"hidden\" name=\"mode\" value=\"$mode\" />
	<input type=\"hidden\" name=\"order\" value=\"$order\" />
	<input type=\"hidden\" name=\"thold\" value=\"$thold\" />
	<input type=\"hidden\" name=\"op\" value=\"moderate\" />
	<input type=\"submit\" value=\"".lang("Moderate")."\" /></div></form>
	";
}

##########################################################################
#  Function: navbar()                                                    #
#  Author:   phpNuke developers                                          #
#  Purpose:  Creates the navigation bar allowing users to sort and       #
#            refresh comments for an article.                            #
##########################################################################
function navbar($sid, $title, $thold, $mode, $order)
{
	global $user;
	global $phpgw;
	global $phpgw_info;

	$phpgw->db->query("select sid FROM wcm_comments where sid=$sid");
//	if(!$query) $count = 0; else $count = $phpgw->db->num_rows();
	$count = $phpgw->db->num_rows();
	if(!isset($thold)) $thold=0;
	
	echo "
<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"2\">
	";

	if($title)
	{
		echo "<tr><td class=\"type6\" align=\"center\">\"$title\" | ";
		if($user || $phpgw_info['user']['account_id'])
		echo "<a href=\"user.php\">".lang("Configure")."</a>";
		else
		echo "<a href=\"user.php\">".lang("Login/Create Account")."</a>";
		echo " | $count ".lang("comments")."</td></tr>";
	}
	
	?>
<tr>
	<td class="type4" align="center">
	<form method="get" action="article.php">
	".lang("Threshold")."<select name="thold">
	<option value="-1" <?PHP if ($thold == -1) { echo "selected=\"selected\" "; } ?>>-1</option>
	<option value="0" <?PHP if ($thold == 0) { echo "selected=\"selected\" "; } ?>>0</option>
	<option value="1" <?PHP if ($thold == 1) { echo "selected=\"selected\" "; } ?>>1</option>
	<option value="2" <?PHP if ($thold == 2) { echo "selected=\"selected\" "; } ?>>2</option>
	<option value="3" <?PHP if ($thold == 3) { echo "selected=\"selected\" "; } ?>>3</option>
	<option value="4" <?PHP if ($thold == 4) { echo "selected=\"selected\" "; } ?>>4</option>
	<option value="5" <?PHP if ($thold == 5) { echo "selected=\"selected\" "; } ?>>5</option>
	</select>

	<select name="mode">
	<option value="nocomments" <?PHP if ($mode == 'nocomments') { echo "selected=\"selected\" "; } ?>>".lang("No Comments")."</option>
	<option value="nested" <?php if($mode == 'nested') echo "selected=\"selected\" "; ?>>".lang("Nested")."</option>
	<option value="flat" <?PHP if ($mode == 'flat') { echo "selected=\"selected\" "; } ?>>".lang("Flat")."</option>
	<option value="threaded" <?PHP if (!isset($mode) || $mode=='threaded' || $mode=="") { echo "selected=\"selected\" "; } ?>>".lang("Threaded")."</option>
	</select>

	<select name="order">
	<option value="0" <?PHP if (!$order) { echo "selected=\"selected\" "; } ?>>".lang("Oldest First")."</option>
	<option value="1" <?PHP if ($order==1) { echo "selected=\"selected\" "; } ?>>".lang("Newest First")."</option>
	<option value="2" <?PHP if ($order==2) { echo "selected=\"selected\" "; } ?>>".lang("Highest Scores First")."</option>
	</select>

	<input type="hidden" name="sid" value="<?PHP echo "$sid"; ?>" />
	<input type="submit" value="<?PHP lang("Refresh") ?>" /></form></td>
</tr>
<tr>
	<td class="type6" align="center">
	<?PHP lang("The comments are owned by the poster. We aren't responsible for its content.") ?>
	</td>
</tr>
</table>
<br /><br />
<?php
}

##########################################################################
#  Function: DisplayKids()                                               #
#  Author:   phpNuke developers                                          #
#  Purpose:  Displays the comments of a topic $tid.                      #
##########################################################################
function DisplayKids ($tid, $mode, $order=0, $thold=0, $level=0, $dummy=0, $tblwidth=99)
{
	global $datetime, $user, $cookie;
	global $phpgw;
	global $phpgw_info;

	include ("config.php");
	$comments = 0;
	if ($user) cookiedecode($user);

	$phpgw->db->query("select tid, pid, sid, date, name, email, url, host_name, subject, comment, score, reason from wcm_comments where pid = $tid order by date, tid");

	if ($mode == 'flat')
	{
		while ($phpgw->db->next_record())
		{
			$r_tid=$phpgw->db->f("tid");
			$r_pid=$phpgw->db->f("pid");
			$r_sid=$phpgw->db->f("sid");
			$r_date=$phpgw->db->f("date");
			$r_name=$phpgw->db->f("name");
			$r_email=$phpgw->db->f("email");
			$r_url=$phpgw->db->f("url");
			$r_host_name=$phpgw->db->f("host_name");
			$r_subject=$phpgw->db->f("subject");
			$r_comment=$phpgw->db->f("comment");
			$r_score=$phpgw->db->f("score");
			$r_reason=$phpgw->db->f("reason");
			if($r_score >= $thold)
			{
				if (!eregi("[a-z0-9]",$r_name)) $r_name = $anonymous;
				if (!eregi("[a-z0-9]",$r_subject)) $r_subject = lang("(No Subject)");
				echo "<a name=\"$r_tid\"></a>
				";
				echo "&nbsp;&nbsp;<table width=\"100%\" border=\"0\" cellspacing=\"0\"><tr><td class=\"type4\">
				";

				formatTimestamp($r_date);

				if ($r_email)
				{
					echo "<span class=\"italic\">$r_subject&nbsp;</span>";
					if(!$cookie[7])
					{
						echo "(".lang("Score:")."&nbsp; $r_score";
						if($r_reason>0) echo ", $reasons[$r_reason]";
						echo ")";
					}
					echo "<br />".lang("by:")." <a href=\"mailto:$r_email\">$r_name</a>($r_email) ".lang("on").": $datetime";
 				}
				else
				{
					echo "<span class=\"italic\">$r_subject</span>&nbsp;";
					if(!$cookie[7])
					{
						echo "(".lang("Score").": $r_score";
						if($r_reason>0) echo ", $reasons[$r_reason]";
						echo ")";
					}
					echo "<br /> ".lang("by").": $r_name ".lang("on").": $datetime";
				}
			
				if ($r_name != $anonymous)
				echo "<br />(<a href=\"user.php?op=userinfo&amp;uname=$r_name\">".lang("User Info")."</a>) ";

				if (eregi("http://",$r_url))
				echo "<a href=\"$r_url\" target=\"window\">$r_url</a> ";

				echo "</td></tr><tr><td class=\"type5\">";

				if(($cookie[10]) && (strlen($r_comment) > $cookie[10]))
				echo substr("$r_comment", 0, $cookie[10])."<br /><br />
	<a href=\"comments.php?sid=$r_sid&amp;tid=$r_tid&amp;mode=$mode&amp;order=$order&amp;thold=$thold\">
	".lang("Read the rest of this comment...")."</a>
				";
				elseif(strlen($r_comment) > $commentlimit)
				echo substr("$r_comment", 0, $commentlimit)."<br /><br />
	<a href=\"comments.php?sid=$r_sid&amp;tid=$r_tid&amp;mode=$mode&amp;order=$order&amp;thold=$thold\">
	".lang("Read the rest of this comment...")."</a>
				";
				else
				echo $r_comment;

				echo "</td></tr></table><br /> [ 
	<a href=\"comments.php?op=Reply&amp;pid=$r_tid&amp;sid=$r_sid&amp;mode=$mode&amp;order=$order&amp;thold=$thold\">
	".lang("Reply")."</a>
				";
				modtwo($r_tid, $r_score, $r_reason);
				echo " ]<br />";
				DisplayKids($r_tid, $mode, $order, $thold);
			}
		}
	}
	else if ($mode == 'nested')
	{
		while ($phpgw->db->next_record())
		{
			$r_tid=$phpgw->db->f("tid");
			$r_pid=$phpgw->db->f("pid");
			$r_sid=$phpgw->db->f("sid");
			$r_date=$phpgw->db->f("date");
			$r_name=$phpgw->db->f("name");
			$r_email=$phpgw->db->f("email");
			$r_url=$phpgw->db->f("url");
			$r_host_name=$phpgw->db->f("host_name");
			$r_subject=$phpgw->db->f("subject");
			$r_comment=$phpgw->db->f("comment");
			$r_score=$phpgw->db->f("score");
			$r_reason=$phpgw->db->f("reason");
			if($r_score >= $thold)
			{
				if (!eregi("[a-z0-9]",$r_name)) $r_name = $anonymous;
				if (!eregi("[a-z0-9]",$r_subject)) $r_subject = lang("(No Subject)");

				echo "<a name=\"$r_tid\"></a>
				&nbsp;&nbsp;<ul>
				<table border=\"0\">
				<tr>
				<td class=\"type4\">\n";

				formatTimestamp($r_date);

				if ($r_email)
				{
					echo "<span class=\"italic\">$r_subject&nbsp;</span>";
					if(!$cookie[7])
					{
						echo "(".lang("Score").":&nbsp; $r_score";
						if($r_reason>0) echo ", $reasons[$r_reason]";
						echo ")";
					}
					echo "<br />".lang("by").": <a href=\"mailto:$r_email\">$r_name</a>($r_email) ".lang("on").": $datetime";
 				}
				else
				{
					echo "<span class=\"italic\">$r_subject</span>&nbsp;";
					if(!$cookie[7])
					{
						echo "(".lang("Score").": $r_score";
						if($r_reason>0) echo ", $reasons[$r_reason]";
						echo ")";
					}
					echo "<br /> ".lang("by").": $r_name ".lang("on").": $datetime";
				}
			
				if ($r_name != $anonymous)
				echo "<br />(<a href=\"user.php?op=userinfo&amp;uname=$r_name\">".lang("User Info")."</a>) ";

				if (eregi("http://",$r_url))
				echo "<a href=\"$r_url\" target=\"window\">$r_url</a> ";

				echo "</td></tr><tr><td class=\"type5\">";

				if(($cookie[10]) && (strlen($r_comment) > $cookie[10]))
				{
					echo substr("$r_comment", 0, $cookie[10])."<br /><br />
					<a href=\"comments.php?sid=$r_sid&amp;tid=$r_tid&amp;mode=$mode&amp;order=$order&amp;thold=$thold\">
					".lang("Read the rest of this comment...")."</a>\n";
				}
				elseif(strlen($r_comment) > $commentlimit)
				{
					echo substr("$r_comment", 0, $commentlimit)."<br /><br />
					<a href=\"comments.php?sid=$r_sid&amp;tid=$r_tid&amp;mode=$mode&amp;order=$order&amp;thold=$thold\">
					".lang("Read the rest of this comment...")."</a>\n";
				}
				else
				echo $r_comment;

				echo "</td></tr></table><br />
				[ <a href=\"comments.php?op=Reply&amp;pid=$r_tid&amp;sid=$r_sid&amp;mode=$mode&amp;order=$order&amp;thold=$thold\">
				".lang("Reply")."</a>\n";
				
				modtwo($r_tid, $r_score, $r_reason);
				echo " ]<br />";
				DisplayKids($r_tid, $mode, $order, $thold);
				echo "</ul>";
			}
		}
	}
	else
	{
		while ($phpgw->db->next_record())
		{
			$r_tid=$phpgw->db->f("tid");
			$r_pid=$phpgw->db->f("pid");
			$r_sid=$phpgw->db->f("sid");
			$r_date=$phpgw->db->f("date");
			$r_name=$phpgw->db->f("name");
			$r_email=$phpgw->db->f("email");
			$r_url=$phpgw->db->f("url");
			$r_host_name=$phpgw->db->f("host_name");
			$r_subject=$phpgw->db->f("subject");
			$r_comment=$phpgw->db->f("comment");
			$r_score=$phpgw->db->f("score");
			$r_reason=$phpgw->db->f("reason");
			if($r_score >= $thold)
			{
				if(isset($level))
				{
					if (!$comments)
					echo "";
				}
				$comments++;
				if (!eregi("[a-z0-9]",$r_name)) $r_name = $anonymous;
				if (!eregi("[a-z0-9]",$r_subject)) $r_subject = lang("(No Subject)");
				formatTimestamp($r_date);

				echo "<span class=\"onebiggerred\">&gt;</span>
	<a href=\"comments.php?op=showreply&amp;tid=$r_tid&amp;sid=$r_sid&amp;pid=$r_pid&amp;mode=$mode&amp;order=$order&amp;thold=$thold#$r_tid\">
	$r_subject</a> ".lang("by").": $r_name ".lang("on").": $datetime<br />
				";

				DisplayKids($r_tid, $mode, $order, $thold, $level+1, $dummy+1);
			} 
		}
	}
	if ($level && $comments)
	echo "&nbsp;&nbsp;";
}

##########################################################################
#  Function: DisplayBabies()                                             #
#  Author:   phpNuke developers                                          #
#  Purpose:  Displays the replys to comments of a topic $tid.            #
##########################################################################
function DisplayBabies($tid, $level=0, $dummy=0)
{
	global $datetime;
	include ("config.php");
	$comments = 0;
	$phpgw->db->query("select tid, pid, sid, date, name, email, url, host_name, subject, comment, score, reason from wcm_comments where pid = $tid order by date, tid");
	while ($phpgw->db->next_record())
	{
		$r_tid=$phpgw->db->f("tid");
		$r_pid=$phpgw->db->f("pid");
		$r_sid=$phpgw->db->f("sid");
		$r_date=$phpgw->db->f("date");
		$r_name=$phpgw->db->f("name");
		$r_email=$phpgw->db->f("email");
		$r_url=$phpgw->db->f("url");
		$r_host_name=$phpgw->db->f("host_name");
		$r_subject=$phpgw->db->f("subject");
		$r_comment=$phpgw->db->f("comment");
		$r_score=$phpgw->db->f("score");
		$r_reason=$phpgw->db->f("reason");
		if(isset($level))
		{
			if (!$comments)
			echo "&nbsp;&nbsp;";
		}
		$comments++;
		
		if (!eregi("[a-z0-9]",$r_name)) { $r_name = $anonymous; }
		if (!eregi("[a-z0-9]",$r_subject)) { $r_subject = lang("(No Subject)"); }

		formatTimestamp($r_date);

		echo "
	<a href=\"comments.php?op=showreply&amp;tid=$r_tid&amp;mode=$mode&amp;order=$order&amp;thold=$thold\">$r_subject</a> 
	".lang("by").": $r_name ".lang("on").": $datetime<br />
		";

		DisplayBabies($r_tid, $level+1, $dummy+1);
	} 
	if($level && $comments)
	echo "&nbsp;&nbsp;";
}

##########################################################################
#  Function: DisplayTopic()                                              #
#  Author:   phpNuke developers                                          #
#  Purpose:  Displays the article selected by the user. It also displays #
#            the comments and replys to those comments indirectly by     #
#            calling DisplayKids().                                      #
##########################################################################
function DisplayTopic($sid, $pid=0, $tid=0, $mode="threaded", $order=0, $thold=0, $level=0, $nokids=0)
{
	global $hr, $user, $datetime, $cookie, $mainfile, $admintest;
	global $phpgw,$phpgw_info;

	$db2=$phpgw->db;
	$db3=$phpgw->db;

	if($mainfile)
	{
		global $title;
		include ("config.php");
	}
	else
	{
		if(!isset($mainfile))
		{
			include("mainfile.php");
		}
		$phpgw->common->phpgw_header();
		include("header.php");
	}
	$count_times = 0;
	if ($user) cookiedecode($user);

	$q = "select tid, pid, sid, date, name, email, url, host_name, subject, comment, score, reason from wcm_comments where sid=$sid and pid=$pid";

	if($thold != "") $q .= " and score>=$thold";
	else $q .= " and score>=0";

	if ($order==1) $q .= " order by date desc";
	if ($order==2) $q .= " order by score desc";

	$db2->query("$q");
	$num_tid = $db2->num_rows();
	navbar($sid, $title, $thold, $mode, $order);
	modone();

	while($count_times < $num_tid)
	{
		$db2->next_record();
		$tid=$db2->f("tid");
		$pid=$db2->f("pid");
		$sid=$db2->f("sid");
		$date=$db2->f("date");
		$name=$db2->f("name");
		$email=$db2->f("email");
		$url=$db2->f("url");
		$host_name=$db2->f("host_name");
		$subject=$db2->f("subject");
		$comment=$db2->f("comment");
		$score=$db2->f("score");
		$reason=$db2->f("reason");

		if ($name == "") $name = $anonymous;
		if ($subject == "") $subject = lang("(No Subject)");

		echo "<a name=\"$tid\"></a>\n<table width=\"100%\" border=\"0\" cellspacing=\"0\"><tr><td class=\"type4\">";

		formatTimestamp($date);

		if ($email)
		{
			echo "<span class=\"italic\">$subject</span>$nbsp;";
			if(!$cookie[7])
			{
				echo "(".lang("Score").": $score";
				if($reason>0) echo ", $reasons[$reason]";
				echo ")";
			}
			echo "<br /> ".lang("by").": <a href=\"mailto:$email\">$name</a> ($email) ".lang("on").": $datetime"; 
		}
		else
		{
			echo "<span class=\"italic\">$subject</span>&nbsp;";
			if(!$cookie[7])
			{
				echo "(".lang("Score")." $score";
				if($reason>0) echo ", $reasons[$reason]";
				echo ")";
			}
			echo "<br /> ".lang("by").": $name ".lang("on").": $datetime";
		}			
		
		
		if ($name != $anonymous) echo "<br />(<a href=\"user.php?op=userinfo&amp;uname=$name\">".lang("User Info")."</a>)";
		if (eregi("http://",$url)) echo "<a href=\"$url\" target=\"window\">$url</a>";
		
		if($admintest)
		{
		    $db3->query("select host_name from wcm_comments where tid='$tid'");
		    $db3->next_record();
		    $host_name=$db3->f("host_name");
		    echo "<br />(IP: $host_name)";
		}
		
		echo "</td></tr><tr><td class=\"type5\">";

		if(($cookie[10]) && (strlen($comment) > $cookie[10]))
		{
			echo substr("$comment", 0, $cookie[10])."<br /><br />
			<a href=\"comments.php?sid=$sid&amp;tid=$tid&amp;mode=$mode&amp;order=$order&amp;thold=$thold\">
			".lang("Read the rest of this comment...")."</a>\n";
		}
		elseif(strlen($comment) > $commentlimit)
		{
			echo substr("$comment", 0, $commentlimit)."<br /><br />
			<a href=\"comments.php?sid=$sid&amp;tid=$tid&amp;mode=$mode&amp;order=$order&amp;thold=$thold\">
			".lang("Read the rest of this comment...")."</a>\n";
		}
		else
		echo $comment;

		echo "</td></tr></table><br />
		[ <a href=\"comments.php?op=Reply&amp;pid=$tid&amp;sid=$sid&amp;mode=$mode&amp;order=$order&amp;thold=$thold\">
		".lang("Reply")."</a>\n";
		
		if ($pid != 0)
		{
			$db3->query("select pid from wcm_comments where tid=$pid");
			$db3->next_record();
			$erin=$db3->f("pid");
			echo "| <a href=\"comments.php?sid=$sid&amp;pid=$erin&amp;mode=$mode&amp;order=$order&amp;thold=$thold\">".lang("Parent")."</a>";
		}
		modtwo($tid, $score, $reason);
		
		if($admintest)
		echo " | <a href=\"admin.php?op=RemoveComment&amp;tid=$tid&amp;sid=$sid\">".lang("Delete")."</a> ]<br />";
		else
		echo " ]<br />";
	
		DisplayKids($tid, $mode, $order, $thold, $level);

		echo "<br />";
		if($hr) echo "&nbsp;&nbsp;";
		$count_times += 1;
	}
	modthree($sid, $mode, $order, $thold);
	if($pid==0)
	return array($sid, $pid, $subject);
	else
	include("footer.php");
	echo "Finish DisplayTopics()<br>\n";
}

##########################################################################
#  Function: singlecomment()                                             #
#  Author:   phpNuke developers                                          #
#  Purpose:  This function's purpose has yet to be determined.           #
##########################################################################
function singlecomment($tid, $sid, $mode, $order, $thold)
{
	global $phpgw,$phpgw_info;
	if(!isset($mainfile))
	{
		include("mainfile.php");
	}

	$phpgw->common->phpgw_header();
	include("header.php");
	global $user, $cookie, $datetime;

	$phpgw->db->query("select date, name, email, url, subject, comment, score, reason from wcm_comments where tid=$tid and sid=$sid");
	$phpgw->db->next_record();
	$tid=$phpgw->db->f("tid");
	$pid=$phpgw->db->f("pid");
	$sid=$phpgw->db->f("sid");
	$date=$phpgw->db->f("date");
	$name=$phpgw->db->f("name");
	$email=$phpgw->db->f("email");
	$url=$phpgw->db->f("url");
	$host_name=$phpgw->db->f("host_name");
	$subject=$phpgw->db->f("subject");
	$comment=$phpgw->db->f("comment");
	$score=$phpgw->db->f("score");
	$reason=$phpgw->db->f("reason");

	$titlebar = "<span class=\"italic\">$subject</span>&nbsp;\n";

	if($name == "") $name = $anonymous;
	if($subject == "") $subject = lang("(No Subject)");

	modone();

	echo "<table width=\"99%\" border=\"0\"><tr><td class=\"type4\" width=\"500\">\n";

	formatTimestamp($date);

	if($email)
	echo "<span class=\"italic\">$subject</span><br />(".lang("Score").": $score)<br />
	".lang("by").":<a href=\"mailto:$email\">$name</a>($email)".lang("on").": $datetime\n";
	else
	echo "<span class=\"italic\">$subject</span><br />(".lang("Score").": $score)<br />
	".lang("by").": $name ".lang("on").": $datetime\n";

	echo "</td></tr><tr><td class=\"type3\">$comment</td></tr></table><br />
	[ <a href=\"comments.php?op=Reply&amp;pid=$tid&amp;sid=$sid&amp;mode=$mode&amp;order=$order&amp;thold=$thold\">
	".lang("Reply")."</a> | <a href=\"article.php?sid=$sid&amp;mode=$mode&amp;order=$order&amp;thold=$thold\">
	".lang("Root")."</a>
	";

	modtwo($tid, $score, $reason);
	echo " ]";
	modthree($sid, $mode, $order, $thold);

	include("footer.php");
}

##########################################################################
#  Function: reply()                                                     #
#  Author:   phpNuke developers                                          #
#            Edited by: Adam Morton, am26882@appstate.edu                #
#  Purpose:  This function gets the info from the user or admin who is   #
#            replying to an article and posts it to the database.        #
##########################################################################
function reply($pid, $sid, $mode, $order, $thold)
{
	global $phpgw,$phpgw_info;
	$phpgw->common->phpgw_header();
	include("header.php");
	global $user, $cookie, $datetime;

	if($pid != 0) {
		$phpgw->db->query("select date, name, email, url, subject, comment, score from wcm_comments where tid=$pid");
		$phpgw->db->next_record();
		$date=$phpgw->db->f("date");
		$name=$phpgw->db->f("name");
		$email=$phpgw->db->f("email");
		$url=$phpgw->db->f("url");
		$subject=$phpgw->db->f("subject");
		$comment=$phpgw->db->f("comment");
		$score=$phpgw->db->f("score");
	} else {
		$phpgw->db->query("select time, title, hometext, bodytext, informant, notes FROM wcm_stories where sid=$sid");
		$phpgw->db->next_record();
		$time=$phpgw->db->f("time");
		$title=$phpgw->db->f("title");
		$hometext=$phpgw->db->f("hometext");
		$bodytext=$phpgw->db->f("bodytext");
		$informant=$phpgw->db->f("informant");
		$notes=$phpgw->db->f("notes");
	}

	if($comment == "") $comment = $temp_comment;
	$titlebar = "$subject";
	if($name == "") $name = $anonymous;
	if($subject == "") $subject = lang("(No Subject)");

	echo "<table width=\"100%\" border=\"0\" cellspacing=\"0\">
<tr>
	<td class=\"type4\" width=\"100%\">
	";
	formatTimestamp($date);

	if($email)
	{
		echo "<span class=\"italic\">$subject</span>&nbsp;";
		if(!$temp_comment) echo"(".lang("Score").": $score)";
		echo "<br /> ".lang("by").": <a href=\"mailto:$email\">$name</a> ($email) ".lang("on").": $datetime";
	}else
	{
		echo "<span class=\"italic\">$subject</span>&nbsp;";
		if(!$temp_comment) echo"(".lang("Score").": $score)";
		echo "<br /> ".lang("by").": $name ".lang("on").": $datetime";
	}
	echo "</td></tr><tr><td class=\"type5\">$comment $notes</td></tr></table>&nbsp;";

	if(!isset($pid) || !isset($sid))
	{
		echo lang("Something is not right. This message is just to keep things from messing up down the road.");
		exit();
	}

	if($pid == 0) {
		$phpgw->db->query("select title from wcm_stories where sid=$sid");
		$phpgw->db->next_record();
		$subject=$phpgw->db->f("title");
	} else {
		$phpgw->db->query("select subject from wcm_comments where tid=$pid");
		$phpgw->db->next_record();
		$subject=$phpgw->db->f("subject");
	}

	echo "<form action=\"comments.php\" method=\"post\">";
	echo lang("Your Name: ");

	if ($user)
	{
		cookiedecode($user);
		echo "<a href=\"user.php\">$cookie[1]</a> [ <a href=\"user.php?op=logout\">".lang("Logout")."</a> ]";
	}
	elseif($phpgw_info['user']['account_id'])
		echo $phpgw_info['user']['firstname'].' '.$phpgw_info['user']['lastname'];
	else echo "$anonymous"; $postanon=2;

	echo "<br /><br />".lang("Subject:");

	if (!eregi("Re:",$subject)) $subject = "Re: $subject";

	echo "<br />
	<input type=\"text\" name=\"subject\" size=\"55\" maxlength=\"60\" value=\"$subject\" /><br /><br />
	".lang("Comment").":<br />
	<textarea cols=\"50\" rows=\"10\" name=\"comment\" wrap=\"soft\"></textarea><br />
	".lang("Allowed HTML").":<br />
	";

	while (list($key,)= each($AllowableHTML)) echo " &lt;".$key."&gt;";

	echo "<br /><br />";

	if ($user || $phpgw_info['user']['account_id'])
	echo "<input type=\"checkbox\" name=\"postanon\" />".lang("Post Anonymously")."<br /><br />";

	echo "
	<input type=\"hidden\" name=\"pid\" value=\"$pid\" />
	<input type=\"hidden\" name=\"sid\" value=\"$sid\" />
	<input type=\"hidden\" name=\"mode\" value=\"$mode\" />
	<input type=\"hidden\" name=\"order\" value=\"$order\" />
	<input type=\"hidden\" name=\"thold\" value=\"$thold\" />
	<input type=\"submit\" name=\"op\" value=\"".lang("Preview")."\" />&nbsp;
	<input type=\"submit\" name=\"op\" value=\"".lang("Ok!")."\" />
	<select name=\"posttype\">
	<option value=\"exttrans\">".lang("Extrans (html tags to text)")."</option>
	<option value=\"html\">".lang("HTML Formatted")."</option>
	<option value=\"plaintext\" selected=\"selected\">".lang("Plain Old Text")."</option>
	</select>
	</form><br />
	";
		
	include("footer.php");
}

##########################################################################
#  Function: replyPreview()                                              #
#  Author:   phpNuke developers                                          #
#            Edited by Adam Morton, am26882@appstate.edu                 #
#  Purpose:  Lets the user preview his/her comment before posting and    #
#            make changes if needed.                                     #
##########################################################################
function replyPreview($pid, $sid, $subject, $comment, $postanon, $mode, $order, $thold, $posttype)
{
	global $phpgw,$phpgw_info;
	if(!isset($mainfile))
	{
		include("mainfile.php");
	}

	$phpgw->common->phpgw_header();
	include("header.php");
	global $user, $cookie;
	if ($user) cookiedecode($user);
	$subject = stripslashes($subject);
	$comment = stripslashes($comment);

	if (!isset($pid) || !isset($sid))
	{
		echo lang("Something is not right with passing a variable to this function. This message is just to keep things from messing up down the road");
		exit();
	}

	echo "
<table width=\"100%\" border=\"0\" cellspacing=\"0\">
<tr>
	<td class=\"type4\">
	<span class=\"italic\">$subject</span><br />
	".lang("by").": ";
	
	if ($user)
	echo "$cookie[1]";
	else if ($phpgw_info['user']['account_id'])
	echo $phpgw_info['user']['firstname'].' '.$phpgw_info['user']['lastname'];
	else
	echo "$anonymous";

	echo lang("on").": </td>
</tr>
<tr>
	<td class=\"type5\">";

	if($posttype=="exttrans") echo ereg_replace("\n", "<br />", htmlspecialchars($comment));
	elseif($posttype=="plaintext") echo ereg_replace("\n", "<br />", $comment);
	else echo $comment;

	echo "
</td></tr></table>
<form action=\"comments.php\" method=\"post\"><br />".lang("Your Name").": ";

	if ($user) echo "<a href=\"user.php\">$cookie[1]</a> [ <a href=\"user.php?op=logout\">".lang("Logout")."</a> ]";
	elseif ($phpgw_info['user']['account_id']) 
		echo $phpgw_info['user']['firstname'].' '.$phpgw_info['user']['lastname'];
	else
		echo "$anonymous";

	echo "<br />
	".lang("Subject").":<input type=\"text\" name=\"subject\" size=\"50\" maxlength=\"60\" value=\"$subject\" /><br />
	".lang("Comment").":<br /><textarea cols=\"50\" rows=\"10\" name=\"comment\" wrap=\"soft\">$comment</textarea><br />
	".lang("Allowed HTML").":<br />";

	while (list($key,)= each($AllowableHTML)) echo " &lt;".$key."&gt;";

	echo "<br />";

	if ($postanon)
	echo "<br />
	<input type=\"checkbox\" name=\"postanon\" checked=\"checked\" />
	".lang("Post Anonymously")."<br /><br />
	";
	elseif($user || $phpgw_info['user']['account_id'])
	echo "<input type=\"checkbox\" name=\"postanon\" /><".lang("Post Anonymously")."<br />";

	echo "
	<input type=\"hidden\" name=\"pid\" value=\"$pid\" />
	<input type=\"hidden\" name=\"sid\" value=\"$sid\" />
	<input type=\"hidden\" name=\"mode\" value=\"$mode\" />
	<input type=\"hidden\" name=\"order\" value=\"$order\" />
	<input type=\"hidden\" name=\"thold\" value=\"$thold\" />
	<input type=\"submit\" name=\"op\" value=\"".lang("Preview")."\" />&nbsp;
	<input type=\"submit\" name=\"op\" value=\"".lang("Ok!")."\" />
	<select name=\"posttype\"><option value=\"exttrans\"";

	if($posttype=="exttrans") echo" selected=\"selected\" ";
	echo  ">".lang("Extrans (html tags to text)")."</option><option value=\"html\"";;
	if($posttype=="html") echo" selected=\"selected\"";
	echo ">".lang("HTML Formatted")."</option><option value=\"plaintext\"";
	if(($posttype!="exttrans") && ($posttype!="html")) echo" selected=\"selected\"";
	echo ">".lang("Plain Old Text")."</option></select></form><br />";

	include("footer.php");
}

##########################################################################
#  Function: CreateTopic()                                               #
#  Author:   phpNuke developers                                          #
#            Edited by Adam Morton, am26882@appstate.edu                 #
#  Purpose:  Posts a new comment into the database then returns the user #
#            to the article he/she just posted to.                       #
##########################################################################
function CreateTopic ($postanon, $subject, $comment, $pid, $sid, $host_name, $mode, $order, $thold, $posttype)
{
	global $phpgw;
	global $phpgw_info;
	if(!isset($mainfile))
	{
		include("mainfile.php");
	}

	global $user, $userinfo, $EditedMessage, $cookie;
	$author = FixQuotes($author);
	$subject = FixQuotes(filter_text($subject, "nohtml"));

	if($posttype=="exttrans")
	$comment = FixQuotes(ereg_replace("\n", "<br />", htmlspecialchars(check_words($comment))));
	elseif($posttype=="plaintext")
	$comment = FixQuotes(ereg_replace("\n", "<br />", filter_text($comment)));
	else
	$comment = FixQuotes(filter_text($comment));

	if($user) getusrinfo($user);
	if (($user) && (!$postanon))
	{
		getusrinfo($user);
		$name = $userinfo[uname];
		$email = $userinfo[femail];
		$url = $userinfo[url];
		$score = 1;
	}
	else if (($phpgw_info['user']['account_id']) && (!$postanon))
	{
		$name = $phpgw_info['user']['firstname'].' '.$phpgw_info['user']['lastname'];
//		$email = $userinfo[femail];
		$score = 1;
	}
	else
	{
		$name = ""; $email = ""; $url = "";
		$score = 0;
	}

	$ip = getenv("REMOTE_ADDR");

	//begin fake thread control
	$phpgw->db->query("select count(*) AS COUNT from wcm_stories where sid=$sid");
	$phpgw->db->next_record();
	$fake=$phpgw->db->f("COUNT");

//	$phpgw->db->query("LOCK TABLES comments WRITE");

	//begin duplicate control
	$phpgw->db->query("select count(*) AS COUNT from wcm_comments where pid='$pid' and sid='$sid' and subject='$subject' and comment='$comment'");
	$phpgw->db->next_record();
	$tia=$phpgw->db->f("COUNT");

	//begin troll control
	if($user) {
		$phpgw->db->query("select count(*) AS COUNT from wcm_comments where (score=-1) and (name='$userinfo[uname]') and (to_days(now()) - to_days(date) < 3)");
		$phpgw->db->next_record();
		$troll=$phpgw->db->f("COUNT");
	} elseif ($phpgw_info['user']['account_id']) {
		$name=$phpgw_info['user']['firstname'].' '.$phpgw_info['user']['lastname'];
		$phpgw->db->query("select count(*) AS COUNT from wcm_comments where (score=-1) and (name='$name') and (to_days(now()) - to_days(date) < 3)");
		$phpgw->db->next_record();
		$troll=$phpgw->db->f("COUNT");

	}
	elseif(!$score) {
		$phpgw->db->query("select count(*)  AS COUNT from wcm_comments where (score=-1) and (host_name='$ip') and (to_days(now()) - to_days(date) < 3)");
		$phpgw->db->next_record();
		$troll=$phpgw->db->f("COUNT");
	}

	if((!$tia) && ($fake == 1) && ($troll < 6))
	$phpgw->db->query("insert into wcm_comments values (NULL, '$pid', '$sid', now(), '$name', '$email', '$url', '$ip', '$subject', '$comment', '$score', '0')");
	else
	{
//		$phpgw->db->query("UNLOCK TABLES");
		$phpgw->common->phpgw_header();
		include("header.php");

		if($tia)
		echo lang("Duplicate. Did you submit twice?")."<br /><br />
		<a href=\"article.php?sid=$sid&mode=$mode&order=$order&thold=$thold\">".lang("Back to comments")."</a>
		";
		elseif($troll > 5) echo lang("This account or IP has been temporarily disabled.")."
		<br /><br /><a href=\"article.php?sid=$sid&mode=$mode&order=$order&thold=$thold\">".lang("Back to comments")."</a>
		";
		elseif($fake == 0) echo lang("The topic you are trying to reply to does not exist.");
		include("footer.php");
		exit;
	}
//	$phpgw->db->query("UNLOCK TABLES");
	$phpgw->db->query("update wcm_stories set comments=comments+1 where sid='$sid'");
	$phpgw->redirect($phpgw->link('/wcm/article.php',"sid=$sid&mode=$mode&order=$order&thold=$thold"));
}

##########################################################################
#  Function: check_num_comments()                                        #
#  Author:   Adam Morton, am26882@appstate.edu                           #
#  Purpose:  This is basically advanced "troll" control. It checks how   #
#            many posts were submitted by a certain IP address and will  #
#            not allow a certain IP to post more than $max_user_comments #
#            to a particular article. $max_user_comments can be set by   #
#            the system admin in the config.php file.                    #
##########################################################################
function check_num_comments($sid)
{
	global $phpgw;
	include("config.php");
	global $admintest;

	if(!isset($mainfile))
	{
		include("mainfile.php");
	}

	if($admintest==1)
		return;

	$ip = getenv("REMOTE_ADDR");
	$phpgw->db->query("select * from wcm_comments where sid='$sid' and host_name='$ip'");
	$num_rows = $phpgw->db->num_rows();
	
	if($num_rows+1 > $max_user_comments)
	comment_error();
}

##########################################################################
#  Function: comment_error()                                             #
#  Author:   Adam Morton, am26882@appstate.edu                           #
#  Purpose:  If a user has posted more than the allowed number of times  #
#            to a particular article he/she is given this error.         #
##########################################################################
function comment_error()
{
	global $phpgw,$phpgw_info;
	$phpgw->common->phpgw_header();
	include ("header.php");

	echo "
<table border=\"0\" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\">
<tr>
	<td class=\"type0\">
<table border=\"0\" width=\"100%\" cellpadding=\"5\" cellspacing=\"1\">
<tr>
	<td class=\"type4bigger\"><font color=\"red\">".lang("Error!!")."</font></td>
</tr>
        ";

	echo "
	<tr>
        <td class=\"type5\" align=\"center\"><b>".lang("The following error has occured:")."</b><br /><br />
	".lang("You have exceeded your maximum number of posts for this article").".
	".lang("If you have any questions please contact the administrator of this site at the following address").":
	<br /><br /><a href=\"mailto:$adminmail?subject=".lang("Max comments exceeded")."\">$adminmail</a>
        </td>
</tr>
</table>
</td></tr></table>
        ";

	include("footer.php");
	exit();
}

##########################################################################
#  Function: The SWITCH (not REALLY a function)                          #
#  Author:   phpNuke developers                                          #
#            Edited by: Adam Morton, am26882@appstate.edu                #
#  Purpose:  This switch statement takes the arguement $op passed to the #
#            comments page and decides which functions to call based on  #
#            that variable.                                              #
##########################################################################
global $phpgw;
switch($op)
{
	case "Reply":
	check_num_comments($sid);
	reply($pid, $sid, $mode, $order, $thold);
	break;

	case lang("Preview"):
	replyPreview ($pid, $sid, $subject, $comment, $postanon, $mode, $order, $thold, $posttype);
	break;

	case lang("Ok!"):
	CreateTopic($postanon, $subject, $comment, $pid, $sid, $host_name, $mode, $order, $thold, $posttype);
	break;

	case "moderate":
	if($admintest==1)
	include("auth.inc.php");
	else
	if(!isset($mainfile))
	{
		include("mainfile.php");
	}
		
	if(($admintest) || ($moderate==2))
	{
		while(list($tdw, $emp) = each($HTTP_POST_VARS))
		{
			if (eregi("dkn",$tdw))
			{
				$emp = explode(":", $emp);
				if($emp[1] != 0)
				{
					$tdw = ereg_replace("dkn", "", $tdw);
					$q = "UPDATE wcm_comments SET";

					if(($emp[1] == 9) && ($emp[0]>=0))         #Overrated
					 $q .= " score=score-1 where tid=$tdw";
					elseif(($emp[1] == 10) && ($emp[0]<=4))    #Underrated
					 $q .= " score=score+1 where tid=$tdw";
					elseif(($emp[1] > 4) && ($emp[0]<=4))
					 $q .= " score=score+1, reason=$emp[1] where tid=$tdw";
					elseif (($emp[1] < 5) && ($emp[0] > -1))
					 $q .= " score=score-1, reason=$emp[1] where tid=$tdw";
					elseif (($emp[0] == -1) || ($emp[0] == 5))
					 $q .= " reason=$emp[1] where tid=$tdw";

					if(strlen($q) > 20) $phpgw->db->query("$q");
				}
			}
		}
	}
	$phpgw->redirect($phpgw->link('/wcm/article.php',"sid=$sid&mode=$mode&order=$order&thold=$thold"));
	break;

	case "showreply":
	DisplayTopic($sid, $pid, $tid, $mode, $order, $thold);
	break;

	default:
	if((isset($tid)) && (!isset($pid))) {
		singlecomment($tid, $sid, $mode, $order, $thold);
	}
	elseif(($mainfile) xor (($pid==0) || (!isset($pid)))) {
		$phpgw->redirect($phpgw->link('/wcm/article.php',"sid=$sid&mode=$mode&order=$order&thold=$thold"));
	}
	else
	{
		if(!isset($pid)) $pid=0;
		DisplayTopic($sid, $pid, $tid, $mode, $order, $thold);
	}
	break;
}

?>
