<?php
	/*******************************************************************\
	* phpGroupWare - Netsaint                                           *
	* http://www.phpgroupware.org                                       *
	*                                                                   *
	* Administration Tool for NetSaint Network Monitor                  *
	* http://www.netsaint.org                                           *
	* Ethan A. Galstad <netsaint@linuxbox.com>                          *
	*                                                                   *
	* Written by Bettina Gille [ceb@phpgroupware.org]                   *
	* -----------------------------------------------                   *
	* Copyright (C) 2001 Bettina Gille                                  *
	*                                                                   *
	* This program is free software; you can redistribute it and/or     *
	* modify it under the terms of the GNU General Public License as    *
	* published by the Free Software Foundation; either version 2 of    *
	* the License, or (at your option) any later version.               *
	*                                                                   *
	* This program is distributed in the hope that it will be useful,   *
	* but WITHOUT ANY WARRANTY; without even the implied warranty of    *
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU  *
	* General Public License for more details.                          *
	*                                                                   *
	* You should have received a copy of the GNU General Public License *
	* along with this program; if not, write to the Free Software       *
	* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.         *
	\*******************************************************************/
	/* $Id: class.uinshost.inc.php,v 1.32 2001/09/06 22:56:15 bettina Exp $ */

	class uinshost
	{
		var $grants;
		var $action;
		var $cat_id;
		var $start;
		var $order;
		var $sort;
		var $filter;

		var $public_functions = array
		(
			'prefs_host'	=> True,
			'add_host'		=> True,
			'edit_host'		=> True,
			'delete_host'	=> True,
			'view_host'		=> True,
			'prefs_hg'		=> True,
			'add_hg'		=> True,
			'edit_hg'		=> True,
			'view_hg'		=> True
		);

		function uinshost()
		{
			global $phpgw, $phpgw_info, $action;

			$this->account					= $phpgw_info['user']['account_id'];
			$this->t						= $phpgw->template;
			$this->cats						= CreateObject('phpgwapi.categories');
			$this->nextmatchs				= CreateObject('phpgwapi.nextmatchs');
			$this->grants					= $phpgw->acl->get_grants('netsaint');
			$this->grants[$this->account]	= PHPGW_ACL_READ + PHPGW_ACL_ADD + PHPGW_ACL_EDIT + PHPGW_ACL_DELETE;
			$this->bonshost					= CreateObject('netsaint.bonshost',True,$action);
			$this->bonscontact				= CreateObject('netsaint.bonscontact');
			$this->botimeperiod				= CreateObject('netsaint.botimeperiod');
			$this->bonetsaint				= CreateObject('netsaint.bonetsaint');

			$this->start					= $this->bonshost->start;
			$this->query					= $this->bonshost->query;
			$this->filter					= $this->bonshost->filter;
			$this->sort						= $this->bonshost->sort;
			$this->order					= $this->bonshost->order;
			$this->cat_id					= $this->bonshost->cat_id;
		}

		function save_sessiondata($action)
		{
			$data = array
			(
				'start'		=> $this->start,
				'query'		=> $this->query,
				'filter'	=> $this->filter,
				'sort'		=> $this->sort,
				'order'		=> $this->order,
				'cat_id'	=> $this->cat_id
			);
			$this->bonshost->save_sessiondata($data, $action);
		}

		function set_app_langs()
		{
			global $phpgw, $phpgw_info, $tr_color;

			$this->t->set_var('bg_color',$phpgw_info['theme']['th_bg']);
			$this->t->set_var('row_on',$phpgw_info['theme']['row_on']);
			$this->t->set_var('row_off',$phpgw_info['theme']['row_off']);
			$this->t->set_var('lang_netsaint',lang('Netsaint'));
			$this->t->set_var('lang_prefs',lang('Preferences'));
			$this->t->set_var('lang_timeperiods',lang('Time Periods'));
			$this->t->set_var('lang_hosts',lang('Hosts'));
			$this->t->set_var('lang_host_groups',lang('Host groups'));
			$this->t->set_var('lang_contacts',lang('Contacts'));
			$this->t->set_var('lang_contact_groups',lang('Contact groups'));
			$this->t->set_var('lang_services',lang('Services'));
			$this->t->set_var('lang_notifications',lang('Notifications'));
			$this->t->set_var('lang_s_escalation',lang('Service escalation'));
			$this->t->set_var('lang_hg_escalation',lang('Host group escalation'));
			$this->t->set_var('lang_escalations',lang('Escalations'));

			$this->t->set_var('lang_done',lang('Done'));
			$this->t->set_var('lang_view',lang('View'));
			$this->t->set_var('lang_edit',lang('Edit'));
			$this->t->set_var('lang_save',lang('Save'));
			$this->t->set_var('lang_delete',lang('Delete'));

			$this->t->set_var('lang_period',lang('Time period'));
			$this->t->set_var('lang_address',lang('Address'));
			$this->t->set_var('lang_parent',lang('Parent hosts'));
			$this->t->set_var('lang_hcheck_comand',lang('Host check command'));
			$this->t->set_var('lang_name',lang('Short name'));
			$this->t->set_var('lang_alias',lang('Description'));
			$this->t->set_var('lang_cat',lang('Category'));
			$this->t->set_var('lang_private',lang('Private'));

			$this->t->set_var('lang_access',lang('Access'));
			$this->t->set_var('lang_min',lang('Minutes'));
			$this->t->set_var('lang_max',lang('Maximal attempts'));
			$this->t->set_var('lang_intval',lang('Notification interval'));
			$this->t->set_var('lang_recover',lang('Notify contacts when host recovers ?'));
			$this->t->set_var('lang_down',lang('Notify contacts when host is down ?'));
			$this->t->set_var('lang_unreach',lang('Notify contacts when host is unreachable ?'));
			$this->t->set_var('lang_handler',lang('Event'));

			$this->t->set_var('lang_created',lang('Created by'));
			$this->t->set_var('lang_modified',lang('last modified'));
			$this->t->set_var('lang_none',lang('None'));
			$this->t->set_var('lang_all',lang('All'));
		}

		function display_prefs_header()
		{
			global $phpgw, $phpgw_info, $Update;

			$this->t->set_file(array('prefs' => 'prefs_header.tpl'));
            $this->t->set_block('prefs','header');

			if ($Update)
			{
				$msg = $this->bonetsaint->check_config();

				if (is_array($msg))
				{
					$this->t->set_var('message',$phpgw->common->error_list($msg));
				}
				else
				{
					$this->bonetsaint->create_config();
					$this->t->set_var('message',lang('Netsaint configuration files have been created successfully !'));
					$this->bonetsaint->set_config_status('off');
				}
			}

			$this->set_app_langs();

			$this->t->set_var('link_time',$phpgw->link('/index.php','menuaction=netsaint.uitimeperiod.prefs_time'));
			$this->t->set_var('link_host',$phpgw->link('/index.php','menuaction=netsaint.uinshost.prefs_host&action=host'));
			$this->t->set_var('link_host_group',$phpgw->link('/index.php','menuaction=netsaint.uinshost.prefs_hg&action=hg'));
			$this->t->set_var('link_contact',$phpgw->link('/index.php','menuaction=netsaint.uinscontact.prefs_contact&action=contact'));
			$this->t->set_var('link_contact_group',$phpgw->link('/index.php','menuaction=netsaint.uinscontact.prefs_cg&action=cg'));
			$this->t->set_var('link_service',$phpgw->link('/index.php','menuaction=netsaint.uinetsaint.prefs_service&action=service'));
			$this->t->set_var('link_escalation',$phpgw->link('/index.php','menuaction=netsaint.uinetsaint.prefs_escal&action=host'));

			$update_config = $this->bonetsaint->check_config_status();

			if ($update_config == True)
			{
				$this->t->set_var('update','<form method="POST"><input type="submit" name="Update" value="' . lang('Update') . '"></form>');
			}
			else
			{
				$this->t->set_var('update','');
			}

			$this->t->fp('prefs','header');

			$phpgw->common->phpgw_header();
			echo parse_navbar();
		}

		function prefs_host()
		{
			global $phpgw, $phpgw_info, $action;

			$this->display_prefs_header();

			$this->t->set_file(array('filter' => 'filter.tpl',
									'host_list_t' => 'prefs_host.tpl'));
			$this->t->set_block('host_list_t','host_list','list');

			$link_data = array
			(
				'menuaction'	=> 'netsaint.uinshost.prefs_host',
				'action'		=> 'host'
			);

			if (!$this->start)
			{
				$this->start = 0;
			}

			$host_list = $this->bonshost->read_hosts('host',$this->start,True,$this->query,$this->filter,$this->sort,$this->order,$this->cat_id);

// --------------------------------- nextmatch ---------------------------

			$left = $this->nextmatchs->left('/index.php',$this->start,$this->bonshost->total_records,$link_data);
			$right = $this->nextmatchs->right('/index.php',$this->start,$this->bonshost->total_records,$link_data);
			$this->t->set_var('left',$left);
			$this->t->set_var('right',$right);

			$this->t->set_var('lang_showing',$this->nextmatchs->show_hits($this->bonshost->total_records,$this->start));

// -------------------------- end nextmatch ------------------------------------

			$this->t->set_var('lang_action',lang('Hosts'));
			$this->t->set_var('cat_action',$phpgw->link('/index.php',$link_data));
			$this->t->set_var('categories',$this->cats->formated_list('select','all',$this->cat_id,'True'));
			$this->t->set_var('filter_action',$phpgw->link('/index.php',$link_data));
			$this->t->set_var('filter_list',$this->nextmatchs->filter(1,1));
			$this->t->set_var('search_action',$phpgw->link('/index.php',$link_data));
			$this->t->set_var('search_list',$this->nextmatchs->search(1));

			$this->t->pfp('out','filter',True);

// ---------------- list header variable template-declarations --------------------------

			$this->t->set_var(sort_name,$this->nextmatchs->show_sort_order($this->sort,'h_name',$this->order,'/index.php',lang('Short name'),$link_data));
			$this->t->set_var(sort_address,$this->nextmatchs->show_sort_order($this->sort,'h_address',$this->order,'/index.php',lang('Address'),$link_data));
			$this->t->set_var(sort_owner,$this->nextmatchs->show_sort_order($this->sort,'h_owner',$this->order,'/index.php',lang('created by'),$link_data));
			$this->t->set_var(sort_modified,$this->nextmatchs->show_sort_order($this->sort,'h_date',$this->order,'/index.php',lang('last modified'),$link_data));

// -------------- end header declaration ---------------------------------------

			for ($i=0;$i<count($host_list);$i++)
			{
				$tr_color = $this->nextmatchs->alternate_row_color($tr_color);
				$this->t->set_var('tr_color',$tr_color);
				$new_date = $host_list[$i]['date'];
				$month = $phpgw->common->show_date(time(),'n');
				$day = $phpgw->common->show_date(time(),'d');
				$year = $phpgw->common->show_date(time(),'Y');
				$new_date = $new_date + (60*60) * $phpgw_info['user']['preferences']['common']['tz_offset'];
				$new_dateout = $phpgw->common->show_date($new_date,$phpgw_info['user']['preferences']['common']['dateformat']);

				$cached_data = $this->bonetsaint->cached_accounts(intval($host_list[$i]['owner']));
				$ownerout = $phpgw->strip_html($cached_data[$host_list[$i]['owner']]['account_lid']
										. ' [' . $cached_data[$host_list[$i]['owner']]['firstname'] . ' '
										. $cached_data[$host_list[$i]['owner']]['lastname'] . ' ]');

				$this->t->set_var(array
				(
					'h_name'	=> $phpgw->strip_html($host_list[$i]['name']),
					'address'	=> $phpgw->strip_html($host_list[$i]['address']),
					'owner'		=> $ownerout,
					'modified'	=> $new_dateout
				));

				$link_data['h_id'] = $host_list[$i]['id'];
				$link_data['menuaction'] = 'netsaint.uinshost.view_host';

				$this->t->set_var('view',$phpgw->link('/index.php',$link_data));
				$this->t->set_var('lang_view_entry',lang('View'));

				if ($this->bonetsaint->check_perms($this->grants[$host_list[$i]['owner']],PHPGW_ACL_EDIT) || $host_list[$i]['owner'] == $this->account)
				{
					$link_data['menuaction'] = 'netsaint.uinshost.edit_host';

					$this->t->set_var('edit',$phpgw->link('/index.php',$link_data));
					$this->t->set_var('lang_edit_entry',lang('Edit'));
				}
				else
				{
					$this->t->set_var('edit','');
					$this->t->set_var('lang_edit_entry','');
				}

				if ($this->bonetsaint->check_perms($this->grants[$host_list[$i]['owner']],PHPGW_ACL_DELETE) || $host_list[$i]['owner'] == $this->account)
				{
					$link_data['menuaction'] = 'netsaint.uinshost.delete_host';
					$this->t->set_var('delete',$phpgw->link('/index.php',$link_data));
					$this->t->set_var('lang_delete_entry',lang('Delete'));
				}
				else
				{
					$this->t->set_var('delete','');
					$this->t->set_var('lang_delete_entry','');
				}

				$this->t->fp('list','host_list',True);
			}

			if ($this->cat_id && $this->cat_id != 0)
			{
				$cat = $this->cats->return_single($this->cat_id);
			}

			$link_data['menuaction']	= 'netsaint.uinshost.add_host';
			$link_data['cat_id']		= $this->cat_id;

			if ($cat[0]['app_name'] == 'phpgw' || !$this->cat_id)
			{
				$this->t->set_var('add','<form method="POST" action="' . $phpgw->link('/index.php',$link_data)
										. '"><input type="submit" name="Add" value="' . lang('Add host') .'"></form>');
			}
			else
			{
				if ($this->bonetsaint->check_perms($this->grants[$cat[0]['owner']],PHPGW_ACL_ADD) || $cat[0]['owner'] == $this->account)
				{
					$this->t->set_var('add','<form method="POST" action="' . $phpgw->link('/index.php',$link_data)
										. '"><input type="submit" name="Add" value="' . lang('Add host') .'"></font></form>');
				}
				else
				{
					$this->t->set_var('add','');
				}
			}

			$this->t->pfp('out','host_list_t',True);
			$this->save_sessiondata('host');
//			$phpgw->common->phpgw_footer();
		}

		function add_host()
		{
			global $phpgw, $phpgw_info, $cat_id, $new_cat, $submit, $values, $hosts, $action;

			if ($new_cat)
			{
				$cat_id = $new_cat;
			}

			$link_data = array
			(
				'menuaction'	=> 'netsaint.uinshost.add_host',
				'action'		=> 'host'
			);

			if ($submit)
			{
				$values['cat'] = $cat_id;

				if (is_array($hosts))
				{
					$values['hosts'] = implode(',',$hosts);
				}

				$error = $this->bonshost->check_values('host',$values);
				if (is_array($error))
				{
					$this->t->set_var('message',$phpgw->common->error_list($error));
				}
				else
				{
					$this->bonshost->save_host('host', $values);

					$link_data['menuaction'] = 'netsaint.uinshost.prefs_host';
					$link_data['cat_id'] = $cat_id;

					Header('Location: ' . $phpgw->link('/index.php',$link_data));
				}
			}

			$this->display_prefs_header();

			$this->t->set_file(array('host_add' => 'host_form.tpl'));
			$this->t->set_block('host_add','add','addhandle');
			$this->t->set_block('host_add','edit','edithandle');

			$this->t->set_var('actionurl',$phpgw->link('/index.php',$link_data));
			$this->t->set_var('lang_action',lang('Add host'));
			$this->t->set_var('cats_list',$this->cats->formated_list('select','all',$cat_id,True));
			$this->t->set_var('parent_list',$this->bonshost->select_host_list($hosts));
			$this->t->set_var('comand_list',$this->bonetsaint->select_comand_list('com_enabled',$values['comand']));
			$this->t->set_var('tp_list',$this->botimeperiod->select_tp_list('tp',$values['period']));
			$this->t->set_var('handler_list','');

			$this->t->set_var('access','<input type="checkbox" name="values[access]" value="True"' . ($values['access'] == 'private'?' checked':'') . '>');
			$this->t->set_var('recover','<input type="checkbox" name="values[recover]" value="True"' . ($values['recover'] == '1'?' checked':'') . '>');
			$this->t->set_var('down','<input type="checkbox" name="values[down]" value="True"' . ($values['down'] == '1'?' checked':'') . '>');
			$this->t->set_var('unreach','<input type="checkbox" name="values[unreach]" value="True"' . ($values['unreach'] == '1'?' checked':'') . '>');


			$this->t->set_var('h_name',$values['name']);
			$this->t->set_var('alias',$values['alias']);
			$this->t->set_var('address',$values['address']);
			$this->t->set_var('max',$values['max']);
			$this->t->set_var('intval',$values['intval']);


			$this->t->set_var('lang_reset',lang('Clear form'));
			$this->t->set_var('edithandle','');
			$this->t->set_var('addhandle','');
			$this->t->pfp('out','host_add');
			$this->t->pfp('addhandle','add');

//			$phpgw->common->phpgw_footer();
		}

		function edit_host()
		{
			global $phpgw, $phpgw_info, $cat_id, $new_cat, $submit, $values, $h_id, $hosts, $action;

			if ($new_cat)
			{
				$cat_id = $new_cat;
			}

			$link_data = array
			(
				'menuaction'	=> 'netsaint.uinshost.edit_host',
				'h_id'			=> $h_id,
				'action'		=> 'host'
			);

			if ($submit)
			{
				$values['cat']	= $cat_id;
				$values['id']	= $h_id;

				if (is_array($hosts))
				{
					$values['hosts'] = implode(',',$hosts);
				}

				$error = $this->bonshost->check_values('host',$values);
				if (is_array($error))
				{
					$this->t->set_var('message',$phpgw->common->error_list($error));
				}
				else
				{
					$this->bonshost->save_host('host', $values);
					$this->bonetsaint->set_config_status('on');
					$link_data['menuaction'] = 'netsaint.uinshost.prefs_host';
					$link_data['cat_id'] = $cat_id;

					Header('Location: ' . $phpgw->link('/index.php',$link_data));
				}
			}

			$this->display_prefs_header();

			$this->t->set_file(array('host_edit' => 'host_form.tpl'));
			$this->t->set_block('host_edit','add','addhandle');
			$this->t->set_block('host_edit','edit','edithandle');

			$values = $this->bonshost->read_single_host('host',$h_id);

			$this->t->set_var('actionurl',$phpgw->link('/index.php',$link_data));
			$this->t->set_var('lang_action',lang('Edit host'));
			$this->t->set_var('cats_list',$this->cats->formated_list('select','all',$values['cat'],True));

			$saved_hosts = explode(',',$phpgw->strip_html($values['parent']));
			$this->t->set_var('parent_list',$this->bonshost->select_host_list($saved_hosts));
			$this->t->set_var('comand_list',$this->bonetsaint->select_comand_list('com_enabled',$values['comand']));
			$this->t->set_var('tp_list',$this->botimeperiod->select_tp_list('tp',$values['period']));
			$this->t->set_var('handler_list','');

			$this->t->set_var('access','<input type="checkbox" name="values[access]" value="True"' . ($values['access'] == 'private'?' checked':'') . '>');
			$this->t->set_var('recover','<input type="checkbox" name="values[recover]" value="True"' . ($values['recover'] == '1'?' checked':'') . '>');
			$this->t->set_var('down','<input type="checkbox" name="values[down]" value="True"' . ($values['down'] == '1'?' checked':'') . '>');
			$this->t->set_var('unreach','<input type="checkbox" name="values[unreach]" value="True"' . ($values['unreach'] == '1'?' checked':'') . '>');

			$this->t->set_var('h_name',$phpgw->strip_html($values['name']));
			$this->t->set_var('alias',$phpgw->strip_html($values['alias']));
			$this->t->set_var('address',$values['address']);
			$this->t->set_var('max',$values['max']);
			$this->t->set_var('intval',$values['intval']);

			if ($this->bonetsaint->check_perms($this->grants[$values['owner']],PHPGW_ACL_DELETE) || $values['owner'] == $this->account)
			{
				$link_data['menuaction'] = 'netsaint.uinshost.delete_host';
				$this->t->set_var('delete','<form method="POST" action="' . $phpgw->link('/index.php',$link_data)
									. '"><input type="submit" value="' . lang('Delete') .'"></form>');
			}
			else
			{
				$this->t->set_var('delete','&nbsp;');
			}

			$this->t->set_var('edithandle','');
			$this->t->set_var('addhandle','');
			$this->t->pfp('out','host_edit');
			$this->t->pfp('edithandle','edit');
//			$phpgw->common->phpgw_footer();
		}

		function delete_host()
		{
			global $phpgw, $confirm, $h_id, $action;

			switch($action)
			{
				case 'host'	: $menu = 'netsaint.uinshost.prefs_host'; break;
				case 'hg'	: $menu = 'netsaint.uinshost.prefs_hg'; break;
			}

			$link_data = array
			(
				'menuaction'	=> $menu,
				'h_id'			=> $h_id,
				'action'		=> $action
			);

			if ($confirm)
			{
				$this->bonshost->delete_host($action, $h_id);
				Header('Location: ' . $phpgw->link('/index.php',$link_data));				
			}
			else
			{
				$this->display_prefs_header();

				$this->t->set_file(array('delete' => 'delete.tpl'));

				$this->t->set_var('done_action',$phpgw->link('/index.php',$link_data));
				$this->t->set_var('deleteheader',lang('Are you sure you want to delete this entry ?'));
				$this->t->set_var('lang_no',lang('No'));
				$this->t->set_var('lang_yes',lang('Yes'));
				$link_data['menuaction'] = 'netsaint.uinshost.delete_host';
				$this->t->set_var('action_url',$phpgw->link('/index.php',$link_data));

				$this->t->pfp('out','delete');
//				$phpgw->common->phpgw_footer();
			}
		}

		function view_host()
		{
			global $h_id, $phpgw, $phpgw_info, $action;

			$this->display_prefs_header();

			$link_data = array
			(
				'menuaction'	=> 'netsaint.uinshost.prefs_host',
				'action'		=> 'host'
			);

			$this->t->set_file(array('view' => 'default_view.tpl'));
			$this->t->set_block('view','service','servicehandle');
			$this->t->set_block('view','escal','escalhandle');
			$this->t->set_block('view','contact','contacthandle');
			$this->t->set_block('view','cg','cghandle');
			$this->t->set_block('view','tp','tphandle');
			$this->t->set_block('view','host','hosthandle');
			$this->t->set_block('view','group','grouphandle');
			$this->t->set_block('view','done','donehandle');

			$h = $this->bonshost->read_single_host('host',$h_id);

			$this->t->set_var('lang_action',lang('View host'));

			$this->t->set_var('cat',$this->cats->id2name($h['cat']));

			$new_date = $h['date'] + (60*60) * $phpgw_info['user']['preferences']['common']['tz_offset'];
			$new_dateout = $phpgw->common->show_date($new_date,$phpgw_info['user']['preferences']['common']['dateformat']);
			$this->t->set_var('new_date',$new_dateout);

			$alias = nl2br($phpgw->strip_html($h['alias']));

			$this->t->set_var('alias',$alias);
			$this->t->set_var('h_name',$phpgw->strip_html($h['name']));
			$this->t->set_var('access',lang($h['access']));

			$cached_data = $this->bonetsaint->cached_accounts(intval($h['owner']));
			$ownerout = $phpgw->strip_html($cached_data[$h['owner']]['account_lid'] . ' [' . $cached_data[$h['owner']]['firstname'] . ' '
										. $cached_data[$h['owner']]['lastname'] . ' ]');

			$this->t->set_var('owner',$ownerout);

			$this->t->set_var('parent',$phpgw->strip_html($h['parent']));
			$this->t->set_var('comand',$phpgw->strip_html($h['comand']));
			$this->t->set_var('period',$phpgw->strip_html($h['period']));
			$this->t->set_var('handler','&nbsp;');

			switch($h['recover'])
			{
				case '1':	$rec = 'Yes'; break;
				case '0':	$rec = 'No'; break;
			}
			
			switch($h['down'])
			{
				case '1':	$down = 'Yes'; break;
				case '0':	$down = 'No'; break;
			}

			switch($h['unreach'])
			{
				case '1':	$unreach = 'Yes'; break;
				case '0':	$unreach = 'No'; break;
			}

			$this->t->set_var('recover',lang($rec));
			$this->t->set_var('down',lang($down));
			$this->t->set_var('unreach',lang($unreach));

			$this->t->set_var('address',$phpgw->strip_html($h['address']));
			$this->t->set_var('max',intval($h['max']));
			$this->t->set_var('intval',intval($h['intval']));

			$this->t->set_var('done_action',$phpgw->link('/index.php',$link_data));

			$this->t->set_var('servicehandle','');
			$this->t->set_var('escalhandle','');
			$this->t->set_var('contacthandle','');
			$this->t->set_var('cghandle','');
			$this->t->set_var('hosthandle','');
			$this->t->set_var('grouphandle','');
			$this->t->set_var('tphandle','');
			$this->t->pfp('out','view');
			$this->t->pfp('hosthandle','host');
			$this->t->pfp('donehandle','done');
//			$phpgw->common->phpgw_footer();
		}

		function prefs_hg()
		{
			global $phpgw, $phpgw_info, $action;

			$this->display_prefs_header();

			$this->t->set_file(array('filter' => 'filter.tpl',
									'item_list_t' => 'prefs_default.tpl'));
			$this->t->set_block('item_list_t','item_list','list');

			$link_data = array
			(
				'menuaction'	=> 'netsaint.uinshost.prefs_hg',
				'action'		=> 'hg'
			);

			if (!$this->start)
			{
				$this->start = 0;
			}

			$hg_list = $this->bonshost->read_hosts('hg',$this->start,True,$this->query,$this->filter,$this->sort,$this->order,$this->cat_id);

// --------------------------------- nextmatch ---------------------------

			$left = $this->nextmatchs->left('/index.php',$this->start,$this->bonshost->total_records,$link_data);
			$right = $this->nextmatchs->right('/index.php',$this->start,$this->bonshost->total_records,$link_data);
			$this->t->set_var('left',$left);
			$this->t->set_var('right',$right);

			$this->t->set_var('lang_showing',$this->nextmatchs->show_hits($this->bonshost->total_records,$this->start));

// -------------------------- end nextmatch ------------------------------------

			$this->t->set_var('lang_action',lang('Host groups'));
			$this->t->set_var('cat_action',$phpgw->link('/index.php',$link_data));
			$this->t->set_var('categories',$this->cats->formated_list('select','all',$this->cat_id,'True'));
			$this->t->set_var('filter_action',$phpgw->link('/index.php',$link_data));
			$this->t->set_var('filter_list',$this->nextmatchs->filter(1,1));
			$this->t->set_var('search_action',$phpgw->link('/index.php',$link_data));
			$this->t->set_var('search_list',$this->nextmatchs->search(1));

			$this->t->pfp('out','filter',True);

// ---------------- list header variable template-declarations --------------------------

			$this->t->set_var(sort_name,$this->nextmatchs->show_sort_order($this->sort,'hg_name',$this->order,'/index.php',lang('Short name'),$link_data));
			$this->t->set_var(sort_alias,$this->nextmatchs->show_sort_order($this->sort,'hg_alias',$this->order,'/index.php',lang('Description'),$link_data));
			$this->t->set_var(sort_owner,$this->nextmatchs->show_sort_order($this->sort,'hg_owner',$this->order,'/index.php',lang('created by'),$link_data));
			$this->t->set_var(sort_modified,$this->nextmatchs->show_sort_order($this->sort,'hg_date',$this->order,'/index.php',lang('last modified'),$link_data));

// -------------- end header declaration ---------------------------------------

			for ($i=0;$i<count($hg_list);$i++)
			{
				$tr_color = $this->nextmatchs->alternate_row_color($tr_color);
				$this->t->set_var('tr_color',$tr_color);
				$new_date = $hg_list[$i]['date'];
				$month = $phpgw->common->show_date(time(),'n');
				$day = $phpgw->common->show_date(time(),'d');
				$year = $phpgw->common->show_date(time(),'Y');
				$new_date = $new_date + (60*60) * $phpgw_info['user']['preferences']['common']['tz_offset'];
				$new_dateout = $phpgw->common->show_date($new_date,$phpgw_info['user']['preferences']['common']['dateformat']);

				$alias = split(' ',$phpgw->strip_html($hg_list[$i]['alias']));
				$first = "$alias[0] $alias[1] $alias[2] $alias[3] .....";

				$cached_data = $this->bonetsaint->cached_accounts(intval($hg_list[$i]['owner']));
				$ownerout = $phpgw->strip_html($cached_data[$hg_list[$i]['owner']]['account_lid']
										. ' [' . $cached_data[$hg_list[$i]['owner']]['firstname'] . ' '
										. $cached_data[$hg_list[$i]['owner']]['lastname'] . ' ]');

				$this->t->set_var(array
				(
					'i_name'	=> $phpgw->strip_html($hg_list[$i]['name']),
					'alias'		=> $first,
					'owner'		=> $ownerout,
					'modified'	=> $new_dateout
				));

				$link_data['h_id'] = $hg_list[$i]['id'];
				$link_data['menuaction'] = 'netsaint.uinshost.view_hg';

				$this->t->set_var('view',$phpgw->link('/index.php',$link_data));
				$this->t->set_var('lang_view_entry',lang('View'));

				if ($this->bonetsaint->check_perms($this->grants[$hg_list[$i]['owner']],PHPGW_ACL_EDIT) || $hg_list[$i]['owner'] == $this->account)
				{
					$link_data['menuaction'] = 'netsaint.uinshost.edit_hg';

					$this->t->set_var('edit',$phpgw->link('/index.php',$link_data));
					$this->t->set_var('lang_edit_entry',lang('Edit'));
				}
				else
				{
					$this->t->set_var('edit','');
					$this->t->set_var('lang_edit_entry','');
				}

				if ($this->bonetsaint->check_perms($this->grants[$hg_list[$i]['owner']],PHPGW_ACL_DELETE) || $hg_list[$i]['owner'] == $this->account)
				{
					$link_data['menuaction'] = 'netsaint.uinshost.delete_host';
					$this->t->set_var('delete',$phpgw->link('/index.php',$link_data));
					$this->t->set_var('lang_delete_entry',lang('Delete'));
				}
				else
				{
					$this->t->set_var('delete','');
					$this->t->set_var('lang_delete_entry','');
				}

				$this->t->fp('list','item_list',True);
			}

			if ($this->cat_id && $this->cat_id != 0)
			{
				$cat = $this->cats->return_single($this->cat_id);
			}

			$link_data['menuaction']	= 'netsaint.uinshost.add_hg';
			$link_data['cat_id']		= $this->cat_id;

			if ($cat[0]['app_name'] == 'phpgw' || !$this->cat_id)
			{
				$this->t->set_var('add','<form method="POST" action="' . $phpgw->link('/index.php',$link_data)
										. '"><input type="submit" name="Add" value="' . lang('Add hostgroup') .'"></form>');
			}
			else
			{
				if ($this->bonetsaint->check_perms($this->grants[$cat[0]['owner']],PHPGW_ACL_ADD) || $cat[0]['owner'] == $this->account)
				{
					$this->t->set_var('add','<form method="POST" action="' . $phpgw->link('/index.php',$link_data)
										. '"><input type="submit" name="Add" value="' . lang('Add hostgroup') .'"></font></form>');
				}
				else
				{
					$this->t->set_var('add','');
				}
			}

			$this->t->pfp('out','item_list_t',True);
			$this->save_sessiondata('hg');
//			$phpgw->common->phpgw_footer();
		}

		function add_hg()
		{
			global $phpgw, $phpgw_info, $cat_id, $new_cat, $submit, $values, $hosts, $cg, $action;

			if ($new_cat)
			{
				$cat_id = $new_cat;
			}

			$link_data = array
			(
				'menuaction'	=> 'netsaint.uinshost.add_hg',
				'action'		=> 'hg'
			);

			if ($submit)
			{
				$values['cat'] = $cat_id;

				if (is_array($hosts))
				{
					$values['hosts'] = implode(',',$hosts);
				}

				if (is_array($cg))
				{
					$values['cg'] = implode(',',$cg);
				}

				$error = $this->bonshost->check_values('hg',$values);
				if (is_array($error))
				{
					$this->t->set_var('message',$phpgw->common->error_list($error));
				}
				else
				{
					$this->bonshost->save_host('hg', $values);

					$link_data['menuaction'] = 'netsaint.uinshost.prefs_hg';
					$link_data['cat_id'] = $cat_id;

					Header('Location: ' . $phpgw->link('/index.php',$link_data));
				}
			}

			$this->display_prefs_header();

			$this->t->set_file(array('hg_add' => 'hg_form.tpl'));
			$this->t->set_block('hg_add','add','addhandle');
			$this->t->set_block('hg_add','edit','edithandle');

			$this->t->set_var('actionurl',$phpgw->link('/index.php',$link_data));
			$this->t->set_var('lang_action',lang('Add hostgroup'));
			$this->t->set_var('cats_list',$this->cats->formated_list('select','all',$cat_id,True));

			$this->t->set_var('contact_list',$this->bonscontact->select_contact_list('cg',$cg));
			$this->t->set_var('host_list',$this->bonshost->select_host_list($hosts));

			$this->t->set_var('access','<input type="checkbox" name="values[access]" value="True"' . ($values['access'] == 'private'?' checked':'') . '>');

			$this->t->set_var('hg_name',$values['name']);
			$this->t->set_var('alias',$values['alias']);

			$this->t->set_var('lang_reset',lang('Clear form'));
			$this->t->set_var('edithandle','');
			$this->t->set_var('addhandle','');
			$this->t->pfp('out','hg_add');
			$this->t->pfp('addhandle','add');

//			$phpgw->common->phpgw_footer();
		}

		function edit_hg()
		{
			global $phpgw, $phpgw_info, $cat_id, $new_cat, $submit, $values, $h_id, $hosts, $cg, $action;

			if ($new_cat)
			{
				$cat_id = $new_cat;
			}

			$link_data = array
			(
				'menuaction'	=> 'netsaint.uinshost.edit_hg',
				'h_id'			=> $h_id,
				'action'		=> 'hg'
			);

			if ($submit)
			{
				$values['cat']	= $cat_id;
				$values['id']	= $h_id;

				if (is_array($hosts))
				{
					$values['hosts'] = implode(',',$hosts);
				}

				if (is_array($cg))
				{
					$values['cg'] = implode(',',$cg);
				}

				$error = $this->bonshost->check_values('hg',$values);
				if (is_array($error))
				{
					$this->t->set_var('message',$phpgw->common->error_list($error));
				}
				else
				{
					$this->bonshost->save_host('hg', $values);
					$this->bonetsaint->set_config_status('on');
					$link_data['menuaction'] = 'netsaint.uinshost.prefs_hg';
					$link_data['cat_id'] = $cat_id;

					Header('Location: ' . $phpgw->link('/index.php',$link_data));
				}
			}

			$this->display_prefs_header();

			$this->t->set_file(array('hg_edit' => 'hg_form.tpl'));
			$this->t->set_block('hg_edit','add','addhandle');
			$this->t->set_block('hg_edit','edit','edithandle');

			$values = $this->bonshost->read_single_host('hg',$h_id);

			$this->t->set_var('actionurl',$phpgw->link('/index.php',$link_data));
			$this->t->set_var('lang_action',lang('Edit hostgroup'));
			$this->t->set_var('cats_list',$this->cats->formated_list('select','all',$values['cat'],True));

			$saved_hosts = explode(',',$phpgw->strip_html($values['hosts']));

			$this->t->set_var('host_list',$this->bonshost->select_host_list($saved_hosts));

			$saved_cg = explode(',',$phpgw->strip_html($values['cg']));
			$this->t->set_var('contact_list',$this->bonscontact->select_contact_list('cg',$saved_cg));

			$this->t->set_var('access','<input type="checkbox" name="values[access]" value="True"' . ($values['access'] == 'private'?' checked':'') . '>');

			$this->t->set_var('hg_name',$phpgw->strip_html($values['name']));
			$this->t->set_var('alias',$phpgw->strip_html($values['alias']));

			if ($this->bonetsaint->check_perms($this->grants[$values['owner']],PHPGW_ACL_DELETE) || $values['owner'] == $this->account)
			{
				$link_data['menuaction'] = 'netsaint.uinshost.delete_host';
				$this->t->set_var('delete','<form method="POST" action="' . $phpgw->link('/index.php',$link_data)
									. '"><input type="submit" value="' . lang('Delete') .'"></form>');
			}
			else
			{
				$this->t->set_var('delete','&nbsp;');
			}

			$this->t->set_var('edithandle','');
			$this->t->set_var('addhandle','');
			$this->t->pfp('out','hg_edit');
			$this->t->pfp('edithandle','edit');
//			$phpgw->common->phpgw_footer();
		}

		function view_hg()
		{
			global $h_id, $phpgw, $phpgw_info, $action;

			$this->display_prefs_header();

			$link_data = array
			(
				'menuaction'	=> 'netsaint.uinshost.prefs_hg',
				'action'		=> 'hg'
			);

			$this->t->set_file(array('view' => 'default_view.tpl'));
			$this->t->set_block('view','service','servicehandle');
			$this->t->set_block('view','escal','escalhandle');
			$this->t->set_block('view','cg','cghandle');
			$this->t->set_block('view','contact','contacthandle');
			$this->t->set_block('view','tp','tphandle');
			$this->t->set_block('view','host','hosthandle');
			$this->t->set_block('view','group','grouphandle');
			$this->t->set_block('view','done','donehandle');

			$h = $this->bonshost->read_single_host('hg',$h_id);

			$this->t->set_var('lang_action',lang('View hostgroup'));

			$this->t->set_var('cat',$this->cats->id2name($h['cat']));

			$new_date = $h['date'] + (60*60) * $phpgw_info['user']['preferences']['common']['tz_offset'];
			$new_dateout = $phpgw->common->show_date($new_date,$phpgw_info['user']['preferences']['common']['dateformat']);
			$this->t->set_var('new_date',$new_dateout);

			$alias = nl2br($phpgw->strip_html($h['alias']));

			$this->t->set_var('alias',$alias);
			$this->t->set_var('h_name',$phpgw->strip_html($h['name']));
			$this->t->set_var('access',lang($h['access']));

			$cached_data = $this->bonetsaint->cached_accounts(intval($h['owner']));
			$ownerout = $phpgw->strip_html($cached_data[$h['owner']]['account_lid'] . ' [' . $cached_data[$h['owner']]['firstname'] . ' '
										. $cached_data[$h['owner']]['lastname'] . ' ]');

			$this->t->set_var('owner',$ownerout);

			$this->t->set_var('contact_list',$phpgw->strip_html($h['cg']));
			$this->t->set_var('host_list',$phpgw->strip_html($h['hosts']));

			$this->t->set_var('done_action',$phpgw->link('/index.php',$link_data));

			$this->t->set_var('servicehandle','');
			$this->t->set_var('escalhandle','');
			$this->t->set_var('cghandle','');
			$this->t->set_var('contacthandle','');
			$this->t->set_var('grouphandle','');
			$this->t->set_var('hosthandle','');
			$this->t->set_var('tphandle','');
			$this->t->pfp('out','view');
			$this->t->pfp('grouphandle','group');
			$this->t->pfp('donehandle','done');
//			$phpgw->common->phpgw_footer();
		}
	}
?>
