<?php
	/*******************************************************************\
	* phpGroupWare - Netsaint                                           *
	* http://www.phpgroupware.org                                       *
	*                                                                   *
	* Administration Tool for NetSaint Network Monitor                  *
	* http://www.netsaint.org                                           *
	* Ethan A. Galstad <netsaint@linuxbox.com>                          *
	*                                                                   *
	* Written by Bettina Gille [ceb@phpgroupware.org]                   *
	* -----------------------------------------------                   *
	* Copyright (C) 2001 Bettina Gille                                  *
	*                                                                   *
	* This program is free software; you can redistribute it and/or     *
	* modify it under the terms of the GNU General Public License as    *
	* published by the Free Software Foundation; either version 2 of    *
	* the License, or (at your option) any later version.               *
	*                                                                   *
	* This program is distributed in the hope that it will be useful,   *
	* but WITHOUT ANY WARRANTY; without even the implied warranty of    *
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU  *
	* General Public License for more details.                          *
	*                                                                   *
	* You should have received a copy of the GNU General Public License *
	* along with this program; if not, write to the Free Software       *
	* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.         *
	\*******************************************************************/
	/* $Id: class.sonshost.inc.php,v 1.12 2001/09/06 22:56:15 bettina Exp $ */

	class sonshost
	{
		var $grants;

		function sonshost()
		{
			global $phpgw, $phpgw_info;

			$this->db		= $phpgw->db;
			$this->db2		= $this->db;
			$this->grants	= $phpgw->acl->get_grants('netsaint');
			$this->owner	= $phpgw_info['user']['account_id'];
		}

		function read_hosts($start, $limit = True, $query = '', $filter = '', $sort = '', $order = '', $cat_id = '')
		{
			global $phpgw, $phpgw_info;

			if (!$sort)
			{
				$sort = "ASC";
			}

			if ($order)
			{
				$ordermethod = "order by $order $sort";
			}
			else
			{
				$ordermethod = "order by h_name asc";
			}

			if (! $filter)
			{
				$filter = 'none';
			}

			if ($filter == 'none')
			{
				$filtermethod = " ( h_owner=" . $this->owner;
				if (is_array($this->grants))
				{
					$grants = $this->grants;
					while (list($user) = each($grants))
					{
						$public_user_list[] = $user;
					}
					reset($public_user_list);
					$filtermethod .= " OR (h_access='public' AND h_owner in(" . implode(',',$public_user_list) . ")))";
				}
				else
				{
					$filtermethod .= ' )';
				}
			}
			elseif ($filter == 'yours')
			{
				$filtermethod = " h_owner='" . $this->owner . "'";
			}
			else
			{
				$filtermethod = " h_owner='" . $this->owner . "' AND h_access='private'";
			}

			if ($cat_id)
			{
				$filtermethod .= " AND h_cat='$cat_id' ";
			}

			if ($query)
			{
				$searchmethod = " AND h_name like '%$query%' OR h_alias like '%$query%' ";
			}

			$sql = "SELECT * FROM phpgw_ns_host WHERE $filtermethod $searchmethod";

			$this->db2->query($sql,__LINE__,__FILE__);
			$this->total_records = $this->db2->num_rows();
			$this->db->limit_query($sql . $ordermethod,$start,__LINE__,__FILE__);

			$i = 0;
			while ($this->db->next_record())
			{
				$h[$i]['id']		= $this->db->f('h_id');
				$h[$i]['name']		= $this->db->f('h_name');
				$h[$i]['access']	= $this->db->f('h_access');
				$h[$i]['owner']		= $this->db->f('h_owner');
				$h[$i]['date']		= $this->db->f('h_date');
				$h[$i]['cat']		= $this->db->f('h_cat');
				$h[$i]['address']	= $this->db->f('h_address');
				$i++;
			}
			return $h;
		}

		function read_config_hosts()
		{
			global $phpgw;

			$sql = "SELECT * FROM phpgw_ns_host";

			$this->db->query($sql,__LINE__,__FILE__);

			$i = 0;
			while ($this->db->next_record())
			{
				$h[$i]['name']		= $this->db->f('h_name');
				$h[$i]['alias']		= $this->db->f('h_alias');
				$h[$i]['address']	= $this->db->f('h_address');
				$h[$i]['parent']	= $this->db->f('h_parent');
				$h[$i]['command']	= $this->db->f('h_check');
				$h[$i]['max']		= $this->db->f('h_max_attempts');
				$h[$i]['intval']	= $this->db->f('h_not_intval');
				$h[$i]['period']	= $this->db->f('h_not_period');
				$h[$i]['recover']	= $this->db->f('h_not_recovery');
				$h[$i]['down']		= $this->db->f('h_not_down');
				$h[$i]['unreach']	= $this->db->f('h_not_unreach');
				$h[$i]['event']		= $this->db->f('h_not_event');
				$i++;
			}
			return $h;
		}

		function read_single_host($h_id)
		{
			$this->db->query("select * from phpgw_ns_host where h_id='$h_id'",__LINE__,__FILE__);

			if ($this->db->next_record())
			{
				$h['id']		= $this->db->f('h_id');
				$h['name']		= $this->db->f('h_name');
				$h['access']	= $this->db->f('h_access');
				$h['owner']		= $this->db->f('h_owner');
				$h['date']		= $this->db->f('h_date');
				$h['cat']		= $this->db->f('h_cat');
				$h['alias']		= $this->db->f('h_alias');
				$h['address']	= $this->db->f('h_address');
				$h['parent']	= $this->db->f('h_parent');
				$h['comand']	= $this->db->f('h_check');
				$h['max']		= $this->db->f('h_max_attempts');
				$h['intval']	= $this->db->f('h_not_intval');
				$h['period']	= $this->db->f('h_not_period');
				$h['recover']	= $this->db->f('h_not_recovery');
				$h['down']		= $this->db->f('h_not_down');
				$h['unreach']	= $this->db->f('h_not_unreach');
				$h['event']		= $this->db->f('h_not_event');

				return $h;
			}
		}

		function add_host($values)
		{
			$values['name'] = addslashes($values['name']);
			$values['alias'] = addslashes($values['alias']);
			$values['hosts'] = addslashes($values['hosts']);

			$this->db->query("INSERT INTO phpgw_ns_host (h_name,h_owner,h_access,h_cat,h_date,h_alias,h_address,h_parent,h_check,h_max_attempts,"
							. "h_not_intval,h_not_period,h_not_recovery,h_not_down,h_not_unreach,h_event_handler) VALUES ('" . $values['name'] . "','"
							. $this->owner . "','" . $values['access'] . "','" . $values['cat'] . "','" . time() . "','" . $values['alias'] . "','"
							. $values['address'] . "','" . $values['hosts'] . "','" . $values['comand'] . "','" . $values['max'] . "','"
							. $values['intval'] . "','" . $values['period'] . "','" . $values['recover'] . "','" . $values['down'] . "','"
							. $values['unreach'] . "','" . $values['event'] . "')",__LINE__,__FILE__);
		}

		function edit_host($values)
		{
			$values['name'] = addslashes($values['name']);
			$values['alias'] = addslashes($values['alias']);
			$values['hosts'] = addslashes($values['hosts']);

			$this->db->query("UPDATE phpgw_ns_host set h_name='" . $values['name'] . "', h_access='" . $values['access'] . "', h_cat='"
							. $values['cat'] . "', h_date='" . time() . "', h_alias='" . $values['alias'] . "', h_address='" . $values['address']
							. "', h_parent='" . $values['hosts'] . "', h_check='" . $values['comand'] . "', h_max_attempts='" . $values['max']
							. "', h_not_intval='" . $values['intval'] . "', h_not_period='" . $values['period'] . "', h_not_recovery='"
							. $values['recover'] . "', h_not_down='" . $values['down'] . "', h_not_unreach='" . $values['unreach']
							. "', h_event_handler='" . $values['event'] . "' WHERE h_id='" . $values['id'] . "'",__LINE__,__FILE__);
		}

		function delete_host($action, $h_id)
		{
			if ($action == 'host')
			{
				$this->db->query("DELETE FROM phpgw_ns_host WHERE h_id='$h_id'",__LINE__,__FILE__);
			}
			else
			{
				$this->db->query("DELETE FROM phpgw_ns_hostgroup WHERE hg_id='$h_id'",__LINE__,__FILE__);
			}
		}

		function in_array($needle,$haystack)
		{
			if (function_exists('in_array'))
			{
				return in_array($needle,$haystack);
			}
			while (list ($k,$v) = each($haystack))
			{
				if ($v == $needle)
				{
					return True;
				}
			}
			return False;
		}

		function select_host_list($selected = '')
		{
			global $phpgw;

			if (!is_array($selected))
			{
				$selected = explode(',',$selected);
			}

			$h = $this->read_hosts($start, False, $query, $filter, $sort, $order, $cat_id);

			for ($i=0;$i<count($h);$i++)
			{
				$h_select .= '<option value="' . $h[$i]['name'] . '"';
				if ($this->in_array($h[$i]['name'],$selected))
				{
					$h_select .= ' selected';
				}
				$h_select .= '>' . $phpgw->strip_html($h[$i]['name']) . '</option>';
			}
			return $h_select;
		}

		function exists($action, $h_name, $h_id = '')
		{
			if ($action == 'host')
			{
				if ($h_id && ($h_id != 0))
				{
					$editexists = " and h_id != '$h_id'";
				}

				$this->db->query("select count(*) from phpgw_ns_host where h_name = '$h_name' $editexists",__LINE__,__FILE__);
			}
			else
			{
				if ($h_id && ($h_id != 0))
				{
					$editexists = " and hg_id != '$h_id'";
				}

				$this->db->query("select count(*) from phpgw_ns_hostgroup where hg_name = '$h_name' $editexists",__LINE__,__FILE__);
			}

			$this->db->next_record();

			if ($this->db->f(0))
			{
				return True;
			}
			else
			{
				return False;
			}
		}

		function read_hgs($start, $limit = True, $query = '', $filter = '', $sort = '', $order = '', $cat_id = '')
		{
			global $phpgw, $phpgw_info;

			if (!$sort)
			{
				$sort = "ASC";
			}

			if ($order)
			{
				$ordermethod = "order by $order $sort";
			}
			else
			{
				$ordermethod = "order by hg_name asc";
			}

			if (! $filter)
			{
				$filter = 'none';
			}

			if ($filter == 'none')
			{
				$filtermethod = " ( hg_owner=" . $this->owner;
				if (is_array($this->grants))
				{
					$grants = $this->grants;
					while (list($user) = each($grants))
					{
						$public_user_list[] = $user;
					}
					reset($public_user_list);
					$filtermethod .= " OR (hg_access='public' AND hg_owner in(" . implode(',',$public_user_list) . ")))";
				}
				else
				{
					$filtermethod .= ' )';
				}
			}
			elseif ($filter == 'yours')
			{
				$filtermethod = " hg_owner='" . $this->owner . "'";
			}
			else
			{
				$filtermethod = " hg_owner='" . $this->owner . "' AND hg_access='private'";
			}

			if ($cat_id)
			{
				$filtermethod .= " AND hg_cat='$cat_id' ";
			}

			if ($query)
			{
				$searchmethod = " AND hg_name like '%$query%' OR hg_alias like '%$query%' ";
			}

			$sql = "SELECT * FROM phpgw_ns_hostgroup WHERE $filtermethod $searchmethod";

			$this->db2->query($sql,__LINE__,__FILE__);
			$this->total_records = $this->db2->num_rows();
			$this->db->limit_query($sql . $ordermethod,$start,__LINE__,__FILE__);

			$i = 0;
			while ($this->db->next_record())
			{
				$hg[$i]['id']		= $this->db->f('hg_id');
				$hg[$i]['name']		= $this->db->f('hg_name');
				$hg[$i]['access']	= $this->db->f('hg_access');
				$hg[$i]['owner']	= $this->db->f('hg_owner');
				$hg[$i]['date']		= $this->db->f('hg_date');
				$hg[$i]['cat']		= $this->db->f('hg_cat');
				$hg[$i]['alias']	= $this->db->f('hg_alias');
				$i++;
			}
			return $hg;
		}

		function read_config_hgs()
		{
			global $phpgw;

			$sql = "SELECT * FROM phpgw_ns_hostgroup";

			$this->db->query($sql,__LINE__,__FILE__);

			$i = 0;
			while ($this->db->next_record())
			{
				$hg[$i]['name']		= $this->db->f('hg_name');
				$hg[$i]['alias']	= $this->db->f('hg_alias');
				$hg[$i]['cg']		= $this->db->f('hg_contact');
				$hg[$i]['hosts']	= $this->db->f('hg_hosts');
				$i++;
			}
			return $hg;
		}


		function read_single_hg($hg_id)
		{
			$this->db->query("select * from phpgw_ns_hostgroup where hg_id='$hg_id'",__LINE__,__FILE__);

			if ($this->db->next_record())
			{
				$h['id']		= $this->db->f('hg_id');
				$h['name']		= $this->db->f('hg_name');
				$h['access']	= $this->db->f('hg_access');
				$h['owner']		= $this->db->f('hg_owner');
				$h['date']		= $this->db->f('hg_date');
				$h['cat']		= $this->db->f('hg_cat');
				$h['alias']		= $this->db->f('hg_alias');
				$h['cg']		= $this->db->f('hg_contact');
				$h['hosts']		= $this->db->f('hg_hosts');

				return $h;
			}
		}

		function add_hg($values)
		{
			$values['name']		= addslashes($values['name']);
			$values['alias']	= addslashes($values['alias']);
			$values['hosts']	= addslashes($values['hosts']);
			$values['cg']		= addslashes($values['cg']);

			$this->db->query("INSERT INTO phpgw_ns_hostgroup (hg_name,hg_owner,hg_access,hg_cat,hg_date,hg_alias,hg_contact,hg_hosts) VALUES ('"
							. $values['name'] . "','" . $this->owner . "','" . $values['access'] . "','" . $values['cat'] . "','" . time() . "','"
							. $values['alias'] . "','" . $values['cg'] . "','" . $values['hosts'] . "')",__LINE__,__FILE__);
		}

		function edit_hg($values)
		{
			$values['name']		= addslashes($values['name']);
			$values['alias']	= addslashes($values['alias']);
			$values['hosts']	= addslashes($values['hosts']);
			$values['cg']		= addslashes($values['cg']);

			$this->db->query("UPDATE phpgw_ns_hostgroup set hg_name='" . $values['name'] . "', hg_access='" . $values['access'] . "', hg_cat='"
							. $values['cat'] . "', hg_date='" . time() . "', hg_alias='" . $values['alias'] . "', hg_contact='" . $values['cg']
							. "', hg_hosts='" . $values['hosts'] . "' WHERE hg_id='" . $values['id'] . "'",__LINE__,__FILE__);
		}
	}
?>
