
CREATE TABLE napster_servers (
  name        varchar(255) NOT NULL,
  ip          varchar(255) NOT NULL,
  port        int          NOT NULL,
  network     varchar(255) NOT NULL,
  users       int          NOT NULL,
  files       int          NOT NULL,
  gb          int          NOT NULL,
  lastupdated int          NOT NULL,
  UNIQUE (name)
);

CREATE TABLE napster_speeds (
  speed       varchar(255) NOT NULL,
  UNIQUE (speed)
);

INSERT INTO napster_speeds VALUES('slow');
INSERT INTO napster_speeds VALUES('14.4K');
INSERT INTO napster_speeds VALUES('28.8K');
INSERT INTO napster_speeds VALUES('33.6K');
INSERT INTO napster_speeds VALUES('56K');
INSERT INTO napster_speeds VALUES('64K');
INSERT INTO napster_speeds VALUES('128K');
INSERT INTO napster_speeds VALUES('Cable');
INSERT INTO napster_speeds VALUES('DSL');
INSERT INTO napster_speeds VALUES('T1');
INSERT INTO napster_speeds VALUES('T3+');

CREATE TABLE napster_compares (
  operator    varchar(255) NOT NULL,
  UNIQUE (operator)
);

INSERT INTO napster_compares VALUES('AT LEAST');
INSERT INTO napster_compares VALUES('EQUAL TO');
INSERT INTO napster_compares VALUES('AT BEST'); 

CREATE TABLE napster_ports (
  port  int              NOT NULL,
  state int    DEFAULT 0 NOT NULL,
  UNIQUE (port)
);

INSERT INTO napster_ports VALUES(6699,0);
INSERT INTO napster_ports VALUES(6700,0);
INSERT INTO napster_ports VALUES(6701,0);
INSERT INTO napster_ports VALUES(6702,0);
INSERT INTO napster_ports VALUES(6703,0);
INSERT INTO napster_ports VALUES(6704,0);

