<?php
	/**************************************************************************\
	* phpGroupWare - Inventory                                                 *
	* http://www.phpgroupware.org                                              *
	* This file written by Joseph Engo <jengo@phpgroupware.org>                *
	* --------------------------------------------                             *
	* This program is free software; you can redistribute it and/or modify it  *
	* under the terms of the GNU General Public License as published by the    *
	* Free Software Foundation; either version 2 of the License, or (at your   *
	* option) any later version.                                               *
	\**************************************************************************/
	/* $Id: liststatus.php,v 1.24 2001/05/30 00:11:24 bettina Exp $ */

	$phpgw_info['flags'] = array('currentapp' => 'inv',
					'enable_nextmatchs_class' => True);

	include('../header.inc.php');

	$t = CreateObject('phpgwapi.Template',PHPGW_APP_TPL);
	$t->set_file(array('status_list_t' => 'liststatus.tpl'));                                                                                                                                  
	$t->set_block('status_list_t','status_list','list');  

	if ($order)
	{
		$ordermethod = "order by $order $sort";
	}
	else
	{
		$ordermethod = "order by status_name asc";
	}

	$t->set_var('lang_action',lang('Product status list'));
	if ($lm == 'statusupdated')
	{
		$t->set_var('message',lang('Product status has been updated !'));
	}
	if ($lm == 'statusadded')
	{
		$t->set_var('message',lang('Product status has been added !'));
	}

	$t->set_var('th_bg',$phpgw_info['theme']['th_bg']);
	$t->set_var('sort_name',$phpgw->nextmatchs->show_sort_order(sort,'status_name',$order,'/inv/liststatus.php',lang('Name')));
	$t->set_var('lang_edit',lang('Edit'));
	$t->set_var('lang_delete',lang('Delete'));

	$phpgw->db->query("select * from phpgw_inv_statuslist $ordermethod");
	while ($phpgw->db->next_record())
	{
		$tr_color = $phpgw->nextmatchs->alternate_row_color($tr_color);
		$t->set_var('tr_color',$tr_color);
		$name = $phpgw->strip_html($phpgw->db->f('status_name'));
		$t->set_var('name',lang($name));

		if ($name != 'archive')
		{
			$t->set_var('edit','<a href="' . $phpgw->link('/inv/editstatus.php','status_id=' . $phpgw->db->f('status_id')) . '"> ' . lang('Edit') . ' </a>');
			$t->set_var('delete','<a href="' . $phpgw->link('/inv/deletestatus.php','status_id=' . $phpgw->db->f('status_id')) . '"> ' . lang('Delete') . ' </a>');
		}
		else
		{
			$t->set_var('edit','&nbsp;');
			$t->set_var('delete','&nbsp;');
		}

		$t->parse('list','status_list',True);
	}

	$t->set_var('add_action',$phpgw->link('/inv/addstatus.php'));
	$t->set_var('lang_add',lang('Add'));
	$t->parse('out','status_list_t',True);                                                                                                                                              
	$t->p('out');
	$phpgw->common->phpgw_footer();
?>

