#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "npnews.h"

int NP_News::get_last_spooled()
{
   char buffer[ 1024 ];
   snprintf( buffer, sizeof buffer, "%s/.peruser4-newsrc", home );

   NP_File file;
   if ( file.openr( buffer ))
   {
      snprintf( error_message, sizeof error_message, "NP_News: "
                "get_last_spooled(): %s", file.get_error());
      return 1;
   }

   char *line;
   do
   {
      if (( line = file.get_string()) == NULL )
      {
         if ( file.status() != EOF )
         {
            snprintf( error_message, sizeof error_message, "NP_News: "
                      "transfer(): %s", file.get_error());
            return 1;
         }

         snprintf( error_message, sizeof error_message, "NP_News: "
                   "transfer(): no such group in ~/.peruser4-newsrc: %s.",
                   group );
         return 1;
      }

      strtok( line, ":" );
   }
   while( strcmp( line + strspn( line, " \t" ), group ));

   char *pointer = strtok( NULL, "\n" );

   last_spooled = (( pointer == NULL ) ? 0 : atoi( pointer ));

   return 0;
}
