#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <sys/time.h>

#include "npfile.h"
#include "nptext.h"

int NP_Text::update()
{
   char buffer[ 1024 ];

   if ( reading )
      return 1;

   reading = 1;

   char old_server[ 1024 ], old_group[ 1024 ];
   long old_offset, old_size;

   if ( server != NULL )
      strcpy( old_server, server );
   else
      *old_server = '\0';

   if ( group != NULL )
      strcpy( old_group, group );
   else
      *old_group = '\0';

   old_offset = offset;
   old_size = size;

   struct timeval tval;
   tval.tv_sec = 0;
   tval.tv_usec = 0;

   int num_fd = fileno( input );

   fd_set rset;
   FD_ZERO( &rset );
   FD_SET( fileno( input ), &rset );

   if ( !select( ++num_fd, &rset, NULL, NULL, &tval ))
   {
      reading = 0;
      return 0;
   }

   if ( fgets( buffer, sizeof buffer, input ) == NULL )
   {
      if ( feof( input ))
         exit( 1 );
      else
      {
         perror( "fgets" );
         exit( 1 );
      }

      reading = 0;
      return 1;
   }

   if ( server != NULL )
      free( server );

   strtok( buffer, "\n" );
   if (( server = strdup( buffer )) == NULL )
   {
      perror( "strdup" );
      reading = 0;
      return 1;
   }

   if ( fgets( buffer, sizeof buffer, input ) == NULL )
   {
      if ( feof( input ))
         exit( 1 );
      else
      {
         perror( "fgets" );
         exit( 1 );
      }

      reading = 0;
      return 1;
   }

   if ( group != NULL )
      free( group );

   strtok( buffer, "\n" );
   if (( group = strdup( buffer )) == NULL )
   {
      perror( "strdup" );
      reading = 0;
      return 1;
   }

   if ( fgets( buffer, sizeof buffer, input ) == NULL )
   {
      if ( feof( input ))
         exit( 1 );
      else
      {
         perror( "fgets" );
         exit( 1 );
      }

      reading = 0;
      return 1;
   }

   offset = atol( buffer );

   if ( fgets( buffer, sizeof buffer, input ) == NULL )
   {
      if ( feof( input ))
         exit( 1 );
      else
      {
         perror( "fgets" );
         exit( 1 );
      }

      reading = 0;
      return 1;
   }

   size = atol( buffer );

   if ( fgets( buffer, sizeof buffer, input ) == NULL )
   {
      if ( feof( input ))
         exit( 1 );
      else
      {
         perror( "fgets" );
         exit( 1 );
      }

      reading = 0;
      return 1;
   }

   header = atoi( buffer );
   header ^= 1;

   if ( fgets( buffer, sizeof buffer, input ) == NULL )
   {
      if ( feof( input ))
         exit( 1 );
      else
      {
         perror( "fgets" );
         exit( 1 );
      }

      reading = 0;
      return 1;
   }

   requested = atoi( buffer );

   if ( fgets( buffer, sizeof buffer, input ) == NULL )
   {
      if ( feof( input ))
         exit( 1 );
      else
      {
         perror( "fgets" );
         exit( 1 );
      }

      reading = 0;
      return 1;
   }

   line = atoi( buffer );

   char *pointer;
   int len;

   if ( !strcmp( old_server, server ) &&
        !strcmp( old_group, group ) &&
        old_offset == offset && old_size == size &&
        text != NULL && line )
   {
      pointer = text;

      if ( *text == '@' )
         pointer += strcspn( pointer, "\n" ) + 1;

      int begin = 0, end = 0;
      end += len = strcspn( pointer, "\n" ) + 1;

      while( --line )
      {
         pointer += len;
         begin = end;
         end += len = strcspn( pointer, "\n" ) + 1;
      }

      gtk_editable_select_region( GTK_EDITABLE( text_widget ),
                                  begin, end );
      
      reading = 0;
      return 0;
   }

   char spool_path[ 1024 ];
   snprintf( spool_path, sizeof spool_path, "%s/.peruser_spool/%s-%s",
             home, server, group );
   NP_File spool;
   if ( spool.openr( spool_path ))
   {
      spool.print_error();
      reading = 0;
      return 1;
   }

   if ( spool.seek( offset, SEEK_SET ))
   {
      spool.print_error();
      reading = 0;
      return 1;
   }

   if ( text != NULL )
      free( text );

   if (( text = ( char *)malloc( size + 1 )) == NULL )
   {
      perror( "malloc" );
      exit( 1 );
   }

   if ( spool.ffread( text, size ))
   {
      spool.print_error();
      reading = 0;
      return 1;
   }
   text[ size ] = '\0';

   spool.close();

   gtk_widget_show( window );
   gtk_label_set( GTK_LABEL( subject_label ), 
                  "Scanning for quoted-printable ISO-8859-1 charset usage..."
                  );

   iso8859_1();

   len = gtk_text_get_length( GTK_TEXT( text_widget ));
   if ( len > 0 )
   {
      gtk_text_freeze( GTK_TEXT( text_widget ));
      gtk_text_set_point( GTK_TEXT( text_widget ), 0 );
      gtk_text_forward_delete( GTK_TEXT( text_widget ), len );
      gtk_text_thaw( GTK_TEXT( text_widget ));
   }

   pointer = strrchr( text, '.' );
   *pointer = '\0';
   
   if ( !line )
      if ( header )
      {
         header_shown = -1;
      
         pointer = text;
         if ( *pointer == '@' )
            pointer += strcspn( pointer, "\n" ) + 1;

         len = strlen( pointer ) + 1;

         gtk_text_freeze( GTK_TEXT( text_widget ));
         gtk_text_insert( GTK_TEXT( text_widget ), NULL, NULL, NULL,
                          pointer, len );
         gtk_text_thaw( GTK_TEXT( text_widget ));
      }
      else
      {
         header_shown = 1;
         show_header_button_callback( NULL, this );
      }
   else
   {
      header_shown = 1;
      
      pointer = text;
      if ( *text == '@' )
         pointer += strcspn( pointer, "\n" ) + 1;

      char *old_pointer = pointer;

      len = strlen( pointer ) + 1;

      gtk_text_freeze( GTK_TEXT( text_widget ));
      gtk_text_insert( GTK_TEXT( text_widget ), NULL, NULL, NULL,
                       pointer, len );

      pointer = old_pointer;

      int begin = 0, end = 0;
      end += len = strcspn( pointer, "\n" ) + 1;

      while( --line )
      {
         pointer += len;
         begin = end;
         end += len = strcspn( pointer, "\n" ) + 1;
      }

      gtk_editable_select_region( GTK_EDITABLE( text_widget ),
                                  begin, end );
      
      gtk_text_thaw( GTK_TEXT( text_widget ));
   }

   pointer = strstr( text, "Subject:" );
   if ( pointer != NULL )
   {
      len = strcspn( pointer, "\r" );
      if ( len > 80 )
         len = 80;
      strncpy( buffer, pointer, len );
      buffer[ len ] = '\0';

      gtk_label_set( GTK_LABEL( subject_label ), buffer );
   }

   pointer = strstr( text, "From:" );
   if ( pointer != NULL )
   {
      len = strcspn( pointer, "\r" );
      if ( len > 80 )
         len = 80;

      strncpy( buffer, pointer, len );
      buffer[ len ] = '\0';

      gtk_label_set( GTK_LABEL( from_label ), buffer );
   }

   pointer = strstr( text, "Date:" );
   if ( pointer != NULL )
   {
      len = strcspn( pointer, "\r" );
      if ( len > 80 )
         len = 80;
      strncpy( buffer, pointer, len );
      buffer[ len ] = '\0';

      gtk_label_set( GTK_LABEL( date_label ), buffer );
   }

   if ( !strcmp( group, "FOLLOW-UPS" ))
   {
      gtk_widget_hide( reply_button );
      gtk_widget_hide( both_button );
      gtk_widget_hide( follow_up_button );

      gtk_widget_hide( cancel_button );
      gtk_widget_hide( supersede_button );
      gtk_widget_show( edit_button );
   }
   else
      if ( !strcmp( group, "POSTED" ))
      {
         gtk_widget_hide( edit_button );
         gtk_widget_hide( reply_button );
         gtk_widget_hide( both_button );
         gtk_widget_hide( follow_up_button );

         gtk_widget_show( cancel_button );
         gtk_widget_show( supersede_button );
      }
      else
         if ( !strcmp( group, "OUTBOX" ))
         {
            gtk_widget_hide( reply_button );
            gtk_widget_hide( both_button );
            gtk_widget_hide( follow_up_button );
            gtk_widget_hide( cancel_button );
            gtk_widget_hide( supersede_button );

            gtk_widget_show( edit_button );
         }
         else
            if ( !strcmp( group, "SENT-MAIL" ))
            {
               gtk_widget_hide( reply_button );
               gtk_widget_hide( both_button );
               gtk_widget_hide( follow_up_button );
               gtk_widget_hide( cancel_button );
               gtk_widget_hide( supersede_button );
               gtk_widget_hide( edit_button );
            }
            else
            {
               gtk_widget_show( reply_button );
               gtk_widget_show( both_button );
               gtk_widget_show( follow_up_button );
            }

   reading = 0;

   return 0;
}
