#include <stdlib.h>
#include <stdio.h>

#include "npthreads.h"

int NP_Threads::thread()
{
   if ( total < 2 )
      return 0;

   np_thread_node_t *current_node, *other_node;

   np_ref_node_t *ref_pointer;

   int gap;

   for( current_node = threads;
        current_node != NULL;
        current_node = current_node->next )
   {
      if ( current_node->references == NULL )
         continue;

      ref_pointer = current_node->references;

      while( ref_pointer->next != NULL )
         ref_pointer = ref_pointer->next;

      for( gap = 0;
           ref_pointer != NULL;
           ref_pointer = ref_pointer->prev )
      {
         for( other_node = threads;
              other_node != NULL;
              other_node = other_node->next )
            if ( other_node == current_node )
               continue;
            else
               if ( !strcmp( other_node->message_id, ref_pointer->reference ))
               {
                  if ( other_node->child_head == NULL )
                     other_node->child_head = other_node->child_tail =
                        current_node;
                  else
                  {
                     current_node->child_prev = other_node->child_tail;
                     other_node->child_tail->child_next = current_node;

                     current_node->child_next = NULL;
                     other_node->child_tail = current_node;
                  }

                  current_node->is_child = 1;
                  current_node->parent = other_node;
                  current_node->gap = gap;
                  other_node->child_count++;
                  break;
               }
      
         if ( current_node->is_child )
            break;

         ++gap;
      }
   }

   return 0;
}
